package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface PersistentVolumeClaimStatusFluent<A extends PersistentVolumeClaimStatusFluent<A>> extends Fluent<A>{
  public A addToAccessModes(int index,String item);
  public A setToAccessModes(int index,String item);
  public A addToAccessModes(java.lang.String... items);
  public A addAllToAccessModes(Collection<String> items);
  public A removeFromAccessModes(java.lang.String... items);
  public A removeAllFromAccessModes(Collection<String> items);
  public List<String> getAccessModes();
  public String getAccessMode(int index);
  public String getFirstAccessMode();
  public String getLastAccessMode();
  public String getMatchingAccessMode(Predicate<String> predicate);
  public Boolean hasMatchingAccessMode(Predicate<String> predicate);
  public A withAccessModes(List<String> accessModes);
  public A withAccessModes(java.lang.String... accessModes);
  public Boolean hasAccessModes();
  public A addToAllocatedResources(String key,Quantity value);
  public A addToAllocatedResources(Map<String,Quantity> map);
  public A removeFromAllocatedResources(String key);
  public A removeFromAllocatedResources(Map<String,Quantity> map);
  public Map<String,Quantity> getAllocatedResources();
  public <K,V>A withAllocatedResources(Map<String,Quantity> allocatedResources);
  public Boolean hasAllocatedResources();
  public A addToCapacity(String key,Quantity value);
  public A addToCapacity(Map<String,Quantity> map);
  public A removeFromCapacity(String key);
  public A removeFromCapacity(Map<String,Quantity> map);
  public Map<String,Quantity> getCapacity();
  public <K,V>A withCapacity(Map<String,Quantity> capacity);
  public Boolean hasCapacity();
  public A addToConditions(int index,PersistentVolumeClaimCondition item);
  public A setToConditions(int index,PersistentVolumeClaimCondition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition... items);
  public A addAllToConditions(Collection<PersistentVolumeClaimCondition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition... items);
  public A removeAllFromConditions(Collection<PersistentVolumeClaimCondition> items);
  public A removeMatchingFromConditions(Predicate<PersistentVolumeClaimConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PersistentVolumeClaimCondition> getConditions();
  public List<PersistentVolumeClaimCondition> buildConditions();
  public PersistentVolumeClaimCondition buildCondition(int index);
  public PersistentVolumeClaimCondition buildFirstCondition();
  public PersistentVolumeClaimCondition buildLastCondition();
  public PersistentVolumeClaimCondition buildMatchingCondition(Predicate<PersistentVolumeClaimConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<PersistentVolumeClaimConditionBuilder> predicate);
  public A withConditions(List<PersistentVolumeClaimCondition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition... conditions);
  public Boolean hasConditions();
  public PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewCondition();
  public PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewConditionLike(PersistentVolumeClaimCondition item);
  public PersistentVolumeClaimStatusFluent.ConditionsNested<A> setNewConditionLike(int index,PersistentVolumeClaimCondition item);
  public PersistentVolumeClaimStatusFluent.ConditionsNested<A> editCondition(int index);
  public PersistentVolumeClaimStatusFluent.ConditionsNested<A> editFirstCondition();
  public PersistentVolumeClaimStatusFluent.ConditionsNested<A> editLastCondition();
  public PersistentVolumeClaimStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<PersistentVolumeClaimConditionBuilder> predicate);
  public String getPhase();
  public A withPhase(String phase);
  public Boolean hasPhase();
  public String getResizeStatus();
  public A withResizeStatus(String resizeStatus);
  public Boolean hasResizeStatus();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,PersistentVolumeClaimConditionFluent<PersistentVolumeClaimStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  
}