package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ServicePortFluent<A extends ServicePortFluent<A>> extends Fluent<A>{
  public String getAppProtocol();
  public A withAppProtocol(String appProtocol);
  public Boolean hasAppProtocol();
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  public Integer getNodePort();
  public A withNodePort(Integer nodePort);
  public Boolean hasNodePort();
  public Integer getPort();
  public A withPort(Integer port);
  public Boolean hasPort();
  public String getProtocol();
  public A withProtocol(String protocol);
  public Boolean hasProtocol();
  
  /**
   * This method has been deprecated, please use method buildTargetPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getTargetPort();
  public IntOrString buildTargetPort();
  public A withTargetPort(IntOrString targetPort);
  public Boolean hasTargetPort();
  public A withNewTargetPort(Object value);
  public ServicePortFluent.TargetPortNested<A> withNewTargetPort();
  public ServicePortFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item);
  public ServicePortFluent.TargetPortNested<A> editTargetPort();
  public ServicePortFluent.TargetPortNested<A> editOrNewTargetPort();
  public ServicePortFluent.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface TargetPortNested<N> extends Nested<N>,IntOrStringFluent<ServicePortFluent.TargetPortNested<N>>{
    public N and();
    public N endTargetPort();
    
  }
  
}