package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WindowsSecurityContextOptionsBuilder extends WindowsSecurityContextOptionsFluentImpl<WindowsSecurityContextOptionsBuilder> implements VisitableBuilder<WindowsSecurityContextOptions,WindowsSecurityContextOptionsBuilder>{
  public WindowsSecurityContextOptionsBuilder() {
    this(false);
  }
  public WindowsSecurityContextOptionsBuilder(Boolean validationEnabled) {
    this(new WindowsSecurityContextOptions(), validationEnabled);
  }
  public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WindowsSecurityContextOptions(), validationEnabled);
  }
  public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent,WindowsSecurityContextOptions instance) {
    this(fluent, instance, false);
  }
  public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent,WindowsSecurityContextOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGmsaCredentialSpec(instance.getGmsaCredentialSpec());
      fluent.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName());
      fluent.withHostProcess(instance.getHostProcess());
      fluent.withRunAsUserName(instance.getRunAsUserName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptions instance) {
    this(instance,false);
  }
  public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGmsaCredentialSpec(instance.getGmsaCredentialSpec());
      this.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName());
      this.withHostProcess(instance.getHostProcess());
      this.withRunAsUserName(instance.getRunAsUserName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  WindowsSecurityContextOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public WindowsSecurityContextOptions build() {
    WindowsSecurityContextOptions buildable = new WindowsSecurityContextOptions(fluent.getGmsaCredentialSpec(),fluent.getGmsaCredentialSpecName(),fluent.getHostProcess(),fluent.getRunAsUserName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}