package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointSubsetBuilder extends EndpointSubsetFluentImpl<EndpointSubsetBuilder> implements VisitableBuilder<EndpointSubset,EndpointSubsetBuilder>{
  public EndpointSubsetBuilder() {
    this(false);
  }
  public EndpointSubsetBuilder(Boolean validationEnabled) {
    this(new EndpointSubset(), validationEnabled);
  }
  public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EndpointSubset(), validationEnabled);
  }
  public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent,EndpointSubset instance) {
    this(fluent, instance, false);
  }
  public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent,EndpointSubset instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddresses(instance.getAddresses());
      fluent.withNotReadyAddresses(instance.getNotReadyAddresses());
      fluent.withPorts(instance.getPorts());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EndpointSubsetBuilder(EndpointSubset instance) {
    this(instance,false);
  }
  public EndpointSubsetBuilder(EndpointSubset instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddresses(instance.getAddresses());
      this.withNotReadyAddresses(instance.getNotReadyAddresses());
      this.withPorts(instance.getPorts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EndpointSubsetFluent<?> fluent;
  Boolean validationEnabled;
  public EndpointSubset build() {
    EndpointSubset buildable = new EndpointSubset(fluent.getAddresses(),fluent.getNotReadyAddresses(),fluent.getPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}