package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EphemeralVolumeSourceBuilder extends EphemeralVolumeSourceFluentImpl<EphemeralVolumeSourceBuilder> implements VisitableBuilder<EphemeralVolumeSource,EphemeralVolumeSourceBuilder>{
  public EphemeralVolumeSourceBuilder() {
    this(false);
  }
  public EphemeralVolumeSourceBuilder(Boolean validationEnabled) {
    this(new EphemeralVolumeSource(), validationEnabled);
  }
  public EphemeralVolumeSourceBuilder(EphemeralVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public EphemeralVolumeSourceBuilder(EphemeralVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EphemeralVolumeSource(), validationEnabled);
  }
  public EphemeralVolumeSourceBuilder(EphemeralVolumeSourceFluent<?> fluent,EphemeralVolumeSource instance) {
    this(fluent, instance, false);
  }
  public EphemeralVolumeSourceBuilder(EphemeralVolumeSourceFluent<?> fluent,EphemeralVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EphemeralVolumeSourceBuilder(EphemeralVolumeSource instance) {
    this(instance,false);
  }
  public EphemeralVolumeSourceBuilder(EphemeralVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EphemeralVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public EphemeralVolumeSource build() {
    EphemeralVolumeSource buildable = new EphemeralVolumeSource(fluent.getVolumeClaimTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}