package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamespaceSpecBuilder extends NamespaceSpecFluentImpl<NamespaceSpecBuilder> implements VisitableBuilder<NamespaceSpec,NamespaceSpecBuilder>{
  public NamespaceSpecBuilder() {
    this(false);
  }
  public NamespaceSpecBuilder(Boolean validationEnabled) {
    this(new NamespaceSpec(), validationEnabled);
  }
  public NamespaceSpecBuilder(NamespaceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NamespaceSpecBuilder(NamespaceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamespaceSpec(), validationEnabled);
  }
  public NamespaceSpecBuilder(NamespaceSpecFluent<?> fluent,NamespaceSpec instance) {
    this(fluent, instance, false);
  }
  public NamespaceSpecBuilder(NamespaceSpecFluent<?> fluent,NamespaceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFinalizers(instance.getFinalizers());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamespaceSpecBuilder(NamespaceSpec instance) {
    this(instance,false);
  }
  public NamespaceSpecBuilder(NamespaceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFinalizers(instance.getFinalizers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamespaceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NamespaceSpec build() {
    NamespaceSpec buildable = new NamespaceSpec(fluent.getFinalizers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}