package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretListBuilder extends SecretListFluentImpl<SecretListBuilder> implements VisitableBuilder<SecretList,SecretListBuilder>{
  public SecretListBuilder() {
    this(false);
  }
  public SecretListBuilder(Boolean validationEnabled) {
    this(new SecretList(), validationEnabled);
  }
  public SecretListBuilder(SecretListFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretListBuilder(SecretListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretList(), validationEnabled);
  }
  public SecretListBuilder(SecretListFluent<?> fluent,SecretList instance) {
    this(fluent, instance, false);
  }
  public SecretListBuilder(SecretListFluent<?> fluent,SecretList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretListBuilder(SecretList instance) {
    this(instance,false);
  }
  public SecretListBuilder(SecretList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretListFluent<?> fluent;
  Boolean validationEnabled;
  public SecretList build() {
    SecretList buildable = new SecretList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}