package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface SecurityContextFluent<A extends SecurityContextFluent<A>> extends Fluent<A>{
  public Boolean getAllowPrivilegeEscalation();
  public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation);
  public Boolean hasAllowPrivilegeEscalation();
  
  /**
   * This method has been deprecated, please use method buildCapabilities instead.
   * @return The buildable object.
   */
  @Deprecated
  public Capabilities getCapabilities();
  public Capabilities buildCapabilities();
  public A withCapabilities(Capabilities capabilities);
  public Boolean hasCapabilities();
  public SecurityContextFluent.CapabilitiesNested<A> withNewCapabilities();
  public SecurityContextFluent.CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item);
  public SecurityContextFluent.CapabilitiesNested<A> editCapabilities();
  public SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilities();
  public SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilitiesLike(Capabilities item);
  public Boolean getPrivileged();
  public A withPrivileged(Boolean privileged);
  public Boolean hasPrivileged();
  public String getProcMount();
  public A withProcMount(String procMount);
  public Boolean hasProcMount();
  public Boolean getReadOnlyRootFilesystem();
  public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
  public Boolean hasReadOnlyRootFilesystem();
  public Long getRunAsGroup();
  public A withRunAsGroup(Long runAsGroup);
  public Boolean hasRunAsGroup();
  public Boolean getRunAsNonRoot();
  public A withRunAsNonRoot(Boolean runAsNonRoot);
  public Boolean hasRunAsNonRoot();
  public Long getRunAsUser();
  public A withRunAsUser(Long runAsUser);
  public Boolean hasRunAsUser();
  
  /**
   * This method has been deprecated, please use method buildSeLinuxOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public SELinuxOptions getSeLinuxOptions();
  public SELinuxOptions buildSeLinuxOptions();
  public A withSeLinuxOptions(SELinuxOptions seLinuxOptions);
  public Boolean hasSeLinuxOptions();
  public A withNewSeLinuxOptions(String level,String role,String type,String user);
  public SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions();
  public SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item);
  public SecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions();
  public SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions();
  public SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item);
  
  /**
   * This method has been deprecated, please use method buildSeccompProfile instead.
   * @return The buildable object.
   */
  @Deprecated
  public SeccompProfile getSeccompProfile();
  public SeccompProfile buildSeccompProfile();
  public A withSeccompProfile(SeccompProfile seccompProfile);
  public Boolean hasSeccompProfile();
  public A withNewSeccompProfile(String localhostProfile,String type);
  public SecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile();
  public SecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item);
  public SecurityContextFluent.SeccompProfileNested<A> editSeccompProfile();
  public SecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile();
  public SecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item);
  
  /**
   * This method has been deprecated, please use method buildWindowsOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public WindowsSecurityContextOptions getWindowsOptions();
  public WindowsSecurityContextOptions buildWindowsOptions();
  public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions);
  public Boolean hasWindowsOptions();
  public A withNewWindowsOptions(String gmsaCredentialSpec,String gmsaCredentialSpecName,Boolean hostProcess,String runAsUserName);
  public SecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions();
  public SecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item);
  public SecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions();
  public SecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions();
  public SecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withAllowPrivilegeEscalation();
  public A withPrivileged();
  public A withReadOnlyRootFilesystem();
  public A withRunAsNonRoot();
  public interface CapabilitiesNested<N> extends Nested<N>,CapabilitiesFluent<SecurityContextFluent.CapabilitiesNested<N>>{
    public N and();
    public N endCapabilities();
    
  }
  public interface SeLinuxOptionsNested<N> extends Nested<N>,SELinuxOptionsFluent<SecurityContextFluent.SeLinuxOptionsNested<N>>{
    public N and();
    public N endSeLinuxOptions();
    
  }
  public interface SeccompProfileNested<N> extends Nested<N>,SeccompProfileFluent<SecurityContextFluent.SeccompProfileNested<N>>{
    public N and();
    public N endSeccompProfile();
    
  }
  public interface WindowsOptionsNested<N> extends Nested<N>,WindowsSecurityContextOptionsFluent<SecurityContextFluent.WindowsOptionsNested<N>>{
    public N and();
    public N endWindowsOptions();
    
  }
  
}