package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TolerationBuilder extends TolerationFluentImpl<TolerationBuilder> implements VisitableBuilder<Toleration,TolerationBuilder>{
  public TolerationBuilder() {
    this(false);
  }
  public TolerationBuilder(Boolean validationEnabled) {
    this(new Toleration(), validationEnabled);
  }
  public TolerationBuilder(TolerationFluent<?> fluent) {
    this(fluent, false);
  }
  public TolerationBuilder(TolerationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Toleration(), validationEnabled);
  }
  public TolerationBuilder(TolerationFluent<?> fluent,Toleration instance) {
    this(fluent, instance, false);
  }
  public TolerationBuilder(TolerationFluent<?> fluent,Toleration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEffect(instance.getEffect());
      fluent.withKey(instance.getKey());
      fluent.withOperator(instance.getOperator());
      fluent.withTolerationSeconds(instance.getTolerationSeconds());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TolerationBuilder(Toleration instance) {
    this(instance,false);
  }
  public TolerationBuilder(Toleration instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEffect(instance.getEffect());
      this.withKey(instance.getKey());
      this.withOperator(instance.getOperator());
      this.withTolerationSeconds(instance.getTolerationSeconds());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TolerationFluent<?> fluent;
  Boolean validationEnabled;
  public Toleration build() {
    Toleration buildable = new Toleration(fluent.getEffect(),fluent.getKey(),fluent.getOperator(),fluent.getTolerationSeconds(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}