package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CephFSPersistentVolumeSourceBuilder extends CephFSPersistentVolumeSourceFluent<CephFSPersistentVolumeSourceBuilder> implements VisitableBuilder<CephFSPersistentVolumeSource,CephFSPersistentVolumeSourceBuilder>{
  public CephFSPersistentVolumeSourceBuilder() {
    this(false);
  }
  public CephFSPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new CephFSPersistentVolumeSource(), validationEnabled);
  }
  public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CephFSPersistentVolumeSource(), validationEnabled);
  }
  public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSourceFluent<?> fluent,CephFSPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSourceFluent<?> fluent,CephFSPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CephFSPersistentVolumeSource());

    if (instance != null) {
      fluent.withMonitors(instance.getMonitors());
      fluent.withPath(instance.getPath());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretFile(instance.getSecretFile());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withUser(instance.getUser());
      fluent.withMonitors(instance.getMonitors());
      fluent.withPath(instance.getPath());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretFile(instance.getSecretFile());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSource instance) {
    this(instance,false);
  }
  public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CephFSPersistentVolumeSource());

    if (instance != null) {
      this.withMonitors(instance.getMonitors());
      this.withPath(instance.getPath());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretFile(instance.getSecretFile());
      this.withSecretRef(instance.getSecretRef());
      this.withUser(instance.getUser());
      this.withMonitors(instance.getMonitors());
      this.withPath(instance.getPath());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretFile(instance.getSecretFile());
      this.withSecretRef(instance.getSecretRef());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CephFSPersistentVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public CephFSPersistentVolumeSource build() {
    CephFSPersistentVolumeSource buildable = new CephFSPersistentVolumeSource(fluent.getMonitors(),fluent.getPath(),fluent.getReadOnly(),fluent.getSecretFile(),fluent.buildSecretRef(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}