package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClaimSourceBuilder extends ClaimSourceFluent<ClaimSourceBuilder> implements VisitableBuilder<ClaimSource,ClaimSourceBuilder>{
  public ClaimSourceBuilder() {
    this(false);
  }
  public ClaimSourceBuilder(Boolean validationEnabled) {
    this(new ClaimSource(), validationEnabled);
  }
  public ClaimSourceBuilder(ClaimSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ClaimSourceBuilder(ClaimSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClaimSource(), validationEnabled);
  }
  public ClaimSourceBuilder(ClaimSourceFluent<?> fluent,ClaimSource instance) {
    this(fluent, instance, false);
  }
  public ClaimSourceBuilder(ClaimSourceFluent<?> fluent,ClaimSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClaimSource());

    if (instance != null) {
      fluent.withResourceClaimName(instance.getResourceClaimName());
      fluent.withResourceClaimTemplateName(instance.getResourceClaimTemplateName());
      fluent.withResourceClaimName(instance.getResourceClaimName());
      fluent.withResourceClaimTemplateName(instance.getResourceClaimTemplateName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClaimSourceBuilder(ClaimSource instance) {
    this(instance,false);
  }
  public ClaimSourceBuilder(ClaimSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClaimSource());

    if (instance != null) {
      this.withResourceClaimName(instance.getResourceClaimName());
      this.withResourceClaimTemplateName(instance.getResourceClaimTemplateName());
      this.withResourceClaimName(instance.getResourceClaimName());
      this.withResourceClaimTemplateName(instance.getResourceClaimTemplateName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClaimSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ClaimSource build() {
    ClaimSource buildable = new ClaimSource(fluent.getResourceClaimName(),fluent.getResourceClaimTemplateName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}