package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerPortBuilder extends ContainerPortFluent<ContainerPortBuilder> implements VisitableBuilder<ContainerPort,ContainerPortBuilder>{
  public ContainerPortBuilder() {
    this(false);
  }
  public ContainerPortBuilder(Boolean validationEnabled) {
    this(new ContainerPort(), validationEnabled);
  }
  public ContainerPortBuilder(ContainerPortFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerPortBuilder(ContainerPortFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerPort(), validationEnabled);
  }
  public ContainerPortBuilder(ContainerPortFluent<?> fluent,ContainerPort instance) {
    this(fluent, instance, false);
  }
  public ContainerPortBuilder(ContainerPortFluent<?> fluent,ContainerPort instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerPort());

    if (instance != null) {
      fluent.withContainerPort(instance.getContainerPort());
      fluent.withHostIP(instance.getHostIP());
      fluent.withHostPort(instance.getHostPort());
      fluent.withName(instance.getName());
      fluent.withProtocol(instance.getProtocol());
      fluent.withContainerPort(instance.getContainerPort());
      fluent.withHostIP(instance.getHostIP());
      fluent.withHostPort(instance.getHostPort());
      fluent.withName(instance.getName());
      fluent.withProtocol(instance.getProtocol());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerPortBuilder(ContainerPort instance) {
    this(instance,false);
  }
  public ContainerPortBuilder(ContainerPort instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerPort());

    if (instance != null) {
      this.withContainerPort(instance.getContainerPort());
      this.withHostIP(instance.getHostIP());
      this.withHostPort(instance.getHostPort());
      this.withName(instance.getName());
      this.withProtocol(instance.getProtocol());
      this.withContainerPort(instance.getContainerPort());
      this.withHostIP(instance.getHostIP());
      this.withHostPort(instance.getHostPort());
      this.withName(instance.getName());
      this.withProtocol(instance.getProtocol());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerPortFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerPort build() {
    ContainerPort buildable = new ContainerPort(fluent.getContainerPort(),fluent.getHostIP(),fluent.getHostPort(),fluent.getName(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}