package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ListMetaBuilder extends ListMetaFluent<ListMetaBuilder> implements VisitableBuilder<ListMeta,ListMetaBuilder>{
  public ListMetaBuilder() {
    this(false);
  }
  public ListMetaBuilder(Boolean validationEnabled) {
    this(new ListMeta(), validationEnabled);
  }
  public ListMetaBuilder(ListMetaFluent<?> fluent) {
    this(fluent, false);
  }
  public ListMetaBuilder(ListMetaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ListMeta(), validationEnabled);
  }
  public ListMetaBuilder(ListMetaFluent<?> fluent,ListMeta instance) {
    this(fluent, instance, false);
  }
  public ListMetaBuilder(ListMetaFluent<?> fluent,ListMeta instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ListMeta());

    if (instance != null) {
      fluent.withContinue(instance.getContinue());
      fluent.withRemainingItemCount(instance.getRemainingItemCount());
      fluent.withResourceVersion(instance.getResourceVersion());
      fluent.withSelfLink(instance.getSelfLink());
      fluent.withContinue(instance.getContinue());
      fluent.withRemainingItemCount(instance.getRemainingItemCount());
      fluent.withResourceVersion(instance.getResourceVersion());
      fluent.withSelfLink(instance.getSelfLink());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ListMetaBuilder(ListMeta instance) {
    this(instance,false);
  }
  public ListMetaBuilder(ListMeta instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ListMeta());

    if (instance != null) {
      this.withContinue(instance.getContinue());
      this.withRemainingItemCount(instance.getRemainingItemCount());
      this.withResourceVersion(instance.getResourceVersion());
      this.withSelfLink(instance.getSelfLink());
      this.withContinue(instance.getContinue());
      this.withRemainingItemCount(instance.getRemainingItemCount());
      this.withResourceVersion(instance.getResourceVersion());
      this.withSelfLink(instance.getSelfLink());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ListMetaFluent<?> fluent;
  Boolean validationEnabled;
  public ListMeta build() {
    ListMeta buildable = new ListMeta(fluent.getContinue(),fluent.getRemainingItemCount(),fluent.getResourceVersion(),fluent.getSelfLink());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}