package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedAuthInfoBuilder extends NamedAuthInfoFluent<NamedAuthInfoBuilder> implements VisitableBuilder<NamedAuthInfo,NamedAuthInfoBuilder>{
  public NamedAuthInfoBuilder() {
    this(false);
  }
  public NamedAuthInfoBuilder(Boolean validationEnabled) {
    this(new NamedAuthInfo(), validationEnabled);
  }
  public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamedAuthInfo(), validationEnabled);
  }
  public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent,NamedAuthInfo instance) {
    this(fluent, instance, false);
  }
  public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent,NamedAuthInfo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NamedAuthInfo());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withUser(instance.getUser());
      fluent.withName(instance.getName());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamedAuthInfoBuilder(NamedAuthInfo instance) {
    this(instance,false);
  }
  public NamedAuthInfoBuilder(NamedAuthInfo instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NamedAuthInfo());

    if (instance != null) {
      this.withName(instance.getName());
      this.withUser(instance.getUser());
      this.withName(instance.getName());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamedAuthInfoFluent<?> fluent;
  Boolean validationEnabled;
  public NamedAuthInfo build() {
    NamedAuthInfo buildable = new NamedAuthInfo(fluent.getName(),fluent.buildUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}