package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedClusterBuilder extends NamedClusterFluent<NamedClusterBuilder> implements VisitableBuilder<NamedCluster,NamedClusterBuilder>{
  public NamedClusterBuilder() {
    this(false);
  }
  public NamedClusterBuilder(Boolean validationEnabled) {
    this(new NamedCluster(), validationEnabled);
  }
  public NamedClusterBuilder(NamedClusterFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedClusterBuilder(NamedClusterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamedCluster(), validationEnabled);
  }
  public NamedClusterBuilder(NamedClusterFluent<?> fluent,NamedCluster instance) {
    this(fluent, instance, false);
  }
  public NamedClusterBuilder(NamedClusterFluent<?> fluent,NamedCluster instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NamedCluster());

    if (instance != null) {
      fluent.withCluster(instance.getCluster());
      fluent.withName(instance.getName());
      fluent.withCluster(instance.getCluster());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamedClusterBuilder(NamedCluster instance) {
    this(instance,false);
  }
  public NamedClusterBuilder(NamedCluster instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NamedCluster());

    if (instance != null) {
      this.withCluster(instance.getCluster());
      this.withName(instance.getName());
      this.withCluster(instance.getCluster());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamedClusterFluent<?> fluent;
  Boolean validationEnabled;
  public NamedCluster build() {
    NamedCluster buildable = new NamedCluster(fluent.buildCluster(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}