package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeSystemInfoBuilder extends NodeSystemInfoFluent<NodeSystemInfoBuilder> implements VisitableBuilder<NodeSystemInfo,NodeSystemInfoBuilder>{
  public NodeSystemInfoBuilder() {
    this(false);
  }
  public NodeSystemInfoBuilder(Boolean validationEnabled) {
    this(new NodeSystemInfo(), validationEnabled);
  }
  public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeSystemInfo(), validationEnabled);
  }
  public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent,NodeSystemInfo instance) {
    this(fluent, instance, false);
  }
  public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent,NodeSystemInfo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodeSystemInfo());

    if (instance != null) {
      fluent.withArchitecture(instance.getArchitecture());
      fluent.withBootID(instance.getBootID());
      fluent.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
      fluent.withKernelVersion(instance.getKernelVersion());
      fluent.withKubeProxyVersion(instance.getKubeProxyVersion());
      fluent.withKubeletVersion(instance.getKubeletVersion());
      fluent.withMachineID(instance.getMachineID());
      fluent.withOperatingSystem(instance.getOperatingSystem());
      fluent.withOsImage(instance.getOsImage());
      fluent.withSystemUUID(instance.getSystemUUID());
      fluent.withArchitecture(instance.getArchitecture());
      fluent.withBootID(instance.getBootID());
      fluent.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
      fluent.withKernelVersion(instance.getKernelVersion());
      fluent.withKubeProxyVersion(instance.getKubeProxyVersion());
      fluent.withKubeletVersion(instance.getKubeletVersion());
      fluent.withMachineID(instance.getMachineID());
      fluent.withOperatingSystem(instance.getOperatingSystem());
      fluent.withOsImage(instance.getOsImage());
      fluent.withSystemUUID(instance.getSystemUUID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeSystemInfoBuilder(NodeSystemInfo instance) {
    this(instance,false);
  }
  public NodeSystemInfoBuilder(NodeSystemInfo instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodeSystemInfo());

    if (instance != null) {
      this.withArchitecture(instance.getArchitecture());
      this.withBootID(instance.getBootID());
      this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
      this.withKernelVersion(instance.getKernelVersion());
      this.withKubeProxyVersion(instance.getKubeProxyVersion());
      this.withKubeletVersion(instance.getKubeletVersion());
      this.withMachineID(instance.getMachineID());
      this.withOperatingSystem(instance.getOperatingSystem());
      this.withOsImage(instance.getOsImage());
      this.withSystemUUID(instance.getSystemUUID());
      this.withArchitecture(instance.getArchitecture());
      this.withBootID(instance.getBootID());
      this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
      this.withKernelVersion(instance.getKernelVersion());
      this.withKubeProxyVersion(instance.getKubeProxyVersion());
      this.withKubeletVersion(instance.getKubeletVersion());
      this.withMachineID(instance.getMachineID());
      this.withOperatingSystem(instance.getOperatingSystem());
      this.withOsImage(instance.getOsImage());
      this.withSystemUUID(instance.getSystemUUID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeSystemInfoFluent<?> fluent;
  Boolean validationEnabled;
  public NodeSystemInfo build() {
    NodeSystemInfo buildable = new NodeSystemInfo(fluent.getArchitecture(),fluent.getBootID(),fluent.getContainerRuntimeVersion(),fluent.getKernelVersion(),fluent.getKubeProxyVersion(),fluent.getKubeletVersion(),fluent.getMachineID(),fluent.getOperatingSystem(),fluent.getOsImage(),fluent.getSystemUUID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}