package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PreferredSchedulingTermBuilder extends PreferredSchedulingTermFluent<PreferredSchedulingTermBuilder> implements VisitableBuilder<PreferredSchedulingTerm,PreferredSchedulingTermBuilder>{
  public PreferredSchedulingTermBuilder() {
    this(false);
  }
  public PreferredSchedulingTermBuilder(Boolean validationEnabled) {
    this(new PreferredSchedulingTerm(), validationEnabled);
  }
  public PreferredSchedulingTermBuilder(PreferredSchedulingTermFluent<?> fluent) {
    this(fluent, false);
  }
  public PreferredSchedulingTermBuilder(PreferredSchedulingTermFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PreferredSchedulingTerm(), validationEnabled);
  }
  public PreferredSchedulingTermBuilder(PreferredSchedulingTermFluent<?> fluent,PreferredSchedulingTerm instance) {
    this(fluent, instance, false);
  }
  public PreferredSchedulingTermBuilder(PreferredSchedulingTermFluent<?> fluent,PreferredSchedulingTerm instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PreferredSchedulingTerm());

    if (instance != null) {
      fluent.withPreference(instance.getPreference());
      fluent.withWeight(instance.getWeight());
      fluent.withPreference(instance.getPreference());
      fluent.withWeight(instance.getWeight());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PreferredSchedulingTermBuilder(PreferredSchedulingTerm instance) {
    this(instance,false);
  }
  public PreferredSchedulingTermBuilder(PreferredSchedulingTerm instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PreferredSchedulingTerm());

    if (instance != null) {
      this.withPreference(instance.getPreference());
      this.withWeight(instance.getWeight());
      this.withPreference(instance.getPreference());
      this.withWeight(instance.getWeight());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PreferredSchedulingTermFluent<?> fluent;
  Boolean validationEnabled;
  public PreferredSchedulingTerm build() {
    PreferredSchedulingTerm buildable = new PreferredSchedulingTerm(fluent.buildPreference(),fluent.getWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}