package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RootPathsFluent<A extends RootPathsFluent<A>> extends BaseFluent<A>{
  public RootPathsFluent() {
  }
  public RootPathsFluent(RootPaths instance) {
    instance = (instance != null ? instance : new RootPaths());

    if (instance != null) {
      this.withPaths(instance.getPaths());
      this.withPaths(instance.getPaths());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> paths = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToPaths(int index,String item) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    this.paths.add(index, item);
    return (A)this;
  }
  public A setToPaths(int index,String item) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    this.paths.set(index, item); return (A)this;
  }
  public A addToPaths(java.lang.String... items) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    for (String item : items) {this.paths.add(item);} return (A)this;
  }
  public A addAllToPaths(Collection<String> items) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    for (String item : items) {this.paths.add(item);} return (A)this;
  }
  public A removeFromPaths(java.lang.String... items) {
    if (this.paths == null) return (A)this;
    for (String item : items) { this.paths.remove(item);} return (A)this;
  }
  public A removeAllFromPaths(Collection<String> items) {
    if (this.paths == null) return (A)this;
    for (String item : items) { this.paths.remove(item);} return (A)this;
  }
  public List<String> getPaths() {
    return this.paths;
  }
  public String getPath(int index) {
    return this.paths.get(index);
  }
  public String getFirstPath() {
    return this.paths.get(0);
  }
  public String getLastPath() {
    return this.paths.get(paths.size() - 1);
  }
  public String getMatchingPath(Predicate<String> predicate) {
    for (String item: paths) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingPath(Predicate<String> predicate) {
    for (String item: paths) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPaths(List<String> paths) {
    if (paths != null) {this.paths = new ArrayList(); for (String item : paths){this.addToPaths(item);}} else { this.paths = null;} return (A) this;
  }
  public A withPaths(java.lang.String... paths) {
    if (this.paths != null) {this.paths.clear(); _visitables.remove("paths"); }
    if (paths != null) {for (String item :paths){ this.addToPaths(item);}} return (A) this;
  }
  public boolean hasPaths() {
    return paths != null && !paths.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RootPathsFluent that = (RootPathsFluent) o;
    if (!java.util.Objects.equals(paths, that.paths)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(paths,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (paths != null && !paths.isEmpty()) { sb.append("paths:"); sb.append(paths + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}