package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TypedObjectReferenceBuilder extends TypedObjectReferenceFluent<TypedObjectReferenceBuilder> implements VisitableBuilder<TypedObjectReference,TypedObjectReferenceBuilder>{
  public TypedObjectReferenceBuilder() {
    this(false);
  }
  public TypedObjectReferenceBuilder(Boolean validationEnabled) {
    this(new TypedObjectReference(), validationEnabled);
  }
  public TypedObjectReferenceBuilder(TypedObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public TypedObjectReferenceBuilder(TypedObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TypedObjectReference(), validationEnabled);
  }
  public TypedObjectReferenceBuilder(TypedObjectReferenceFluent<?> fluent,TypedObjectReference instance) {
    this(fluent, instance, false);
  }
  public TypedObjectReferenceBuilder(TypedObjectReferenceFluent<?> fluent,TypedObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TypedObjectReference());

    if (instance != null) {
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TypedObjectReferenceBuilder(TypedObjectReference instance) {
    this(instance,false);
  }
  public TypedObjectReferenceBuilder(TypedObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TypedObjectReference());

    if (instance != null) {
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TypedObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public TypedObjectReference build() {
    TypedObjectReference buildable = new TypedObjectReference(fluent.getApiGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}