package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VolumeMountFluent<A extends VolumeMountFluent<A>> extends BaseFluent<A>{
  public VolumeMountFluent() {
  }
  public VolumeMountFluent(VolumeMount instance) {
    instance = (instance != null ? instance : new VolumeMount());

    if (instance != null) {
      this.withMountPath(instance.getMountPath());
      this.withMountPropagation(instance.getMountPropagation());
      this.withName(instance.getName());
      this.withReadOnly(instance.getReadOnly());
      this.withSubPath(instance.getSubPath());
      this.withSubPathExpr(instance.getSubPathExpr());
      this.withMountPath(instance.getMountPath());
      this.withMountPropagation(instance.getMountPropagation());
      this.withName(instance.getName());
      this.withReadOnly(instance.getReadOnly());
      this.withSubPath(instance.getSubPath());
      this.withSubPathExpr(instance.getSubPathExpr());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String mountPath;
  private String mountPropagation;
  private String name;
  private Boolean readOnly;
  private String subPath;
  private String subPathExpr;
  private Map<String,Object> additionalProperties;
  public String getMountPath() {
    return this.mountPath;
  }
  public A withMountPath(String mountPath) {
    this.mountPath=mountPath; return (A) this;
  }
  public boolean hasMountPath() {
    return this.mountPath != null;
  }
  public String getMountPropagation() {
    return this.mountPropagation;
  }
  public A withMountPropagation(String mountPropagation) {
    this.mountPropagation=mountPropagation; return (A) this;
  }
  public boolean hasMountPropagation() {
    return this.mountPropagation != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public boolean hasReadOnly() {
    return this.readOnly != null;
  }
  public String getSubPath() {
    return this.subPath;
  }
  public A withSubPath(String subPath) {
    this.subPath=subPath; return (A) this;
  }
  public boolean hasSubPath() {
    return this.subPath != null;
  }
  public String getSubPathExpr() {
    return this.subPathExpr;
  }
  public A withSubPathExpr(String subPathExpr) {
    this.subPathExpr=subPathExpr; return (A) this;
  }
  public boolean hasSubPathExpr() {
    return this.subPathExpr != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VolumeMountFluent that = (VolumeMountFluent) o;
    if (!java.util.Objects.equals(mountPath, that.mountPath)) return false;

    if (!java.util.Objects.equals(mountPropagation, that.mountPropagation)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;

    if (!java.util.Objects.equals(subPath, that.subPath)) return false;

    if (!java.util.Objects.equals(subPathExpr, that.subPathExpr)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(mountPath,  mountPropagation,  name,  readOnly,  subPath,  subPathExpr,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mountPath != null) { sb.append("mountPath:"); sb.append(mountPath + ","); }
    if (mountPropagation != null) { sb.append("mountPropagation:"); sb.append(mountPropagation + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (subPath != null) { sb.append("subPath:"); sb.append(subPath + ","); }
    if (subPathExpr != null) { sb.append("subPathExpr:"); sb.append(subPathExpr + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReadOnly() {
    return withReadOnly(true);
  }
  
}