package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIGroupListBuilder extends APIGroupListFluent<APIGroupListBuilder> implements VisitableBuilder<APIGroupList,APIGroupListBuilder>{
  public APIGroupListBuilder() {
    this(false);
  }
  public APIGroupListBuilder(Boolean validationEnabled) {
    this(new APIGroupList(), validationEnabled);
  }
  public APIGroupListBuilder(APIGroupListFluent<?> fluent) {
    this(fluent, false);
  }
  public APIGroupListBuilder(APIGroupListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIGroupList(), validationEnabled);
  }
  public APIGroupListBuilder(APIGroupListFluent<?> fluent,APIGroupList instance) {
    this(fluent, instance, false);
  }
  public APIGroupListBuilder(APIGroupListFluent<?> fluent,APIGroupList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new APIGroupList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withGroups(instance.getGroups());
      fluent.withKind(instance.getKind());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withGroups(instance.getGroups());
      fluent.withKind(instance.getKind());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIGroupListBuilder(APIGroupList instance) {
    this(instance,false);
  }
  public APIGroupListBuilder(APIGroupList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new APIGroupList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withGroups(instance.getGroups());
      this.withKind(instance.getKind());
      this.withApiVersion(instance.getApiVersion());
      this.withGroups(instance.getGroups());
      this.withKind(instance.getKind());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIGroupListFluent<?> fluent;
  Boolean validationEnabled;
  public APIGroupList build() {
    APIGroupList buildable = new APIGroupList(fluent.getApiVersion(),fluent.buildGroups(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}