package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerStateTerminatedBuilder extends ContainerStateTerminatedFluent<ContainerStateTerminatedBuilder> implements VisitableBuilder<ContainerStateTerminated,ContainerStateTerminatedBuilder>{
  public ContainerStateTerminatedBuilder() {
    this(false);
  }
  public ContainerStateTerminatedBuilder(Boolean validationEnabled) {
    this(new ContainerStateTerminated(), validationEnabled);
  }
  public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerStateTerminated(), validationEnabled);
  }
  public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent,ContainerStateTerminated instance) {
    this(fluent, instance, false);
  }
  public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent,ContainerStateTerminated instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerStateTerminated());

    if (instance != null) {
      fluent.withContainerID(instance.getContainerID());
      fluent.withExitCode(instance.getExitCode());
      fluent.withFinishedAt(instance.getFinishedAt());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withSignal(instance.getSignal());
      fluent.withStartedAt(instance.getStartedAt());
      fluent.withContainerID(instance.getContainerID());
      fluent.withExitCode(instance.getExitCode());
      fluent.withFinishedAt(instance.getFinishedAt());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withSignal(instance.getSignal());
      fluent.withStartedAt(instance.getStartedAt());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerStateTerminatedBuilder(ContainerStateTerminated instance) {
    this(instance,false);
  }
  public ContainerStateTerminatedBuilder(ContainerStateTerminated instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerStateTerminated());

    if (instance != null) {
      this.withContainerID(instance.getContainerID());
      this.withExitCode(instance.getExitCode());
      this.withFinishedAt(instance.getFinishedAt());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withSignal(instance.getSignal());
      this.withStartedAt(instance.getStartedAt());
      this.withContainerID(instance.getContainerID());
      this.withExitCode(instance.getExitCode());
      this.withFinishedAt(instance.getFinishedAt());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withSignal(instance.getSignal());
      this.withStartedAt(instance.getStartedAt());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerStateTerminatedFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerStateTerminated build() {
    ContainerStateTerminated buildable = new ContainerStateTerminated(fluent.getContainerID(),fluent.getExitCode(),fluent.getFinishedAt(),fluent.getMessage(),fluent.getReason(),fluent.getSignal(),fluent.getStartedAt());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}