package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DownwardAPIProjectionBuilder extends DownwardAPIProjectionFluent<DownwardAPIProjectionBuilder> implements VisitableBuilder<DownwardAPIProjection,DownwardAPIProjectionBuilder>{
  public DownwardAPIProjectionBuilder() {
    this(false);
  }
  public DownwardAPIProjectionBuilder(Boolean validationEnabled) {
    this(new DownwardAPIProjection(), validationEnabled);
  }
  public DownwardAPIProjectionBuilder(DownwardAPIProjectionFluent<?> fluent) {
    this(fluent, false);
  }
  public DownwardAPIProjectionBuilder(DownwardAPIProjectionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DownwardAPIProjection(), validationEnabled);
  }
  public DownwardAPIProjectionBuilder(DownwardAPIProjectionFluent<?> fluent,DownwardAPIProjection instance) {
    this(fluent, instance, false);
  }
  public DownwardAPIProjectionBuilder(DownwardAPIProjectionFluent<?> fluent,DownwardAPIProjection instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DownwardAPIProjection());

    if (instance != null) {
      fluent.withItems(instance.getItems());
      fluent.withItems(instance.getItems());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DownwardAPIProjectionBuilder(DownwardAPIProjection instance) {
    this(instance,false);
  }
  public DownwardAPIProjectionBuilder(DownwardAPIProjection instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DownwardAPIProjection());

    if (instance != null) {
      this.withItems(instance.getItems());
      this.withItems(instance.getItems());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DownwardAPIProjectionFluent<?> fluent;
  Boolean validationEnabled;
  public DownwardAPIProjection build() {
    DownwardAPIProjection buildable = new DownwardAPIProjection(fluent.buildItems());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}