package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointsBuilder extends EndpointsFluent<EndpointsBuilder> implements VisitableBuilder<Endpoints,EndpointsBuilder>{
  public EndpointsBuilder() {
    this(false);
  }
  public EndpointsBuilder(Boolean validationEnabled) {
    this(new Endpoints(), validationEnabled);
  }
  public EndpointsBuilder(EndpointsFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointsBuilder(EndpointsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Endpoints(), validationEnabled);
  }
  public EndpointsBuilder(EndpointsFluent<?> fluent,Endpoints instance) {
    this(fluent, instance, false);
  }
  public EndpointsBuilder(EndpointsFluent<?> fluent,Endpoints instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Endpoints());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSubsets(instance.getSubsets());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSubsets(instance.getSubsets());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EndpointsBuilder(Endpoints instance) {
    this(instance,false);
  }
  public EndpointsBuilder(Endpoints instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Endpoints());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSubsets(instance.getSubsets());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSubsets(instance.getSubsets());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EndpointsFluent<?> fluent;
  Boolean validationEnabled;
  public Endpoints build() {
    Endpoints buildable = new Endpoints(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSubsets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}