package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupVersionKindBuilder extends GroupVersionKindFluent<GroupVersionKindBuilder> implements VisitableBuilder<GroupVersionKind,GroupVersionKindBuilder>{
  public GroupVersionKindBuilder() {
    this(false);
  }
  public GroupVersionKindBuilder(Boolean validationEnabled) {
    this(new GroupVersionKind(), validationEnabled);
  }
  public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GroupVersionKind(), validationEnabled);
  }
  public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent,GroupVersionKind instance) {
    this(fluent, instance, false);
  }
  public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent,GroupVersionKind instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GroupVersionKind());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withVersion(instance.getVersion());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GroupVersionKindBuilder(GroupVersionKind instance) {
    this(instance,false);
  }
  public GroupVersionKindBuilder(GroupVersionKind instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GroupVersionKind());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withVersion(instance.getVersion());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GroupVersionKindFluent<?> fluent;
  Boolean validationEnabled;
  public GroupVersionKind build() {
    GroupVersionKind buildable = new GroupVersionKind(fluent.getGroup(),fluent.getKind(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}