package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupVersionResourceBuilder extends GroupVersionResourceFluent<GroupVersionResourceBuilder> implements VisitableBuilder<GroupVersionResource,GroupVersionResourceBuilder>{
  public GroupVersionResourceBuilder() {
    this(false);
  }
  public GroupVersionResourceBuilder(Boolean validationEnabled) {
    this(new GroupVersionResource(), validationEnabled);
  }
  public GroupVersionResourceBuilder(GroupVersionResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupVersionResourceBuilder(GroupVersionResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GroupVersionResource(), validationEnabled);
  }
  public GroupVersionResourceBuilder(GroupVersionResourceFluent<?> fluent,GroupVersionResource instance) {
    this(fluent, instance, false);
  }
  public GroupVersionResourceBuilder(GroupVersionResourceFluent<?> fluent,GroupVersionResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GroupVersionResource());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withResource(instance.getResource());
      fluent.withVersion(instance.getVersion());
      fluent.withGroup(instance.getGroup());
      fluent.withResource(instance.getResource());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GroupVersionResourceBuilder(GroupVersionResource instance) {
    this(instance,false);
  }
  public GroupVersionResourceBuilder(GroupVersionResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GroupVersionResource());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withResource(instance.getResource());
      this.withVersion(instance.getVersion());
      this.withGroup(instance.getGroup());
      this.withResource(instance.getResource());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GroupVersionResourceFluent<?> fluent;
  Boolean validationEnabled;
  public GroupVersionResource build() {
    GroupVersionResource buildable = new GroupVersionResource(fluent.getGroup(),fluent.getResource(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}