package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeAddressBuilder extends NodeAddressFluent<NodeAddressBuilder> implements VisitableBuilder<NodeAddress,NodeAddressBuilder>{
  public NodeAddressBuilder() {
    this(false);
  }
  public NodeAddressBuilder(Boolean validationEnabled) {
    this(new NodeAddress(), validationEnabled);
  }
  public NodeAddressBuilder(NodeAddressFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeAddressBuilder(NodeAddressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeAddress(), validationEnabled);
  }
  public NodeAddressBuilder(NodeAddressFluent<?> fluent,NodeAddress instance) {
    this(fluent, instance, false);
  }
  public NodeAddressBuilder(NodeAddressFluent<?> fluent,NodeAddress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodeAddress());

    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withType(instance.getType());
      fluent.withAddress(instance.getAddress());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeAddressBuilder(NodeAddress instance) {
    this(instance,false);
  }
  public NodeAddressBuilder(NodeAddress instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodeAddress());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withType(instance.getType());
      this.withAddress(instance.getAddress());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeAddressFluent<?> fluent;
  Boolean validationEnabled;
  public NodeAddress build() {
    NodeAddress buildable = new NodeAddress(fluent.getAddress(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}