package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PortStatusBuilder extends PortStatusFluent<PortStatusBuilder> implements VisitableBuilder<PortStatus,PortStatusBuilder>{
  public PortStatusBuilder() {
    this(false);
  }
  public PortStatusBuilder(Boolean validationEnabled) {
    this(new PortStatus(), validationEnabled);
  }
  public PortStatusBuilder(PortStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PortStatusBuilder(PortStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PortStatus(), validationEnabled);
  }
  public PortStatusBuilder(PortStatusFluent<?> fluent,PortStatus instance) {
    this(fluent, instance, false);
  }
  public PortStatusBuilder(PortStatusFluent<?> fluent,PortStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PortStatus());

    if (instance != null) {
      fluent.withError(instance.getError());
      fluent.withPort(instance.getPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withError(instance.getError());
      fluent.withPort(instance.getPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PortStatusBuilder(PortStatus instance) {
    this(instance,false);
  }
  public PortStatusBuilder(PortStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PortStatus());

    if (instance != null) {
      this.withError(instance.getError());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withError(instance.getError());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PortStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PortStatus build() {
    PortStatus buildable = new PortStatus(fluent.getError(),fluent.getPort(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}