package io.fabric8.kubernetes.api.model;

import java.lang.String;
import io.fabric8.kubernetes.api.model.version.Info;
import io.fabric8.kubernetes.api.model.version.InfoBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.version.InfoFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import java.util.Map;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WatchEventFluent<A extends WatchEventFluent<A>> extends BaseFluent<A>{
  public WatchEventFluent() {
  }
  public WatchEventFluent(WatchEvent instance) {
    instance = (instance != null ? instance : new WatchEvent());

    if (instance != null) {
      this.withObject(instance.getObject());
      this.withType(instance.getType());
      this.withObject(instance.getObject());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private VisitableBuilder<? extends KubernetesResource,?> object;
  private String type;
  private Map<String,Object> additionalProperties;
  public KubernetesResource buildObject() {
    return this.object!=null?this.object.build():null;
  }
  public A withObject(KubernetesResource object) {
    if (object==null){ this.object = null; _visitables.remove("object"); return (A) this;}
    VisitableBuilder<? extends KubernetesResource,?> builder = builder(object); _visitables.get("object").clear();_visitables.get("object").add(builder);this.object = builder;
    return (A) this;
  }
  public boolean hasObject() {
    return this.object != null;
  }
  public PatchObjectNested<A> withNewPatchObject() {
    return new PatchObjectNested(null);
  }
  public PatchObjectNested<A> withNewPatchObjectLike(Patch item) {
    return new PatchObjectNested(item);
  }
  public LimitRangeObjectNested<A> withNewLimitRangeObject() {
    return new LimitRangeObjectNested(null);
  }
  public LimitRangeObjectNested<A> withNewLimitRangeObjectLike(LimitRange item) {
    return new LimitRangeObjectNested(item);
  }
  public APIGroupListObjectNested<A> withNewAPIGroupListObject() {
    return new APIGroupListObjectNested(null);
  }
  public APIGroupListObjectNested<A> withNewAPIGroupListObjectLike(APIGroupList item) {
    return new APIGroupListObjectNested(item);
  }
  public PortStatusObjectNested<A> withNewPortStatusObject() {
    return new PortStatusObjectNested(null);
  }
  public PortStatusObjectNested<A> withNewPortStatusObjectLike(PortStatus item) {
    return new PortStatusObjectNested(item);
  }
  public A withNewPortStatusObject(String error,Integer port,String protocol) {
    return (A)withObject(new PortStatus(error, port, protocol));
  }
  public PodTemplateSpecObjectNested<A> withNewPodTemplateSpecObject() {
    return new PodTemplateSpecObjectNested(null);
  }
  public PodTemplateSpecObjectNested<A> withNewPodTemplateSpecObjectLike(PodTemplateSpec item) {
    return new PodTemplateSpecObjectNested(item);
  }
  public CSIPersistentVolumeSourceObjectNested<A> withNewCSIPersistentVolumeSourceObject() {
    return new CSIPersistentVolumeSourceObjectNested(null);
  }
  public CSIPersistentVolumeSourceObjectNested<A> withNewCSIPersistentVolumeSourceObjectLike(CSIPersistentVolumeSource item) {
    return new CSIPersistentVolumeSourceObjectNested(item);
  }
  public AuthInfoObjectNested<A> withNewAuthInfoObject() {
    return new AuthInfoObjectNested(null);
  }
  public AuthInfoObjectNested<A> withNewAuthInfoObjectLike(AuthInfo item) {
    return new AuthInfoObjectNested(item);
  }
  public APIServiceObjectNested<A> withNewAPIServiceObject() {
    return new APIServiceObjectNested(null);
  }
  public APIServiceObjectNested<A> withNewAPIServiceObjectLike(APIService item) {
    return new APIServiceObjectNested(item);
  }
  public ResourceRequirementsObjectNested<A> withNewResourceRequirementsObject() {
    return new ResourceRequirementsObjectNested(null);
  }
  public ResourceRequirementsObjectNested<A> withNewResourceRequirementsObjectLike(ResourceRequirements item) {
    return new ResourceRequirementsObjectNested(item);
  }
  public ConfigMapKeySelectorObjectNested<A> withNewConfigMapKeySelectorObject() {
    return new ConfigMapKeySelectorObjectNested(null);
  }
  public ConfigMapKeySelectorObjectNested<A> withNewConfigMapKeySelectorObjectLike(ConfigMapKeySelector item) {
    return new ConfigMapKeySelectorObjectNested(item);
  }
  public A withNewConfigMapKeySelectorObject(String key,String name,Boolean optional) {
    return (A)withObject(new ConfigMapKeySelector(key, name, optional));
  }
  public HostPathVolumeSourceObjectNested<A> withNewHostPathVolumeSourceObject() {
    return new HostPathVolumeSourceObjectNested(null);
  }
  public HostPathVolumeSourceObjectNested<A> withNewHostPathVolumeSourceObjectLike(HostPathVolumeSource item) {
    return new HostPathVolumeSourceObjectNested(item);
  }
  public A withNewHostPathVolumeSourceObject(String path,String type) {
    return (A)withObject(new HostPathVolumeSource(path, type));
  }
  public PersistentVolumeClaimListObjectNested<A> withNewPersistentVolumeClaimListObject() {
    return new PersistentVolumeClaimListObjectNested(null);
  }
  public PersistentVolumeClaimListObjectNested<A> withNewPersistentVolumeClaimListObjectLike(PersistentVolumeClaimList item) {
    return new PersistentVolumeClaimListObjectNested(item);
  }
  public NamedContextObjectNested<A> withNewNamedContextObject() {
    return new NamedContextObjectNested(null);
  }
  public NamedContextObjectNested<A> withNewNamedContextObjectLike(NamedContext item) {
    return new NamedContextObjectNested(item);
  }
  public ConfigObjectNested<A> withNewConfigObject() {
    return new ConfigObjectNested(null);
  }
  public ConfigObjectNested<A> withNewConfigObjectLike(Config item) {
    return new ConfigObjectNested(item);
  }
  public AffinityObjectNested<A> withNewAffinityObject() {
    return new AffinityObjectNested(null);
  }
  public AffinityObjectNested<A> withNewAffinityObjectLike(Affinity item) {
    return new AffinityObjectNested(item);
  }
  public PodResourceClaimObjectNested<A> withNewPodResourceClaimObject() {
    return new PodResourceClaimObjectNested(null);
  }
  public PodResourceClaimObjectNested<A> withNewPodResourceClaimObjectLike(PodResourceClaim item) {
    return new PodResourceClaimObjectNested(item);
  }
  public ReplicationControllerStatusObjectNested<A> withNewReplicationControllerStatusObject() {
    return new ReplicationControllerStatusObjectNested(null);
  }
  public ReplicationControllerStatusObjectNested<A> withNewReplicationControllerStatusObjectLike(ReplicationControllerStatus item) {
    return new ReplicationControllerStatusObjectNested(item);
  }
  public APIServiceStatusObjectNested<A> withNewAPIServiceStatusObject() {
    return new APIServiceStatusObjectNested(null);
  }
  public APIServiceStatusObjectNested<A> withNewAPIServiceStatusObjectLike(APIServiceStatus item) {
    return new APIServiceStatusObjectNested(item);
  }
  public MicroTimeObjectNested<A> withNewMicroTimeObject() {
    return new MicroTimeObjectNested(null);
  }
  public MicroTimeObjectNested<A> withNewMicroTimeObjectLike(MicroTime item) {
    return new MicroTimeObjectNested(item);
  }
  public A withNewMicroTimeObject(String time) {
    return (A)withObject(new MicroTime(time));
  }
  public LifecycleObjectNested<A> withNewLifecycleObject() {
    return new LifecycleObjectNested(null);
  }
  public LifecycleObjectNested<A> withNewLifecycleObjectLike(Lifecycle item) {
    return new LifecycleObjectNested(item);
  }
  public PortworxVolumeSourceObjectNested<A> withNewPortworxVolumeSourceObject() {
    return new PortworxVolumeSourceObjectNested(null);
  }
  public PortworxVolumeSourceObjectNested<A> withNewPortworxVolumeSourceObjectLike(PortworxVolumeSource item) {
    return new PortworxVolumeSourceObjectNested(item);
  }
  public A withNewPortworxVolumeSourceObject(String fsType,Boolean readOnly,String volumeID) {
    return (A)withObject(new PortworxVolumeSource(fsType, readOnly, volumeID));
  }
  public EventSourceObjectNested<A> withNewEventSourceObject() {
    return new EventSourceObjectNested(null);
  }
  public EventSourceObjectNested<A> withNewEventSourceObjectLike(EventSource item) {
    return new EventSourceObjectNested(item);
  }
  public A withNewEventSourceObject(String component,String host) {
    return (A)withObject(new EventSource(component, host));
  }
  public GRPCActionObjectNested<A> withNewGRPCActionObject() {
    return new GRPCActionObjectNested(null);
  }
  public GRPCActionObjectNested<A> withNewGRPCActionObjectLike(GRPCAction item) {
    return new GRPCActionObjectNested(item);
  }
  public A withNewGRPCActionObject(Integer port,String service) {
    return (A)withObject(new GRPCAction(port, service));
  }
  public AzureFileVolumeSourceObjectNested<A> withNewAzureFileVolumeSourceObject() {
    return new AzureFileVolumeSourceObjectNested(null);
  }
  public AzureFileVolumeSourceObjectNested<A> withNewAzureFileVolumeSourceObjectLike(AzureFileVolumeSource item) {
    return new AzureFileVolumeSourceObjectNested(item);
  }
  public A withNewAzureFileVolumeSourceObject(Boolean readOnly,String secretName,String shareName) {
    return (A)withObject(new AzureFileVolumeSource(readOnly, secretName, shareName));
  }
  public ResourceClaimObjectNested<A> withNewResourceClaimObject() {
    return new ResourceClaimObjectNested(null);
  }
  public ResourceClaimObjectNested<A> withNewResourceClaimObjectLike(ResourceClaim item) {
    return new ResourceClaimObjectNested(item);
  }
  public A withNewResourceClaimObject(String name) {
    return (A)withObject(new ResourceClaim(name));
  }
  public ComponentConditionObjectNested<A> withNewComponentConditionObject() {
    return new ComponentConditionObjectNested(null);
  }
  public ComponentConditionObjectNested<A> withNewComponentConditionObjectLike(ComponentCondition item) {
    return new ComponentConditionObjectNested(item);
  }
  public A withNewComponentConditionObject(String error,String message,String status,String type) {
    return (A)withObject(new ComponentCondition(error, message, status, type));
  }
  public EnvVarObjectNested<A> withNewEnvVarObject() {
    return new EnvVarObjectNested(null);
  }
  public EnvVarObjectNested<A> withNewEnvVarObjectLike(EnvVar item) {
    return new EnvVarObjectNested(item);
  }
  public ReplicationControllerSpecObjectNested<A> withNewReplicationControllerSpecObject() {
    return new ReplicationControllerSpecObjectNested(null);
  }
  public ReplicationControllerSpecObjectNested<A> withNewReplicationControllerSpecObjectLike(ReplicationControllerSpec item) {
    return new ReplicationControllerSpecObjectNested(item);
  }
  public LoadBalancerIngressObjectNested<A> withNewLoadBalancerIngressObject() {
    return new LoadBalancerIngressObjectNested(null);
  }
  public LoadBalancerIngressObjectNested<A> withNewLoadBalancerIngressObjectLike(LoadBalancerIngress item) {
    return new LoadBalancerIngressObjectNested(item);
  }
  public AttachedVolumeObjectNested<A> withNewAttachedVolumeObject() {
    return new AttachedVolumeObjectNested(null);
  }
  public AttachedVolumeObjectNested<A> withNewAttachedVolumeObjectLike(AttachedVolume item) {
    return new AttachedVolumeObjectNested(item);
  }
  public A withNewAttachedVolumeObject(String devicePath,String name) {
    return (A)withObject(new AttachedVolume(devicePath, name));
  }
  public LocalObjectReferenceNested<A> withNewLocalObjectReference() {
    return new LocalObjectReferenceNested(null);
  }
  public LocalObjectReferenceNested<A> withNewLocalObjectReferenceLike(LocalObjectReference item) {
    return new LocalObjectReferenceNested(item);
  }
  public A withNewLocalObjectReference(String name) {
    return (A)withObject(new LocalObjectReference(name));
  }
  public NamedAuthInfoObjectNested<A> withNewNamedAuthInfoObject() {
    return new NamedAuthInfoObjectNested(null);
  }
  public NamedAuthInfoObjectNested<A> withNewNamedAuthInfoObjectLike(NamedAuthInfo item) {
    return new NamedAuthInfoObjectNested(item);
  }
  public EmptyDirVolumeSourceObjectNested<A> withNewEmptyDirVolumeSourceObject() {
    return new EmptyDirVolumeSourceObjectNested(null);
  }
  public EmptyDirVolumeSourceObjectNested<A> withNewEmptyDirVolumeSourceObjectLike(EmptyDirVolumeSource item) {
    return new EmptyDirVolumeSourceObjectNested(item);
  }
  public PodSpecObjectNested<A> withNewPodSpecObject() {
    return new PodSpecObjectNested(null);
  }
  public PodSpecObjectNested<A> withNewPodSpecObjectLike(PodSpec item) {
    return new PodSpecObjectNested(item);
  }
  public ServerAddressByClientCIDRObjectNested<A> withNewServerAddressByClientCIDRObject() {
    return new ServerAddressByClientCIDRObjectNested(null);
  }
  public ServerAddressByClientCIDRObjectNested<A> withNewServerAddressByClientCIDRObjectLike(ServerAddressByClientCIDR item) {
    return new ServerAddressByClientCIDRObjectNested(item);
  }
  public A withNewServerAddressByClientCIDRObject(String clientCIDR,String serverAddress) {
    return (A)withObject(new ServerAddressByClientCIDR(clientCIDR, serverAddress));
  }
  public AzureDiskVolumeSourceObjectNested<A> withNewAzureDiskVolumeSourceObject() {
    return new AzureDiskVolumeSourceObjectNested(null);
  }
  public AzureDiskVolumeSourceObjectNested<A> withNewAzureDiskVolumeSourceObjectLike(AzureDiskVolumeSource item) {
    return new AzureDiskVolumeSourceObjectNested(item);
  }
  public PreconditionsObjectNested<A> withNewPreconditionsObject() {
    return new PreconditionsObjectNested(null);
  }
  public PreconditionsObjectNested<A> withNewPreconditionsObjectLike(Preconditions item) {
    return new PreconditionsObjectNested(item);
  }
  public A withNewPreconditionsObject(String resourceVersion,String uid) {
    return (A)withObject(new Preconditions(resourceVersion, uid));
  }
  public InfoObjectNested<A> withNewInfoObject() {
    return new InfoObjectNested(null);
  }
  public InfoObjectNested<A> withNewInfoObjectLike(Info item) {
    return new InfoObjectNested(item);
  }
  public CephFSVolumeSourceObjectNested<A> withNewCephFSVolumeSourceObject() {
    return new CephFSVolumeSourceObjectNested(null);
  }
  public CephFSVolumeSourceObjectNested<A> withNewCephFSVolumeSourceObjectLike(CephFSVolumeSource item) {
    return new CephFSVolumeSourceObjectNested(item);
  }
  public EphemeralContainerObjectNested<A> withNewEphemeralContainerObject() {
    return new EphemeralContainerObjectNested(null);
  }
  public EphemeralContainerObjectNested<A> withNewEphemeralContainerObjectLike(EphemeralContainer item) {
    return new EphemeralContainerObjectNested(item);
  }
  public NodeConditionObjectNested<A> withNewNodeConditionObject() {
    return new NodeConditionObjectNested(null);
  }
  public NodeConditionObjectNested<A> withNewNodeConditionObjectLike(NodeCondition item) {
    return new NodeConditionObjectNested(item);
  }
  public EndpointSubsetObjectNested<A> withNewEndpointSubsetObject() {
    return new EndpointSubsetObjectNested(null);
  }
  public EndpointSubsetObjectNested<A> withNewEndpointSubsetObjectLike(EndpointSubset item) {
    return new EndpointSubsetObjectNested(item);
  }
  public LocalVolumeSourceObjectNested<A> withNewLocalVolumeSourceObject() {
    return new LocalVolumeSourceObjectNested(null);
  }
  public LocalVolumeSourceObjectNested<A> withNewLocalVolumeSourceObjectLike(LocalVolumeSource item) {
    return new LocalVolumeSourceObjectNested(item);
  }
  public A withNewLocalVolumeSourceObject(String fsType,String path) {
    return (A)withObject(new LocalVolumeSource(fsType, path));
  }
  public ServiceReferenceObjectNested<A> withNewServiceReferenceObject() {
    return new ServiceReferenceObjectNested(null);
  }
  public ServiceReferenceObjectNested<A> withNewServiceReferenceObjectLike(ServiceReference item) {
    return new ServiceReferenceObjectNested(item);
  }
  public A withNewServiceReferenceObject(String name,String namespace,Integer port) {
    return (A)withObject(new ServiceReference(name, namespace, port));
  }
  public ServiceStatusObjectNested<A> withNewServiceStatusObject() {
    return new ServiceStatusObjectNested(null);
  }
  public ServiceStatusObjectNested<A> withNewServiceStatusObjectLike(ServiceStatus item) {
    return new ServiceStatusObjectNested(item);
  }
  public TaintObjectNested<A> withNewTaintObject() {
    return new TaintObjectNested(null);
  }
  public TaintObjectNested<A> withNewTaintObjectLike(Taint item) {
    return new TaintObjectNested(item);
  }
  public A withNewTaintObject(String effect,String key,String timeAdded,String value) {
    return (A)withObject(new Taint(effect, key, timeAdded, value));
  }
  public PatchOptionsObjectNested<A> withNewPatchOptionsObject() {
    return new PatchOptionsObjectNested(null);
  }
  public PatchOptionsObjectNested<A> withNewPatchOptionsObjectLike(PatchOptions item) {
    return new PatchOptionsObjectNested(item);
  }
  public ConfigMapNodeConfigSourceObjectNested<A> withNewConfigMapNodeConfigSourceObject() {
    return new ConfigMapNodeConfigSourceObjectNested(null);
  }
  public ConfigMapNodeConfigSourceObjectNested<A> withNewConfigMapNodeConfigSourceObjectLike(ConfigMapNodeConfigSource item) {
    return new ConfigMapNodeConfigSourceObjectNested(item);
  }
  public A withNewConfigMapNodeConfigSourceObject(String kubeletConfigKey,String name,String namespace,String resourceVersion,String uid) {
    return (A)withObject(new ConfigMapNodeConfigSource(kubeletConfigKey, name, namespace, resourceVersion, uid));
  }
  public HTTPGetActionObjectNested<A> withNewHTTPGetActionObject() {
    return new HTTPGetActionObjectNested(null);
  }
  public HTTPGetActionObjectNested<A> withNewHTTPGetActionObjectLike(HTTPGetAction item) {
    return new HTTPGetActionObjectNested(item);
  }
  public GlusterfsPersistentVolumeSourceObjectNested<A> withNewGlusterfsPersistentVolumeSourceObject() {
    return new GlusterfsPersistentVolumeSourceObjectNested(null);
  }
  public GlusterfsPersistentVolumeSourceObjectNested<A> withNewGlusterfsPersistentVolumeSourceObjectLike(GlusterfsPersistentVolumeSource item) {
    return new GlusterfsPersistentVolumeSourceObjectNested(item);
  }
  public A withNewGlusterfsPersistentVolumeSourceObject(String endpoints,String endpointsNamespace,String path,Boolean readOnly) {
    return (A)withObject(new GlusterfsPersistentVolumeSource(endpoints, endpointsNamespace, path, readOnly));
  }
  public DownwardAPIVolumeSourceObjectNested<A> withNewDownwardAPIVolumeSourceObject() {
    return new DownwardAPIVolumeSourceObjectNested(null);
  }
  public DownwardAPIVolumeSourceObjectNested<A> withNewDownwardAPIVolumeSourceObjectLike(DownwardAPIVolumeSource item) {
    return new DownwardAPIVolumeSourceObjectNested(item);
  }
  public ISCSIPersistentVolumeSourceObjectNested<A> withNewISCSIPersistentVolumeSourceObject() {
    return new ISCSIPersistentVolumeSourceObjectNested(null);
  }
  public ISCSIPersistentVolumeSourceObjectNested<A> withNewISCSIPersistentVolumeSourceObjectLike(ISCSIPersistentVolumeSource item) {
    return new ISCSIPersistentVolumeSourceObjectNested(item);
  }
  public WindowsSecurityContextOptionsObjectNested<A> withNewWindowsSecurityContextOptionsObject() {
    return new WindowsSecurityContextOptionsObjectNested(null);
  }
  public WindowsSecurityContextOptionsObjectNested<A> withNewWindowsSecurityContextOptionsObjectLike(WindowsSecurityContextOptions item) {
    return new WindowsSecurityContextOptionsObjectNested(item);
  }
  public A withNewWindowsSecurityContextOptionsObject(String gmsaCredentialSpec,String gmsaCredentialSpecName,Boolean hostProcess,String runAsUserName) {
    return (A)withObject(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, hostProcess, runAsUserName));
  }
  public CreateOptionsObjectNested<A> withNewCreateOptionsObject() {
    return new CreateOptionsObjectNested(null);
  }
  public CreateOptionsObjectNested<A> withNewCreateOptionsObjectLike(CreateOptions item) {
    return new CreateOptionsObjectNested(item);
  }
  public EnvFromSourceObjectNested<A> withNewEnvFromSourceObject() {
    return new EnvFromSourceObjectNested(null);
  }
  public EnvFromSourceObjectNested<A> withNewEnvFromSourceObjectLike(EnvFromSource item) {
    return new EnvFromSourceObjectNested(item);
  }
  public NamespaceSpecObjectNested<A> withNewNamespaceSpecObject() {
    return new NamespaceSpecObjectNested(null);
  }
  public NamespaceSpecObjectNested<A> withNewNamespaceSpecObjectLike(NamespaceSpec item) {
    return new NamespaceSpecObjectNested(item);
  }
  public TypeMetaObjectNested<A> withNewTypeMetaObject() {
    return new TypeMetaObjectNested(null);
  }
  public TypeMetaObjectNested<A> withNewTypeMetaObjectLike(TypeMeta item) {
    return new TypeMetaObjectNested(item);
  }
  public A withNewTypeMetaObject(String apiVersion,String kind) {
    return (A)withObject(new TypeMeta(apiVersion, kind));
  }
  public RootPathsObjectNested<A> withNewRootPathsObject() {
    return new RootPathsObjectNested(null);
  }
  public RootPathsObjectNested<A> withNewRootPathsObjectLike(RootPaths item) {
    return new RootPathsObjectNested(item);
  }
  public ListMetaObjectNested<A> withNewListMetaObject() {
    return new ListMetaObjectNested(null);
  }
  public ListMetaObjectNested<A> withNewListMetaObjectLike(ListMeta item) {
    return new ListMetaObjectNested(item);
  }
  public A withNewListMetaObject(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withObject(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public SecretReferenceObjectNested<A> withNewSecretReferenceObject() {
    return new SecretReferenceObjectNested(null);
  }
  public SecretReferenceObjectNested<A> withNewSecretReferenceObjectLike(SecretReference item) {
    return new SecretReferenceObjectNested(item);
  }
  public A withNewSecretReferenceObject(String name,String namespace) {
    return (A)withObject(new SecretReference(name, namespace));
  }
  public APIGroupObjectNested<A> withNewAPIGroupObject() {
    return new APIGroupObjectNested(null);
  }
  public APIGroupObjectNested<A> withNewAPIGroupObjectLike(APIGroup item) {
    return new APIGroupObjectNested(item);
  }
  public FlexVolumeSourceObjectNested<A> withNewFlexVolumeSourceObject() {
    return new FlexVolumeSourceObjectNested(null);
  }
  public FlexVolumeSourceObjectNested<A> withNewFlexVolumeSourceObjectLike(FlexVolumeSource item) {
    return new FlexVolumeSourceObjectNested(item);
  }
  public PersistentVolumeClaimTemplateObjectNested<A> withNewPersistentVolumeClaimTemplateObject() {
    return new PersistentVolumeClaimTemplateObjectNested(null);
  }
  public PersistentVolumeClaimTemplateObjectNested<A> withNewPersistentVolumeClaimTemplateObjectLike(PersistentVolumeClaimTemplate item) {
    return new PersistentVolumeClaimTemplateObjectNested(item);
  }
  public ISCSIVolumeSourceObjectNested<A> withNewISCSIVolumeSourceObject() {
    return new ISCSIVolumeSourceObjectNested(null);
  }
  public ISCSIVolumeSourceObjectNested<A> withNewISCSIVolumeSourceObjectLike(ISCSIVolumeSource item) {
    return new ISCSIVolumeSourceObjectNested(item);
  }
  public SecretKeySelectorObjectNested<A> withNewSecretKeySelectorObject() {
    return new SecretKeySelectorObjectNested(null);
  }
  public SecretKeySelectorObjectNested<A> withNewSecretKeySelectorObjectLike(SecretKeySelector item) {
    return new SecretKeySelectorObjectNested(item);
  }
  public A withNewSecretKeySelectorObject(String key,String name,Boolean optional) {
    return (A)withObject(new SecretKeySelector(key, name, optional));
  }
  public RBDVolumeSourceObjectNested<A> withNewRBDVolumeSourceObject() {
    return new RBDVolumeSourceObjectNested(null);
  }
  public RBDVolumeSourceObjectNested<A> withNewRBDVolumeSourceObjectLike(RBDVolumeSource item) {
    return new RBDVolumeSourceObjectNested(item);
  }
  public NodeConfigStatusObjectNested<A> withNewNodeConfigStatusObject() {
    return new NodeConfigStatusObjectNested(null);
  }
  public NodeConfigStatusObjectNested<A> withNewNodeConfigStatusObjectLike(NodeConfigStatus item) {
    return new NodeConfigStatusObjectNested(item);
  }
  public ResourceQuotaListObjectNested<A> withNewResourceQuotaListObject() {
    return new ResourceQuotaListObjectNested(null);
  }
  public ResourceQuotaListObjectNested<A> withNewResourceQuotaListObjectLike(ResourceQuotaList item) {
    return new ResourceQuotaListObjectNested(item);
  }
  public QuobyteVolumeSourceObjectNested<A> withNewQuobyteVolumeSourceObject() {
    return new QuobyteVolumeSourceObjectNested(null);
  }
  public QuobyteVolumeSourceObjectNested<A> withNewQuobyteVolumeSourceObjectLike(QuobyteVolumeSource item) {
    return new QuobyteVolumeSourceObjectNested(item);
  }
  public APIResourceObjectNested<A> withNewAPIResourceObject() {
    return new APIResourceObjectNested(null);
  }
  public APIResourceObjectNested<A> withNewAPIResourceObjectLike(APIResource item) {
    return new APIResourceObjectNested(item);
  }
  public ResourceQuotaStatusObjectNested<A> withNewResourceQuotaStatusObject() {
    return new ResourceQuotaStatusObjectNested(null);
  }
  public ResourceQuotaStatusObjectNested<A> withNewResourceQuotaStatusObjectLike(ResourceQuotaStatus item) {
    return new ResourceQuotaStatusObjectNested(item);
  }
  public RawExtensionObjectNested<A> withNewRawExtensionObject() {
    return new RawExtensionObjectNested(null);
  }
  public RawExtensionObjectNested<A> withNewRawExtensionObjectLike(RawExtension item) {
    return new RawExtensionObjectNested(item);
  }
  public A withNewRawExtensionObject(Object value) {
    return (A)withObject(new RawExtension(value));
  }
  public ConfigMapProjectionObjectNested<A> withNewConfigMapProjectionObject() {
    return new ConfigMapProjectionObjectNested(null);
  }
  public ConfigMapProjectionObjectNested<A> withNewConfigMapProjectionObjectLike(ConfigMapProjection item) {
    return new ConfigMapProjectionObjectNested(item);
  }
  public ScopedResourceSelectorRequirementObjectNested<A> withNewScopedResourceSelectorRequirementObject() {
    return new ScopedResourceSelectorRequirementObjectNested(null);
  }
  public ScopedResourceSelectorRequirementObjectNested<A> withNewScopedResourceSelectorRequirementObjectLike(ScopedResourceSelectorRequirement item) {
    return new ScopedResourceSelectorRequirementObjectNested(item);
  }
  public NamespaceObjectNested<A> withNewNamespaceObject() {
    return new NamespaceObjectNested(null);
  }
  public NamespaceObjectNested<A> withNewNamespaceObjectLike(Namespace item) {
    return new NamespaceObjectNested(item);
  }
  public GroupVersionKindObjectNested<A> withNewGroupVersionKindObject() {
    return new GroupVersionKindObjectNested(null);
  }
  public GroupVersionKindObjectNested<A> withNewGroupVersionKindObjectLike(GroupVersionKind item) {
    return new GroupVersionKindObjectNested(item);
  }
  public A withNewGroupVersionKindObject(String group,String kind,String version) {
    return (A)withObject(new GroupVersionKind(group, kind, version));
  }
  public ContainerStateTerminatedObjectNested<A> withNewContainerStateTerminatedObject() {
    return new ContainerStateTerminatedObjectNested(null);
  }
  public ContainerStateTerminatedObjectNested<A> withNewContainerStateTerminatedObjectLike(ContainerStateTerminated item) {
    return new ContainerStateTerminatedObjectNested(item);
  }
  public LimitRangeSpecObjectNested<A> withNewLimitRangeSpecObject() {
    return new LimitRangeSpecObjectNested(null);
  }
  public LimitRangeSpecObjectNested<A> withNewLimitRangeSpecObjectLike(LimitRangeSpec item) {
    return new LimitRangeSpecObjectNested(item);
  }
  public ProjectedVolumeSourceObjectNested<A> withNewProjectedVolumeSourceObject() {
    return new ProjectedVolumeSourceObjectNested(null);
  }
  public ProjectedVolumeSourceObjectNested<A> withNewProjectedVolumeSourceObjectLike(ProjectedVolumeSource item) {
    return new ProjectedVolumeSourceObjectNested(item);
  }
  public PodOSObjectNested<A> withNewPodOSObject() {
    return new PodOSObjectNested(null);
  }
  public PodOSObjectNested<A> withNewPodOSObjectLike(PodOS item) {
    return new PodOSObjectNested(item);
  }
  public A withNewPodOSObject(String name) {
    return (A)withObject(new PodOS(name));
  }
  public PersistentVolumeClaimStatusObjectNested<A> withNewPersistentVolumeClaimStatusObject() {
    return new PersistentVolumeClaimStatusObjectNested(null);
  }
  public PersistentVolumeClaimStatusObjectNested<A> withNewPersistentVolumeClaimStatusObjectLike(PersistentVolumeClaimStatus item) {
    return new PersistentVolumeClaimStatusObjectNested(item);
  }
  public ContainerStateObjectNested<A> withNewContainerStateObject() {
    return new ContainerStateObjectNested(null);
  }
  public ContainerStateObjectNested<A> withNewContainerStateObjectLike(ContainerState item) {
    return new ContainerStateObjectNested(item);
  }
  public ServiceSpecObjectNested<A> withNewServiceSpecObject() {
    return new ServiceSpecObjectNested(null);
  }
  public ServiceSpecObjectNested<A> withNewServiceSpecObjectLike(ServiceSpec item) {
    return new ServiceSpecObjectNested(item);
  }
  public ServiceAccountTokenProjectionObjectNested<A> withNewServiceAccountTokenProjectionObject() {
    return new ServiceAccountTokenProjectionObjectNested(null);
  }
  public ServiceAccountTokenProjectionObjectNested<A> withNewServiceAccountTokenProjectionObjectLike(ServiceAccountTokenProjection item) {
    return new ServiceAccountTokenProjectionObjectNested(item);
  }
  public A withNewServiceAccountTokenProjectionObject(String audience,Long expirationSeconds,String path) {
    return (A)withObject(new ServiceAccountTokenProjection(audience, expirationSeconds, path));
  }
  public PhotonPersistentDiskVolumeSourceObjectNested<A> withNewPhotonPersistentDiskVolumeSourceObject() {
    return new PhotonPersistentDiskVolumeSourceObjectNested(null);
  }
  public PhotonPersistentDiskVolumeSourceObjectNested<A> withNewPhotonPersistentDiskVolumeSourceObjectLike(PhotonPersistentDiskVolumeSource item) {
    return new PhotonPersistentDiskVolumeSourceObjectNested(item);
  }
  public A withNewPhotonPersistentDiskVolumeSourceObject(String fsType,String pdID) {
    return (A)withObject(new PhotonPersistentDiskVolumeSource(fsType, pdID));
  }
  public ContainerObjectNested<A> withNewContainerObject() {
    return new ContainerObjectNested(null);
  }
  public ContainerObjectNested<A> withNewContainerObjectLike(Container item) {
    return new ContainerObjectNested(item);
  }
  public NodeSpecObjectNested<A> withNewNodeSpecObject() {
    return new NodeSpecObjectNested(null);
  }
  public NodeSpecObjectNested<A> withNewNodeSpecObjectLike(NodeSpec item) {
    return new NodeSpecObjectNested(item);
  }
  public TypedLocalObjectReferenceNested<A> withNewTypedLocalObjectReference() {
    return new TypedLocalObjectReferenceNested(null);
  }
  public TypedLocalObjectReferenceNested<A> withNewTypedLocalObjectReferenceLike(TypedLocalObjectReference item) {
    return new TypedLocalObjectReferenceNested(item);
  }
  public A withNewTypedLocalObjectReference(String apiGroup,String kind,String name) {
    return (A)withObject(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  public FieldsV1ObjectNested<A> withNewFieldsV1Object() {
    return new FieldsV1ObjectNested(null);
  }
  public FieldsV1ObjectNested<A> withNewFieldsV1ObjectLike(FieldsV1 item) {
    return new FieldsV1ObjectNested(item);
  }
  public SecretListObjectNested<A> withNewSecretListObject() {
    return new SecretListObjectNested(null);
  }
  public SecretListObjectNested<A> withNewSecretListObjectLike(SecretList item) {
    return new SecretListObjectNested(item);
  }
  public NodeAddressObjectNested<A> withNewNodeAddressObject() {
    return new NodeAddressObjectNested(null);
  }
  public NodeAddressObjectNested<A> withNewNodeAddressObjectLike(NodeAddress item) {
    return new NodeAddressObjectNested(item);
  }
  public A withNewNodeAddressObject(String address,String type) {
    return (A)withObject(new NodeAddress(address, type));
  }
  public PodAffinityObjectNested<A> withNewPodAffinityObject() {
    return new PodAffinityObjectNested(null);
  }
  public PodAffinityObjectNested<A> withNewPodAffinityObjectLike(PodAffinity item) {
    return new PodAffinityObjectNested(item);
  }
  public ExecEnvVarObjectNested<A> withNewExecEnvVarObject() {
    return new ExecEnvVarObjectNested(null);
  }
  public ExecEnvVarObjectNested<A> withNewExecEnvVarObjectLike(ExecEnvVar item) {
    return new ExecEnvVarObjectNested(item);
  }
  public A withNewExecEnvVarObject(String name,String value) {
    return (A)withObject(new ExecEnvVar(name, value));
  }
  public ServiceObjectNested<A> withNewServiceObject() {
    return new ServiceObjectNested(null);
  }
  public ServiceObjectNested<A> withNewServiceObjectLike(Service item) {
    return new ServiceObjectNested(item);
  }
  public EventSeriesObjectNested<A> withNewEventSeriesObject() {
    return new EventSeriesObjectNested(null);
  }
  public EventSeriesObjectNested<A> withNewEventSeriesObjectLike(EventSeries item) {
    return new EventSeriesObjectNested(item);
  }
  public PodConditionObjectNested<A> withNewPodConditionObject() {
    return new PodConditionObjectNested(null);
  }
  public PodConditionObjectNested<A> withNewPodConditionObjectLike(PodCondition item) {
    return new PodConditionObjectNested(item);
  }
  public TopologySpreadConstraintObjectNested<A> withNewTopologySpreadConstraintObject() {
    return new TopologySpreadConstraintObjectNested(null);
  }
  public TopologySpreadConstraintObjectNested<A> withNewTopologySpreadConstraintObjectLike(TopologySpreadConstraint item) {
    return new TopologySpreadConstraintObjectNested(item);
  }
  public ExecActionObjectNested<A> withNewExecActionObject() {
    return new ExecActionObjectNested(null);
  }
  public ExecActionObjectNested<A> withNewExecActionObjectLike(ExecAction item) {
    return new ExecActionObjectNested(item);
  }
  public ContainerImageObjectNested<A> withNewContainerImageObject() {
    return new ContainerImageObjectNested(null);
  }
  public ContainerImageObjectNested<A> withNewContainerImageObjectLike(ContainerImage item) {
    return new ContainerImageObjectNested(item);
  }
  public GroupKindObjectNested<A> withNewGroupKindObject() {
    return new GroupKindObjectNested(null);
  }
  public GroupKindObjectNested<A> withNewGroupKindObjectLike(GroupKind item) {
    return new GroupKindObjectNested(item);
  }
  public A withNewGroupKindObject(String group,String kind) {
    return (A)withObject(new GroupKind(group, kind));
  }
  public ReplicationControllerObjectNested<A> withNewReplicationControllerObject() {
    return new ReplicationControllerObjectNested(null);
  }
  public ReplicationControllerObjectNested<A> withNewReplicationControllerObjectLike(ReplicationController item) {
    return new ReplicationControllerObjectNested(item);
  }
  public NodeStatusObjectNested<A> withNewNodeStatusObject() {
    return new NodeStatusObjectNested(null);
  }
  public NodeStatusObjectNested<A> withNewNodeStatusObjectLike(NodeStatus item) {
    return new NodeStatusObjectNested(item);
  }
  public ConfigMapListObjectNested<A> withNewConfigMapListObject() {
    return new ConfigMapListObjectNested(null);
  }
  public ConfigMapListObjectNested<A> withNewConfigMapListObjectLike(ConfigMapList item) {
    return new ConfigMapListObjectNested(item);
  }
  public NodeSelectorObjectNested<A> withNewNodeSelectorObject() {
    return new NodeSelectorObjectNested(null);
  }
  public NodeSelectorObjectNested<A> withNewNodeSelectorObjectLike(NodeSelector item) {
    return new NodeSelectorObjectNested(item);
  }
  public TolerationObjectNested<A> withNewTolerationObject() {
    return new TolerationObjectNested(null);
  }
  public TolerationObjectNested<A> withNewTolerationObjectLike(Toleration item) {
    return new TolerationObjectNested(item);
  }
  public A withNewTolerationObject(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)withObject(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public CephFSPersistentVolumeSourceObjectNested<A> withNewCephFSPersistentVolumeSourceObject() {
    return new CephFSPersistentVolumeSourceObjectNested(null);
  }
  public CephFSPersistentVolumeSourceObjectNested<A> withNewCephFSPersistentVolumeSourceObjectLike(CephFSPersistentVolumeSource item) {
    return new CephFSPersistentVolumeSourceObjectNested(item);
  }
  public PersistentVolumeClaimConditionObjectNested<A> withNewPersistentVolumeClaimConditionObject() {
    return new PersistentVolumeClaimConditionObjectNested(null);
  }
  public PersistentVolumeClaimConditionObjectNested<A> withNewPersistentVolumeClaimConditionObjectLike(PersistentVolumeClaimCondition item) {
    return new PersistentVolumeClaimConditionObjectNested(item);
  }
  public PreferredSchedulingTermObjectNested<A> withNewPreferredSchedulingTermObject() {
    return new PreferredSchedulingTermObjectNested(null);
  }
  public PreferredSchedulingTermObjectNested<A> withNewPreferredSchedulingTermObjectLike(PreferredSchedulingTerm item) {
    return new PreferredSchedulingTermObjectNested(item);
  }
  public PersistentVolumeListObjectNested<A> withNewPersistentVolumeListObject() {
    return new PersistentVolumeListObjectNested(null);
  }
  public PersistentVolumeListObjectNested<A> withNewPersistentVolumeListObjectLike(PersistentVolumeList item) {
    return new PersistentVolumeListObjectNested(item);
  }
  public PodSchedulingGateObjectNested<A> withNewPodSchedulingGateObject() {
    return new PodSchedulingGateObjectNested(null);
  }
  public PodSchedulingGateObjectNested<A> withNewPodSchedulingGateObjectLike(PodSchedulingGate item) {
    return new PodSchedulingGateObjectNested(item);
  }
  public A withNewPodSchedulingGateObject(String name) {
    return (A)withObject(new PodSchedulingGate(name));
  }
  public PodDNSConfigOptionObjectNested<A> withNewPodDNSConfigOptionObject() {
    return new PodDNSConfigOptionObjectNested(null);
  }
  public PodDNSConfigOptionObjectNested<A> withNewPodDNSConfigOptionObjectLike(PodDNSConfigOption item) {
    return new PodDNSConfigOptionObjectNested(item);
  }
  public A withNewPodDNSConfigOptionObject(String name,String value) {
    return (A)withObject(new PodDNSConfigOption(name, value));
  }
  public GCEPersistentDiskVolumeSourceObjectNested<A> withNewGCEPersistentDiskVolumeSourceObject() {
    return new GCEPersistentDiskVolumeSourceObjectNested(null);
  }
  public GCEPersistentDiskVolumeSourceObjectNested<A> withNewGCEPersistentDiskVolumeSourceObjectLike(GCEPersistentDiskVolumeSource item) {
    return new GCEPersistentDiskVolumeSourceObjectNested(item);
  }
  public A withNewGCEPersistentDiskVolumeSourceObject(String fsType,Integer partition,String pdName,Boolean readOnly) {
    return (A)withObject(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
  }
  public APIServiceConditionObjectNested<A> withNewAPIServiceConditionObject() {
    return new APIServiceConditionObjectNested(null);
  }
  public APIServiceConditionObjectNested<A> withNewAPIServiceConditionObjectLike(APIServiceCondition item) {
    return new APIServiceConditionObjectNested(item);
  }
  public A withNewAPIServiceConditionObject(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withObject(new APIServiceCondition(lastTransitionTime, message, reason, status, type));
  }
  public EventListObjectNested<A> withNewEventListObject() {
    return new EventListObjectNested(null);
  }
  public EventListObjectNested<A> withNewEventListObjectLike(EventList item) {
    return new EventListObjectNested(item);
  }
  public PodReadinessGateObjectNested<A> withNewPodReadinessGateObject() {
    return new PodReadinessGateObjectNested(null);
  }
  public PodReadinessGateObjectNested<A> withNewPodReadinessGateObjectLike(PodReadinessGate item) {
    return new PodReadinessGateObjectNested(item);
  }
  public A withNewPodReadinessGateObject(String conditionType) {
    return (A)withObject(new PodReadinessGate(conditionType));
  }
  public ContainerStateWaitingObjectNested<A> withNewContainerStateWaitingObject() {
    return new ContainerStateWaitingObjectNested(null);
  }
  public ContainerStateWaitingObjectNested<A> withNewContainerStateWaitingObjectLike(ContainerStateWaiting item) {
    return new ContainerStateWaitingObjectNested(item);
  }
  public A withNewContainerStateWaitingObject(String message,String reason) {
    return (A)withObject(new ContainerStateWaiting(message, reason));
  }
  public VolumeMountObjectNested<A> withNewVolumeMountObject() {
    return new VolumeMountObjectNested(null);
  }
  public VolumeMountObjectNested<A> withNewVolumeMountObjectLike(VolumeMount item) {
    return new VolumeMountObjectNested(item);
  }
  public NamespaceConditionObjectNested<A> withNewNamespaceConditionObject() {
    return new NamespaceConditionObjectNested(null);
  }
  public NamespaceConditionObjectNested<A> withNewNamespaceConditionObjectLike(NamespaceCondition item) {
    return new NamespaceConditionObjectNested(item);
  }
  public A withNewNamespaceConditionObject(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withObject(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
  }
  public LabelSelectorObjectNested<A> withNewLabelSelectorObject() {
    return new LabelSelectorObjectNested(null);
  }
  public LabelSelectorObjectNested<A> withNewLabelSelectorObjectLike(LabelSelector item) {
    return new LabelSelectorObjectNested(item);
  }
  public StatusCauseObjectNested<A> withNewStatusCauseObject() {
    return new StatusCauseObjectNested(null);
  }
  public StatusCauseObjectNested<A> withNewStatusCauseObjectLike(StatusCause item) {
    return new StatusCauseObjectNested(item);
  }
  public A withNewStatusCauseObject(String field,String message,String reason) {
    return (A)withObject(new StatusCause(field, message, reason));
  }
  public NamedClusterObjectNested<A> withNewNamedClusterObject() {
    return new NamedClusterObjectNested(null);
  }
  public NamedClusterObjectNested<A> withNewNamedClusterObjectLike(NamedCluster item) {
    return new NamedClusterObjectNested(item);
  }
  public StatusDetailsObjectNested<A> withNewStatusDetailsObject() {
    return new StatusDetailsObjectNested(null);
  }
  public StatusDetailsObjectNested<A> withNewStatusDetailsObjectLike(StatusDetails item) {
    return new StatusDetailsObjectNested(item);
  }
  public DownwardAPIVolumeFileObjectNested<A> withNewDownwardAPIVolumeFileObject() {
    return new DownwardAPIVolumeFileObjectNested(null);
  }
  public DownwardAPIVolumeFileObjectNested<A> withNewDownwardAPIVolumeFileObjectLike(DownwardAPIVolumeFile item) {
    return new DownwardAPIVolumeFileObjectNested(item);
  }
  public SeccompProfileObjectNested<A> withNewSeccompProfileObject() {
    return new SeccompProfileObjectNested(null);
  }
  public SeccompProfileObjectNested<A> withNewSeccompProfileObjectLike(SeccompProfile item) {
    return new SeccompProfileObjectNested(item);
  }
  public A withNewSeccompProfileObject(String localhostProfile,String type) {
    return (A)withObject(new SeccompProfile(localhostProfile, type));
  }
  public SysctlObjectNested<A> withNewSysctlObject() {
    return new SysctlObjectNested(null);
  }
  public SysctlObjectNested<A> withNewSysctlObjectLike(Sysctl item) {
    return new SysctlObjectNested(item);
  }
  public A withNewSysctlObject(String name,String value) {
    return (A)withObject(new Sysctl(name, value));
  }
  public DeleteOptionsObjectNested<A> withNewDeleteOptionsObject() {
    return new DeleteOptionsObjectNested(null);
  }
  public DeleteOptionsObjectNested<A> withNewDeleteOptionsObjectLike(DeleteOptions item) {
    return new DeleteOptionsObjectNested(item);
  }
  public StatusObjectNested<A> withNewStatusObject() {
    return new StatusObjectNested(null);
  }
  public StatusObjectNested<A> withNewStatusObjectLike(Status item) {
    return new StatusObjectNested(item);
  }
  public ContainerStatusObjectNested<A> withNewContainerStatusObject() {
    return new ContainerStatusObjectNested(null);
  }
  public ContainerStatusObjectNested<A> withNewContainerStatusObjectLike(ContainerStatus item) {
    return new ContainerStatusObjectNested(item);
  }
  public PodTemplateObjectNested<A> withNewPodTemplateObject() {
    return new PodTemplateObjectNested(null);
  }
  public PodTemplateObjectNested<A> withNewPodTemplateObjectLike(PodTemplate item) {
    return new PodTemplateObjectNested(item);
  }
  public ConfigMapEnvSourceObjectNested<A> withNewConfigMapEnvSourceObject() {
    return new ConfigMapEnvSourceObjectNested(null);
  }
  public ConfigMapEnvSourceObjectNested<A> withNewConfigMapEnvSourceObjectLike(ConfigMapEnvSource item) {
    return new ConfigMapEnvSourceObjectNested(item);
  }
  public A withNewConfigMapEnvSourceObject(String name,Boolean optional) {
    return (A)withObject(new ConfigMapEnvSource(name, optional));
  }
  public NodeSelectorRequirementObjectNested<A> withNewNodeSelectorRequirementObject() {
    return new NodeSelectorRequirementObjectNested(null);
  }
  public NodeSelectorRequirementObjectNested<A> withNewNodeSelectorRequirementObjectLike(NodeSelectorRequirement item) {
    return new NodeSelectorRequirementObjectNested(item);
  }
  public TCPSocketActionObjectNested<A> withNewTCPSocketActionObject() {
    return new TCPSocketActionObjectNested(null);
  }
  public TCPSocketActionObjectNested<A> withNewTCPSocketActionObjectLike(TCPSocketAction item) {
    return new TCPSocketActionObjectNested(item);
  }
  public EventObjectNested<A> withNewEventObject() {
    return new EventObjectNested(null);
  }
  public EventObjectNested<A> withNewEventObjectLike(Event item) {
    return new EventObjectNested(item);
  }
  public PreferencesObjectNested<A> withNewPreferencesObject() {
    return new PreferencesObjectNested(null);
  }
  public PreferencesObjectNested<A> withNewPreferencesObjectLike(Preferences item) {
    return new PreferencesObjectNested(item);
  }
  public ObjectFieldSelectorObjectNested<A> withNewObjectFieldSelectorObject() {
    return new ObjectFieldSelectorObjectNested(null);
  }
  public ObjectFieldSelectorObjectNested<A> withNewObjectFieldSelectorObjectLike(ObjectFieldSelector item) {
    return new ObjectFieldSelectorObjectNested(item);
  }
  public A withNewObjectFieldSelectorObject(String apiVersion,String fieldPath) {
    return (A)withObject(new ObjectFieldSelector(apiVersion, fieldPath));
  }
  public PodTemplateListObjectNested<A> withNewPodTemplateListObject() {
    return new PodTemplateListObjectNested(null);
  }
  public PodTemplateListObjectNested<A> withNewPodTemplateListObjectLike(PodTemplateList item) {
    return new PodTemplateListObjectNested(item);
  }
  public PersistentVolumeObjectNested<A> withNewPersistentVolumeObject() {
    return new PersistentVolumeObjectNested(null);
  }
  public PersistentVolumeObjectNested<A> withNewPersistentVolumeObjectLike(PersistentVolume item) {
    return new PersistentVolumeObjectNested(item);
  }
  public CinderVolumeSourceObjectNested<A> withNewCinderVolumeSourceObject() {
    return new CinderVolumeSourceObjectNested(null);
  }
  public CinderVolumeSourceObjectNested<A> withNewCinderVolumeSourceObjectLike(CinderVolumeSource item) {
    return new CinderVolumeSourceObjectNested(item);
  }
  public EndpointAddressObjectNested<A> withNewEndpointAddressObject() {
    return new EndpointAddressObjectNested(null);
  }
  public EndpointAddressObjectNested<A> withNewEndpointAddressObjectLike(EndpointAddress item) {
    return new EndpointAddressObjectNested(item);
  }
  public NodeConfigSourceObjectNested<A> withNewNodeConfigSourceObject() {
    return new NodeConfigSourceObjectNested(null);
  }
  public NodeConfigSourceObjectNested<A> withNewNodeConfigSourceObjectLike(NodeConfigSource item) {
    return new NodeConfigSourceObjectNested(item);
  }
  public VsphereVirtualDiskVolumeSourceObjectNested<A> withNewVsphereVirtualDiskVolumeSourceObject() {
    return new VsphereVirtualDiskVolumeSourceObjectNested(null);
  }
  public VsphereVirtualDiskVolumeSourceObjectNested<A> withNewVsphereVirtualDiskVolumeSourceObjectLike(VsphereVirtualDiskVolumeSource item) {
    return new VsphereVirtualDiskVolumeSourceObjectNested(item);
  }
  public A withNewVsphereVirtualDiskVolumeSourceObject(String fsType,String storagePolicyID,String storagePolicyName,String volumePath) {
    return (A)withObject(new VsphereVirtualDiskVolumeSource(fsType, storagePolicyID, storagePolicyName, volumePath));
  }
  public ObjectMetaObjectNested<A> withNewObjectMetaObject() {
    return new ObjectMetaObjectNested(null);
  }
  public ObjectMetaObjectNested<A> withNewObjectMetaObjectLike(ObjectMeta item) {
    return new ObjectMetaObjectNested(item);
  }
  public PersistentVolumeClaimObjectNested<A> withNewPersistentVolumeClaimObject() {
    return new PersistentVolumeClaimObjectNested(null);
  }
  public PersistentVolumeClaimObjectNested<A> withNewPersistentVolumeClaimObjectLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimObjectNested(item);
  }
  public LabelSelectorRequirementObjectNested<A> withNewLabelSelectorRequirementObject() {
    return new LabelSelectorRequirementObjectNested(null);
  }
  public LabelSelectorRequirementObjectNested<A> withNewLabelSelectorRequirementObjectLike(LabelSelectorRequirement item) {
    return new LabelSelectorRequirementObjectNested(item);
  }
  public GitRepoVolumeSourceObjectNested<A> withNewGitRepoVolumeSourceObject() {
    return new GitRepoVolumeSourceObjectNested(null);
  }
  public GitRepoVolumeSourceObjectNested<A> withNewGitRepoVolumeSourceObjectLike(GitRepoVolumeSource item) {
    return new GitRepoVolumeSourceObjectNested(item);
  }
  public A withNewGitRepoVolumeSourceObject(String directory,String repository,String revision) {
    return (A)withObject(new GitRepoVolumeSource(directory, repository, revision));
  }
  public GenericKubernetesResourceObjectNested<A> withNewGenericKubernetesResourceObject() {
    return new GenericKubernetesResourceObjectNested(null);
  }
  public GenericKubernetesResourceObjectNested<A> withNewGenericKubernetesResourceObjectLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceObjectNested(item);
  }
  public EndpointsListObjectNested<A> withNewEndpointsListObject() {
    return new EndpointsListObjectNested(null);
  }
  public EndpointsListObjectNested<A> withNewEndpointsListObjectLike(EndpointsList item) {
    return new EndpointsListObjectNested(item);
  }
  public GroupVersionResourceObjectNested<A> withNewGroupVersionResourceObject() {
    return new GroupVersionResourceObjectNested(null);
  }
  public GroupVersionResourceObjectNested<A> withNewGroupVersionResourceObjectLike(GroupVersionResource item) {
    return new GroupVersionResourceObjectNested(item);
  }
  public A withNewGroupVersionResourceObject(String group,String resource,String version) {
    return (A)withObject(new GroupVersionResource(group, resource, version));
  }
  public CinderPersistentVolumeSourceObjectNested<A> withNewCinderPersistentVolumeSourceObject() {
    return new CinderPersistentVolumeSourceObjectNested(null);
  }
  public CinderPersistentVolumeSourceObjectNested<A> withNewCinderPersistentVolumeSourceObjectLike(CinderPersistentVolumeSource item) {
    return new CinderPersistentVolumeSourceObjectNested(item);
  }
  public TopologySelectorTermObjectNested<A> withNewTopologySelectorTermObject() {
    return new TopologySelectorTermObjectNested(null);
  }
  public TopologySelectorTermObjectNested<A> withNewTopologySelectorTermObjectLike(TopologySelectorTerm item) {
    return new TopologySelectorTermObjectNested(item);
  }
  public OwnerReferenceObjectNested<A> withNewOwnerReferenceObject() {
    return new OwnerReferenceObjectNested(null);
  }
  public OwnerReferenceObjectNested<A> withNewOwnerReferenceObjectLike(OwnerReference item) {
    return new OwnerReferenceObjectNested(item);
  }
  public StorageOSPersistentVolumeSourceObjectNested<A> withNewStorageOSPersistentVolumeSourceObject() {
    return new StorageOSPersistentVolumeSourceObjectNested(null);
  }
  public StorageOSPersistentVolumeSourceObjectNested<A> withNewStorageOSPersistentVolumeSourceObjectLike(StorageOSPersistentVolumeSource item) {
    return new StorageOSPersistentVolumeSourceObjectNested(item);
  }
  public EphemeralVolumeSourceObjectNested<A> withNewEphemeralVolumeSourceObject() {
    return new EphemeralVolumeSourceObjectNested(null);
  }
  public EphemeralVolumeSourceObjectNested<A> withNewEphemeralVolumeSourceObjectLike(EphemeralVolumeSource item) {
    return new EphemeralVolumeSourceObjectNested(item);
  }
  public ReplicationControllerConditionObjectNested<A> withNewReplicationControllerConditionObject() {
    return new ReplicationControllerConditionObjectNested(null);
  }
  public ReplicationControllerConditionObjectNested<A> withNewReplicationControllerConditionObjectLike(ReplicationControllerCondition item) {
    return new ReplicationControllerConditionObjectNested(item);
  }
  public A withNewReplicationControllerConditionObject(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withObject(new ReplicationControllerCondition(lastTransitionTime, message, reason, status, type));
  }
  public PodAntiAffinityObjectNested<A> withNewPodAntiAffinityObject() {
    return new PodAntiAffinityObjectNested(null);
  }
  public PodAntiAffinityObjectNested<A> withNewPodAntiAffinityObjectLike(PodAntiAffinity item) {
    return new PodAntiAffinityObjectNested(item);
  }
  public SecurityContextObjectNested<A> withNewSecurityContextObject() {
    return new SecurityContextObjectNested(null);
  }
  public SecurityContextObjectNested<A> withNewSecurityContextObjectLike(SecurityContext item) {
    return new SecurityContextObjectNested(item);
  }
  public ReplicationControllerListObjectNested<A> withNewReplicationControllerListObject() {
    return new ReplicationControllerListObjectNested(null);
  }
  public ReplicationControllerListObjectNested<A> withNewReplicationControllerListObjectLike(ReplicationControllerList item) {
    return new ReplicationControllerListObjectNested(item);
  }
  public ConfigMapVolumeSourceObjectNested<A> withNewConfigMapVolumeSourceObject() {
    return new ConfigMapVolumeSourceObjectNested(null);
  }
  public ConfigMapVolumeSourceObjectNested<A> withNewConfigMapVolumeSourceObjectLike(ConfigMapVolumeSource item) {
    return new ConfigMapVolumeSourceObjectNested(item);
  }
  public ContainerStateRunningObjectNested<A> withNewContainerStateRunningObject() {
    return new ContainerStateRunningObjectNested(null);
  }
  public ContainerStateRunningObjectNested<A> withNewContainerStateRunningObjectLike(ContainerStateRunning item) {
    return new ContainerStateRunningObjectNested(item);
  }
  public A withNewContainerStateRunningObject(String startedAt) {
    return (A)withObject(new ContainerStateRunning(startedAt));
  }
  public ComponentStatusListObjectNested<A> withNewComponentStatusListObject() {
    return new ComponentStatusListObjectNested(null);
  }
  public ComponentStatusListObjectNested<A> withNewComponentStatusListObjectLike(ComponentStatusList item) {
    return new ComponentStatusListObjectNested(item);
  }
  public FlockerVolumeSourceObjectNested<A> withNewFlockerVolumeSourceObject() {
    return new FlockerVolumeSourceObjectNested(null);
  }
  public FlockerVolumeSourceObjectNested<A> withNewFlockerVolumeSourceObjectLike(FlockerVolumeSource item) {
    return new FlockerVolumeSourceObjectNested(item);
  }
  public A withNewFlockerVolumeSourceObject(String datasetName,String datasetUUID) {
    return (A)withObject(new FlockerVolumeSource(datasetName, datasetUUID));
  }
  public ScaleIOVolumeSourceObjectNested<A> withNewScaleIOVolumeSourceObject() {
    return new ScaleIOVolumeSourceObjectNested(null);
  }
  public ScaleIOVolumeSourceObjectNested<A> withNewScaleIOVolumeSourceObjectLike(ScaleIOVolumeSource item) {
    return new ScaleIOVolumeSourceObjectNested(item);
  }
  public LimitRangeListObjectNested<A> withNewLimitRangeListObject() {
    return new LimitRangeListObjectNested(null);
  }
  public LimitRangeListObjectNested<A> withNewLimitRangeListObjectLike(LimitRangeList item) {
    return new LimitRangeListObjectNested(item);
  }
  public PodExecOptionsObjectNested<A> withNewPodExecOptionsObject() {
    return new PodExecOptionsObjectNested(null);
  }
  public PodExecOptionsObjectNested<A> withNewPodExecOptionsObjectLike(PodExecOptions item) {
    return new PodExecOptionsObjectNested(item);
  }
  public ProbeObjectNested<A> withNewProbeObject() {
    return new ProbeObjectNested(null);
  }
  public ProbeObjectNested<A> withNewProbeObjectLike(Probe item) {
    return new ProbeObjectNested(item);
  }
  public UpdateOptionsObjectNested<A> withNewUpdateOptionsObject() {
    return new UpdateOptionsObjectNested(null);
  }
  public UpdateOptionsObjectNested<A> withNewUpdateOptionsObjectLike(UpdateOptions item) {
    return new UpdateOptionsObjectNested(item);
  }
  public EndpointsObjectNested<A> withNewEndpointsObject() {
    return new EndpointsObjectNested(null);
  }
  public EndpointsObjectNested<A> withNewEndpointsObjectLike(Endpoints item) {
    return new EndpointsObjectNested(item);
  }
  public NamedExtensionObjectNested<A> withNewNamedExtensionObject() {
    return new NamedExtensionObjectNested(null);
  }
  public NamedExtensionObjectNested<A> withNewNamedExtensionObjectLike(NamedExtension item) {
    return new NamedExtensionObjectNested(item);
  }
  public AzureFilePersistentVolumeSourceObjectNested<A> withNewAzureFilePersistentVolumeSourceObject() {
    return new AzureFilePersistentVolumeSourceObjectNested(null);
  }
  public AzureFilePersistentVolumeSourceObjectNested<A> withNewAzureFilePersistentVolumeSourceObjectLike(AzureFilePersistentVolumeSource item) {
    return new AzureFilePersistentVolumeSourceObjectNested(item);
  }
  public A withNewAzureFilePersistentVolumeSourceObject(Boolean readOnly,String secretName,String secretNamespace,String shareName) {
    return (A)withObject(new AzureFilePersistentVolumeSource(readOnly, secretName, secretNamespace, shareName));
  }
  public APIResourceListObjectNested<A> withNewAPIResourceListObject() {
    return new APIResourceListObjectNested(null);
  }
  public APIResourceListObjectNested<A> withNewAPIResourceListObjectLike(APIResourceList item) {
    return new APIResourceListObjectNested(item);
  }
  public APIServiceListObjectNested<A> withNewAPIServiceListObject() {
    return new APIServiceListObjectNested(null);
  }
  public APIServiceListObjectNested<A> withNewAPIServiceListObjectLike(APIServiceList item) {
    return new APIServiceListObjectNested(item);
  }
  public SecretVolumeSourceObjectNested<A> withNewSecretVolumeSourceObject() {
    return new SecretVolumeSourceObjectNested(null);
  }
  public SecretVolumeSourceObjectNested<A> withNewSecretVolumeSourceObjectLike(SecretVolumeSource item) {
    return new SecretVolumeSourceObjectNested(item);
  }
  public PodObjectNested<A> withNewPodObject() {
    return new PodObjectNested(null);
  }
  public PodObjectNested<A> withNewPodObjectLike(Pod item) {
    return new PodObjectNested(item);
  }
  public ClientIPConfigObjectNested<A> withNewClientIPConfigObject() {
    return new ClientIPConfigObjectNested(null);
  }
  public ClientIPConfigObjectNested<A> withNewClientIPConfigObjectLike(ClientIPConfig item) {
    return new ClientIPConfigObjectNested(item);
  }
  public A withNewClientIPConfigObject(Integer timeoutSeconds) {
    return (A)withObject(new ClientIPConfig(timeoutSeconds));
  }
  public ContextObjectNested<A> withNewContextObject() {
    return new ContextObjectNested(null);
  }
  public ContextObjectNested<A> withNewContextObjectLike(Context item) {
    return new ContextObjectNested(item);
  }
  public NodeAffinityObjectNested<A> withNewNodeAffinityObject() {
    return new NodeAffinityObjectNested(null);
  }
  public NodeAffinityObjectNested<A> withNewNodeAffinityObjectLike(NodeAffinity item) {
    return new NodeAffinityObjectNested(item);
  }
  public ConfigMapObjectNested<A> withNewConfigMapObject() {
    return new ConfigMapObjectNested(null);
  }
  public ConfigMapObjectNested<A> withNewConfigMapObjectLike(ConfigMap item) {
    return new ConfigMapObjectNested(item);
  }
  public ContainerPortObjectNested<A> withNewContainerPortObject() {
    return new ContainerPortObjectNested(null);
  }
  public ContainerPortObjectNested<A> withNewContainerPortObjectLike(ContainerPort item) {
    return new ContainerPortObjectNested(item);
  }
  public A withNewContainerPortObject(Integer containerPort,String hostIP,Integer hostPort,String name,String protocol) {
    return (A)withObject(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
  }
  public ConditionObjectNested<A> withNewConditionObject() {
    return new ConditionObjectNested(null);
  }
  public ConditionObjectNested<A> withNewConditionObjectLike(Condition item) {
    return new ConditionObjectNested(item);
  }
  public PodListObjectNested<A> withNewPodListObject() {
    return new PodListObjectNested(null);
  }
  public PodListObjectNested<A> withNewPodListObjectLike(PodList item) {
    return new PodListObjectNested(item);
  }
  public FCVolumeSourceObjectNested<A> withNewFCVolumeSourceObject() {
    return new FCVolumeSourceObjectNested(null);
  }
  public FCVolumeSourceObjectNested<A> withNewFCVolumeSourceObjectLike(FCVolumeSource item) {
    return new FCVolumeSourceObjectNested(item);
  }
  public ResourceFieldSelectorObjectNested<A> withNewResourceFieldSelectorObject() {
    return new ResourceFieldSelectorObjectNested(null);
  }
  public ResourceFieldSelectorObjectNested<A> withNewResourceFieldSelectorObjectLike(ResourceFieldSelector item) {
    return new ResourceFieldSelectorObjectNested(item);
  }
  public PersistentVolumeClaimSpecObjectNested<A> withNewPersistentVolumeClaimSpecObject() {
    return new PersistentVolumeClaimSpecObjectNested(null);
  }
  public PersistentVolumeClaimSpecObjectNested<A> withNewPersistentVolumeClaimSpecObjectLike(PersistentVolumeClaimSpec item) {
    return new PersistentVolumeClaimSpecObjectNested(item);
  }
  public LoadBalancerStatusObjectNested<A> withNewLoadBalancerStatusObject() {
    return new LoadBalancerStatusObjectNested(null);
  }
  public LoadBalancerStatusObjectNested<A> withNewLoadBalancerStatusObjectLike(LoadBalancerStatus item) {
    return new LoadBalancerStatusObjectNested(item);
  }
  public PodSecurityContextObjectNested<A> withNewPodSecurityContextObject() {
    return new PodSecurityContextObjectNested(null);
  }
  public PodSecurityContextObjectNested<A> withNewPodSecurityContextObjectLike(PodSecurityContext item) {
    return new PodSecurityContextObjectNested(item);
  }
  public ScopeSelectorObjectNested<A> withNewScopeSelectorObject() {
    return new ScopeSelectorObjectNested(null);
  }
  public ScopeSelectorObjectNested<A> withNewScopeSelectorObjectLike(ScopeSelector item) {
    return new ScopeSelectorObjectNested(item);
  }
  public DownwardAPIProjectionObjectNested<A> withNewDownwardAPIProjectionObject() {
    return new DownwardAPIProjectionObjectNested(null);
  }
  public DownwardAPIProjectionObjectNested<A> withNewDownwardAPIProjectionObjectLike(DownwardAPIProjection item) {
    return new DownwardAPIProjectionObjectNested(item);
  }
  public PodAffinityTermObjectNested<A> withNewPodAffinityTermObject() {
    return new PodAffinityTermObjectNested(null);
  }
  public PodAffinityTermObjectNested<A> withNewPodAffinityTermObjectLike(PodAffinityTerm item) {
    return new PodAffinityTermObjectNested(item);
  }
  public APIServiceSpecObjectNested<A> withNewAPIServiceSpecObject() {
    return new APIServiceSpecObjectNested(null);
  }
  public APIServiceSpecObjectNested<A> withNewAPIServiceSpecObjectLike(APIServiceSpec item) {
    return new APIServiceSpecObjectNested(item);
  }
  public ServicePortObjectNested<A> withNewServicePortObject() {
    return new ServicePortObjectNested(null);
  }
  public ServicePortObjectNested<A> withNewServicePortObjectLike(ServicePort item) {
    return new ServicePortObjectNested(item);
  }
  public GroupVersionForDiscoveryObjectNested<A> withNewGroupVersionForDiscoveryObject() {
    return new GroupVersionForDiscoveryObjectNested(null);
  }
  public GroupVersionForDiscoveryObjectNested<A> withNewGroupVersionForDiscoveryObjectLike(GroupVersionForDiscovery item) {
    return new GroupVersionForDiscoveryObjectNested(item);
  }
  public A withNewGroupVersionForDiscoveryObject(String groupVersion,String version) {
    return (A)withObject(new GroupVersionForDiscovery(groupVersion, version));
  }
  public ClaimSourceObjectNested<A> withNewClaimSourceObject() {
    return new ClaimSourceObjectNested(null);
  }
  public ClaimSourceObjectNested<A> withNewClaimSourceObjectLike(ClaimSource item) {
    return new ClaimSourceObjectNested(item);
  }
  public A withNewClaimSourceObject(String resourceClaimName,String resourceClaimTemplateName) {
    return (A)withObject(new ClaimSource(resourceClaimName, resourceClaimTemplateName));
  }
  public PersistentVolumeClaimSourceObjectNested<A> withNewPersistentVolumeClaimSourceObject() {
    return new PersistentVolumeClaimSourceObjectNested(null);
  }
  public PersistentVolumeClaimSourceObjectNested<A> withNewPersistentVolumeClaimSourceObjectLike(PersistentVolumeClaimVolumeSource item) {
    return new PersistentVolumeClaimSourceObjectNested(item);
  }
  public A withNewPersistentVolumeClaimSourceObject(String claimName,Boolean readOnly) {
    return (A)withObject(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
  }
  public SessionAffinityConfigObjectNested<A> withNewSessionAffinityConfigObject() {
    return new SessionAffinityConfigObjectNested(null);
  }
  public SessionAffinityConfigObjectNested<A> withNewSessionAffinityConfigObjectLike(SessionAffinityConfig item) {
    return new SessionAffinityConfigObjectNested(item);
  }
  public ServiceAccountListObjectNested<A> withNewServiceAccountListObject() {
    return new ServiceAccountListObjectNested(null);
  }
  public ServiceAccountListObjectNested<A> withNewServiceAccountListObjectLike(ServiceAccountList item) {
    return new ServiceAccountListObjectNested(item);
  }
  public ComponentStatusObjectNested<A> withNewComponentStatusObject() {
    return new ComponentStatusObjectNested(null);
  }
  public ComponentStatusObjectNested<A> withNewComponentStatusObjectLike(ComponentStatus item) {
    return new ComponentStatusObjectNested(item);
  }
  public DaemonEndpointObjectNested<A> withNewDaemonEndpointObject() {
    return new DaemonEndpointObjectNested(null);
  }
  public DaemonEndpointObjectNested<A> withNewDaemonEndpointObjectLike(DaemonEndpoint item) {
    return new DaemonEndpointObjectNested(item);
  }
  public A withNewDaemonEndpointObject(Integer port) {
    return (A)withObject(new DaemonEndpoint(port));
  }
  public KeyToPathObjectNested<A> withNewKeyToPathObject() {
    return new KeyToPathObjectNested(null);
  }
  public KeyToPathObjectNested<A> withNewKeyToPathObjectLike(KeyToPath item) {
    return new KeyToPathObjectNested(item);
  }
  public A withNewKeyToPathObject(String key,Integer mode,String path) {
    return (A)withObject(new KeyToPath(key, mode, path));
  }
  public FlexPersistentVolumeSourceObjectNested<A> withNewFlexPersistentVolumeSourceObject() {
    return new FlexPersistentVolumeSourceObjectNested(null);
  }
  public FlexPersistentVolumeSourceObjectNested<A> withNewFlexPersistentVolumeSourceObjectLike(FlexPersistentVolumeSource item) {
    return new FlexPersistentVolumeSourceObjectNested(item);
  }
  public NamespaceListObjectNested<A> withNewNamespaceListObject() {
    return new NamespaceListObjectNested(null);
  }
  public NamespaceListObjectNested<A> withNewNamespaceListObjectLike(NamespaceList item) {
    return new NamespaceListObjectNested(item);
  }
  public PodDNSConfigObjectNested<A> withNewPodDNSConfigObject() {
    return new PodDNSConfigObjectNested(null);
  }
  public PodDNSConfigObjectNested<A> withNewPodDNSConfigObjectLike(PodDNSConfig item) {
    return new PodDNSConfigObjectNested(item);
  }
  public NodeListObjectNested<A> withNewNodeListObject() {
    return new NodeListObjectNested(null);
  }
  public NodeListObjectNested<A> withNewNodeListObjectLike(NodeList item) {
    return new NodeListObjectNested(item);
  }
  public BindingObjectNested<A> withNewBindingObject() {
    return new BindingObjectNested(null);
  }
  public BindingObjectNested<A> withNewBindingObjectLike(Binding item) {
    return new BindingObjectNested(item);
  }
  public EnvVarSourceObjectNested<A> withNewEnvVarSourceObject() {
    return new EnvVarSourceObjectNested(null);
  }
  public EnvVarSourceObjectNested<A> withNewEnvVarSourceObjectLike(EnvVarSource item) {
    return new EnvVarSourceObjectNested(item);
  }
  public VolumeProjectionObjectNested<A> withNewVolumeProjectionObject() {
    return new VolumeProjectionObjectNested(null);
  }
  public VolumeProjectionObjectNested<A> withNewVolumeProjectionObjectLike(VolumeProjection item) {
    return new VolumeProjectionObjectNested(item);
  }
  public ResourceQuotaObjectNested<A> withNewResourceQuotaObject() {
    return new ResourceQuotaObjectNested(null);
  }
  public ResourceQuotaObjectNested<A> withNewResourceQuotaObjectLike(ResourceQuota item) {
    return new ResourceQuotaObjectNested(item);
  }
  public SecretObjectNested<A> withNewSecretObject() {
    return new SecretObjectNested(null);
  }
  public SecretObjectNested<A> withNewSecretObjectLike(Secret item) {
    return new SecretObjectNested(item);
  }
  public ServiceListObjectNested<A> withNewServiceListObject() {
    return new ServiceListObjectNested(null);
  }
  public ServiceListObjectNested<A> withNewServiceListObjectLike(ServiceList item) {
    return new ServiceListObjectNested(item);
  }
  public VolumeNodeAffinityObjectNested<A> withNewVolumeNodeAffinityObject() {
    return new VolumeNodeAffinityObjectNested(null);
  }
  public VolumeNodeAffinityObjectNested<A> withNewVolumeNodeAffinityObjectLike(VolumeNodeAffinity item) {
    return new VolumeNodeAffinityObjectNested(item);
  }
  public ResourceQuotaSpecObjectNested<A> withNewResourceQuotaSpecObject() {
    return new ResourceQuotaSpecObjectNested(null);
  }
  public ResourceQuotaSpecObjectNested<A> withNewResourceQuotaSpecObjectLike(ResourceQuotaSpec item) {
    return new ResourceQuotaSpecObjectNested(item);
  }
  public NodeSelectorTermObjectNested<A> withNewNodeSelectorTermObject() {
    return new NodeSelectorTermObjectNested(null);
  }
  public NodeSelectorTermObjectNested<A> withNewNodeSelectorTermObjectLike(NodeSelectorTerm item) {
    return new NodeSelectorTermObjectNested(item);
  }
  public ScaleIOPersistentVolumeSourceObjectNested<A> withNewScaleIOPersistentVolumeSourceObject() {
    return new ScaleIOPersistentVolumeSourceObjectNested(null);
  }
  public ScaleIOPersistentVolumeSourceObjectNested<A> withNewScaleIOPersistentVolumeSourceObjectLike(ScaleIOPersistentVolumeSource item) {
    return new ScaleIOPersistentVolumeSourceObjectNested(item);
  }
  public ListOptionsObjectNested<A> withNewListOptionsObject() {
    return new ListOptionsObjectNested(null);
  }
  public ListOptionsObjectNested<A> withNewListOptionsObjectLike(ListOptions item) {
    return new ListOptionsObjectNested(item);
  }
  public WeightedPodAffinityTermObjectNested<A> withNewWeightedPodAffinityTermObject() {
    return new WeightedPodAffinityTermObjectNested(null);
  }
  public WeightedPodAffinityTermObjectNested<A> withNewWeightedPodAffinityTermObjectLike(WeightedPodAffinityTerm item) {
    return new WeightedPodAffinityTermObjectNested(item);
  }
  public TypedObjectReferenceNested<A> withNewTypedObjectReference() {
    return new TypedObjectReferenceNested(null);
  }
  public TypedObjectReferenceNested<A> withNewTypedObjectReferenceLike(TypedObjectReference item) {
    return new TypedObjectReferenceNested(item);
  }
  public A withNewTypedObjectReference(String apiGroup,String kind,String name,String namespace) {
    return (A)withObject(new TypedObjectReference(apiGroup, kind, name, namespace));
  }
  public ContainerResizePolicyObjectNested<A> withNewContainerResizePolicyObject() {
    return new ContainerResizePolicyObjectNested(null);
  }
  public ContainerResizePolicyObjectNested<A> withNewContainerResizePolicyObjectLike(ContainerResizePolicy item) {
    return new ContainerResizePolicyObjectNested(item);
  }
  public A withNewContainerResizePolicyObject(String resourceName,String restartPolicy) {
    return (A)withObject(new ContainerResizePolicy(resourceName, restartPolicy));
  }
  public NodeSystemInfoObjectNested<A> withNewNodeSystemInfoObject() {
    return new NodeSystemInfoObjectNested(null);
  }
  public NodeSystemInfoObjectNested<A> withNewNodeSystemInfoObjectLike(NodeSystemInfo item) {
    return new NodeSystemInfoObjectNested(item);
  }
  public TopologySelectorLabelRequirementObjectNested<A> withNewTopologySelectorLabelRequirementObject() {
    return new TopologySelectorLabelRequirementObjectNested(null);
  }
  public TopologySelectorLabelRequirementObjectNested<A> withNewTopologySelectorLabelRequirementObjectLike(TopologySelectorLabelRequirement item) {
    return new TopologySelectorLabelRequirementObjectNested(item);
  }
  public RBDPersistentVolumeSourceObjectNested<A> withNewRBDPersistentVolumeSourceObject() {
    return new RBDPersistentVolumeSourceObjectNested(null);
  }
  public RBDPersistentVolumeSourceObjectNested<A> withNewRBDPersistentVolumeSourceObjectLike(RBDPersistentVolumeSource item) {
    return new RBDPersistentVolumeSourceObjectNested(item);
  }
  public AuthProviderConfigObjectNested<A> withNewAuthProviderConfigObject() {
    return new AuthProviderConfigObjectNested(null);
  }
  public AuthProviderConfigObjectNested<A> withNewAuthProviderConfigObjectLike(AuthProviderConfig item) {
    return new AuthProviderConfigObjectNested(item);
  }
  public SELinuxOptionsObjectNested<A> withNewSELinuxOptionsObject() {
    return new SELinuxOptionsObjectNested(null);
  }
  public SELinuxOptionsObjectNested<A> withNewSELinuxOptionsObjectLike(SELinuxOptions item) {
    return new SELinuxOptionsObjectNested(item);
  }
  public A withNewSELinuxOptionsObject(String level,String role,String type,String user) {
    return (A)withObject(new SELinuxOptions(level, role, type, user));
  }
  public HostAliasObjectNested<A> withNewHostAliasObject() {
    return new HostAliasObjectNested(null);
  }
  public HostAliasObjectNested<A> withNewHostAliasObjectLike(HostAlias item) {
    return new HostAliasObjectNested(item);
  }
  public NodeDaemonEndpointsObjectNested<A> withNewNodeDaemonEndpointsObject() {
    return new NodeDaemonEndpointsObjectNested(null);
  }
  public NodeDaemonEndpointsObjectNested<A> withNewNodeDaemonEndpointsObjectLike(NodeDaemonEndpoints item) {
    return new NodeDaemonEndpointsObjectNested(item);
  }
  public VolumeDeviceObjectNested<A> withNewVolumeDeviceObject() {
    return new VolumeDeviceObjectNested(null);
  }
  public VolumeDeviceObjectNested<A> withNewVolumeDeviceObjectLike(VolumeDevice item) {
    return new VolumeDeviceObjectNested(item);
  }
  public A withNewVolumeDeviceObject(String devicePath,String name) {
    return (A)withObject(new VolumeDevice(devicePath, name));
  }
  public CSIVolumeSourceObjectNested<A> withNewCSIVolumeSourceObject() {
    return new CSIVolumeSourceObjectNested(null);
  }
  public CSIVolumeSourceObjectNested<A> withNewCSIVolumeSourceObjectLike(CSIVolumeSource item) {
    return new CSIVolumeSourceObjectNested(item);
  }
  public PersistentVolumeSpecObjectNested<A> withNewPersistentVolumeSpecObject() {
    return new PersistentVolumeSpecObjectNested(null);
  }
  public PersistentVolumeSpecObjectNested<A> withNewPersistentVolumeSpecObjectLike(PersistentVolumeSpec item) {
    return new PersistentVolumeSpecObjectNested(item);
  }
  public NodeObjectNested<A> withNewNodeObject() {
    return new NodeObjectNested(null);
  }
  public NodeObjectNested<A> withNewNodeObjectLike(Node item) {
    return new NodeObjectNested(item);
  }
  public LifecycleHandlerObjectNested<A> withNewLifecycleHandlerObject() {
    return new LifecycleHandlerObjectNested(null);
  }
  public LifecycleHandlerObjectNested<A> withNewLifecycleHandlerObjectLike(LifecycleHandler item) {
    return new LifecycleHandlerObjectNested(item);
  }
  public VolumeObjectNested<A> withNewVolumeObject() {
    return new VolumeObjectNested(null);
  }
  public VolumeObjectNested<A> withNewVolumeObjectLike(Volume item) {
    return new VolumeObjectNested(item);
  }
  public ClusterObjectNested<A> withNewClusterObject() {
    return new ClusterObjectNested(null);
  }
  public ClusterObjectNested<A> withNewClusterObjectLike(Cluster item) {
    return new ClusterObjectNested(item);
  }
  public NFSVolumeSourceObjectNested<A> withNewNFSVolumeSourceObject() {
    return new NFSVolumeSourceObjectNested(null);
  }
  public NFSVolumeSourceObjectNested<A> withNewNFSVolumeSourceObjectLike(NFSVolumeSource item) {
    return new NFSVolumeSourceObjectNested(item);
  }
  public A withNewNFSVolumeSourceObject(String path,Boolean readOnly,String server) {
    return (A)withObject(new NFSVolumeSource(path, readOnly, server));
  }
  public StorageOSVolumeSourceObjectNested<A> withNewStorageOSVolumeSourceObject() {
    return new StorageOSVolumeSourceObjectNested(null);
  }
  public StorageOSVolumeSourceObjectNested<A> withNewStorageOSVolumeSourceObjectLike(StorageOSVolumeSource item) {
    return new StorageOSVolumeSourceObjectNested(item);
  }
  public PodStatusObjectNested<A> withNewPodStatusObject() {
    return new PodStatusObjectNested(null);
  }
  public PodStatusObjectNested<A> withNewPodStatusObjectLike(PodStatus item) {
    return new PodStatusObjectNested(item);
  }
  public KubernetesListObjectNested<A> withNewKubernetesListObject() {
    return new KubernetesListObjectNested(null);
  }
  public KubernetesListObjectNested<A> withNewKubernetesListObjectLike(KubernetesList item) {
    return new KubernetesListObjectNested(item);
  }
  public ExecConfigObjectNested<A> withNewExecConfigObject() {
    return new ExecConfigObjectNested(null);
  }
  public ExecConfigObjectNested<A> withNewExecConfigObjectLike(ExecConfig item) {
    return new ExecConfigObjectNested(item);
  }
  public PersistentVolumeStatusObjectNested<A> withNewPersistentVolumeStatusObject() {
    return new PersistentVolumeStatusObjectNested(null);
  }
  public PersistentVolumeStatusObjectNested<A> withNewPersistentVolumeStatusObjectLike(PersistentVolumeStatus item) {
    return new PersistentVolumeStatusObjectNested(item);
  }
  public A withNewPersistentVolumeStatusObject(String message,String phase,String reason) {
    return (A)withObject(new PersistentVolumeStatus(message, phase, reason));
  }
  public EndpointPortObjectNested<A> withNewEndpointPortObject() {
    return new EndpointPortObjectNested(null);
  }
  public EndpointPortObjectNested<A> withNewEndpointPortObjectLike(EndpointPort item) {
    return new EndpointPortObjectNested(item);
  }
  public A withNewEndpointPortObject(String appProtocol,String name,Integer port,String protocol) {
    return (A)withObject(new EndpointPort(appProtocol, name, port, protocol));
  }
  public HTTPHeaderObjectNested<A> withNewHTTPHeaderObject() {
    return new HTTPHeaderObjectNested(null);
  }
  public HTTPHeaderObjectNested<A> withNewHTTPHeaderObjectLike(HTTPHeader item) {
    return new HTTPHeaderObjectNested(item);
  }
  public A withNewHTTPHeaderObject(String name,String value) {
    return (A)withObject(new HTTPHeader(name, value));
  }
  public CapabilitiesObjectNested<A> withNewCapabilitiesObject() {
    return new CapabilitiesObjectNested(null);
  }
  public CapabilitiesObjectNested<A> withNewCapabilitiesObjectLike(Capabilities item) {
    return new CapabilitiesObjectNested(item);
  }
  public ObjectReferenceObjectNested<A> withNewObjectReferenceObject() {
    return new ObjectReferenceObjectNested(null);
  }
  public ObjectReferenceObjectNested<A> withNewObjectReferenceObjectLike(ObjectReference item) {
    return new ObjectReferenceObjectNested(item);
  }
  public WatchEventObjectNested<A> withNewWatchEventObject() {
    return new WatchEventObjectNested(null);
  }
  public WatchEventObjectNested<A> withNewWatchEventObjectLike(WatchEvent item) {
    return new WatchEventObjectNested(item);
  }
  public LimitRangeItemObjectNested<A> withNewLimitRangeItemObject() {
    return new LimitRangeItemObjectNested(null);
  }
  public LimitRangeItemObjectNested<A> withNewLimitRangeItemObjectLike(LimitRangeItem item) {
    return new LimitRangeItemObjectNested(item);
  }
  public SecretProjectionObjectNested<A> withNewSecretProjectionObject() {
    return new SecretProjectionObjectNested(null);
  }
  public SecretProjectionObjectNested<A> withNewSecretProjectionObjectLike(SecretProjection item) {
    return new SecretProjectionObjectNested(item);
  }
  public GetOptionsObjectNested<A> withNewGetOptionsObject() {
    return new GetOptionsObjectNested(null);
  }
  public GetOptionsObjectNested<A> withNewGetOptionsObjectLike(GetOptions item) {
    return new GetOptionsObjectNested(item);
  }
  public A withNewGetOptionsObject(String apiVersion,String kind,String resourceVersion) {
    return (A)withObject(new GetOptions(apiVersion, kind, resourceVersion));
  }
  public GlusterfsVolumeSourceObjectNested<A> withNewGlusterfsVolumeSourceObject() {
    return new GlusterfsVolumeSourceObjectNested(null);
  }
  public GlusterfsVolumeSourceObjectNested<A> withNewGlusterfsVolumeSourceObjectLike(GlusterfsVolumeSource item) {
    return new GlusterfsVolumeSourceObjectNested(item);
  }
  public A withNewGlusterfsVolumeSourceObject(String endpoints,String path,Boolean readOnly) {
    return (A)withObject(new GlusterfsVolumeSource(endpoints, path, readOnly));
  }
  public ManagedFieldsEntryObjectNested<A> withNewManagedFieldsEntryObject() {
    return new ManagedFieldsEntryObjectNested(null);
  }
  public ManagedFieldsEntryObjectNested<A> withNewManagedFieldsEntryObjectLike(ManagedFieldsEntry item) {
    return new ManagedFieldsEntryObjectNested(item);
  }
  public NamespaceStatusObjectNested<A> withNewNamespaceStatusObject() {
    return new NamespaceStatusObjectNested(null);
  }
  public NamespaceStatusObjectNested<A> withNewNamespaceStatusObjectLike(NamespaceStatus item) {
    return new NamespaceStatusObjectNested(item);
  }
  public SecretEnvSourceObjectNested<A> withNewSecretEnvSourceObject() {
    return new SecretEnvSourceObjectNested(null);
  }
  public SecretEnvSourceObjectNested<A> withNewSecretEnvSourceObjectLike(SecretEnvSource item) {
    return new SecretEnvSourceObjectNested(item);
  }
  public A withNewSecretEnvSourceObject(String name,Boolean optional) {
    return (A)withObject(new SecretEnvSource(name, optional));
  }
  public ServiceAccountObjectNested<A> withNewServiceAccountObject() {
    return new ServiceAccountObjectNested(null);
  }
  public ServiceAccountObjectNested<A> withNewServiceAccountObjectLike(ServiceAccount item) {
    return new ServiceAccountObjectNested(item);
  }
  public AWSElasticBlockStoreVolumeSourceObjectNested<A> withNewAWSElasticBlockStoreVolumeSourceObject() {
    return new AWSElasticBlockStoreVolumeSourceObjectNested(null);
  }
  public AWSElasticBlockStoreVolumeSourceObjectNested<A> withNewAWSElasticBlockStoreVolumeSourceObjectLike(AWSElasticBlockStoreVolumeSource item) {
    return new AWSElasticBlockStoreVolumeSourceObjectNested(item);
  }
  public A withNewAWSElasticBlockStoreVolumeSourceObject(String fsType,Integer partition,Boolean readOnly,String volumeID) {
    return (A)withObject(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
  }
  public PodIPObjectNested<A> withNewPodIPObject() {
    return new PodIPObjectNested(null);
  }
  public PodIPObjectNested<A> withNewPodIPObjectLike(PodIP item) {
    return new PodIPObjectNested(item);
  }
  public A withNewPodIPObject(String ip) {
    return (A)withObject(new PodIP(ip));
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WatchEventFluent that = (WatchEventFluent) o;
    if (!java.util.Objects.equals(object, that.object)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(object,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (object != null) { sb.append("object:"); sb.append(object + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.kubernetes.api.model."+"Patch": return (VisitableBuilder<T, ?>)new PatchBuilder((Patch) item);
    case "io.fabric8.kubernetes.api.model."+"LimitRange": return (VisitableBuilder<T, ?>)new LimitRangeBuilder((LimitRange) item);
    case "io.fabric8.kubernetes.api.model."+"APIGroupList": return (VisitableBuilder<T, ?>)new APIGroupListBuilder((APIGroupList) item);
    case "io.fabric8.kubernetes.api.model."+"PortStatus": return (VisitableBuilder<T, ?>)new PortStatusBuilder((PortStatus) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplateSpec": return (VisitableBuilder<T, ?>)new PodTemplateSpecBuilder((PodTemplateSpec) item);
    case "io.fabric8.kubernetes.api.model."+"CSIPersistentVolumeSource": return (VisitableBuilder<T, ?>)new CSIPersistentVolumeSourceBuilder((CSIPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"AuthInfo": return (VisitableBuilder<T, ?>)new AuthInfoBuilder((AuthInfo) item);
    case "io.fabric8.kubernetes.api.model."+"APIService": return (VisitableBuilder<T, ?>)new APIServiceBuilder((APIService) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceRequirements": return (VisitableBuilder<T, ?>)new ResourceRequirementsBuilder((ResourceRequirements) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapKeySelector": return (VisitableBuilder<T, ?>)new ConfigMapKeySelectorBuilder((ConfigMapKeySelector) item);
    case "io.fabric8.kubernetes.api.model."+"HostPathVolumeSource": return (VisitableBuilder<T, ?>)new HostPathVolumeSourceBuilder((HostPathVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimList": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimListBuilder((PersistentVolumeClaimList) item);
    case "io.fabric8.kubernetes.api.model."+"NamedContext": return (VisitableBuilder<T, ?>)new NamedContextBuilder((NamedContext) item);
    case "io.fabric8.kubernetes.api.model."+"Config": return (VisitableBuilder<T, ?>)new ConfigBuilder((Config) item);
    case "io.fabric8.kubernetes.api.model."+"Affinity": return (VisitableBuilder<T, ?>)new AffinityBuilder((Affinity) item);
    case "io.fabric8.kubernetes.api.model."+"PodResourceClaim": return (VisitableBuilder<T, ?>)new PodResourceClaimBuilder((PodResourceClaim) item);
    case "io.fabric8.kubernetes.api.model."+"ReplicationControllerStatus": return (VisitableBuilder<T, ?>)new ReplicationControllerStatusBuilder((ReplicationControllerStatus) item);
    case "io.fabric8.kubernetes.api.model."+"APIServiceStatus": return (VisitableBuilder<T, ?>)new APIServiceStatusBuilder((APIServiceStatus) item);
    case "io.fabric8.kubernetes.api.model."+"MicroTime": return (VisitableBuilder<T, ?>)new MicroTimeBuilder((MicroTime) item);
    case "io.fabric8.kubernetes.api.model."+"Lifecycle": return (VisitableBuilder<T, ?>)new LifecycleBuilder((Lifecycle) item);
    case "io.fabric8.kubernetes.api.model."+"PortworxVolumeSource": return (VisitableBuilder<T, ?>)new PortworxVolumeSourceBuilder((PortworxVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"EventSource": return (VisitableBuilder<T, ?>)new EventSourceBuilder((EventSource) item);
    case "io.fabric8.kubernetes.api.model."+"GRPCAction": return (VisitableBuilder<T, ?>)new GRPCActionBuilder((GRPCAction) item);
    case "io.fabric8.kubernetes.api.model."+"AzureFileVolumeSource": return (VisitableBuilder<T, ?>)new AzureFileVolumeSourceBuilder((AzureFileVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceClaim": return (VisitableBuilder<T, ?>)new ResourceClaimBuilder((ResourceClaim) item);
    case "io.fabric8.kubernetes.api.model."+"ComponentCondition": return (VisitableBuilder<T, ?>)new ComponentConditionBuilder((ComponentCondition) item);
    case "io.fabric8.kubernetes.api.model."+"EnvVar": return (VisitableBuilder<T, ?>)new EnvVarBuilder((EnvVar) item);
    case "io.fabric8.kubernetes.api.model."+"ReplicationControllerSpec": return (VisitableBuilder<T, ?>)new ReplicationControllerSpecBuilder((ReplicationControllerSpec) item);
    case "io.fabric8.kubernetes.api.model."+"LoadBalancerIngress": return (VisitableBuilder<T, ?>)new LoadBalancerIngressBuilder((LoadBalancerIngress) item);
    case "io.fabric8.kubernetes.api.model."+"AttachedVolume": return (VisitableBuilder<T, ?>)new AttachedVolumeBuilder((AttachedVolume) item);
    case "io.fabric8.kubernetes.api.model."+"LocalObjectReference": return (VisitableBuilder<T, ?>)new LocalObjectReferenceBuilder((LocalObjectReference) item);
    case "io.fabric8.kubernetes.api.model."+"NamedAuthInfo": return (VisitableBuilder<T, ?>)new NamedAuthInfoBuilder((NamedAuthInfo) item);
    case "io.fabric8.kubernetes.api.model."+"EmptyDirVolumeSource": return (VisitableBuilder<T, ?>)new EmptyDirVolumeSourceBuilder((EmptyDirVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PodSpec": return (VisitableBuilder<T, ?>)new PodSpecBuilder((PodSpec) item);
    case "io.fabric8.kubernetes.api.model."+"ServerAddressByClientCIDR": return (VisitableBuilder<T, ?>)new ServerAddressByClientCIDRBuilder((ServerAddressByClientCIDR) item);
    case "io.fabric8.kubernetes.api.model."+"AzureDiskVolumeSource": return (VisitableBuilder<T, ?>)new AzureDiskVolumeSourceBuilder((AzureDiskVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"Preconditions": return (VisitableBuilder<T, ?>)new PreconditionsBuilder((Preconditions) item);
    case "io.fabric8.kubernetes.api.model.version."+"Info": return (VisitableBuilder<T, ?>)new InfoBuilder((Info) item);
    case "io.fabric8.kubernetes.api.model."+"CephFSVolumeSource": return (VisitableBuilder<T, ?>)new CephFSVolumeSourceBuilder((CephFSVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"EphemeralContainer": return (VisitableBuilder<T, ?>)new EphemeralContainerBuilder((EphemeralContainer) item);
    case "io.fabric8.kubernetes.api.model."+"NodeCondition": return (VisitableBuilder<T, ?>)new NodeConditionBuilder((NodeCondition) item);
    case "io.fabric8.kubernetes.api.model."+"EndpointSubset": return (VisitableBuilder<T, ?>)new EndpointSubsetBuilder((EndpointSubset) item);
    case "io.fabric8.kubernetes.api.model."+"LocalVolumeSource": return (VisitableBuilder<T, ?>)new LocalVolumeSourceBuilder((LocalVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceReference": return (VisitableBuilder<T, ?>)new ServiceReferenceBuilder((ServiceReference) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceStatus": return (VisitableBuilder<T, ?>)new ServiceStatusBuilder((ServiceStatus) item);
    case "io.fabric8.kubernetes.api.model."+"Taint": return (VisitableBuilder<T, ?>)new TaintBuilder((Taint) item);
    case "io.fabric8.kubernetes.api.model."+"PatchOptions": return (VisitableBuilder<T, ?>)new PatchOptionsBuilder((PatchOptions) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapNodeConfigSource": return (VisitableBuilder<T, ?>)new ConfigMapNodeConfigSourceBuilder((ConfigMapNodeConfigSource) item);
    case "io.fabric8.kubernetes.api.model."+"HTTPGetAction": return (VisitableBuilder<T, ?>)new HTTPGetActionBuilder((HTTPGetAction) item);
    case "io.fabric8.kubernetes.api.model."+"GlusterfsPersistentVolumeSource": return (VisitableBuilder<T, ?>)new GlusterfsPersistentVolumeSourceBuilder((GlusterfsPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"DownwardAPIVolumeSource": return (VisitableBuilder<T, ?>)new DownwardAPIVolumeSourceBuilder((DownwardAPIVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ISCSIPersistentVolumeSource": return (VisitableBuilder<T, ?>)new ISCSIPersistentVolumeSourceBuilder((ISCSIPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"WindowsSecurityContextOptions": return (VisitableBuilder<T, ?>)new WindowsSecurityContextOptionsBuilder((WindowsSecurityContextOptions) item);
    case "io.fabric8.kubernetes.api.model."+"CreateOptions": return (VisitableBuilder<T, ?>)new CreateOptionsBuilder((CreateOptions) item);
    case "io.fabric8.kubernetes.api.model."+"EnvFromSource": return (VisitableBuilder<T, ?>)new EnvFromSourceBuilder((EnvFromSource) item);
    case "io.fabric8.kubernetes.api.model."+"NamespaceSpec": return (VisitableBuilder<T, ?>)new NamespaceSpecBuilder((NamespaceSpec) item);
    case "io.fabric8.kubernetes.api.model."+"TypeMeta": return (VisitableBuilder<T, ?>)new TypeMetaBuilder((TypeMeta) item);
    case "io.fabric8.kubernetes.api.model."+"RootPaths": return (VisitableBuilder<T, ?>)new RootPathsBuilder((RootPaths) item);
    case "io.fabric8.kubernetes.api.model."+"ListMeta": return (VisitableBuilder<T, ?>)new ListMetaBuilder((ListMeta) item);
    case "io.fabric8.kubernetes.api.model."+"SecretReference": return (VisitableBuilder<T, ?>)new SecretReferenceBuilder((SecretReference) item);
    case "io.fabric8.kubernetes.api.model."+"APIGroup": return (VisitableBuilder<T, ?>)new APIGroupBuilder((APIGroup) item);
    case "io.fabric8.kubernetes.api.model."+"FlexVolumeSource": return (VisitableBuilder<T, ?>)new FlexVolumeSourceBuilder((FlexVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimTemplate": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimTemplateBuilder((PersistentVolumeClaimTemplate) item);
    case "io.fabric8.kubernetes.api.model."+"ISCSIVolumeSource": return (VisitableBuilder<T, ?>)new ISCSIVolumeSourceBuilder((ISCSIVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"SecretKeySelector": return (VisitableBuilder<T, ?>)new SecretKeySelectorBuilder((SecretKeySelector) item);
    case "io.fabric8.kubernetes.api.model."+"RBDVolumeSource": return (VisitableBuilder<T, ?>)new RBDVolumeSourceBuilder((RBDVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"NodeConfigStatus": return (VisitableBuilder<T, ?>)new NodeConfigStatusBuilder((NodeConfigStatus) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceQuotaList": return (VisitableBuilder<T, ?>)new ResourceQuotaListBuilder((ResourceQuotaList) item);
    case "io.fabric8.kubernetes.api.model."+"QuobyteVolumeSource": return (VisitableBuilder<T, ?>)new QuobyteVolumeSourceBuilder((QuobyteVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"APIResource": return (VisitableBuilder<T, ?>)new APIResourceBuilder((APIResource) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceQuotaStatus": return (VisitableBuilder<T, ?>)new ResourceQuotaStatusBuilder((ResourceQuotaStatus) item);
    case "io.fabric8.kubernetes.api.model.runtime."+"RawExtension": return (VisitableBuilder<T, ?>)new RawExtensionBuilder((RawExtension) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapProjection": return (VisitableBuilder<T, ?>)new ConfigMapProjectionBuilder((ConfigMapProjection) item);
    case "io.fabric8.kubernetes.api.model."+"ScopedResourceSelectorRequirement": return (VisitableBuilder<T, ?>)new ScopedResourceSelectorRequirementBuilder((ScopedResourceSelectorRequirement) item);
    case "io.fabric8.kubernetes.api.model."+"Namespace": return (VisitableBuilder<T, ?>)new NamespaceBuilder((Namespace) item);
    case "io.fabric8.kubernetes.api.model."+"GroupVersionKind": return (VisitableBuilder<T, ?>)new GroupVersionKindBuilder((GroupVersionKind) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerStateTerminated": return (VisitableBuilder<T, ?>)new ContainerStateTerminatedBuilder((ContainerStateTerminated) item);
    case "io.fabric8.kubernetes.api.model."+"LimitRangeSpec": return (VisitableBuilder<T, ?>)new LimitRangeSpecBuilder((LimitRangeSpec) item);
    case "io.fabric8.kubernetes.api.model."+"ProjectedVolumeSource": return (VisitableBuilder<T, ?>)new ProjectedVolumeSourceBuilder((ProjectedVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PodOS": return (VisitableBuilder<T, ?>)new PodOSBuilder((PodOS) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimStatus": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimStatusBuilder((PersistentVolumeClaimStatus) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerState": return (VisitableBuilder<T, ?>)new ContainerStateBuilder((ContainerState) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceSpec": return (VisitableBuilder<T, ?>)new ServiceSpecBuilder((ServiceSpec) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceAccountTokenProjection": return (VisitableBuilder<T, ?>)new ServiceAccountTokenProjectionBuilder((ServiceAccountTokenProjection) item);
    case "io.fabric8.kubernetes.api.model."+"PhotonPersistentDiskVolumeSource": return (VisitableBuilder<T, ?>)new PhotonPersistentDiskVolumeSourceBuilder((PhotonPersistentDiskVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"Container": return (VisitableBuilder<T, ?>)new ContainerBuilder((Container) item);
    case "io.fabric8.kubernetes.api.model."+"NodeSpec": return (VisitableBuilder<T, ?>)new NodeSpecBuilder((NodeSpec) item);
    case "io.fabric8.kubernetes.api.model."+"TypedLocalObjectReference": return (VisitableBuilder<T, ?>)new TypedLocalObjectReferenceBuilder((TypedLocalObjectReference) item);
    case "io.fabric8.kubernetes.api.model."+"FieldsV1": return (VisitableBuilder<T, ?>)new FieldsV1Builder((FieldsV1) item);
    case "io.fabric8.kubernetes.api.model."+"SecretList": return (VisitableBuilder<T, ?>)new SecretListBuilder((SecretList) item);
    case "io.fabric8.kubernetes.api.model."+"NodeAddress": return (VisitableBuilder<T, ?>)new NodeAddressBuilder((NodeAddress) item);
    case "io.fabric8.kubernetes.api.model."+"PodAffinity": return (VisitableBuilder<T, ?>)new PodAffinityBuilder((PodAffinity) item);
    case "io.fabric8.kubernetes.api.model."+"ExecEnvVar": return (VisitableBuilder<T, ?>)new ExecEnvVarBuilder((ExecEnvVar) item);
    case "io.fabric8.kubernetes.api.model."+"Service": return (VisitableBuilder<T, ?>)new ServiceBuilder((Service) item);
    case "io.fabric8.kubernetes.api.model."+"EventSeries": return (VisitableBuilder<T, ?>)new EventSeriesBuilder((EventSeries) item);
    case "io.fabric8.kubernetes.api.model."+"PodCondition": return (VisitableBuilder<T, ?>)new PodConditionBuilder((PodCondition) item);
    case "io.fabric8.kubernetes.api.model."+"TopologySpreadConstraint": return (VisitableBuilder<T, ?>)new TopologySpreadConstraintBuilder((TopologySpreadConstraint) item);
    case "io.fabric8.kubernetes.api.model."+"ExecAction": return (VisitableBuilder<T, ?>)new ExecActionBuilder((ExecAction) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerImage": return (VisitableBuilder<T, ?>)new ContainerImageBuilder((ContainerImage) item);
    case "io.fabric8.kubernetes.api.model."+"GroupKind": return (VisitableBuilder<T, ?>)new GroupKindBuilder((GroupKind) item);
    case "io.fabric8.kubernetes.api.model."+"ReplicationController": return (VisitableBuilder<T, ?>)new ReplicationControllerBuilder((ReplicationController) item);
    case "io.fabric8.kubernetes.api.model."+"NodeStatus": return (VisitableBuilder<T, ?>)new NodeStatusBuilder((NodeStatus) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapList": return (VisitableBuilder<T, ?>)new ConfigMapListBuilder((ConfigMapList) item);
    case "io.fabric8.kubernetes.api.model."+"NodeSelector": return (VisitableBuilder<T, ?>)new NodeSelectorBuilder((NodeSelector) item);
    case "io.fabric8.kubernetes.api.model."+"Toleration": return (VisitableBuilder<T, ?>)new TolerationBuilder((Toleration) item);
    case "io.fabric8.kubernetes.api.model."+"CephFSPersistentVolumeSource": return (VisitableBuilder<T, ?>)new CephFSPersistentVolumeSourceBuilder((CephFSPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimCondition": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimConditionBuilder((PersistentVolumeClaimCondition) item);
    case "io.fabric8.kubernetes.api.model."+"PreferredSchedulingTerm": return (VisitableBuilder<T, ?>)new PreferredSchedulingTermBuilder((PreferredSchedulingTerm) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeList": return (VisitableBuilder<T, ?>)new PersistentVolumeListBuilder((PersistentVolumeList) item);
    case "io.fabric8.kubernetes.api.model."+"PodSchedulingGate": return (VisitableBuilder<T, ?>)new PodSchedulingGateBuilder((PodSchedulingGate) item);
    case "io.fabric8.kubernetes.api.model."+"PodDNSConfigOption": return (VisitableBuilder<T, ?>)new PodDNSConfigOptionBuilder((PodDNSConfigOption) item);
    case "io.fabric8.kubernetes.api.model."+"GCEPersistentDiskVolumeSource": return (VisitableBuilder<T, ?>)new GCEPersistentDiskVolumeSourceBuilder((GCEPersistentDiskVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"APIServiceCondition": return (VisitableBuilder<T, ?>)new APIServiceConditionBuilder((APIServiceCondition) item);
    case "io.fabric8.kubernetes.api.model."+"EventList": return (VisitableBuilder<T, ?>)new EventListBuilder((EventList) item);
    case "io.fabric8.kubernetes.api.model."+"PodReadinessGate": return (VisitableBuilder<T, ?>)new PodReadinessGateBuilder((PodReadinessGate) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerStateWaiting": return (VisitableBuilder<T, ?>)new ContainerStateWaitingBuilder((ContainerStateWaiting) item);
    case "io.fabric8.kubernetes.api.model."+"VolumeMount": return (VisitableBuilder<T, ?>)new VolumeMountBuilder((VolumeMount) item);
    case "io.fabric8.kubernetes.api.model."+"NamespaceCondition": return (VisitableBuilder<T, ?>)new NamespaceConditionBuilder((NamespaceCondition) item);
    case "io.fabric8.kubernetes.api.model."+"LabelSelector": return (VisitableBuilder<T, ?>)new LabelSelectorBuilder((LabelSelector) item);
    case "io.fabric8.kubernetes.api.model."+"StatusCause": return (VisitableBuilder<T, ?>)new StatusCauseBuilder((StatusCause) item);
    case "io.fabric8.kubernetes.api.model."+"NamedCluster": return (VisitableBuilder<T, ?>)new NamedClusterBuilder((NamedCluster) item);
    case "io.fabric8.kubernetes.api.model."+"StatusDetails": return (VisitableBuilder<T, ?>)new StatusDetailsBuilder((StatusDetails) item);
    case "io.fabric8.kubernetes.api.model."+"DownwardAPIVolumeFile": return (VisitableBuilder<T, ?>)new DownwardAPIVolumeFileBuilder((DownwardAPIVolumeFile) item);
    case "io.fabric8.kubernetes.api.model."+"SeccompProfile": return (VisitableBuilder<T, ?>)new SeccompProfileBuilder((SeccompProfile) item);
    case "io.fabric8.kubernetes.api.model."+"Sysctl": return (VisitableBuilder<T, ?>)new SysctlBuilder((Sysctl) item);
    case "io.fabric8.kubernetes.api.model."+"DeleteOptions": return (VisitableBuilder<T, ?>)new DeleteOptionsBuilder((DeleteOptions) item);
    case "io.fabric8.kubernetes.api.model."+"Status": return (VisitableBuilder<T, ?>)new StatusBuilder((Status) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerStatus": return (VisitableBuilder<T, ?>)new ContainerStatusBuilder((ContainerStatus) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplate": return (VisitableBuilder<T, ?>)new PodTemplateBuilder((PodTemplate) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapEnvSource": return (VisitableBuilder<T, ?>)new ConfigMapEnvSourceBuilder((ConfigMapEnvSource) item);
    case "io.fabric8.kubernetes.api.model."+"NodeSelectorRequirement": return (VisitableBuilder<T, ?>)new NodeSelectorRequirementBuilder((NodeSelectorRequirement) item);
    case "io.fabric8.kubernetes.api.model."+"TCPSocketAction": return (VisitableBuilder<T, ?>)new TCPSocketActionBuilder((TCPSocketAction) item);
    case "io.fabric8.kubernetes.api.model."+"Event": return (VisitableBuilder<T, ?>)new EventBuilder((Event) item);
    case "io.fabric8.kubernetes.api.model."+"Preferences": return (VisitableBuilder<T, ?>)new PreferencesBuilder((Preferences) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectFieldSelector": return (VisitableBuilder<T, ?>)new ObjectFieldSelectorBuilder((ObjectFieldSelector) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplateList": return (VisitableBuilder<T, ?>)new PodTemplateListBuilder((PodTemplateList) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolume": return (VisitableBuilder<T, ?>)new PersistentVolumeBuilder((PersistentVolume) item);
    case "io.fabric8.kubernetes.api.model."+"CinderVolumeSource": return (VisitableBuilder<T, ?>)new CinderVolumeSourceBuilder((CinderVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"EndpointAddress": return (VisitableBuilder<T, ?>)new EndpointAddressBuilder((EndpointAddress) item);
    case "io.fabric8.kubernetes.api.model."+"NodeConfigSource": return (VisitableBuilder<T, ?>)new NodeConfigSourceBuilder((NodeConfigSource) item);
    case "io.fabric8.kubernetes.api.model."+"VsphereVirtualDiskVolumeSource": return (VisitableBuilder<T, ?>)new VsphereVirtualDiskVolumeSourceBuilder((VsphereVirtualDiskVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectMeta": return (VisitableBuilder<T, ?>)new ObjectMetaBuilder((ObjectMeta) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.kubernetes.api.model."+"LabelSelectorRequirement": return (VisitableBuilder<T, ?>)new LabelSelectorRequirementBuilder((LabelSelectorRequirement) item);
    case "io.fabric8.kubernetes.api.model."+"GitRepoVolumeSource": return (VisitableBuilder<T, ?>)new GitRepoVolumeSourceBuilder((GitRepoVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.kubernetes.api.model."+"EndpointsList": return (VisitableBuilder<T, ?>)new EndpointsListBuilder((EndpointsList) item);
    case "io.fabric8.kubernetes.api.model."+"GroupVersionResource": return (VisitableBuilder<T, ?>)new GroupVersionResourceBuilder((GroupVersionResource) item);
    case "io.fabric8.kubernetes.api.model."+"CinderPersistentVolumeSource": return (VisitableBuilder<T, ?>)new CinderPersistentVolumeSourceBuilder((CinderPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"TopologySelectorTerm": return (VisitableBuilder<T, ?>)new TopologySelectorTermBuilder((TopologySelectorTerm) item);
    case "io.fabric8.kubernetes.api.model."+"OwnerReference": return (VisitableBuilder<T, ?>)new OwnerReferenceBuilder((OwnerReference) item);
    case "io.fabric8.kubernetes.api.model."+"StorageOSPersistentVolumeSource": return (VisitableBuilder<T, ?>)new StorageOSPersistentVolumeSourceBuilder((StorageOSPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"EphemeralVolumeSource": return (VisitableBuilder<T, ?>)new EphemeralVolumeSourceBuilder((EphemeralVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ReplicationControllerCondition": return (VisitableBuilder<T, ?>)new ReplicationControllerConditionBuilder((ReplicationControllerCondition) item);
    case "io.fabric8.kubernetes.api.model."+"PodAntiAffinity": return (VisitableBuilder<T, ?>)new PodAntiAffinityBuilder((PodAntiAffinity) item);
    case "io.fabric8.kubernetes.api.model."+"SecurityContext": return (VisitableBuilder<T, ?>)new SecurityContextBuilder((SecurityContext) item);
    case "io.fabric8.kubernetes.api.model."+"ReplicationControllerList": return (VisitableBuilder<T, ?>)new ReplicationControllerListBuilder((ReplicationControllerList) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapVolumeSource": return (VisitableBuilder<T, ?>)new ConfigMapVolumeSourceBuilder((ConfigMapVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerStateRunning": return (VisitableBuilder<T, ?>)new ContainerStateRunningBuilder((ContainerStateRunning) item);
    case "io.fabric8.kubernetes.api.model."+"ComponentStatusList": return (VisitableBuilder<T, ?>)new ComponentStatusListBuilder((ComponentStatusList) item);
    case "io.fabric8.kubernetes.api.model."+"FlockerVolumeSource": return (VisitableBuilder<T, ?>)new FlockerVolumeSourceBuilder((FlockerVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ScaleIOVolumeSource": return (VisitableBuilder<T, ?>)new ScaleIOVolumeSourceBuilder((ScaleIOVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"LimitRangeList": return (VisitableBuilder<T, ?>)new LimitRangeListBuilder((LimitRangeList) item);
    case "io.fabric8.kubernetes.api.model."+"PodExecOptions": return (VisitableBuilder<T, ?>)new PodExecOptionsBuilder((PodExecOptions) item);
    case "io.fabric8.kubernetes.api.model."+"Probe": return (VisitableBuilder<T, ?>)new ProbeBuilder((Probe) item);
    case "io.fabric8.kubernetes.api.model."+"UpdateOptions": return (VisitableBuilder<T, ?>)new UpdateOptionsBuilder((UpdateOptions) item);
    case "io.fabric8.kubernetes.api.model."+"Endpoints": return (VisitableBuilder<T, ?>)new EndpointsBuilder((Endpoints) item);
    case "io.fabric8.kubernetes.api.model."+"NamedExtension": return (VisitableBuilder<T, ?>)new NamedExtensionBuilder((NamedExtension) item);
    case "io.fabric8.kubernetes.api.model."+"AzureFilePersistentVolumeSource": return (VisitableBuilder<T, ?>)new AzureFilePersistentVolumeSourceBuilder((AzureFilePersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"APIResourceList": return (VisitableBuilder<T, ?>)new APIResourceListBuilder((APIResourceList) item);
    case "io.fabric8.kubernetes.api.model."+"APIServiceList": return (VisitableBuilder<T, ?>)new APIServiceListBuilder((APIServiceList) item);
    case "io.fabric8.kubernetes.api.model."+"SecretVolumeSource": return (VisitableBuilder<T, ?>)new SecretVolumeSourceBuilder((SecretVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"Pod": return (VisitableBuilder<T, ?>)new PodBuilder((Pod) item);
    case "io.fabric8.kubernetes.api.model."+"ClientIPConfig": return (VisitableBuilder<T, ?>)new ClientIPConfigBuilder((ClientIPConfig) item);
    case "io.fabric8.kubernetes.api.model."+"Context": return (VisitableBuilder<T, ?>)new ContextBuilder((Context) item);
    case "io.fabric8.kubernetes.api.model."+"NodeAffinity": return (VisitableBuilder<T, ?>)new NodeAffinityBuilder((NodeAffinity) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMap": return (VisitableBuilder<T, ?>)new ConfigMapBuilder((ConfigMap) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerPort": return (VisitableBuilder<T, ?>)new ContainerPortBuilder((ContainerPort) item);
    case "io.fabric8.kubernetes.api.model."+"Condition": return (VisitableBuilder<T, ?>)new ConditionBuilder((Condition) item);
    case "io.fabric8.kubernetes.api.model."+"PodList": return (VisitableBuilder<T, ?>)new PodListBuilder((PodList) item);
    case "io.fabric8.kubernetes.api.model."+"FCVolumeSource": return (VisitableBuilder<T, ?>)new FCVolumeSourceBuilder((FCVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceFieldSelector": return (VisitableBuilder<T, ?>)new ResourceFieldSelectorBuilder((ResourceFieldSelector) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimSpec": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimSpecBuilder((PersistentVolumeClaimSpec) item);
    case "io.fabric8.kubernetes.api.model."+"LoadBalancerStatus": return (VisitableBuilder<T, ?>)new LoadBalancerStatusBuilder((LoadBalancerStatus) item);
    case "io.fabric8.kubernetes.api.model."+"PodSecurityContext": return (VisitableBuilder<T, ?>)new PodSecurityContextBuilder((PodSecurityContext) item);
    case "io.fabric8.kubernetes.api.model."+"ScopeSelector": return (VisitableBuilder<T, ?>)new ScopeSelectorBuilder((ScopeSelector) item);
    case "io.fabric8.kubernetes.api.model."+"DownwardAPIProjection": return (VisitableBuilder<T, ?>)new DownwardAPIProjectionBuilder((DownwardAPIProjection) item);
    case "io.fabric8.kubernetes.api.model."+"PodAffinityTerm": return (VisitableBuilder<T, ?>)new PodAffinityTermBuilder((PodAffinityTerm) item);
    case "io.fabric8.kubernetes.api.model."+"APIServiceSpec": return (VisitableBuilder<T, ?>)new APIServiceSpecBuilder((APIServiceSpec) item);
    case "io.fabric8.kubernetes.api.model."+"ServicePort": return (VisitableBuilder<T, ?>)new ServicePortBuilder((ServicePort) item);
    case "io.fabric8.kubernetes.api.model."+"GroupVersionForDiscovery": return (VisitableBuilder<T, ?>)new GroupVersionForDiscoveryBuilder((GroupVersionForDiscovery) item);
    case "io.fabric8.kubernetes.api.model."+"ClaimSource": return (VisitableBuilder<T, ?>)new ClaimSourceBuilder((ClaimSource) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimVolumeSource": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimVolumeSourceBuilder((PersistentVolumeClaimVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"SessionAffinityConfig": return (VisitableBuilder<T, ?>)new SessionAffinityConfigBuilder((SessionAffinityConfig) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceAccountList": return (VisitableBuilder<T, ?>)new ServiceAccountListBuilder((ServiceAccountList) item);
    case "io.fabric8.kubernetes.api.model."+"ComponentStatus": return (VisitableBuilder<T, ?>)new ComponentStatusBuilder((ComponentStatus) item);
    case "io.fabric8.kubernetes.api.model."+"DaemonEndpoint": return (VisitableBuilder<T, ?>)new DaemonEndpointBuilder((DaemonEndpoint) item);
    case "io.fabric8.kubernetes.api.model."+"KeyToPath": return (VisitableBuilder<T, ?>)new KeyToPathBuilder((KeyToPath) item);
    case "io.fabric8.kubernetes.api.model."+"FlexPersistentVolumeSource": return (VisitableBuilder<T, ?>)new FlexPersistentVolumeSourceBuilder((FlexPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"NamespaceList": return (VisitableBuilder<T, ?>)new NamespaceListBuilder((NamespaceList) item);
    case "io.fabric8.kubernetes.api.model."+"PodDNSConfig": return (VisitableBuilder<T, ?>)new PodDNSConfigBuilder((PodDNSConfig) item);
    case "io.fabric8.kubernetes.api.model."+"NodeList": return (VisitableBuilder<T, ?>)new NodeListBuilder((NodeList) item);
    case "io.fabric8.kubernetes.api.model."+"Binding": return (VisitableBuilder<T, ?>)new BindingBuilder((Binding) item);
    case "io.fabric8.kubernetes.api.model."+"EnvVarSource": return (VisitableBuilder<T, ?>)new EnvVarSourceBuilder((EnvVarSource) item);
    case "io.fabric8.kubernetes.api.model."+"VolumeProjection": return (VisitableBuilder<T, ?>)new VolumeProjectionBuilder((VolumeProjection) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceQuota": return (VisitableBuilder<T, ?>)new ResourceQuotaBuilder((ResourceQuota) item);
    case "io.fabric8.kubernetes.api.model."+"Secret": return (VisitableBuilder<T, ?>)new SecretBuilder((Secret) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceList": return (VisitableBuilder<T, ?>)new ServiceListBuilder((ServiceList) item);
    case "io.fabric8.kubernetes.api.model."+"VolumeNodeAffinity": return (VisitableBuilder<T, ?>)new VolumeNodeAffinityBuilder((VolumeNodeAffinity) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceQuotaSpec": return (VisitableBuilder<T, ?>)new ResourceQuotaSpecBuilder((ResourceQuotaSpec) item);
    case "io.fabric8.kubernetes.api.model."+"NodeSelectorTerm": return (VisitableBuilder<T, ?>)new NodeSelectorTermBuilder((NodeSelectorTerm) item);
    case "io.fabric8.kubernetes.api.model."+"ScaleIOPersistentVolumeSource": return (VisitableBuilder<T, ?>)new ScaleIOPersistentVolumeSourceBuilder((ScaleIOPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ListOptions": return (VisitableBuilder<T, ?>)new ListOptionsBuilder((ListOptions) item);
    case "io.fabric8.kubernetes.api.model."+"WeightedPodAffinityTerm": return (VisitableBuilder<T, ?>)new WeightedPodAffinityTermBuilder((WeightedPodAffinityTerm) item);
    case "io.fabric8.kubernetes.api.model."+"TypedObjectReference": return (VisitableBuilder<T, ?>)new TypedObjectReferenceBuilder((TypedObjectReference) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerResizePolicy": return (VisitableBuilder<T, ?>)new ContainerResizePolicyBuilder((ContainerResizePolicy) item);
    case "io.fabric8.kubernetes.api.model."+"NodeSystemInfo": return (VisitableBuilder<T, ?>)new NodeSystemInfoBuilder((NodeSystemInfo) item);
    case "io.fabric8.kubernetes.api.model."+"TopologySelectorLabelRequirement": return (VisitableBuilder<T, ?>)new TopologySelectorLabelRequirementBuilder((TopologySelectorLabelRequirement) item);
    case "io.fabric8.kubernetes.api.model."+"RBDPersistentVolumeSource": return (VisitableBuilder<T, ?>)new RBDPersistentVolumeSourceBuilder((RBDPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"AuthProviderConfig": return (VisitableBuilder<T, ?>)new AuthProviderConfigBuilder((AuthProviderConfig) item);
    case "io.fabric8.kubernetes.api.model."+"SELinuxOptions": return (VisitableBuilder<T, ?>)new SELinuxOptionsBuilder((SELinuxOptions) item);
    case "io.fabric8.kubernetes.api.model."+"HostAlias": return (VisitableBuilder<T, ?>)new HostAliasBuilder((HostAlias) item);
    case "io.fabric8.kubernetes.api.model."+"NodeDaemonEndpoints": return (VisitableBuilder<T, ?>)new NodeDaemonEndpointsBuilder((NodeDaemonEndpoints) item);
    case "io.fabric8.kubernetes.api.model."+"VolumeDevice": return (VisitableBuilder<T, ?>)new VolumeDeviceBuilder((VolumeDevice) item);
    case "io.fabric8.kubernetes.api.model."+"CSIVolumeSource": return (VisitableBuilder<T, ?>)new CSIVolumeSourceBuilder((CSIVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeSpec": return (VisitableBuilder<T, ?>)new PersistentVolumeSpecBuilder((PersistentVolumeSpec) item);
    case "io.fabric8.kubernetes.api.model."+"Node": return (VisitableBuilder<T, ?>)new NodeBuilder((Node) item);
    case "io.fabric8.kubernetes.api.model."+"LifecycleHandler": return (VisitableBuilder<T, ?>)new LifecycleHandlerBuilder((LifecycleHandler) item);
    case "io.fabric8.kubernetes.api.model."+"Volume": return (VisitableBuilder<T, ?>)new VolumeBuilder((Volume) item);
    case "io.fabric8.kubernetes.api.model."+"Cluster": return (VisitableBuilder<T, ?>)new ClusterBuilder((Cluster) item);
    case "io.fabric8.kubernetes.api.model."+"NFSVolumeSource": return (VisitableBuilder<T, ?>)new NFSVolumeSourceBuilder((NFSVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"StorageOSVolumeSource": return (VisitableBuilder<T, ?>)new StorageOSVolumeSourceBuilder((StorageOSVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PodStatus": return (VisitableBuilder<T, ?>)new PodStatusBuilder((PodStatus) item);
    case "io.fabric8.kubernetes.api.model."+"KubernetesList": return (VisitableBuilder<T, ?>)new KubernetesListBuilder((KubernetesList) item);
    case "io.fabric8.kubernetes.api.model."+"ExecConfig": return (VisitableBuilder<T, ?>)new ExecConfigBuilder((ExecConfig) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeStatus": return (VisitableBuilder<T, ?>)new PersistentVolumeStatusBuilder((PersistentVolumeStatus) item);
    case "io.fabric8.kubernetes.api.model."+"EndpointPort": return (VisitableBuilder<T, ?>)new EndpointPortBuilder((EndpointPort) item);
    case "io.fabric8.kubernetes.api.model."+"HTTPHeader": return (VisitableBuilder<T, ?>)new HTTPHeaderBuilder((HTTPHeader) item);
    case "io.fabric8.kubernetes.api.model."+"Capabilities": return (VisitableBuilder<T, ?>)new CapabilitiesBuilder((Capabilities) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectReference": return (VisitableBuilder<T, ?>)new ObjectReferenceBuilder((ObjectReference) item);
    case "io.fabric8.kubernetes.api.model."+"WatchEvent": return (VisitableBuilder<T, ?>)new WatchEventBuilder((WatchEvent) item);
    case "io.fabric8.kubernetes.api.model."+"LimitRangeItem": return (VisitableBuilder<T, ?>)new LimitRangeItemBuilder((LimitRangeItem) item);
    case "io.fabric8.kubernetes.api.model."+"SecretProjection": return (VisitableBuilder<T, ?>)new SecretProjectionBuilder((SecretProjection) item);
    case "io.fabric8.kubernetes.api.model."+"GetOptions": return (VisitableBuilder<T, ?>)new GetOptionsBuilder((GetOptions) item);
    case "io.fabric8.kubernetes.api.model."+"GlusterfsVolumeSource": return (VisitableBuilder<T, ?>)new GlusterfsVolumeSourceBuilder((GlusterfsVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ManagedFieldsEntry": return (VisitableBuilder<T, ?>)new ManagedFieldsEntryBuilder((ManagedFieldsEntry) item);
    case "io.fabric8.kubernetes.api.model."+"NamespaceStatus": return (VisitableBuilder<T, ?>)new NamespaceStatusBuilder((NamespaceStatus) item);
    case "io.fabric8.kubernetes.api.model."+"SecretEnvSource": return (VisitableBuilder<T, ?>)new SecretEnvSourceBuilder((SecretEnvSource) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceAccount": return (VisitableBuilder<T, ?>)new ServiceAccountBuilder((ServiceAccount) item);
    case "io.fabric8.kubernetes.api.model."+"AWSElasticBlockStoreVolumeSource": return (VisitableBuilder<T, ?>)new AWSElasticBlockStoreVolumeSourceBuilder((AWSElasticBlockStoreVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PodIP": return (VisitableBuilder<T, ?>)new PodIPBuilder((PodIP) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class PatchObjectNested<N> extends PatchFluent<PatchObjectNested<N>> implements Nested<N>{
    PatchObjectNested(Patch item) {
      this.builder = new PatchBuilder(this, item);
    }
    PatchBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPatchObject() {
      return and();
    }
    
  }
  public class LimitRangeObjectNested<N> extends LimitRangeFluent<LimitRangeObjectNested<N>> implements Nested<N>{
    LimitRangeObjectNested(LimitRange item) {
      this.builder = new LimitRangeBuilder(this, item);
    }
    LimitRangeBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLimitRangeObject() {
      return and();
    }
    
  }
  public class APIGroupListObjectNested<N> extends APIGroupListFluent<APIGroupListObjectNested<N>> implements Nested<N>{
    APIGroupListObjectNested(APIGroupList item) {
      this.builder = new APIGroupListBuilder(this, item);
    }
    APIGroupListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAPIGroupListObject() {
      return and();
    }
    
  }
  public class PortStatusObjectNested<N> extends PortStatusFluent<PortStatusObjectNested<N>> implements Nested<N>{
    PortStatusObjectNested(PortStatus item) {
      this.builder = new PortStatusBuilder(this, item);
    }
    PortStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPortStatusObject() {
      return and();
    }
    
  }
  public class PodTemplateSpecObjectNested<N> extends PodTemplateSpecFluent<PodTemplateSpecObjectNested<N>> implements Nested<N>{
    PodTemplateSpecObjectNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodTemplateSpecObject() {
      return and();
    }
    
  }
  public class CSIPersistentVolumeSourceObjectNested<N> extends CSIPersistentVolumeSourceFluent<CSIPersistentVolumeSourceObjectNested<N>> implements Nested<N>{
    CSIPersistentVolumeSourceObjectNested(CSIPersistentVolumeSource item) {
      this.builder = new CSIPersistentVolumeSourceBuilder(this, item);
    }
    CSIPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endCSIPersistentVolumeSourceObject() {
      return and();
    }
    
  }
  public class AuthInfoObjectNested<N> extends AuthInfoFluent<AuthInfoObjectNested<N>> implements Nested<N>{
    AuthInfoObjectNested(AuthInfo item) {
      this.builder = new AuthInfoBuilder(this, item);
    }
    AuthInfoBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAuthInfoObject() {
      return and();
    }
    
  }
  public class APIServiceObjectNested<N> extends APIServiceFluent<APIServiceObjectNested<N>> implements Nested<N>{
    APIServiceObjectNested(APIService item) {
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAPIServiceObject() {
      return and();
    }
    
  }
  public class ResourceRequirementsObjectNested<N> extends ResourceRequirementsFluent<ResourceRequirementsObjectNested<N>> implements Nested<N>{
    ResourceRequirementsObjectNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endResourceRequirementsObject() {
      return and();
    }
    
  }
  public class ConfigMapKeySelectorObjectNested<N> extends ConfigMapKeySelectorFluent<ConfigMapKeySelectorObjectNested<N>> implements Nested<N>{
    ConfigMapKeySelectorObjectNested(ConfigMapKeySelector item) {
      this.builder = new ConfigMapKeySelectorBuilder(this, item);
    }
    ConfigMapKeySelectorBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endConfigMapKeySelectorObject() {
      return and();
    }
    
  }
  public class HostPathVolumeSourceObjectNested<N> extends HostPathVolumeSourceFluent<HostPathVolumeSourceObjectNested<N>> implements Nested<N>{
    HostPathVolumeSourceObjectNested(HostPathVolumeSource item) {
      this.builder = new HostPathVolumeSourceBuilder(this, item);
    }
    HostPathVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endHostPathVolumeSourceObject() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimListObjectNested<N> extends PersistentVolumeClaimListFluent<PersistentVolumeClaimListObjectNested<N>> implements Nested<N>{
    PersistentVolumeClaimListObjectNested(PersistentVolumeClaimList item) {
      this.builder = new PersistentVolumeClaimListBuilder(this, item);
    }
    PersistentVolumeClaimListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeClaimListObject() {
      return and();
    }
    
  }
  public class NamedContextObjectNested<N> extends NamedContextFluent<NamedContextObjectNested<N>> implements Nested<N>{
    NamedContextObjectNested(NamedContext item) {
      this.builder = new NamedContextBuilder(this, item);
    }
    NamedContextBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNamedContextObject() {
      return and();
    }
    
  }
  public class ConfigObjectNested<N> extends ConfigFluent<ConfigObjectNested<N>> implements Nested<N>{
    ConfigObjectNested(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endConfigObject() {
      return and();
    }
    
  }
  public class AffinityObjectNested<N> extends AffinityFluent<AffinityObjectNested<N>> implements Nested<N>{
    AffinityObjectNested(Affinity item) {
      this.builder = new AffinityBuilder(this, item);
    }
    AffinityBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAffinityObject() {
      return and();
    }
    
  }
  public class PodResourceClaimObjectNested<N> extends PodResourceClaimFluent<PodResourceClaimObjectNested<N>> implements Nested<N>{
    PodResourceClaimObjectNested(PodResourceClaim item) {
      this.builder = new PodResourceClaimBuilder(this, item);
    }
    PodResourceClaimBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodResourceClaimObject() {
      return and();
    }
    
  }
  public class ReplicationControllerStatusObjectNested<N> extends ReplicationControllerStatusFluent<ReplicationControllerStatusObjectNested<N>> implements Nested<N>{
    ReplicationControllerStatusObjectNested(ReplicationControllerStatus item) {
      this.builder = new ReplicationControllerStatusBuilder(this, item);
    }
    ReplicationControllerStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endReplicationControllerStatusObject() {
      return and();
    }
    
  }
  public class APIServiceStatusObjectNested<N> extends APIServiceStatusFluent<APIServiceStatusObjectNested<N>> implements Nested<N>{
    APIServiceStatusObjectNested(APIServiceStatus item) {
      this.builder = new APIServiceStatusBuilder(this, item);
    }
    APIServiceStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAPIServiceStatusObject() {
      return and();
    }
    
  }
  public class MicroTimeObjectNested<N> extends MicroTimeFluent<MicroTimeObjectNested<N>> implements Nested<N>{
    MicroTimeObjectNested(MicroTime item) {
      this.builder = new MicroTimeBuilder(this, item);
    }
    MicroTimeBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endMicroTimeObject() {
      return and();
    }
    
  }
  public class LifecycleObjectNested<N> extends LifecycleFluent<LifecycleObjectNested<N>> implements Nested<N>{
    LifecycleObjectNested(Lifecycle item) {
      this.builder = new LifecycleBuilder(this, item);
    }
    LifecycleBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLifecycleObject() {
      return and();
    }
    
  }
  public class PortworxVolumeSourceObjectNested<N> extends PortworxVolumeSourceFluent<PortworxVolumeSourceObjectNested<N>> implements Nested<N>{
    PortworxVolumeSourceObjectNested(PortworxVolumeSource item) {
      this.builder = new PortworxVolumeSourceBuilder(this, item);
    }
    PortworxVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPortworxVolumeSourceObject() {
      return and();
    }
    
  }
  public class EventSourceObjectNested<N> extends EventSourceFluent<EventSourceObjectNested<N>> implements Nested<N>{
    EventSourceObjectNested(EventSource item) {
      this.builder = new EventSourceBuilder(this, item);
    }
    EventSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEventSourceObject() {
      return and();
    }
    
  }
  public class GRPCActionObjectNested<N> extends GRPCActionFluent<GRPCActionObjectNested<N>> implements Nested<N>{
    GRPCActionObjectNested(GRPCAction item) {
      this.builder = new GRPCActionBuilder(this, item);
    }
    GRPCActionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGRPCActionObject() {
      return and();
    }
    
  }
  public class AzureFileVolumeSourceObjectNested<N> extends AzureFileVolumeSourceFluent<AzureFileVolumeSourceObjectNested<N>> implements Nested<N>{
    AzureFileVolumeSourceObjectNested(AzureFileVolumeSource item) {
      this.builder = new AzureFileVolumeSourceBuilder(this, item);
    }
    AzureFileVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAzureFileVolumeSourceObject() {
      return and();
    }
    
  }
  public class ResourceClaimObjectNested<N> extends ResourceClaimFluent<ResourceClaimObjectNested<N>> implements Nested<N>{
    ResourceClaimObjectNested(ResourceClaim item) {
      this.builder = new ResourceClaimBuilder(this, item);
    }
    ResourceClaimBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endResourceClaimObject() {
      return and();
    }
    
  }
  public class ComponentConditionObjectNested<N> extends ComponentConditionFluent<ComponentConditionObjectNested<N>> implements Nested<N>{
    ComponentConditionObjectNested(ComponentCondition item) {
      this.builder = new ComponentConditionBuilder(this, item);
    }
    ComponentConditionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endComponentConditionObject() {
      return and();
    }
    
  }
  public class EnvVarObjectNested<N> extends EnvVarFluent<EnvVarObjectNested<N>> implements Nested<N>{
    EnvVarObjectNested(EnvVar item) {
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEnvVarObject() {
      return and();
    }
    
  }
  public class ReplicationControllerSpecObjectNested<N> extends ReplicationControllerSpecFluent<ReplicationControllerSpecObjectNested<N>> implements Nested<N>{
    ReplicationControllerSpecObjectNested(ReplicationControllerSpec item) {
      this.builder = new ReplicationControllerSpecBuilder(this, item);
    }
    ReplicationControllerSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endReplicationControllerSpecObject() {
      return and();
    }
    
  }
  public class LoadBalancerIngressObjectNested<N> extends LoadBalancerIngressFluent<LoadBalancerIngressObjectNested<N>> implements Nested<N>{
    LoadBalancerIngressObjectNested(LoadBalancerIngress item) {
      this.builder = new LoadBalancerIngressBuilder(this, item);
    }
    LoadBalancerIngressBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLoadBalancerIngressObject() {
      return and();
    }
    
  }
  public class AttachedVolumeObjectNested<N> extends AttachedVolumeFluent<AttachedVolumeObjectNested<N>> implements Nested<N>{
    AttachedVolumeObjectNested(AttachedVolume item) {
      this.builder = new AttachedVolumeBuilder(this, item);
    }
    AttachedVolumeBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAttachedVolumeObject() {
      return and();
    }
    
  }
  public class LocalObjectReferenceNested<N> extends LocalObjectReferenceFluent<LocalObjectReferenceNested<N>> implements Nested<N>{
    LocalObjectReferenceNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLocalObjectReference() {
      return and();
    }
    
  }
  public class NamedAuthInfoObjectNested<N> extends NamedAuthInfoFluent<NamedAuthInfoObjectNested<N>> implements Nested<N>{
    NamedAuthInfoObjectNested(NamedAuthInfo item) {
      this.builder = new NamedAuthInfoBuilder(this, item);
    }
    NamedAuthInfoBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNamedAuthInfoObject() {
      return and();
    }
    
  }
  public class EmptyDirVolumeSourceObjectNested<N> extends EmptyDirVolumeSourceFluent<EmptyDirVolumeSourceObjectNested<N>> implements Nested<N>{
    EmptyDirVolumeSourceObjectNested(EmptyDirVolumeSource item) {
      this.builder = new EmptyDirVolumeSourceBuilder(this, item);
    }
    EmptyDirVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEmptyDirVolumeSourceObject() {
      return and();
    }
    
  }
  public class PodSpecObjectNested<N> extends PodSpecFluent<PodSpecObjectNested<N>> implements Nested<N>{
    PodSpecObjectNested(PodSpec item) {
      this.builder = new PodSpecBuilder(this, item);
    }
    PodSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodSpecObject() {
      return and();
    }
    
  }
  public class ServerAddressByClientCIDRObjectNested<N> extends ServerAddressByClientCIDRFluent<ServerAddressByClientCIDRObjectNested<N>> implements Nested<N>{
    ServerAddressByClientCIDRObjectNested(ServerAddressByClientCIDR item) {
      this.builder = new ServerAddressByClientCIDRBuilder(this, item);
    }
    ServerAddressByClientCIDRBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endServerAddressByClientCIDRObject() {
      return and();
    }
    
  }
  public class AzureDiskVolumeSourceObjectNested<N> extends AzureDiskVolumeSourceFluent<AzureDiskVolumeSourceObjectNested<N>> implements Nested<N>{
    AzureDiskVolumeSourceObjectNested(AzureDiskVolumeSource item) {
      this.builder = new AzureDiskVolumeSourceBuilder(this, item);
    }
    AzureDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAzureDiskVolumeSourceObject() {
      return and();
    }
    
  }
  public class PreconditionsObjectNested<N> extends PreconditionsFluent<PreconditionsObjectNested<N>> implements Nested<N>{
    PreconditionsObjectNested(Preconditions item) {
      this.builder = new PreconditionsBuilder(this, item);
    }
    PreconditionsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPreconditionsObject() {
      return and();
    }
    
  }
  public class InfoObjectNested<N> extends InfoFluent<InfoObjectNested<N>> implements Nested<N>{
    InfoObjectNested(Info item) {
      this.builder = new InfoBuilder(this, item);
    }
    InfoBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endInfoObject() {
      return and();
    }
    
  }
  public class CephFSVolumeSourceObjectNested<N> extends CephFSVolumeSourceFluent<CephFSVolumeSourceObjectNested<N>> implements Nested<N>{
    CephFSVolumeSourceObjectNested(CephFSVolumeSource item) {
      this.builder = new CephFSVolumeSourceBuilder(this, item);
    }
    CephFSVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endCephFSVolumeSourceObject() {
      return and();
    }
    
  }
  public class EphemeralContainerObjectNested<N> extends EphemeralContainerFluent<EphemeralContainerObjectNested<N>> implements Nested<N>{
    EphemeralContainerObjectNested(EphemeralContainer item) {
      this.builder = new EphemeralContainerBuilder(this, item);
    }
    EphemeralContainerBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEphemeralContainerObject() {
      return and();
    }
    
  }
  public class NodeConditionObjectNested<N> extends NodeConditionFluent<NodeConditionObjectNested<N>> implements Nested<N>{
    NodeConditionObjectNested(NodeCondition item) {
      this.builder = new NodeConditionBuilder(this, item);
    }
    NodeConditionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeConditionObject() {
      return and();
    }
    
  }
  public class EndpointSubsetObjectNested<N> extends EndpointSubsetFluent<EndpointSubsetObjectNested<N>> implements Nested<N>{
    EndpointSubsetObjectNested(EndpointSubset item) {
      this.builder = new EndpointSubsetBuilder(this, item);
    }
    EndpointSubsetBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEndpointSubsetObject() {
      return and();
    }
    
  }
  public class LocalVolumeSourceObjectNested<N> extends LocalVolumeSourceFluent<LocalVolumeSourceObjectNested<N>> implements Nested<N>{
    LocalVolumeSourceObjectNested(LocalVolumeSource item) {
      this.builder = new LocalVolumeSourceBuilder(this, item);
    }
    LocalVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLocalVolumeSourceObject() {
      return and();
    }
    
  }
  public class ServiceReferenceObjectNested<N> extends ServiceReferenceFluent<ServiceReferenceObjectNested<N>> implements Nested<N>{
    ServiceReferenceObjectNested(ServiceReference item) {
      this.builder = new ServiceReferenceBuilder(this, item);
    }
    ServiceReferenceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endServiceReferenceObject() {
      return and();
    }
    
  }
  public class ServiceStatusObjectNested<N> extends ServiceStatusFluent<ServiceStatusObjectNested<N>> implements Nested<N>{
    ServiceStatusObjectNested(ServiceStatus item) {
      this.builder = new ServiceStatusBuilder(this, item);
    }
    ServiceStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endServiceStatusObject() {
      return and();
    }
    
  }
  public class TaintObjectNested<N> extends TaintFluent<TaintObjectNested<N>> implements Nested<N>{
    TaintObjectNested(Taint item) {
      this.builder = new TaintBuilder(this, item);
    }
    TaintBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endTaintObject() {
      return and();
    }
    
  }
  public class PatchOptionsObjectNested<N> extends PatchOptionsFluent<PatchOptionsObjectNested<N>> implements Nested<N>{
    PatchOptionsObjectNested(PatchOptions item) {
      this.builder = new PatchOptionsBuilder(this, item);
    }
    PatchOptionsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPatchOptionsObject() {
      return and();
    }
    
  }
  public class ConfigMapNodeConfigSourceObjectNested<N> extends ConfigMapNodeConfigSourceFluent<ConfigMapNodeConfigSourceObjectNested<N>> implements Nested<N>{
    ConfigMapNodeConfigSourceObjectNested(ConfigMapNodeConfigSource item) {
      this.builder = new ConfigMapNodeConfigSourceBuilder(this, item);
    }
    ConfigMapNodeConfigSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endConfigMapNodeConfigSourceObject() {
      return and();
    }
    
  }
  public class HTTPGetActionObjectNested<N> extends HTTPGetActionFluent<HTTPGetActionObjectNested<N>> implements Nested<N>{
    HTTPGetActionObjectNested(HTTPGetAction item) {
      this.builder = new HTTPGetActionBuilder(this, item);
    }
    HTTPGetActionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endHTTPGetActionObject() {
      return and();
    }
    
  }
  public class GlusterfsPersistentVolumeSourceObjectNested<N> extends GlusterfsPersistentVolumeSourceFluent<GlusterfsPersistentVolumeSourceObjectNested<N>> implements Nested<N>{
    GlusterfsPersistentVolumeSourceObjectNested(GlusterfsPersistentVolumeSource item) {
      this.builder = new GlusterfsPersistentVolumeSourceBuilder(this, item);
    }
    GlusterfsPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGlusterfsPersistentVolumeSourceObject() {
      return and();
    }
    
  }
  public class DownwardAPIVolumeSourceObjectNested<N> extends DownwardAPIVolumeSourceFluent<DownwardAPIVolumeSourceObjectNested<N>> implements Nested<N>{
    DownwardAPIVolumeSourceObjectNested(DownwardAPIVolumeSource item) {
      this.builder = new DownwardAPIVolumeSourceBuilder(this, item);
    }
    DownwardAPIVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endDownwardAPIVolumeSourceObject() {
      return and();
    }
    
  }
  public class ISCSIPersistentVolumeSourceObjectNested<N> extends ISCSIPersistentVolumeSourceFluent<ISCSIPersistentVolumeSourceObjectNested<N>> implements Nested<N>{
    ISCSIPersistentVolumeSourceObjectNested(ISCSIPersistentVolumeSource item) {
      this.builder = new ISCSIPersistentVolumeSourceBuilder(this, item);
    }
    ISCSIPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endISCSIPersistentVolumeSourceObject() {
      return and();
    }
    
  }
  public class WindowsSecurityContextOptionsObjectNested<N> extends WindowsSecurityContextOptionsFluent<WindowsSecurityContextOptionsObjectNested<N>> implements Nested<N>{
    WindowsSecurityContextOptionsObjectNested(WindowsSecurityContextOptions item) {
      this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
    }
    WindowsSecurityContextOptionsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endWindowsSecurityContextOptionsObject() {
      return and();
    }
    
  }
  public class CreateOptionsObjectNested<N> extends CreateOptionsFluent<CreateOptionsObjectNested<N>> implements Nested<N>{
    CreateOptionsObjectNested(CreateOptions item) {
      this.builder = new CreateOptionsBuilder(this, item);
    }
    CreateOptionsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endCreateOptionsObject() {
      return and();
    }
    
  }
  public class EnvFromSourceObjectNested<N> extends EnvFromSourceFluent<EnvFromSourceObjectNested<N>> implements Nested<N>{
    EnvFromSourceObjectNested(EnvFromSource item) {
      this.builder = new EnvFromSourceBuilder(this, item);
    }
    EnvFromSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEnvFromSourceObject() {
      return and();
    }
    
  }
  public class NamespaceSpecObjectNested<N> extends NamespaceSpecFluent<NamespaceSpecObjectNested<N>> implements Nested<N>{
    NamespaceSpecObjectNested(NamespaceSpec item) {
      this.builder = new NamespaceSpecBuilder(this, item);
    }
    NamespaceSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNamespaceSpecObject() {
      return and();
    }
    
  }
  public class TypeMetaObjectNested<N> extends TypeMetaFluent<TypeMetaObjectNested<N>> implements Nested<N>{
    TypeMetaObjectNested(TypeMeta item) {
      this.builder = new TypeMetaBuilder(this, item);
    }
    TypeMetaBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endTypeMetaObject() {
      return and();
    }
    
  }
  public class RootPathsObjectNested<N> extends RootPathsFluent<RootPathsObjectNested<N>> implements Nested<N>{
    RootPathsObjectNested(RootPaths item) {
      this.builder = new RootPathsBuilder(this, item);
    }
    RootPathsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endRootPathsObject() {
      return and();
    }
    
  }
  public class ListMetaObjectNested<N> extends ListMetaFluent<ListMetaObjectNested<N>> implements Nested<N>{
    ListMetaObjectNested(ListMeta item) {
      this.builder = new ListMetaBuilder(this, item);
    }
    ListMetaBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endListMetaObject() {
      return and();
    }
    
  }
  public class SecretReferenceObjectNested<N> extends SecretReferenceFluent<SecretReferenceObjectNested<N>> implements Nested<N>{
    SecretReferenceObjectNested(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretReferenceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSecretReferenceObject() {
      return and();
    }
    
  }
  public class APIGroupObjectNested<N> extends APIGroupFluent<APIGroupObjectNested<N>> implements Nested<N>{
    APIGroupObjectNested(APIGroup item) {
      this.builder = new APIGroupBuilder(this, item);
    }
    APIGroupBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAPIGroupObject() {
      return and();
    }
    
  }
  public class FlexVolumeSourceObjectNested<N> extends FlexVolumeSourceFluent<FlexVolumeSourceObjectNested<N>> implements Nested<N>{
    FlexVolumeSourceObjectNested(FlexVolumeSource item) {
      this.builder = new FlexVolumeSourceBuilder(this, item);
    }
    FlexVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endFlexVolumeSourceObject() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimTemplateObjectNested<N> extends PersistentVolumeClaimTemplateFluent<PersistentVolumeClaimTemplateObjectNested<N>> implements Nested<N>{
    PersistentVolumeClaimTemplateObjectNested(PersistentVolumeClaimTemplate item) {
      this.builder = new PersistentVolumeClaimTemplateBuilder(this, item);
    }
    PersistentVolumeClaimTemplateBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeClaimTemplateObject() {
      return and();
    }
    
  }
  public class ISCSIVolumeSourceObjectNested<N> extends ISCSIVolumeSourceFluent<ISCSIVolumeSourceObjectNested<N>> implements Nested<N>{
    ISCSIVolumeSourceObjectNested(ISCSIVolumeSource item) {
      this.builder = new ISCSIVolumeSourceBuilder(this, item);
    }
    ISCSIVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endISCSIVolumeSourceObject() {
      return and();
    }
    
  }
  public class SecretKeySelectorObjectNested<N> extends SecretKeySelectorFluent<SecretKeySelectorObjectNested<N>> implements Nested<N>{
    SecretKeySelectorObjectNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSecretKeySelectorObject() {
      return and();
    }
    
  }
  public class RBDVolumeSourceObjectNested<N> extends RBDVolumeSourceFluent<RBDVolumeSourceObjectNested<N>> implements Nested<N>{
    RBDVolumeSourceObjectNested(RBDVolumeSource item) {
      this.builder = new RBDVolumeSourceBuilder(this, item);
    }
    RBDVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endRBDVolumeSourceObject() {
      return and();
    }
    
  }
  public class NodeConfigStatusObjectNested<N> extends NodeConfigStatusFluent<NodeConfigStatusObjectNested<N>> implements Nested<N>{
    NodeConfigStatusObjectNested(NodeConfigStatus item) {
      this.builder = new NodeConfigStatusBuilder(this, item);
    }
    NodeConfigStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeConfigStatusObject() {
      return and();
    }
    
  }
  public class ResourceQuotaListObjectNested<N> extends ResourceQuotaListFluent<ResourceQuotaListObjectNested<N>> implements Nested<N>{
    ResourceQuotaListObjectNested(ResourceQuotaList item) {
      this.builder = new ResourceQuotaListBuilder(this, item);
    }
    ResourceQuotaListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endResourceQuotaListObject() {
      return and();
    }
    
  }
  public class QuobyteVolumeSourceObjectNested<N> extends QuobyteVolumeSourceFluent<QuobyteVolumeSourceObjectNested<N>> implements Nested<N>{
    QuobyteVolumeSourceObjectNested(QuobyteVolumeSource item) {
      this.builder = new QuobyteVolumeSourceBuilder(this, item);
    }
    QuobyteVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endQuobyteVolumeSourceObject() {
      return and();
    }
    
  }
  public class APIResourceObjectNested<N> extends APIResourceFluent<APIResourceObjectNested<N>> implements Nested<N>{
    APIResourceObjectNested(APIResource item) {
      this.builder = new APIResourceBuilder(this, item);
    }
    APIResourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAPIResourceObject() {
      return and();
    }
    
  }
  public class ResourceQuotaStatusObjectNested<N> extends ResourceQuotaStatusFluent<ResourceQuotaStatusObjectNested<N>> implements Nested<N>{
    ResourceQuotaStatusObjectNested(ResourceQuotaStatus item) {
      this.builder = new ResourceQuotaStatusBuilder(this, item);
    }
    ResourceQuotaStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endResourceQuotaStatusObject() {
      return and();
    }
    
  }
  public class RawExtensionObjectNested<N> extends RawExtensionFluent<RawExtensionObjectNested<N>> implements Nested<N>{
    RawExtensionObjectNested(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endRawExtensionObject() {
      return and();
    }
    
  }
  public class ConfigMapProjectionObjectNested<N> extends ConfigMapProjectionFluent<ConfigMapProjectionObjectNested<N>> implements Nested<N>{
    ConfigMapProjectionObjectNested(ConfigMapProjection item) {
      this.builder = new ConfigMapProjectionBuilder(this, item);
    }
    ConfigMapProjectionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endConfigMapProjectionObject() {
      return and();
    }
    
  }
  public class ScopedResourceSelectorRequirementObjectNested<N> extends ScopedResourceSelectorRequirementFluent<ScopedResourceSelectorRequirementObjectNested<N>> implements Nested<N>{
    ScopedResourceSelectorRequirementObjectNested(ScopedResourceSelectorRequirement item) {
      this.builder = new ScopedResourceSelectorRequirementBuilder(this, item);
    }
    ScopedResourceSelectorRequirementBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endScopedResourceSelectorRequirementObject() {
      return and();
    }
    
  }
  public class NamespaceObjectNested<N> extends NamespaceFluent<NamespaceObjectNested<N>> implements Nested<N>{
    NamespaceObjectNested(Namespace item) {
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNamespaceObject() {
      return and();
    }
    
  }
  public class GroupVersionKindObjectNested<N> extends GroupVersionKindFluent<GroupVersionKindObjectNested<N>> implements Nested<N>{
    GroupVersionKindObjectNested(GroupVersionKind item) {
      this.builder = new GroupVersionKindBuilder(this, item);
    }
    GroupVersionKindBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGroupVersionKindObject() {
      return and();
    }
    
  }
  public class ContainerStateTerminatedObjectNested<N> extends ContainerStateTerminatedFluent<ContainerStateTerminatedObjectNested<N>> implements Nested<N>{
    ContainerStateTerminatedObjectNested(ContainerStateTerminated item) {
      this.builder = new ContainerStateTerminatedBuilder(this, item);
    }
    ContainerStateTerminatedBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endContainerStateTerminatedObject() {
      return and();
    }
    
  }
  public class LimitRangeSpecObjectNested<N> extends LimitRangeSpecFluent<LimitRangeSpecObjectNested<N>> implements Nested<N>{
    LimitRangeSpecObjectNested(LimitRangeSpec item) {
      this.builder = new LimitRangeSpecBuilder(this, item);
    }
    LimitRangeSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLimitRangeSpecObject() {
      return and();
    }
    
  }
  public class ProjectedVolumeSourceObjectNested<N> extends ProjectedVolumeSourceFluent<ProjectedVolumeSourceObjectNested<N>> implements Nested<N>{
    ProjectedVolumeSourceObjectNested(ProjectedVolumeSource item) {
      this.builder = new ProjectedVolumeSourceBuilder(this, item);
    }
    ProjectedVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endProjectedVolumeSourceObject() {
      return and();
    }
    
  }
  public class PodOSObjectNested<N> extends PodOSFluent<PodOSObjectNested<N>> implements Nested<N>{
    PodOSObjectNested(PodOS item) {
      this.builder = new PodOSBuilder(this, item);
    }
    PodOSBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodOSObject() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimStatusObjectNested<N> extends PersistentVolumeClaimStatusFluent<PersistentVolumeClaimStatusObjectNested<N>> implements Nested<N>{
    PersistentVolumeClaimStatusObjectNested(PersistentVolumeClaimStatus item) {
      this.builder = new PersistentVolumeClaimStatusBuilder(this, item);
    }
    PersistentVolumeClaimStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeClaimStatusObject() {
      return and();
    }
    
  }
  public class ContainerStateObjectNested<N> extends ContainerStateFluent<ContainerStateObjectNested<N>> implements Nested<N>{
    ContainerStateObjectNested(ContainerState item) {
      this.builder = new ContainerStateBuilder(this, item);
    }
    ContainerStateBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endContainerStateObject() {
      return and();
    }
    
  }
  public class ServiceSpecObjectNested<N> extends ServiceSpecFluent<ServiceSpecObjectNested<N>> implements Nested<N>{
    ServiceSpecObjectNested(ServiceSpec item) {
      this.builder = new ServiceSpecBuilder(this, item);
    }
    ServiceSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endServiceSpecObject() {
      return and();
    }
    
  }
  public class ServiceAccountTokenProjectionObjectNested<N> extends ServiceAccountTokenProjectionFluent<ServiceAccountTokenProjectionObjectNested<N>> implements Nested<N>{
    ServiceAccountTokenProjectionObjectNested(ServiceAccountTokenProjection item) {
      this.builder = new ServiceAccountTokenProjectionBuilder(this, item);
    }
    ServiceAccountTokenProjectionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endServiceAccountTokenProjectionObject() {
      return and();
    }
    
  }
  public class PhotonPersistentDiskVolumeSourceObjectNested<N> extends PhotonPersistentDiskVolumeSourceFluent<PhotonPersistentDiskVolumeSourceObjectNested<N>> implements Nested<N>{
    PhotonPersistentDiskVolumeSourceObjectNested(PhotonPersistentDiskVolumeSource item) {
      this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this, item);
    }
    PhotonPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPhotonPersistentDiskVolumeSourceObject() {
      return and();
    }
    
  }
  public class ContainerObjectNested<N> extends ContainerFluent<ContainerObjectNested<N>> implements Nested<N>{
    ContainerObjectNested(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endContainerObject() {
      return and();
    }
    
  }
  public class NodeSpecObjectNested<N> extends NodeSpecFluent<NodeSpecObjectNested<N>> implements Nested<N>{
    NodeSpecObjectNested(NodeSpec item) {
      this.builder = new NodeSpecBuilder(this, item);
    }
    NodeSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeSpecObject() {
      return and();
    }
    
  }
  public class TypedLocalObjectReferenceNested<N> extends TypedLocalObjectReferenceFluent<TypedLocalObjectReferenceNested<N>> implements Nested<N>{
    TypedLocalObjectReferenceNested(TypedLocalObjectReference item) {
      this.builder = new TypedLocalObjectReferenceBuilder(this, item);
    }
    TypedLocalObjectReferenceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endTypedLocalObjectReference() {
      return and();
    }
    
  }
  public class FieldsV1ObjectNested<N> extends FieldsV1Fluent<FieldsV1ObjectNested<N>> implements Nested<N>{
    FieldsV1ObjectNested(FieldsV1 item) {
      this.builder = new FieldsV1Builder(this, item);
    }
    FieldsV1Builder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endFieldsV1Object() {
      return and();
    }
    
  }
  public class SecretListObjectNested<N> extends SecretListFluent<SecretListObjectNested<N>> implements Nested<N>{
    SecretListObjectNested(SecretList item) {
      this.builder = new SecretListBuilder(this, item);
    }
    SecretListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSecretListObject() {
      return and();
    }
    
  }
  public class NodeAddressObjectNested<N> extends NodeAddressFluent<NodeAddressObjectNested<N>> implements Nested<N>{
    NodeAddressObjectNested(NodeAddress item) {
      this.builder = new NodeAddressBuilder(this, item);
    }
    NodeAddressBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeAddressObject() {
      return and();
    }
    
  }
  public class PodAffinityObjectNested<N> extends PodAffinityFluent<PodAffinityObjectNested<N>> implements Nested<N>{
    PodAffinityObjectNested(PodAffinity item) {
      this.builder = new PodAffinityBuilder(this, item);
    }
    PodAffinityBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodAffinityObject() {
      return and();
    }
    
  }
  public class ExecEnvVarObjectNested<N> extends ExecEnvVarFluent<ExecEnvVarObjectNested<N>> implements Nested<N>{
    ExecEnvVarObjectNested(ExecEnvVar item) {
      this.builder = new ExecEnvVarBuilder(this, item);
    }
    ExecEnvVarBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endExecEnvVarObject() {
      return and();
    }
    
  }
  public class ServiceObjectNested<N> extends ServiceFluent<ServiceObjectNested<N>> implements Nested<N>{
    ServiceObjectNested(Service item) {
      this.builder = new ServiceBuilder(this, item);
    }
    ServiceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endServiceObject() {
      return and();
    }
    
  }
  public class EventSeriesObjectNested<N> extends EventSeriesFluent<EventSeriesObjectNested<N>> implements Nested<N>{
    EventSeriesObjectNested(EventSeries item) {
      this.builder = new EventSeriesBuilder(this, item);
    }
    EventSeriesBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEventSeriesObject() {
      return and();
    }
    
  }
  public class PodConditionObjectNested<N> extends PodConditionFluent<PodConditionObjectNested<N>> implements Nested<N>{
    PodConditionObjectNested(PodCondition item) {
      this.builder = new PodConditionBuilder(this, item);
    }
    PodConditionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodConditionObject() {
      return and();
    }
    
  }
  public class TopologySpreadConstraintObjectNested<N> extends TopologySpreadConstraintFluent<TopologySpreadConstraintObjectNested<N>> implements Nested<N>{
    TopologySpreadConstraintObjectNested(TopologySpreadConstraint item) {
      this.builder = new TopologySpreadConstraintBuilder(this, item);
    }
    TopologySpreadConstraintBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endTopologySpreadConstraintObject() {
      return and();
    }
    
  }
  public class ExecActionObjectNested<N> extends ExecActionFluent<ExecActionObjectNested<N>> implements Nested<N>{
    ExecActionObjectNested(ExecAction item) {
      this.builder = new ExecActionBuilder(this, item);
    }
    ExecActionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endExecActionObject() {
      return and();
    }
    
  }
  public class ContainerImageObjectNested<N> extends ContainerImageFluent<ContainerImageObjectNested<N>> implements Nested<N>{
    ContainerImageObjectNested(ContainerImage item) {
      this.builder = new ContainerImageBuilder(this, item);
    }
    ContainerImageBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endContainerImageObject() {
      return and();
    }
    
  }
  public class GroupKindObjectNested<N> extends GroupKindFluent<GroupKindObjectNested<N>> implements Nested<N>{
    GroupKindObjectNested(GroupKind item) {
      this.builder = new GroupKindBuilder(this, item);
    }
    GroupKindBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGroupKindObject() {
      return and();
    }
    
  }
  public class ReplicationControllerObjectNested<N> extends ReplicationControllerFluent<ReplicationControllerObjectNested<N>> implements Nested<N>{
    ReplicationControllerObjectNested(ReplicationController item) {
      this.builder = new ReplicationControllerBuilder(this, item);
    }
    ReplicationControllerBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endReplicationControllerObject() {
      return and();
    }
    
  }
  public class NodeStatusObjectNested<N> extends NodeStatusFluent<NodeStatusObjectNested<N>> implements Nested<N>{
    NodeStatusObjectNested(NodeStatus item) {
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeStatusObject() {
      return and();
    }
    
  }
  public class ConfigMapListObjectNested<N> extends ConfigMapListFluent<ConfigMapListObjectNested<N>> implements Nested<N>{
    ConfigMapListObjectNested(ConfigMapList item) {
      this.builder = new ConfigMapListBuilder(this, item);
    }
    ConfigMapListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endConfigMapListObject() {
      return and();
    }
    
  }
  public class NodeSelectorObjectNested<N> extends NodeSelectorFluent<NodeSelectorObjectNested<N>> implements Nested<N>{
    NodeSelectorObjectNested(NodeSelector item) {
      this.builder = new NodeSelectorBuilder(this, item);
    }
    NodeSelectorBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeSelectorObject() {
      return and();
    }
    
  }
  public class TolerationObjectNested<N> extends TolerationFluent<TolerationObjectNested<N>> implements Nested<N>{
    TolerationObjectNested(Toleration item) {
      this.builder = new TolerationBuilder(this, item);
    }
    TolerationBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endTolerationObject() {
      return and();
    }
    
  }
  public class CephFSPersistentVolumeSourceObjectNested<N> extends CephFSPersistentVolumeSourceFluent<CephFSPersistentVolumeSourceObjectNested<N>> implements Nested<N>{
    CephFSPersistentVolumeSourceObjectNested(CephFSPersistentVolumeSource item) {
      this.builder = new CephFSPersistentVolumeSourceBuilder(this, item);
    }
    CephFSPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endCephFSPersistentVolumeSourceObject() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimConditionObjectNested<N> extends PersistentVolumeClaimConditionFluent<PersistentVolumeClaimConditionObjectNested<N>> implements Nested<N>{
    PersistentVolumeClaimConditionObjectNested(PersistentVolumeClaimCondition item) {
      this.builder = new PersistentVolumeClaimConditionBuilder(this, item);
    }
    PersistentVolumeClaimConditionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeClaimConditionObject() {
      return and();
    }
    
  }
  public class PreferredSchedulingTermObjectNested<N> extends PreferredSchedulingTermFluent<PreferredSchedulingTermObjectNested<N>> implements Nested<N>{
    PreferredSchedulingTermObjectNested(PreferredSchedulingTerm item) {
      this.builder = new PreferredSchedulingTermBuilder(this, item);
    }
    PreferredSchedulingTermBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPreferredSchedulingTermObject() {
      return and();
    }
    
  }
  public class PersistentVolumeListObjectNested<N> extends PersistentVolumeListFluent<PersistentVolumeListObjectNested<N>> implements Nested<N>{
    PersistentVolumeListObjectNested(PersistentVolumeList item) {
      this.builder = new PersistentVolumeListBuilder(this, item);
    }
    PersistentVolumeListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeListObject() {
      return and();
    }
    
  }
  public class PodSchedulingGateObjectNested<N> extends PodSchedulingGateFluent<PodSchedulingGateObjectNested<N>> implements Nested<N>{
    PodSchedulingGateObjectNested(PodSchedulingGate item) {
      this.builder = new PodSchedulingGateBuilder(this, item);
    }
    PodSchedulingGateBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodSchedulingGateObject() {
      return and();
    }
    
  }
  public class PodDNSConfigOptionObjectNested<N> extends PodDNSConfigOptionFluent<PodDNSConfigOptionObjectNested<N>> implements Nested<N>{
    PodDNSConfigOptionObjectNested(PodDNSConfigOption item) {
      this.builder = new PodDNSConfigOptionBuilder(this, item);
    }
    PodDNSConfigOptionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodDNSConfigOptionObject() {
      return and();
    }
    
  }
  public class GCEPersistentDiskVolumeSourceObjectNested<N> extends GCEPersistentDiskVolumeSourceFluent<GCEPersistentDiskVolumeSourceObjectNested<N>> implements Nested<N>{
    GCEPersistentDiskVolumeSourceObjectNested(GCEPersistentDiskVolumeSource item) {
      this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
    }
    GCEPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGCEPersistentDiskVolumeSourceObject() {
      return and();
    }
    
  }
  public class APIServiceConditionObjectNested<N> extends APIServiceConditionFluent<APIServiceConditionObjectNested<N>> implements Nested<N>{
    APIServiceConditionObjectNested(APIServiceCondition item) {
      this.builder = new APIServiceConditionBuilder(this, item);
    }
    APIServiceConditionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAPIServiceConditionObject() {
      return and();
    }
    
  }
  public class EventListObjectNested<N> extends EventListFluent<EventListObjectNested<N>> implements Nested<N>{
    EventListObjectNested(EventList item) {
      this.builder = new EventListBuilder(this, item);
    }
    EventListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEventListObject() {
      return and();
    }
    
  }
  public class PodReadinessGateObjectNested<N> extends PodReadinessGateFluent<PodReadinessGateObjectNested<N>> implements Nested<N>{
    PodReadinessGateObjectNested(PodReadinessGate item) {
      this.builder = new PodReadinessGateBuilder(this, item);
    }
    PodReadinessGateBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodReadinessGateObject() {
      return and();
    }
    
  }
  public class ContainerStateWaitingObjectNested<N> extends ContainerStateWaitingFluent<ContainerStateWaitingObjectNested<N>> implements Nested<N>{
    ContainerStateWaitingObjectNested(ContainerStateWaiting item) {
      this.builder = new ContainerStateWaitingBuilder(this, item);
    }
    ContainerStateWaitingBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endContainerStateWaitingObject() {
      return and();
    }
    
  }
  public class VolumeMountObjectNested<N> extends VolumeMountFluent<VolumeMountObjectNested<N>> implements Nested<N>{
    VolumeMountObjectNested(VolumeMount item) {
      this.builder = new VolumeMountBuilder(this, item);
    }
    VolumeMountBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endVolumeMountObject() {
      return and();
    }
    
  }
  public class NamespaceConditionObjectNested<N> extends NamespaceConditionFluent<NamespaceConditionObjectNested<N>> implements Nested<N>{
    NamespaceConditionObjectNested(NamespaceCondition item) {
      this.builder = new NamespaceConditionBuilder(this, item);
    }
    NamespaceConditionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNamespaceConditionObject() {
      return and();
    }
    
  }
  public class LabelSelectorObjectNested<N> extends LabelSelectorFluent<LabelSelectorObjectNested<N>> implements Nested<N>{
    LabelSelectorObjectNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLabelSelectorObject() {
      return and();
    }
    
  }
  public class StatusCauseObjectNested<N> extends StatusCauseFluent<StatusCauseObjectNested<N>> implements Nested<N>{
    StatusCauseObjectNested(StatusCause item) {
      this.builder = new StatusCauseBuilder(this, item);
    }
    StatusCauseBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endStatusCauseObject() {
      return and();
    }
    
  }
  public class NamedClusterObjectNested<N> extends NamedClusterFluent<NamedClusterObjectNested<N>> implements Nested<N>{
    NamedClusterObjectNested(NamedCluster item) {
      this.builder = new NamedClusterBuilder(this, item);
    }
    NamedClusterBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNamedClusterObject() {
      return and();
    }
    
  }
  public class StatusDetailsObjectNested<N> extends StatusDetailsFluent<StatusDetailsObjectNested<N>> implements Nested<N>{
    StatusDetailsObjectNested(StatusDetails item) {
      this.builder = new StatusDetailsBuilder(this, item);
    }
    StatusDetailsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endStatusDetailsObject() {
      return and();
    }
    
  }
  public class DownwardAPIVolumeFileObjectNested<N> extends DownwardAPIVolumeFileFluent<DownwardAPIVolumeFileObjectNested<N>> implements Nested<N>{
    DownwardAPIVolumeFileObjectNested(DownwardAPIVolumeFile item) {
      this.builder = new DownwardAPIVolumeFileBuilder(this, item);
    }
    DownwardAPIVolumeFileBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endDownwardAPIVolumeFileObject() {
      return and();
    }
    
  }
  public class SeccompProfileObjectNested<N> extends SeccompProfileFluent<SeccompProfileObjectNested<N>> implements Nested<N>{
    SeccompProfileObjectNested(SeccompProfile item) {
      this.builder = new SeccompProfileBuilder(this, item);
    }
    SeccompProfileBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSeccompProfileObject() {
      return and();
    }
    
  }
  public class SysctlObjectNested<N> extends SysctlFluent<SysctlObjectNested<N>> implements Nested<N>{
    SysctlObjectNested(Sysctl item) {
      this.builder = new SysctlBuilder(this, item);
    }
    SysctlBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSysctlObject() {
      return and();
    }
    
  }
  public class DeleteOptionsObjectNested<N> extends DeleteOptionsFluent<DeleteOptionsObjectNested<N>> implements Nested<N>{
    DeleteOptionsObjectNested(DeleteOptions item) {
      this.builder = new DeleteOptionsBuilder(this, item);
    }
    DeleteOptionsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endDeleteOptionsObject() {
      return and();
    }
    
  }
  public class StatusObjectNested<N> extends StatusFluent<StatusObjectNested<N>> implements Nested<N>{
    StatusObjectNested(Status item) {
      this.builder = new StatusBuilder(this, item);
    }
    StatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endStatusObject() {
      return and();
    }
    
  }
  public class ContainerStatusObjectNested<N> extends ContainerStatusFluent<ContainerStatusObjectNested<N>> implements Nested<N>{
    ContainerStatusObjectNested(ContainerStatus item) {
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endContainerStatusObject() {
      return and();
    }
    
  }
  public class PodTemplateObjectNested<N> extends PodTemplateFluent<PodTemplateObjectNested<N>> implements Nested<N>{
    PodTemplateObjectNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodTemplateObject() {
      return and();
    }
    
  }
  public class ConfigMapEnvSourceObjectNested<N> extends ConfigMapEnvSourceFluent<ConfigMapEnvSourceObjectNested<N>> implements Nested<N>{
    ConfigMapEnvSourceObjectNested(ConfigMapEnvSource item) {
      this.builder = new ConfigMapEnvSourceBuilder(this, item);
    }
    ConfigMapEnvSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endConfigMapEnvSourceObject() {
      return and();
    }
    
  }
  public class NodeSelectorRequirementObjectNested<N> extends NodeSelectorRequirementFluent<NodeSelectorRequirementObjectNested<N>> implements Nested<N>{
    NodeSelectorRequirementObjectNested(NodeSelectorRequirement item) {
      this.builder = new NodeSelectorRequirementBuilder(this, item);
    }
    NodeSelectorRequirementBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeSelectorRequirementObject() {
      return and();
    }
    
  }
  public class TCPSocketActionObjectNested<N> extends TCPSocketActionFluent<TCPSocketActionObjectNested<N>> implements Nested<N>{
    TCPSocketActionObjectNested(TCPSocketAction item) {
      this.builder = new TCPSocketActionBuilder(this, item);
    }
    TCPSocketActionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endTCPSocketActionObject() {
      return and();
    }
    
  }
  public class EventObjectNested<N> extends EventFluent<EventObjectNested<N>> implements Nested<N>{
    EventObjectNested(Event item) {
      this.builder = new EventBuilder(this, item);
    }
    EventBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEventObject() {
      return and();
    }
    
  }
  public class PreferencesObjectNested<N> extends PreferencesFluent<PreferencesObjectNested<N>> implements Nested<N>{
    PreferencesObjectNested(Preferences item) {
      this.builder = new PreferencesBuilder(this, item);
    }
    PreferencesBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPreferencesObject() {
      return and();
    }
    
  }
  public class ObjectFieldSelectorObjectNested<N> extends ObjectFieldSelectorFluent<ObjectFieldSelectorObjectNested<N>> implements Nested<N>{
    ObjectFieldSelectorObjectNested(ObjectFieldSelector item) {
      this.builder = new ObjectFieldSelectorBuilder(this, item);
    }
    ObjectFieldSelectorBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endObjectFieldSelectorObject() {
      return and();
    }
    
  }
  public class PodTemplateListObjectNested<N> extends PodTemplateListFluent<PodTemplateListObjectNested<N>> implements Nested<N>{
    PodTemplateListObjectNested(PodTemplateList item) {
      this.builder = new PodTemplateListBuilder(this, item);
    }
    PodTemplateListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodTemplateListObject() {
      return and();
    }
    
  }
  public class PersistentVolumeObjectNested<N> extends PersistentVolumeFluent<PersistentVolumeObjectNested<N>> implements Nested<N>{
    PersistentVolumeObjectNested(PersistentVolume item) {
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeObject() {
      return and();
    }
    
  }
  public class CinderVolumeSourceObjectNested<N> extends CinderVolumeSourceFluent<CinderVolumeSourceObjectNested<N>> implements Nested<N>{
    CinderVolumeSourceObjectNested(CinderVolumeSource item) {
      this.builder = new CinderVolumeSourceBuilder(this, item);
    }
    CinderVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endCinderVolumeSourceObject() {
      return and();
    }
    
  }
  public class EndpointAddressObjectNested<N> extends EndpointAddressFluent<EndpointAddressObjectNested<N>> implements Nested<N>{
    EndpointAddressObjectNested(EndpointAddress item) {
      this.builder = new EndpointAddressBuilder(this, item);
    }
    EndpointAddressBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEndpointAddressObject() {
      return and();
    }
    
  }
  public class NodeConfigSourceObjectNested<N> extends NodeConfigSourceFluent<NodeConfigSourceObjectNested<N>> implements Nested<N>{
    NodeConfigSourceObjectNested(NodeConfigSource item) {
      this.builder = new NodeConfigSourceBuilder(this, item);
    }
    NodeConfigSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeConfigSourceObject() {
      return and();
    }
    
  }
  public class VsphereVirtualDiskVolumeSourceObjectNested<N> extends VsphereVirtualDiskVolumeSourceFluent<VsphereVirtualDiskVolumeSourceObjectNested<N>> implements Nested<N>{
    VsphereVirtualDiskVolumeSourceObjectNested(VsphereVirtualDiskVolumeSource item) {
      this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
    }
    VsphereVirtualDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endVsphereVirtualDiskVolumeSourceObject() {
      return and();
    }
    
  }
  public class ObjectMetaObjectNested<N> extends ObjectMetaFluent<ObjectMetaObjectNested<N>> implements Nested<N>{
    ObjectMetaObjectNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endObjectMetaObject() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimObjectNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimObjectNested<N>> implements Nested<N>{
    PersistentVolumeClaimObjectNested(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeClaimObject() {
      return and();
    }
    
  }
  public class LabelSelectorRequirementObjectNested<N> extends LabelSelectorRequirementFluent<LabelSelectorRequirementObjectNested<N>> implements Nested<N>{
    LabelSelectorRequirementObjectNested(LabelSelectorRequirement item) {
      this.builder = new LabelSelectorRequirementBuilder(this, item);
    }
    LabelSelectorRequirementBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLabelSelectorRequirementObject() {
      return and();
    }
    
  }
  public class GitRepoVolumeSourceObjectNested<N> extends GitRepoVolumeSourceFluent<GitRepoVolumeSourceObjectNested<N>> implements Nested<N>{
    GitRepoVolumeSourceObjectNested(GitRepoVolumeSource item) {
      this.builder = new GitRepoVolumeSourceBuilder(this, item);
    }
    GitRepoVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGitRepoVolumeSourceObject() {
      return and();
    }
    
  }
  public class GenericKubernetesResourceObjectNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceObjectNested<N>> implements Nested<N>{
    GenericKubernetesResourceObjectNested(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGenericKubernetesResourceObject() {
      return and();
    }
    
  }
  public class EndpointsListObjectNested<N> extends EndpointsListFluent<EndpointsListObjectNested<N>> implements Nested<N>{
    EndpointsListObjectNested(EndpointsList item) {
      this.builder = new EndpointsListBuilder(this, item);
    }
    EndpointsListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEndpointsListObject() {
      return and();
    }
    
  }
  public class GroupVersionResourceObjectNested<N> extends GroupVersionResourceFluent<GroupVersionResourceObjectNested<N>> implements Nested<N>{
    GroupVersionResourceObjectNested(GroupVersionResource item) {
      this.builder = new GroupVersionResourceBuilder(this, item);
    }
    GroupVersionResourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGroupVersionResourceObject() {
      return and();
    }
    
  }
  public class CinderPersistentVolumeSourceObjectNested<N> extends CinderPersistentVolumeSourceFluent<CinderPersistentVolumeSourceObjectNested<N>> implements Nested<N>{
    CinderPersistentVolumeSourceObjectNested(CinderPersistentVolumeSource item) {
      this.builder = new CinderPersistentVolumeSourceBuilder(this, item);
    }
    CinderPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endCinderPersistentVolumeSourceObject() {
      return and();
    }
    
  }
  public class TopologySelectorTermObjectNested<N> extends TopologySelectorTermFluent<TopologySelectorTermObjectNested<N>> implements Nested<N>{
    TopologySelectorTermObjectNested(TopologySelectorTerm item) {
      this.builder = new TopologySelectorTermBuilder(this, item);
    }
    TopologySelectorTermBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endTopologySelectorTermObject() {
      return and();
    }
    
  }
  public class OwnerReferenceObjectNested<N> extends OwnerReferenceFluent<OwnerReferenceObjectNested<N>> implements Nested<N>{
    OwnerReferenceObjectNested(OwnerReference item) {
      this.builder = new OwnerReferenceBuilder(this, item);
    }
    OwnerReferenceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endOwnerReferenceObject() {
      return and();
    }
    
  }
  public class StorageOSPersistentVolumeSourceObjectNested<N> extends StorageOSPersistentVolumeSourceFluent<StorageOSPersistentVolumeSourceObjectNested<N>> implements Nested<N>{
    StorageOSPersistentVolumeSourceObjectNested(StorageOSPersistentVolumeSource item) {
      this.builder = new StorageOSPersistentVolumeSourceBuilder(this, item);
    }
    StorageOSPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endStorageOSPersistentVolumeSourceObject() {
      return and();
    }
    
  }
  public class EphemeralVolumeSourceObjectNested<N> extends EphemeralVolumeSourceFluent<EphemeralVolumeSourceObjectNested<N>> implements Nested<N>{
    EphemeralVolumeSourceObjectNested(EphemeralVolumeSource item) {
      this.builder = new EphemeralVolumeSourceBuilder(this, item);
    }
    EphemeralVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEphemeralVolumeSourceObject() {
      return and();
    }
    
  }
  public class ReplicationControllerConditionObjectNested<N> extends ReplicationControllerConditionFluent<ReplicationControllerConditionObjectNested<N>> implements Nested<N>{
    ReplicationControllerConditionObjectNested(ReplicationControllerCondition item) {
      this.builder = new ReplicationControllerConditionBuilder(this, item);
    }
    ReplicationControllerConditionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endReplicationControllerConditionObject() {
      return and();
    }
    
  }
  public class PodAntiAffinityObjectNested<N> extends PodAntiAffinityFluent<PodAntiAffinityObjectNested<N>> implements Nested<N>{
    PodAntiAffinityObjectNested(PodAntiAffinity item) {
      this.builder = new PodAntiAffinityBuilder(this, item);
    }
    PodAntiAffinityBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodAntiAffinityObject() {
      return and();
    }
    
  }
  public class SecurityContextObjectNested<N> extends SecurityContextFluent<SecurityContextObjectNested<N>> implements Nested<N>{
    SecurityContextObjectNested(SecurityContext item) {
      this.builder = new SecurityContextBuilder(this, item);
    }
    SecurityContextBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSecurityContextObject() {
      return and();
    }
    
  }
  public class ReplicationControllerListObjectNested<N> extends ReplicationControllerListFluent<ReplicationControllerListObjectNested<N>> implements Nested<N>{
    ReplicationControllerListObjectNested(ReplicationControllerList item) {
      this.builder = new ReplicationControllerListBuilder(this, item);
    }
    ReplicationControllerListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endReplicationControllerListObject() {
      return and();
    }
    
  }
  public class ConfigMapVolumeSourceObjectNested<N> extends ConfigMapVolumeSourceFluent<ConfigMapVolumeSourceObjectNested<N>> implements Nested<N>{
    ConfigMapVolumeSourceObjectNested(ConfigMapVolumeSource item) {
      this.builder = new ConfigMapVolumeSourceBuilder(this, item);
    }
    ConfigMapVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endConfigMapVolumeSourceObject() {
      return and();
    }
    
  }
  public class ContainerStateRunningObjectNested<N> extends ContainerStateRunningFluent<ContainerStateRunningObjectNested<N>> implements Nested<N>{
    ContainerStateRunningObjectNested(ContainerStateRunning item) {
      this.builder = new ContainerStateRunningBuilder(this, item);
    }
    ContainerStateRunningBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endContainerStateRunningObject() {
      return and();
    }
    
  }
  public class ComponentStatusListObjectNested<N> extends ComponentStatusListFluent<ComponentStatusListObjectNested<N>> implements Nested<N>{
    ComponentStatusListObjectNested(ComponentStatusList item) {
      this.builder = new ComponentStatusListBuilder(this, item);
    }
    ComponentStatusListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endComponentStatusListObject() {
      return and();
    }
    
  }
  public class FlockerVolumeSourceObjectNested<N> extends FlockerVolumeSourceFluent<FlockerVolumeSourceObjectNested<N>> implements Nested<N>{
    FlockerVolumeSourceObjectNested(FlockerVolumeSource item) {
      this.builder = new FlockerVolumeSourceBuilder(this, item);
    }
    FlockerVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endFlockerVolumeSourceObject() {
      return and();
    }
    
  }
  public class ScaleIOVolumeSourceObjectNested<N> extends ScaleIOVolumeSourceFluent<ScaleIOVolumeSourceObjectNested<N>> implements Nested<N>{
    ScaleIOVolumeSourceObjectNested(ScaleIOVolumeSource item) {
      this.builder = new ScaleIOVolumeSourceBuilder(this, item);
    }
    ScaleIOVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endScaleIOVolumeSourceObject() {
      return and();
    }
    
  }
  public class LimitRangeListObjectNested<N> extends LimitRangeListFluent<LimitRangeListObjectNested<N>> implements Nested<N>{
    LimitRangeListObjectNested(LimitRangeList item) {
      this.builder = new LimitRangeListBuilder(this, item);
    }
    LimitRangeListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLimitRangeListObject() {
      return and();
    }
    
  }
  public class PodExecOptionsObjectNested<N> extends PodExecOptionsFluent<PodExecOptionsObjectNested<N>> implements Nested<N>{
    PodExecOptionsObjectNested(PodExecOptions item) {
      this.builder = new PodExecOptionsBuilder(this, item);
    }
    PodExecOptionsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodExecOptionsObject() {
      return and();
    }
    
  }
  public class ProbeObjectNested<N> extends ProbeFluent<ProbeObjectNested<N>> implements Nested<N>{
    ProbeObjectNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endProbeObject() {
      return and();
    }
    
  }
  public class UpdateOptionsObjectNested<N> extends UpdateOptionsFluent<UpdateOptionsObjectNested<N>> implements Nested<N>{
    UpdateOptionsObjectNested(UpdateOptions item) {
      this.builder = new UpdateOptionsBuilder(this, item);
    }
    UpdateOptionsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endUpdateOptionsObject() {
      return and();
    }
    
  }
  public class EndpointsObjectNested<N> extends EndpointsFluent<EndpointsObjectNested<N>> implements Nested<N>{
    EndpointsObjectNested(Endpoints item) {
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEndpointsObject() {
      return and();
    }
    
  }
  public class NamedExtensionObjectNested<N> extends NamedExtensionFluent<NamedExtensionObjectNested<N>> implements Nested<N>{
    NamedExtensionObjectNested(NamedExtension item) {
      this.builder = new NamedExtensionBuilder(this, item);
    }
    NamedExtensionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNamedExtensionObject() {
      return and();
    }
    
  }
  public class AzureFilePersistentVolumeSourceObjectNested<N> extends AzureFilePersistentVolumeSourceFluent<AzureFilePersistentVolumeSourceObjectNested<N>> implements Nested<N>{
    AzureFilePersistentVolumeSourceObjectNested(AzureFilePersistentVolumeSource item) {
      this.builder = new AzureFilePersistentVolumeSourceBuilder(this, item);
    }
    AzureFilePersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAzureFilePersistentVolumeSourceObject() {
      return and();
    }
    
  }
  public class APIResourceListObjectNested<N> extends APIResourceListFluent<APIResourceListObjectNested<N>> implements Nested<N>{
    APIResourceListObjectNested(APIResourceList item) {
      this.builder = new APIResourceListBuilder(this, item);
    }
    APIResourceListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAPIResourceListObject() {
      return and();
    }
    
  }
  public class APIServiceListObjectNested<N> extends APIServiceListFluent<APIServiceListObjectNested<N>> implements Nested<N>{
    APIServiceListObjectNested(APIServiceList item) {
      this.builder = new APIServiceListBuilder(this, item);
    }
    APIServiceListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAPIServiceListObject() {
      return and();
    }
    
  }
  public class SecretVolumeSourceObjectNested<N> extends SecretVolumeSourceFluent<SecretVolumeSourceObjectNested<N>> implements Nested<N>{
    SecretVolumeSourceObjectNested(SecretVolumeSource item) {
      this.builder = new SecretVolumeSourceBuilder(this, item);
    }
    SecretVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSecretVolumeSourceObject() {
      return and();
    }
    
  }
  public class PodObjectNested<N> extends PodFluent<PodObjectNested<N>> implements Nested<N>{
    PodObjectNested(Pod item) {
      this.builder = new PodBuilder(this, item);
    }
    PodBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodObject() {
      return and();
    }
    
  }
  public class ClientIPConfigObjectNested<N> extends ClientIPConfigFluent<ClientIPConfigObjectNested<N>> implements Nested<N>{
    ClientIPConfigObjectNested(ClientIPConfig item) {
      this.builder = new ClientIPConfigBuilder(this, item);
    }
    ClientIPConfigBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endClientIPConfigObject() {
      return and();
    }
    
  }
  public class ContextObjectNested<N> extends ContextFluent<ContextObjectNested<N>> implements Nested<N>{
    ContextObjectNested(Context item) {
      this.builder = new ContextBuilder(this, item);
    }
    ContextBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endContextObject() {
      return and();
    }
    
  }
  public class NodeAffinityObjectNested<N> extends NodeAffinityFluent<NodeAffinityObjectNested<N>> implements Nested<N>{
    NodeAffinityObjectNested(NodeAffinity item) {
      this.builder = new NodeAffinityBuilder(this, item);
    }
    NodeAffinityBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeAffinityObject() {
      return and();
    }
    
  }
  public class ConfigMapObjectNested<N> extends ConfigMapFluent<ConfigMapObjectNested<N>> implements Nested<N>{
    ConfigMapObjectNested(ConfigMap item) {
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endConfigMapObject() {
      return and();
    }
    
  }
  public class ContainerPortObjectNested<N> extends ContainerPortFluent<ContainerPortObjectNested<N>> implements Nested<N>{
    ContainerPortObjectNested(ContainerPort item) {
      this.builder = new ContainerPortBuilder(this, item);
    }
    ContainerPortBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endContainerPortObject() {
      return and();
    }
    
  }
  public class ConditionObjectNested<N> extends ConditionFluent<ConditionObjectNested<N>> implements Nested<N>{
    ConditionObjectNested(Condition item) {
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endConditionObject() {
      return and();
    }
    
  }
  public class PodListObjectNested<N> extends PodListFluent<PodListObjectNested<N>> implements Nested<N>{
    PodListObjectNested(PodList item) {
      this.builder = new PodListBuilder(this, item);
    }
    PodListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodListObject() {
      return and();
    }
    
  }
  public class FCVolumeSourceObjectNested<N> extends FCVolumeSourceFluent<FCVolumeSourceObjectNested<N>> implements Nested<N>{
    FCVolumeSourceObjectNested(FCVolumeSource item) {
      this.builder = new FCVolumeSourceBuilder(this, item);
    }
    FCVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endFCVolumeSourceObject() {
      return and();
    }
    
  }
  public class ResourceFieldSelectorObjectNested<N> extends ResourceFieldSelectorFluent<ResourceFieldSelectorObjectNested<N>> implements Nested<N>{
    ResourceFieldSelectorObjectNested(ResourceFieldSelector item) {
      this.builder = new ResourceFieldSelectorBuilder(this, item);
    }
    ResourceFieldSelectorBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endResourceFieldSelectorObject() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimSpecObjectNested<N> extends PersistentVolumeClaimSpecFluent<PersistentVolumeClaimSpecObjectNested<N>> implements Nested<N>{
    PersistentVolumeClaimSpecObjectNested(PersistentVolumeClaimSpec item) {
      this.builder = new PersistentVolumeClaimSpecBuilder(this, item);
    }
    PersistentVolumeClaimSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeClaimSpecObject() {
      return and();
    }
    
  }
  public class LoadBalancerStatusObjectNested<N> extends LoadBalancerStatusFluent<LoadBalancerStatusObjectNested<N>> implements Nested<N>{
    LoadBalancerStatusObjectNested(LoadBalancerStatus item) {
      this.builder = new LoadBalancerStatusBuilder(this, item);
    }
    LoadBalancerStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLoadBalancerStatusObject() {
      return and();
    }
    
  }
  public class PodSecurityContextObjectNested<N> extends PodSecurityContextFluent<PodSecurityContextObjectNested<N>> implements Nested<N>{
    PodSecurityContextObjectNested(PodSecurityContext item) {
      this.builder = new PodSecurityContextBuilder(this, item);
    }
    PodSecurityContextBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodSecurityContextObject() {
      return and();
    }
    
  }
  public class ScopeSelectorObjectNested<N> extends ScopeSelectorFluent<ScopeSelectorObjectNested<N>> implements Nested<N>{
    ScopeSelectorObjectNested(ScopeSelector item) {
      this.builder = new ScopeSelectorBuilder(this, item);
    }
    ScopeSelectorBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endScopeSelectorObject() {
      return and();
    }
    
  }
  public class DownwardAPIProjectionObjectNested<N> extends DownwardAPIProjectionFluent<DownwardAPIProjectionObjectNested<N>> implements Nested<N>{
    DownwardAPIProjectionObjectNested(DownwardAPIProjection item) {
      this.builder = new DownwardAPIProjectionBuilder(this, item);
    }
    DownwardAPIProjectionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endDownwardAPIProjectionObject() {
      return and();
    }
    
  }
  public class PodAffinityTermObjectNested<N> extends PodAffinityTermFluent<PodAffinityTermObjectNested<N>> implements Nested<N>{
    PodAffinityTermObjectNested(PodAffinityTerm item) {
      this.builder = new PodAffinityTermBuilder(this, item);
    }
    PodAffinityTermBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodAffinityTermObject() {
      return and();
    }
    
  }
  public class APIServiceSpecObjectNested<N> extends APIServiceSpecFluent<APIServiceSpecObjectNested<N>> implements Nested<N>{
    APIServiceSpecObjectNested(APIServiceSpec item) {
      this.builder = new APIServiceSpecBuilder(this, item);
    }
    APIServiceSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAPIServiceSpecObject() {
      return and();
    }
    
  }
  public class ServicePortObjectNested<N> extends ServicePortFluent<ServicePortObjectNested<N>> implements Nested<N>{
    ServicePortObjectNested(ServicePort item) {
      this.builder = new ServicePortBuilder(this, item);
    }
    ServicePortBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endServicePortObject() {
      return and();
    }
    
  }
  public class GroupVersionForDiscoveryObjectNested<N> extends GroupVersionForDiscoveryFluent<GroupVersionForDiscoveryObjectNested<N>> implements Nested<N>{
    GroupVersionForDiscoveryObjectNested(GroupVersionForDiscovery item) {
      this.builder = new GroupVersionForDiscoveryBuilder(this, item);
    }
    GroupVersionForDiscoveryBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGroupVersionForDiscoveryObject() {
      return and();
    }
    
  }
  public class ClaimSourceObjectNested<N> extends ClaimSourceFluent<ClaimSourceObjectNested<N>> implements Nested<N>{
    ClaimSourceObjectNested(ClaimSource item) {
      this.builder = new ClaimSourceBuilder(this, item);
    }
    ClaimSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endClaimSourceObject() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimSourceObjectNested<N> extends PersistentVolumeClaimVolumeSourceFluent<PersistentVolumeClaimSourceObjectNested<N>> implements Nested<N>{
    PersistentVolumeClaimSourceObjectNested(PersistentVolumeClaimVolumeSource item) {
      this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this, item);
    }
    PersistentVolumeClaimVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeClaimSourceObject() {
      return and();
    }
    
  }
  public class SessionAffinityConfigObjectNested<N> extends SessionAffinityConfigFluent<SessionAffinityConfigObjectNested<N>> implements Nested<N>{
    SessionAffinityConfigObjectNested(SessionAffinityConfig item) {
      this.builder = new SessionAffinityConfigBuilder(this, item);
    }
    SessionAffinityConfigBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSessionAffinityConfigObject() {
      return and();
    }
    
  }
  public class ServiceAccountListObjectNested<N> extends ServiceAccountListFluent<ServiceAccountListObjectNested<N>> implements Nested<N>{
    ServiceAccountListObjectNested(ServiceAccountList item) {
      this.builder = new ServiceAccountListBuilder(this, item);
    }
    ServiceAccountListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endServiceAccountListObject() {
      return and();
    }
    
  }
  public class ComponentStatusObjectNested<N> extends ComponentStatusFluent<ComponentStatusObjectNested<N>> implements Nested<N>{
    ComponentStatusObjectNested(ComponentStatus item) {
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endComponentStatusObject() {
      return and();
    }
    
  }
  public class DaemonEndpointObjectNested<N> extends DaemonEndpointFluent<DaemonEndpointObjectNested<N>> implements Nested<N>{
    DaemonEndpointObjectNested(DaemonEndpoint item) {
      this.builder = new DaemonEndpointBuilder(this, item);
    }
    DaemonEndpointBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endDaemonEndpointObject() {
      return and();
    }
    
  }
  public class KeyToPathObjectNested<N> extends KeyToPathFluent<KeyToPathObjectNested<N>> implements Nested<N>{
    KeyToPathObjectNested(KeyToPath item) {
      this.builder = new KeyToPathBuilder(this, item);
    }
    KeyToPathBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endKeyToPathObject() {
      return and();
    }
    
  }
  public class FlexPersistentVolumeSourceObjectNested<N> extends FlexPersistentVolumeSourceFluent<FlexPersistentVolumeSourceObjectNested<N>> implements Nested<N>{
    FlexPersistentVolumeSourceObjectNested(FlexPersistentVolumeSource item) {
      this.builder = new FlexPersistentVolumeSourceBuilder(this, item);
    }
    FlexPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endFlexPersistentVolumeSourceObject() {
      return and();
    }
    
  }
  public class NamespaceListObjectNested<N> extends NamespaceListFluent<NamespaceListObjectNested<N>> implements Nested<N>{
    NamespaceListObjectNested(NamespaceList item) {
      this.builder = new NamespaceListBuilder(this, item);
    }
    NamespaceListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNamespaceListObject() {
      return and();
    }
    
  }
  public class PodDNSConfigObjectNested<N> extends PodDNSConfigFluent<PodDNSConfigObjectNested<N>> implements Nested<N>{
    PodDNSConfigObjectNested(PodDNSConfig item) {
      this.builder = new PodDNSConfigBuilder(this, item);
    }
    PodDNSConfigBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodDNSConfigObject() {
      return and();
    }
    
  }
  public class NodeListObjectNested<N> extends NodeListFluent<NodeListObjectNested<N>> implements Nested<N>{
    NodeListObjectNested(NodeList item) {
      this.builder = new NodeListBuilder(this, item);
    }
    NodeListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeListObject() {
      return and();
    }
    
  }
  public class BindingObjectNested<N> extends BindingFluent<BindingObjectNested<N>> implements Nested<N>{
    BindingObjectNested(Binding item) {
      this.builder = new BindingBuilder(this, item);
    }
    BindingBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endBindingObject() {
      return and();
    }
    
  }
  public class EnvVarSourceObjectNested<N> extends EnvVarSourceFluent<EnvVarSourceObjectNested<N>> implements Nested<N>{
    EnvVarSourceObjectNested(EnvVarSource item) {
      this.builder = new EnvVarSourceBuilder(this, item);
    }
    EnvVarSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEnvVarSourceObject() {
      return and();
    }
    
  }
  public class VolumeProjectionObjectNested<N> extends VolumeProjectionFluent<VolumeProjectionObjectNested<N>> implements Nested<N>{
    VolumeProjectionObjectNested(VolumeProjection item) {
      this.builder = new VolumeProjectionBuilder(this, item);
    }
    VolumeProjectionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endVolumeProjectionObject() {
      return and();
    }
    
  }
  public class ResourceQuotaObjectNested<N> extends ResourceQuotaFluent<ResourceQuotaObjectNested<N>> implements Nested<N>{
    ResourceQuotaObjectNested(ResourceQuota item) {
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endResourceQuotaObject() {
      return and();
    }
    
  }
  public class SecretObjectNested<N> extends SecretFluent<SecretObjectNested<N>> implements Nested<N>{
    SecretObjectNested(Secret item) {
      this.builder = new SecretBuilder(this, item);
    }
    SecretBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSecretObject() {
      return and();
    }
    
  }
  public class ServiceListObjectNested<N> extends ServiceListFluent<ServiceListObjectNested<N>> implements Nested<N>{
    ServiceListObjectNested(ServiceList item) {
      this.builder = new ServiceListBuilder(this, item);
    }
    ServiceListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endServiceListObject() {
      return and();
    }
    
  }
  public class VolumeNodeAffinityObjectNested<N> extends VolumeNodeAffinityFluent<VolumeNodeAffinityObjectNested<N>> implements Nested<N>{
    VolumeNodeAffinityObjectNested(VolumeNodeAffinity item) {
      this.builder = new VolumeNodeAffinityBuilder(this, item);
    }
    VolumeNodeAffinityBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endVolumeNodeAffinityObject() {
      return and();
    }
    
  }
  public class ResourceQuotaSpecObjectNested<N> extends ResourceQuotaSpecFluent<ResourceQuotaSpecObjectNested<N>> implements Nested<N>{
    ResourceQuotaSpecObjectNested(ResourceQuotaSpec item) {
      this.builder = new ResourceQuotaSpecBuilder(this, item);
    }
    ResourceQuotaSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endResourceQuotaSpecObject() {
      return and();
    }
    
  }
  public class NodeSelectorTermObjectNested<N> extends NodeSelectorTermFluent<NodeSelectorTermObjectNested<N>> implements Nested<N>{
    NodeSelectorTermObjectNested(NodeSelectorTerm item) {
      this.builder = new NodeSelectorTermBuilder(this, item);
    }
    NodeSelectorTermBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeSelectorTermObject() {
      return and();
    }
    
  }
  public class ScaleIOPersistentVolumeSourceObjectNested<N> extends ScaleIOPersistentVolumeSourceFluent<ScaleIOPersistentVolumeSourceObjectNested<N>> implements Nested<N>{
    ScaleIOPersistentVolumeSourceObjectNested(ScaleIOPersistentVolumeSource item) {
      this.builder = new ScaleIOPersistentVolumeSourceBuilder(this, item);
    }
    ScaleIOPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endScaleIOPersistentVolumeSourceObject() {
      return and();
    }
    
  }
  public class ListOptionsObjectNested<N> extends ListOptionsFluent<ListOptionsObjectNested<N>> implements Nested<N>{
    ListOptionsObjectNested(ListOptions item) {
      this.builder = new ListOptionsBuilder(this, item);
    }
    ListOptionsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endListOptionsObject() {
      return and();
    }
    
  }
  public class WeightedPodAffinityTermObjectNested<N> extends WeightedPodAffinityTermFluent<WeightedPodAffinityTermObjectNested<N>> implements Nested<N>{
    WeightedPodAffinityTermObjectNested(WeightedPodAffinityTerm item) {
      this.builder = new WeightedPodAffinityTermBuilder(this, item);
    }
    WeightedPodAffinityTermBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endWeightedPodAffinityTermObject() {
      return and();
    }
    
  }
  public class TypedObjectReferenceNested<N> extends TypedObjectReferenceFluent<TypedObjectReferenceNested<N>> implements Nested<N>{
    TypedObjectReferenceNested(TypedObjectReference item) {
      this.builder = new TypedObjectReferenceBuilder(this, item);
    }
    TypedObjectReferenceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endTypedObjectReference() {
      return and();
    }
    
  }
  public class ContainerResizePolicyObjectNested<N> extends ContainerResizePolicyFluent<ContainerResizePolicyObjectNested<N>> implements Nested<N>{
    ContainerResizePolicyObjectNested(ContainerResizePolicy item) {
      this.builder = new ContainerResizePolicyBuilder(this, item);
    }
    ContainerResizePolicyBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endContainerResizePolicyObject() {
      return and();
    }
    
  }
  public class NodeSystemInfoObjectNested<N> extends NodeSystemInfoFluent<NodeSystemInfoObjectNested<N>> implements Nested<N>{
    NodeSystemInfoObjectNested(NodeSystemInfo item) {
      this.builder = new NodeSystemInfoBuilder(this, item);
    }
    NodeSystemInfoBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeSystemInfoObject() {
      return and();
    }
    
  }
  public class TopologySelectorLabelRequirementObjectNested<N> extends TopologySelectorLabelRequirementFluent<TopologySelectorLabelRequirementObjectNested<N>> implements Nested<N>{
    TopologySelectorLabelRequirementObjectNested(TopologySelectorLabelRequirement item) {
      this.builder = new TopologySelectorLabelRequirementBuilder(this, item);
    }
    TopologySelectorLabelRequirementBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endTopologySelectorLabelRequirementObject() {
      return and();
    }
    
  }
  public class RBDPersistentVolumeSourceObjectNested<N> extends RBDPersistentVolumeSourceFluent<RBDPersistentVolumeSourceObjectNested<N>> implements Nested<N>{
    RBDPersistentVolumeSourceObjectNested(RBDPersistentVolumeSource item) {
      this.builder = new RBDPersistentVolumeSourceBuilder(this, item);
    }
    RBDPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endRBDPersistentVolumeSourceObject() {
      return and();
    }
    
  }
  public class AuthProviderConfigObjectNested<N> extends AuthProviderConfigFluent<AuthProviderConfigObjectNested<N>> implements Nested<N>{
    AuthProviderConfigObjectNested(AuthProviderConfig item) {
      this.builder = new AuthProviderConfigBuilder(this, item);
    }
    AuthProviderConfigBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAuthProviderConfigObject() {
      return and();
    }
    
  }
  public class SELinuxOptionsObjectNested<N> extends SELinuxOptionsFluent<SELinuxOptionsObjectNested<N>> implements Nested<N>{
    SELinuxOptionsObjectNested(SELinuxOptions item) {
      this.builder = new SELinuxOptionsBuilder(this, item);
    }
    SELinuxOptionsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSELinuxOptionsObject() {
      return and();
    }
    
  }
  public class HostAliasObjectNested<N> extends HostAliasFluent<HostAliasObjectNested<N>> implements Nested<N>{
    HostAliasObjectNested(HostAlias item) {
      this.builder = new HostAliasBuilder(this, item);
    }
    HostAliasBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endHostAliasObject() {
      return and();
    }
    
  }
  public class NodeDaemonEndpointsObjectNested<N> extends NodeDaemonEndpointsFluent<NodeDaemonEndpointsObjectNested<N>> implements Nested<N>{
    NodeDaemonEndpointsObjectNested(NodeDaemonEndpoints item) {
      this.builder = new NodeDaemonEndpointsBuilder(this, item);
    }
    NodeDaemonEndpointsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeDaemonEndpointsObject() {
      return and();
    }
    
  }
  public class VolumeDeviceObjectNested<N> extends VolumeDeviceFluent<VolumeDeviceObjectNested<N>> implements Nested<N>{
    VolumeDeviceObjectNested(VolumeDevice item) {
      this.builder = new VolumeDeviceBuilder(this, item);
    }
    VolumeDeviceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endVolumeDeviceObject() {
      return and();
    }
    
  }
  public class CSIVolumeSourceObjectNested<N> extends CSIVolumeSourceFluent<CSIVolumeSourceObjectNested<N>> implements Nested<N>{
    CSIVolumeSourceObjectNested(CSIVolumeSource item) {
      this.builder = new CSIVolumeSourceBuilder(this, item);
    }
    CSIVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endCSIVolumeSourceObject() {
      return and();
    }
    
  }
  public class PersistentVolumeSpecObjectNested<N> extends PersistentVolumeSpecFluent<PersistentVolumeSpecObjectNested<N>> implements Nested<N>{
    PersistentVolumeSpecObjectNested(PersistentVolumeSpec item) {
      this.builder = new PersistentVolumeSpecBuilder(this, item);
    }
    PersistentVolumeSpecBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeSpecObject() {
      return and();
    }
    
  }
  public class NodeObjectNested<N> extends NodeFluent<NodeObjectNested<N>> implements Nested<N>{
    NodeObjectNested(Node item) {
      this.builder = new NodeBuilder(this, item);
    }
    NodeBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNodeObject() {
      return and();
    }
    
  }
  public class LifecycleHandlerObjectNested<N> extends LifecycleHandlerFluent<LifecycleHandlerObjectNested<N>> implements Nested<N>{
    LifecycleHandlerObjectNested(LifecycleHandler item) {
      this.builder = new LifecycleHandlerBuilder(this, item);
    }
    LifecycleHandlerBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLifecycleHandlerObject() {
      return and();
    }
    
  }
  public class VolumeObjectNested<N> extends VolumeFluent<VolumeObjectNested<N>> implements Nested<N>{
    VolumeObjectNested(Volume item) {
      this.builder = new VolumeBuilder(this, item);
    }
    VolumeBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endVolumeObject() {
      return and();
    }
    
  }
  public class ClusterObjectNested<N> extends ClusterFluent<ClusterObjectNested<N>> implements Nested<N>{
    ClusterObjectNested(Cluster item) {
      this.builder = new ClusterBuilder(this, item);
    }
    ClusterBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endClusterObject() {
      return and();
    }
    
  }
  public class NFSVolumeSourceObjectNested<N> extends NFSVolumeSourceFluent<NFSVolumeSourceObjectNested<N>> implements Nested<N>{
    NFSVolumeSourceObjectNested(NFSVolumeSource item) {
      this.builder = new NFSVolumeSourceBuilder(this, item);
    }
    NFSVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNFSVolumeSourceObject() {
      return and();
    }
    
  }
  public class StorageOSVolumeSourceObjectNested<N> extends StorageOSVolumeSourceFluent<StorageOSVolumeSourceObjectNested<N>> implements Nested<N>{
    StorageOSVolumeSourceObjectNested(StorageOSVolumeSource item) {
      this.builder = new StorageOSVolumeSourceBuilder(this, item);
    }
    StorageOSVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endStorageOSVolumeSourceObject() {
      return and();
    }
    
  }
  public class PodStatusObjectNested<N> extends PodStatusFluent<PodStatusObjectNested<N>> implements Nested<N>{
    PodStatusObjectNested(PodStatus item) {
      this.builder = new PodStatusBuilder(this, item);
    }
    PodStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodStatusObject() {
      return and();
    }
    
  }
  public class KubernetesListObjectNested<N> extends KubernetesListFluent<KubernetesListObjectNested<N>> implements Nested<N>{
    KubernetesListObjectNested(KubernetesList item) {
      this.builder = new KubernetesListBuilder(this, item);
    }
    KubernetesListBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endKubernetesListObject() {
      return and();
    }
    
  }
  public class ExecConfigObjectNested<N> extends ExecConfigFluent<ExecConfigObjectNested<N>> implements Nested<N>{
    ExecConfigObjectNested(ExecConfig item) {
      this.builder = new ExecConfigBuilder(this, item);
    }
    ExecConfigBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endExecConfigObject() {
      return and();
    }
    
  }
  public class PersistentVolumeStatusObjectNested<N> extends PersistentVolumeStatusFluent<PersistentVolumeStatusObjectNested<N>> implements Nested<N>{
    PersistentVolumeStatusObjectNested(PersistentVolumeStatus item) {
      this.builder = new PersistentVolumeStatusBuilder(this, item);
    }
    PersistentVolumeStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPersistentVolumeStatusObject() {
      return and();
    }
    
  }
  public class EndpointPortObjectNested<N> extends EndpointPortFluent<EndpointPortObjectNested<N>> implements Nested<N>{
    EndpointPortObjectNested(EndpointPort item) {
      this.builder = new EndpointPortBuilder(this, item);
    }
    EndpointPortBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endEndpointPortObject() {
      return and();
    }
    
  }
  public class HTTPHeaderObjectNested<N> extends HTTPHeaderFluent<HTTPHeaderObjectNested<N>> implements Nested<N>{
    HTTPHeaderObjectNested(HTTPHeader item) {
      this.builder = new HTTPHeaderBuilder(this, item);
    }
    HTTPHeaderBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endHTTPHeaderObject() {
      return and();
    }
    
  }
  public class CapabilitiesObjectNested<N> extends CapabilitiesFluent<CapabilitiesObjectNested<N>> implements Nested<N>{
    CapabilitiesObjectNested(Capabilities item) {
      this.builder = new CapabilitiesBuilder(this, item);
    }
    CapabilitiesBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endCapabilitiesObject() {
      return and();
    }
    
  }
  public class ObjectReferenceObjectNested<N> extends ObjectReferenceFluent<ObjectReferenceObjectNested<N>> implements Nested<N>{
    ObjectReferenceObjectNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endObjectReferenceObject() {
      return and();
    }
    
  }
  public class WatchEventObjectNested<N> extends WatchEventFluent<WatchEventObjectNested<N>> implements Nested<N>{
    WatchEventObjectNested(WatchEvent item) {
      this.builder = new WatchEventBuilder(this, item);
    }
    WatchEventBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endWatchEventObject() {
      return and();
    }
    
  }
  public class LimitRangeItemObjectNested<N> extends LimitRangeItemFluent<LimitRangeItemObjectNested<N>> implements Nested<N>{
    LimitRangeItemObjectNested(LimitRangeItem item) {
      this.builder = new LimitRangeItemBuilder(this, item);
    }
    LimitRangeItemBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endLimitRangeItemObject() {
      return and();
    }
    
  }
  public class SecretProjectionObjectNested<N> extends SecretProjectionFluent<SecretProjectionObjectNested<N>> implements Nested<N>{
    SecretProjectionObjectNested(SecretProjection item) {
      this.builder = new SecretProjectionBuilder(this, item);
    }
    SecretProjectionBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSecretProjectionObject() {
      return and();
    }
    
  }
  public class GetOptionsObjectNested<N> extends GetOptionsFluent<GetOptionsObjectNested<N>> implements Nested<N>{
    GetOptionsObjectNested(GetOptions item) {
      this.builder = new GetOptionsBuilder(this, item);
    }
    GetOptionsBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGetOptionsObject() {
      return and();
    }
    
  }
  public class GlusterfsVolumeSourceObjectNested<N> extends GlusterfsVolumeSourceFluent<GlusterfsVolumeSourceObjectNested<N>> implements Nested<N>{
    GlusterfsVolumeSourceObjectNested(GlusterfsVolumeSource item) {
      this.builder = new GlusterfsVolumeSourceBuilder(this, item);
    }
    GlusterfsVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endGlusterfsVolumeSourceObject() {
      return and();
    }
    
  }
  public class ManagedFieldsEntryObjectNested<N> extends ManagedFieldsEntryFluent<ManagedFieldsEntryObjectNested<N>> implements Nested<N>{
    ManagedFieldsEntryObjectNested(ManagedFieldsEntry item) {
      this.builder = new ManagedFieldsEntryBuilder(this, item);
    }
    ManagedFieldsEntryBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endManagedFieldsEntryObject() {
      return and();
    }
    
  }
  public class NamespaceStatusObjectNested<N> extends NamespaceStatusFluent<NamespaceStatusObjectNested<N>> implements Nested<N>{
    NamespaceStatusObjectNested(NamespaceStatus item) {
      this.builder = new NamespaceStatusBuilder(this, item);
    }
    NamespaceStatusBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endNamespaceStatusObject() {
      return and();
    }
    
  }
  public class SecretEnvSourceObjectNested<N> extends SecretEnvSourceFluent<SecretEnvSourceObjectNested<N>> implements Nested<N>{
    SecretEnvSourceObjectNested(SecretEnvSource item) {
      this.builder = new SecretEnvSourceBuilder(this, item);
    }
    SecretEnvSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endSecretEnvSourceObject() {
      return and();
    }
    
  }
  public class ServiceAccountObjectNested<N> extends ServiceAccountFluent<ServiceAccountObjectNested<N>> implements Nested<N>{
    ServiceAccountObjectNested(ServiceAccount item) {
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endServiceAccountObject() {
      return and();
    }
    
  }
  public class AWSElasticBlockStoreVolumeSourceObjectNested<N> extends AWSElasticBlockStoreVolumeSourceFluent<AWSElasticBlockStoreVolumeSourceObjectNested<N>> implements Nested<N>{
    AWSElasticBlockStoreVolumeSourceObjectNested(AWSElasticBlockStoreVolumeSource item) {
      this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
    }
    AWSElasticBlockStoreVolumeSourceBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endAWSElasticBlockStoreVolumeSourceObject() {
      return and();
    }
    
  }
  public class PodIPObjectNested<N> extends PodIPFluent<PodIPObjectNested<N>> implements Nested<N>{
    PodIPObjectNested(PodIP item) {
      this.builder = new PodIPBuilder(this, item);
    }
    PodIPBuilder builder;
    public N and() {
      return (N) WatchEventFluent.this.withObject(builder.build());
    }
    public N endPodIPObject() {
      return and();
    }
    
  }
  
}