package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ContainerStateFluent<A extends ContainerStateFluent<A>> extends BaseFluent<A>{
  public ContainerStateFluent() {
  }
  
  public ContainerStateFluent(ContainerState instance) {
    this.copyInstance(instance);
  }
  private ContainerStateRunningBuilder running;
  private ContainerStateTerminatedBuilder terminated;
  private ContainerStateWaitingBuilder waiting;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ContainerState instance) {
    instance = (instance != null ? instance : new ContainerState());
  
    if (instance != null) {
        this.withRunning(instance.getRunning());
        this.withTerminated(instance.getTerminated());
        this.withWaiting(instance.getWaiting());
        this.withRunning(instance.getRunning());
        this.withTerminated(instance.getTerminated());
        this.withWaiting(instance.getWaiting());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public ContainerStateRunning buildRunning() {
    return this.running!=null ?this.running.build():null;
  }
  
  public A withRunning(ContainerStateRunning running) {
    _visitables.get("running").remove(this.running);
    if (running!=null){ this.running= new ContainerStateRunningBuilder(running); _visitables.get("running").add(this.running);} else { this.running = null; _visitables.get("running").remove(this.running); } return (A) this;
  }
  
  public boolean hasRunning() {
    return this.running != null;
  }
  
  public A withNewRunning(String startedAt) {
    return (A)withRunning(new ContainerStateRunning(startedAt));
  }
  
  public RunningNested<A> withNewRunning() {
    return new RunningNested(null);
  }
  
  public RunningNested<A> withNewRunningLike(ContainerStateRunning item) {
    return new RunningNested(item);
  }
  
  public RunningNested<A> editRunning() {
    return withNewRunningLike(java.util.Optional.ofNullable(buildRunning()).orElse(null));
  }
  
  public RunningNested<A> editOrNewRunning() {
    return withNewRunningLike(java.util.Optional.ofNullable(buildRunning()).orElse(new ContainerStateRunningBuilder().build()));
  }
  
  public RunningNested<A> editOrNewRunningLike(ContainerStateRunning item) {
    return withNewRunningLike(java.util.Optional.ofNullable(buildRunning()).orElse(item));
  }
  
  public ContainerStateTerminated buildTerminated() {
    return this.terminated!=null ?this.terminated.build():null;
  }
  
  public A withTerminated(ContainerStateTerminated terminated) {
    _visitables.get("terminated").remove(this.terminated);
    if (terminated!=null){ this.terminated= new ContainerStateTerminatedBuilder(terminated); _visitables.get("terminated").add(this.terminated);} else { this.terminated = null; _visitables.get("terminated").remove(this.terminated); } return (A) this;
  }
  
  public boolean hasTerminated() {
    return this.terminated != null;
  }
  
  public TerminatedNested<A> withNewTerminated() {
    return new TerminatedNested(null);
  }
  
  public TerminatedNested<A> withNewTerminatedLike(ContainerStateTerminated item) {
    return new TerminatedNested(item);
  }
  
  public TerminatedNested<A> editTerminated() {
    return withNewTerminatedLike(java.util.Optional.ofNullable(buildTerminated()).orElse(null));
  }
  
  public TerminatedNested<A> editOrNewTerminated() {
    return withNewTerminatedLike(java.util.Optional.ofNullable(buildTerminated()).orElse(new ContainerStateTerminatedBuilder().build()));
  }
  
  public TerminatedNested<A> editOrNewTerminatedLike(ContainerStateTerminated item) {
    return withNewTerminatedLike(java.util.Optional.ofNullable(buildTerminated()).orElse(item));
  }
  
  public ContainerStateWaiting buildWaiting() {
    return this.waiting!=null ?this.waiting.build():null;
  }
  
  public A withWaiting(ContainerStateWaiting waiting) {
    _visitables.get("waiting").remove(this.waiting);
    if (waiting!=null){ this.waiting= new ContainerStateWaitingBuilder(waiting); _visitables.get("waiting").add(this.waiting);} else { this.waiting = null; _visitables.get("waiting").remove(this.waiting); } return (A) this;
  }
  
  public boolean hasWaiting() {
    return this.waiting != null;
  }
  
  public A withNewWaiting(String message,String reason) {
    return (A)withWaiting(new ContainerStateWaiting(message, reason));
  }
  
  public WaitingNested<A> withNewWaiting() {
    return new WaitingNested(null);
  }
  
  public WaitingNested<A> withNewWaitingLike(ContainerStateWaiting item) {
    return new WaitingNested(item);
  }
  
  public WaitingNested<A> editWaiting() {
    return withNewWaitingLike(java.util.Optional.ofNullable(buildWaiting()).orElse(null));
  }
  
  public WaitingNested<A> editOrNewWaiting() {
    return withNewWaitingLike(java.util.Optional.ofNullable(buildWaiting()).orElse(new ContainerStateWaitingBuilder().build()));
  }
  
  public WaitingNested<A> editOrNewWaitingLike(ContainerStateWaiting item) {
    return withNewWaitingLike(java.util.Optional.ofNullable(buildWaiting()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerStateFluent that = (ContainerStateFluent) o;
    if (!java.util.Objects.equals(running, that.running)) return false;
  
    if (!java.util.Objects.equals(terminated, that.terminated)) return false;
  
    if (!java.util.Objects.equals(waiting, that.waiting)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(running,  terminated,  waiting,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (running != null) { sb.append("running:"); sb.append(running + ","); }
    if (terminated != null) { sb.append("terminated:"); sb.append(terminated + ","); }
    if (waiting != null) { sb.append("waiting:"); sb.append(waiting + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RunningNested<N> extends ContainerStateRunningFluent<RunningNested<N>> implements Nested<N>{
    RunningNested(ContainerStateRunning item) {
      this.builder = new ContainerStateRunningBuilder(this, item);
    }
    ContainerStateRunningBuilder builder;
    
    public N and() {
      return (N) ContainerStateFluent.this.withRunning(builder.build());
    }
    
    public N endRunning() {
      return and();
    }
    
  
  }
  public class TerminatedNested<N> extends ContainerStateTerminatedFluent<TerminatedNested<N>> implements Nested<N>{
    TerminatedNested(ContainerStateTerminated item) {
      this.builder = new ContainerStateTerminatedBuilder(this, item);
    }
    ContainerStateTerminatedBuilder builder;
    
    public N and() {
      return (N) ContainerStateFluent.this.withTerminated(builder.build());
    }
    
    public N endTerminated() {
      return and();
    }
    
  
  }
  public class WaitingNested<N> extends ContainerStateWaitingFluent<WaitingNested<N>> implements Nested<N>{
    WaitingNested(ContainerStateWaiting item) {
      this.builder = new ContainerStateWaitingBuilder(this, item);
    }
    ContainerStateWaitingBuilder builder;
    
    public N and() {
      return (N) ContainerStateFluent.this.withWaiting(builder.build());
    }
    
    public N endWaiting() {
      return and();
    }
    
  
  }

}