package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EventSeriesFluent<A extends EventSeriesFluent<A>> extends BaseFluent<A>{
  public EventSeriesFluent() {
  }
  
  public EventSeriesFluent(EventSeries instance) {
    this.copyInstance(instance);
  }
  private Integer count;
  private MicroTimeBuilder lastObservedTime;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EventSeries instance) {
    instance = (instance != null ? instance : new EventSeries());
  
    if (instance != null) {
        this.withCount(instance.getCount());
        this.withLastObservedTime(instance.getLastObservedTime());
        this.withCount(instance.getCount());
        this.withLastObservedTime(instance.getLastObservedTime());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public Integer getCount() {
    return this.count;
  }
  
  public A withCount(Integer count) {
    this.count=count; return (A) this;
  }
  
  public boolean hasCount() {
    return this.count != null;
  }
  
  public MicroTime buildLastObservedTime() {
    return this.lastObservedTime!=null ?this.lastObservedTime.build():null;
  }
  
  public A withLastObservedTime(MicroTime lastObservedTime) {
    _visitables.get("lastObservedTime").remove(this.lastObservedTime);
    if (lastObservedTime!=null){ this.lastObservedTime= new MicroTimeBuilder(lastObservedTime); _visitables.get("lastObservedTime").add(this.lastObservedTime);} else { this.lastObservedTime = null; _visitables.get("lastObservedTime").remove(this.lastObservedTime); } return (A) this;
  }
  
  public boolean hasLastObservedTime() {
    return this.lastObservedTime != null;
  }
  
  public A withNewLastObservedTime(String time) {
    return (A)withLastObservedTime(new MicroTime(time));
  }
  
  public LastObservedTimeNested<A> withNewLastObservedTime() {
    return new LastObservedTimeNested(null);
  }
  
  public LastObservedTimeNested<A> withNewLastObservedTimeLike(MicroTime item) {
    return new LastObservedTimeNested(item);
  }
  
  public LastObservedTimeNested<A> editLastObservedTime() {
    return withNewLastObservedTimeLike(java.util.Optional.ofNullable(buildLastObservedTime()).orElse(null));
  }
  
  public LastObservedTimeNested<A> editOrNewLastObservedTime() {
    return withNewLastObservedTimeLike(java.util.Optional.ofNullable(buildLastObservedTime()).orElse(new MicroTimeBuilder().build()));
  }
  
  public LastObservedTimeNested<A> editOrNewLastObservedTimeLike(MicroTime item) {
    return withNewLastObservedTimeLike(java.util.Optional.ofNullable(buildLastObservedTime()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EventSeriesFluent that = (EventSeriesFluent) o;
    if (!java.util.Objects.equals(count, that.count)) return false;
  
    if (!java.util.Objects.equals(lastObservedTime, that.lastObservedTime)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(count,  lastObservedTime,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (count != null) { sb.append("count:"); sb.append(count + ","); }
    if (lastObservedTime != null) { sb.append("lastObservedTime:"); sb.append(lastObservedTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class LastObservedTimeNested<N> extends MicroTimeFluent<LastObservedTimeNested<N>> implements Nested<N>{
    LastObservedTimeNested(MicroTime item) {
      this.builder = new MicroTimeBuilder(this, item);
    }
    MicroTimeBuilder builder;
    
    public N and() {
      return (N) EventSeriesFluent.this.withLastObservedTime(builder.build());
    }
    
    public N endLastObservedTime() {
      return and();
    }
    
  
  }

}