package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EventSourceFluent<A extends EventSourceFluent<A>> extends BaseFluent<A>{
  public EventSourceFluent() {
  }
  
  public EventSourceFluent(EventSource instance) {
    this.copyInstance(instance);
  }
  private String component;
  private String host;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EventSource instance) {
    instance = (instance != null ? instance : new EventSource());
  
    if (instance != null) {
        this.withComponent(instance.getComponent());
        this.withHost(instance.getHost());
        this.withComponent(instance.getComponent());
        this.withHost(instance.getHost());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getComponent() {
    return this.component;
  }
  
  public A withComponent(String component) {
    this.component=component; return (A) this;
  }
  
  public boolean hasComponent() {
    return this.component != null;
  }
  
  public String getHost() {
    return this.host;
  }
  
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  
  public boolean hasHost() {
    return this.host != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EventSourceFluent that = (EventSourceFluent) o;
    if (!java.util.Objects.equals(component, that.component)) return false;
  
    if (!java.util.Objects.equals(host, that.host)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(component,  host,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (component != null) { sb.append("component:"); sb.append(component + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}