package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NamespaceSpecFluent<A extends NamespaceSpecFluent<A>> extends BaseFluent<A>{
  public NamespaceSpecFluent() {
  }
  
  public NamespaceSpecFluent(NamespaceSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> finalizers = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NamespaceSpec instance) {
    instance = (instance != null ? instance : new NamespaceSpec());
  
    if (instance != null) {
        this.withFinalizers(instance.getFinalizers());
        this.withFinalizers(instance.getFinalizers());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToFinalizers(int index,String item) {
    if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
    this.finalizers.add(index, item);
    return (A)this;
  }
  
  public A setToFinalizers(int index,String item) {
    if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
    this.finalizers.set(index, item); return (A)this;
  }
  
  public A addToFinalizers(java.lang.String... items) {
    if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
    for (String item : items) {this.finalizers.add(item);} return (A)this;
  }
  
  public A addAllToFinalizers(Collection<String> items) {
    if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
    for (String item : items) {this.finalizers.add(item);} return (A)this;
  }
  
  public A removeFromFinalizers(java.lang.String... items) {
    if (this.finalizers == null) return (A)this;
    for (String item : items) { this.finalizers.remove(item);} return (A)this;
  }
  
  public A removeAllFromFinalizers(Collection<String> items) {
    if (this.finalizers == null) return (A)this;
    for (String item : items) { this.finalizers.remove(item);} return (A)this;
  }
  
  public List<String> getFinalizers() {
    return this.finalizers;
  }
  
  public String getFinalizer(int index) {
    return this.finalizers.get(index);
  }
  
  public String getFirstFinalizer() {
    return this.finalizers.get(0);
  }
  
  public String getLastFinalizer() {
    return this.finalizers.get(finalizers.size() - 1);
  }
  
  public String getMatchingFinalizer(Predicate<String> predicate) {
    for (String item: finalizers) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingFinalizer(Predicate<String> predicate) {
    for (String item: finalizers) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withFinalizers(List<String> finalizers) {
    if (finalizers != null) {this.finalizers = new ArrayList(); for (String item : finalizers){this.addToFinalizers(item);}} else { this.finalizers = null;} return (A) this;
  }
  
  public A withFinalizers(java.lang.String... finalizers) {
    if (this.finalizers != null) {this.finalizers.clear(); _visitables.remove("finalizers"); }
    if (finalizers != null) {for (String item :finalizers){ this.addToFinalizers(item);}} return (A) this;
  }
  
  public boolean hasFinalizers() {
    return finalizers != null && !finalizers.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamespaceSpecFluent that = (NamespaceSpecFluent) o;
    if (!java.util.Objects.equals(finalizers, that.finalizers)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(finalizers,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (finalizers != null && !finalizers.isEmpty()) { sb.append("finalizers:"); sb.append(finalizers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}