package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NodeDaemonEndpointsFluent<A extends NodeDaemonEndpointsFluent<A>> extends BaseFluent<A>{
  public NodeDaemonEndpointsFluent() {
  }
  
  public NodeDaemonEndpointsFluent(NodeDaemonEndpoints instance) {
    this.copyInstance(instance);
  }
  private DaemonEndpointBuilder kubeletEndpoint;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NodeDaemonEndpoints instance) {
    instance = (instance != null ? instance : new NodeDaemonEndpoints());
  
    if (instance != null) {
        this.withKubeletEndpoint(instance.getKubeletEndpoint());
        this.withKubeletEndpoint(instance.getKubeletEndpoint());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public DaemonEndpoint buildKubeletEndpoint() {
    return this.kubeletEndpoint!=null ?this.kubeletEndpoint.build():null;
  }
  
  public A withKubeletEndpoint(DaemonEndpoint kubeletEndpoint) {
    _visitables.get("kubeletEndpoint").remove(this.kubeletEndpoint);
    if (kubeletEndpoint!=null){ this.kubeletEndpoint= new DaemonEndpointBuilder(kubeletEndpoint); _visitables.get("kubeletEndpoint").add(this.kubeletEndpoint);} else { this.kubeletEndpoint = null; _visitables.get("kubeletEndpoint").remove(this.kubeletEndpoint); } return (A) this;
  }
  
  public boolean hasKubeletEndpoint() {
    return this.kubeletEndpoint != null;
  }
  
  public A withNewKubeletEndpoint(Integer port) {
    return (A)withKubeletEndpoint(new DaemonEndpoint(port));
  }
  
  public KubeletEndpointNested<A> withNewKubeletEndpoint() {
    return new KubeletEndpointNested(null);
  }
  
  public KubeletEndpointNested<A> withNewKubeletEndpointLike(DaemonEndpoint item) {
    return new KubeletEndpointNested(item);
  }
  
  public KubeletEndpointNested<A> editKubeletEndpoint() {
    return withNewKubeletEndpointLike(java.util.Optional.ofNullable(buildKubeletEndpoint()).orElse(null));
  }
  
  public KubeletEndpointNested<A> editOrNewKubeletEndpoint() {
    return withNewKubeletEndpointLike(java.util.Optional.ofNullable(buildKubeletEndpoint()).orElse(new DaemonEndpointBuilder().build()));
  }
  
  public KubeletEndpointNested<A> editOrNewKubeletEndpointLike(DaemonEndpoint item) {
    return withNewKubeletEndpointLike(java.util.Optional.ofNullable(buildKubeletEndpoint()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeDaemonEndpointsFluent that = (NodeDaemonEndpointsFluent) o;
    if (!java.util.Objects.equals(kubeletEndpoint, that.kubeletEndpoint)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(kubeletEndpoint,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kubeletEndpoint != null) { sb.append("kubeletEndpoint:"); sb.append(kubeletEndpoint + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class KubeletEndpointNested<N> extends DaemonEndpointFluent<KubeletEndpointNested<N>> implements Nested<N>{
    KubeletEndpointNested(DaemonEndpoint item) {
      this.builder = new DaemonEndpointBuilder(this, item);
    }
    DaemonEndpointBuilder builder;
    
    public N and() {
      return (N) NodeDaemonEndpointsFluent.this.withKubeletEndpoint(builder.build());
    }
    
    public N endKubeletEndpoint() {
      return and();
    }
    
  
  }

}