package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceFieldSelectorFluent<A extends ResourceFieldSelectorFluent<A>> extends BaseFluent<A>{
  public ResourceFieldSelectorFluent() {
  }
  
  public ResourceFieldSelectorFluent(ResourceFieldSelector instance) {
    this.copyInstance(instance);
  }
  private String containerName;
  private QuantityBuilder divisor;
  private String resource;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceFieldSelector instance) {
    instance = (instance != null ? instance : new ResourceFieldSelector());
  
    if (instance != null) {
        this.withContainerName(instance.getContainerName());
        this.withDivisor(instance.getDivisor());
        this.withResource(instance.getResource());
        this.withContainerName(instance.getContainerName());
        this.withDivisor(instance.getDivisor());
        this.withResource(instance.getResource());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getContainerName() {
    return this.containerName;
  }
  
  public A withContainerName(String containerName) {
    this.containerName=containerName; return (A) this;
  }
  
  public boolean hasContainerName() {
    return this.containerName != null;
  }
  
  public Quantity buildDivisor() {
    return this.divisor!=null ?this.divisor.build():null;
  }
  
  public A withDivisor(Quantity divisor) {
    _visitables.get("divisor").remove(this.divisor);
    if (divisor!=null){ this.divisor= new QuantityBuilder(divisor); _visitables.get("divisor").add(this.divisor);} else { this.divisor = null; _visitables.get("divisor").remove(this.divisor); } return (A) this;
  }
  
  public boolean hasDivisor() {
    return this.divisor != null;
  }
  
  public A withNewDivisor(String amount,String format) {
    return (A)withDivisor(new Quantity(amount, format));
  }
  
  public A withNewDivisor(String amount) {
    return (A)withDivisor(new Quantity(amount));
  }
  
  public DivisorNested<A> withNewDivisor() {
    return new DivisorNested(null);
  }
  
  public DivisorNested<A> withNewDivisorLike(Quantity item) {
    return new DivisorNested(item);
  }
  
  public DivisorNested<A> editDivisor() {
    return withNewDivisorLike(java.util.Optional.ofNullable(buildDivisor()).orElse(null));
  }
  
  public DivisorNested<A> editOrNewDivisor() {
    return withNewDivisorLike(java.util.Optional.ofNullable(buildDivisor()).orElse(new QuantityBuilder().build()));
  }
  
  public DivisorNested<A> editOrNewDivisorLike(Quantity item) {
    return withNewDivisorLike(java.util.Optional.ofNullable(buildDivisor()).orElse(item));
  }
  
  public String getResource() {
    return this.resource;
  }
  
  public A withResource(String resource) {
    this.resource=resource; return (A) this;
  }
  
  public boolean hasResource() {
    return this.resource != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceFieldSelectorFluent that = (ResourceFieldSelectorFluent) o;
    if (!java.util.Objects.equals(containerName, that.containerName)) return false;
  
    if (!java.util.Objects.equals(divisor, that.divisor)) return false;
  
    if (!java.util.Objects.equals(resource, that.resource)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(containerName,  divisor,  resource,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerName != null) { sb.append("containerName:"); sb.append(containerName + ","); }
    if (divisor != null) { sb.append("divisor:"); sb.append(divisor + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DivisorNested<N> extends QuantityFluent<DivisorNested<N>> implements Nested<N>{
    DivisorNested(Quantity item) {
      this.builder = new QuantityBuilder(this, item);
    }
    QuantityBuilder builder;
    
    public N and() {
      return (N) ResourceFieldSelectorFluent.this.withDivisor(builder.build());
    }
    
    public N endDivisor() {
      return and();
    }
    
  
  }

}