package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ScopedResourceSelectorRequirementFluent<A extends ScopedResourceSelectorRequirementFluent<A>> extends BaseFluent<A>{
  public ScopedResourceSelectorRequirementFluent() {
  }
  
  public ScopedResourceSelectorRequirementFluent(ScopedResourceSelectorRequirement instance) {
    this.copyInstance(instance);
  }
  private String operator;
  private String scopeName;
  private List<String> values = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ScopedResourceSelectorRequirement instance) {
    instance = (instance != null ? instance : new ScopedResourceSelectorRequirement());
  
    if (instance != null) {
        this.withOperator(instance.getOperator());
        this.withScopeName(instance.getScopeName());
        this.withValues(instance.getValues());
        this.withOperator(instance.getOperator());
        this.withScopeName(instance.getScopeName());
        this.withValues(instance.getValues());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getOperator() {
    return this.operator;
  }
  
  public A withOperator(String operator) {
    this.operator=operator; return (A) this;
  }
  
  public boolean hasOperator() {
    return this.operator != null;
  }
  
  public String getScopeName() {
    return this.scopeName;
  }
  
  public A withScopeName(String scopeName) {
    this.scopeName=scopeName; return (A) this;
  }
  
  public boolean hasScopeName() {
    return this.scopeName != null;
  }
  
  public A addToValues(int index,String item) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    this.values.add(index, item);
    return (A)this;
  }
  
  public A setToValues(int index,String item) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    this.values.set(index, item); return (A)this;
  }
  
  public A addToValues(java.lang.String... items) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    for (String item : items) {this.values.add(item);} return (A)this;
  }
  
  public A addAllToValues(Collection<String> items) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    for (String item : items) {this.values.add(item);} return (A)this;
  }
  
  public A removeFromValues(java.lang.String... items) {
    if (this.values == null) return (A)this;
    for (String item : items) { this.values.remove(item);} return (A)this;
  }
  
  public A removeAllFromValues(Collection<String> items) {
    if (this.values == null) return (A)this;
    for (String item : items) { this.values.remove(item);} return (A)this;
  }
  
  public List<String> getValues() {
    return this.values;
  }
  
  public String getValue(int index) {
    return this.values.get(index);
  }
  
  public String getFirstValue() {
    return this.values.get(0);
  }
  
  public String getLastValue() {
    return this.values.get(values.size() - 1);
  }
  
  public String getMatchingValue(Predicate<String> predicate) {
    for (String item: values) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingValue(Predicate<String> predicate) {
    for (String item: values) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withValues(List<String> values) {
    if (values != null) {this.values = new ArrayList(); for (String item : values){this.addToValues(item);}} else { this.values = null;} return (A) this;
  }
  
  public A withValues(java.lang.String... values) {
    if (this.values != null) {this.values.clear(); _visitables.remove("values"); }
    if (values != null) {for (String item :values){ this.addToValues(item);}} return (A) this;
  }
  
  public boolean hasValues() {
    return values != null && !values.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ScopedResourceSelectorRequirementFluent that = (ScopedResourceSelectorRequirementFluent) o;
    if (!java.util.Objects.equals(operator, that.operator)) return false;
  
    if (!java.util.Objects.equals(scopeName, that.scopeName)) return false;
  
    if (!java.util.Objects.equals(values, that.values)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(operator,  scopeName,  values,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (operator != null) { sb.append("operator:"); sb.append(operator + ","); }
    if (scopeName != null) { sb.append("scopeName:"); sb.append(scopeName + ","); }
    if (values != null && !values.isEmpty()) { sb.append("values:"); sb.append(values + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}