package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceAccountFluent<A extends ServiceAccountFluent<A>> extends BaseFluent<A>{
  public ServiceAccountFluent() {
  }
  
  public ServiceAccountFluent(ServiceAccount instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private Boolean automountServiceAccountToken;
  private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
  private String kind;
  private ObjectMetaBuilder metadata;
  private ArrayList<ObjectReferenceBuilder> secrets = new ArrayList<ObjectReferenceBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ServiceAccount instance) {
    instance = (instance != null ? instance : new ServiceAccount());
  
    if (instance != null) {
        this.withApiVersion(instance.getApiVersion());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSecrets(instance.getSecrets());
        this.withApiVersion(instance.getApiVersion());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSecrets(instance.getSecrets());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public Boolean getAutomountServiceAccountToken() {
    return this.automountServiceAccountToken;
  }
  
  public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
    this.automountServiceAccountToken=automountServiceAccountToken; return (A) this;
  }
  
  public boolean hasAutomountServiceAccountToken() {
    return this.automountServiceAccountToken != null;
  }
  
  public A addToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) { _visitables.get("imagePullSecrets").add(builder); imagePullSecrets.add(builder); } else { _visitables.get("imagePullSecrets").add(index, builder); imagePullSecrets.add(index, builder);}
    return (A)this;
  }
  
  public A setToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) { _visitables.get("imagePullSecrets").add(builder); imagePullSecrets.add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder); imagePullSecrets.set(index, builder);}
    return (A)this;
  }
  
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder); this.imagePullSecrets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder); this.imagePullSecrets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (imagePullSecrets == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
    final List visitables = _visitables.get("imagePullSecrets");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalObjectReference> buildImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  
  public LocalObjectReference buildImagePullSecret(int index) {
    return this.imagePullSecrets.get(index).build();
  }
  
  public LocalObjectReference buildFirstImagePullSecret() {
    return this.imagePullSecrets.get(0).build();
  }
  
  public LocalObjectReference buildLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
  }
  
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
    if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").clear();}
    if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
  }
  
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
    if (this.imagePullSecrets != null) {this.imagePullSecrets.clear(); _visitables.remove("imagePullSecrets"); }
    if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
  }
  
  public boolean hasImagePullSecrets() {
    return imagePullSecrets != null && !imagePullSecrets.isEmpty();
  }
  
  public A addNewImagePullSecret(String name) {
    return (A)addToImagePullSecrets(new LocalObjectReference(name));
  }
  
  public ImagePullSecretsNested<A> addNewImagePullSecret() {
    return new ImagePullSecretsNested(-1, null);
  }
  
  public ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
    return new ImagePullSecretsNested(-1, item);
  }
  
  public ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item) {
    return new ImagePullSecretsNested(index, item);
  }
  
  public ImagePullSecretsNested<A> editImagePullSecret(int index) {
    if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  
  public ImagePullSecretsNested<A> editFirstImagePullSecret() {
    if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(0, buildImagePullSecret(0));
  }
  
  public ImagePullSecretsNested<A> editLastImagePullSecret() {
    int index = imagePullSecrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  
  public ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imagePullSecrets.size();i++) { 
    if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public A addToSecrets(int index,ObjectReference item) {
    if (this.secrets == null) {this.secrets = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= secrets.size()) { _visitables.get("secrets").add(builder); secrets.add(builder); } else { _visitables.get("secrets").add(index, builder); secrets.add(index, builder);}
    return (A)this;
  }
  
  public A setToSecrets(int index,ObjectReference item) {
    if (this.secrets == null) {this.secrets = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= secrets.size()) { _visitables.get("secrets").add(builder); secrets.add(builder); } else { _visitables.get("secrets").set(index, builder); secrets.set(index, builder);}
    return (A)this;
  }
  
  public A addToSecrets(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.secrets == null) {this.secrets = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
  }
  
  public A addAllToSecrets(Collection<ObjectReference> items) {
    if (this.secrets == null) {this.secrets = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
  }
  
  public A removeFromSecrets(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.secrets == null) return (A)this;
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("secrets").remove(builder); this.secrets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSecrets(Collection<ObjectReference> items) {
    if (this.secrets == null) return (A)this;
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("secrets").remove(builder); this.secrets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSecrets(Predicate<ObjectReferenceBuilder> predicate) {
    if (secrets == null) return (A) this;
    final Iterator<ObjectReferenceBuilder> each = secrets.iterator();
    final List visitables = _visitables.get("secrets");
    while (each.hasNext()) {
      ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ObjectReference> buildSecrets() {
    return secrets != null ? build(secrets) : null;
  }
  
  public ObjectReference buildSecret(int index) {
    return this.secrets.get(index).build();
  }
  
  public ObjectReference buildFirstSecret() {
    return this.secrets.get(0).build();
  }
  
  public ObjectReference buildLastSecret() {
    return this.secrets.get(secrets.size() - 1).build();
  }
  
  public ObjectReference buildMatchingSecret(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: secrets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingSecret(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: secrets) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withSecrets(List<ObjectReference> secrets) {
    if (this.secrets != null) { _visitables.get("secrets").clear();}
    if (secrets != null) {this.secrets = new ArrayList(); for (ObjectReference item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
  }
  
  public A withSecrets(io.fabric8.kubernetes.api.model.ObjectReference... secrets) {
    if (this.secrets != null) {this.secrets.clear(); _visitables.remove("secrets"); }
    if (secrets != null) {for (ObjectReference item :secrets){ this.addToSecrets(item);}} return (A) this;
  }
  
  public boolean hasSecrets() {
    return secrets != null && !secrets.isEmpty();
  }
  
  public SecretsNested<A> addNewSecret() {
    return new SecretsNested(-1, null);
  }
  
  public SecretsNested<A> addNewSecretLike(ObjectReference item) {
    return new SecretsNested(-1, item);
  }
  
  public SecretsNested<A> setNewSecretLike(int index,ObjectReference item) {
    return new SecretsNested(index, item);
  }
  
  public SecretsNested<A> editSecret(int index) {
    if (secrets.size() <= index) throw new RuntimeException("Can't edit secrets. Index exceeds size.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public SecretsNested<A> editFirstSecret() {
    if (secrets.size() == 0) throw new RuntimeException("Can't edit first secrets. The list is empty.");
    return setNewSecretLike(0, buildSecret(0));
  }
  
  public SecretsNested<A> editLastSecret() {
    int index = secrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secrets. The list is empty.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public SecretsNested<A> editMatchingSecret(Predicate<ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secrets.size();i++) { 
    if (predicate.test(secrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secrets. No match found.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceAccountFluent that = (ServiceAccountFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
  
    if (!java.util.Objects.equals(automountServiceAccountToken, that.automountServiceAccountToken)) return false;
  
    if (!java.util.Objects.equals(imagePullSecrets, that.imagePullSecrets)) return false;
  
    if (!java.util.Objects.equals(kind, that.kind)) return false;
  
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
  
    if (!java.util.Objects.equals(secrets, that.secrets)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  automountServiceAccountToken,  imagePullSecrets,  kind,  metadata,  secrets,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (automountServiceAccountToken != null) { sb.append("automountServiceAccountToken:"); sb.append(automountServiceAccountToken + ","); }
    if (imagePullSecrets != null && !imagePullSecrets.isEmpty()) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (secrets != null && !secrets.isEmpty()) { sb.append("secrets:"); sb.append(secrets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAutomountServiceAccountToken() {
    return withAutomountServiceAccountToken(true);
  }
  public class ImagePullSecretsNested<N> extends LocalObjectReferenceFluent<ImagePullSecretsNested<N>> implements Nested<N>{
    ImagePullSecretsNested(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceAccountFluent.this.setToImagePullSecrets(index,builder.build());
    }
    
    public N endImagePullSecret() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) ServiceAccountFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class SecretsNested<N> extends ObjectReferenceFluent<SecretsNested<N>> implements Nested<N>{
    SecretsNested(int index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceAccountFluent.this.setToSecrets(index,builder.build());
    }
    
    public N endSecret() {
      return and();
    }
    
  
  }

}