package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SessionAffinityConfigFluent<A extends SessionAffinityConfigFluent<A>> extends BaseFluent<A>{
  public SessionAffinityConfigFluent() {
  }
  
  public SessionAffinityConfigFluent(SessionAffinityConfig instance) {
    this.copyInstance(instance);
  }
  private ClientIPConfigBuilder clientIP;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SessionAffinityConfig instance) {
    instance = (instance != null ? instance : new SessionAffinityConfig());
  
    if (instance != null) {
        this.withClientIP(instance.getClientIP());
        this.withClientIP(instance.getClientIP());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public ClientIPConfig buildClientIP() {
    return this.clientIP!=null ?this.clientIP.build():null;
  }
  
  public A withClientIP(ClientIPConfig clientIP) {
    _visitables.get("clientIP").remove(this.clientIP);
    if (clientIP!=null){ this.clientIP= new ClientIPConfigBuilder(clientIP); _visitables.get("clientIP").add(this.clientIP);} else { this.clientIP = null; _visitables.get("clientIP").remove(this.clientIP); } return (A) this;
  }
  
  public boolean hasClientIP() {
    return this.clientIP != null;
  }
  
  public A withNewClientIP(Integer timeoutSeconds) {
    return (A)withClientIP(new ClientIPConfig(timeoutSeconds));
  }
  
  public ClientIPNested<A> withNewClientIP() {
    return new ClientIPNested(null);
  }
  
  public ClientIPNested<A> withNewClientIPLike(ClientIPConfig item) {
    return new ClientIPNested(item);
  }
  
  public ClientIPNested<A> editClientIP() {
    return withNewClientIPLike(java.util.Optional.ofNullable(buildClientIP()).orElse(null));
  }
  
  public ClientIPNested<A> editOrNewClientIP() {
    return withNewClientIPLike(java.util.Optional.ofNullable(buildClientIP()).orElse(new ClientIPConfigBuilder().build()));
  }
  
  public ClientIPNested<A> editOrNewClientIPLike(ClientIPConfig item) {
    return withNewClientIPLike(java.util.Optional.ofNullable(buildClientIP()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SessionAffinityConfigFluent that = (SessionAffinityConfigFluent) o;
    if (!java.util.Objects.equals(clientIP, that.clientIP)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientIP,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientIP != null) { sb.append("clientIP:"); sb.append(clientIP + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClientIPNested<N> extends ClientIPConfigFluent<ClientIPNested<N>> implements Nested<N>{
    ClientIPNested(ClientIPConfig item) {
      this.builder = new ClientIPConfigBuilder(this, item);
    }
    ClientIPConfigBuilder builder;
    
    public N and() {
      return (N) SessionAffinityConfigFluent.this.withClientIP(builder.build());
    }
    
    public N endClientIP() {
      return and();
    }
    
  
  }

}