package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TCPSocketActionFluent<A extends TCPSocketActionFluent<A>> extends BaseFluent<A>{
  public TCPSocketActionFluent() {
  }
  
  public TCPSocketActionFluent(TCPSocketAction instance) {
    this.copyInstance(instance);
  }
  private String host;
  private IntOrStringBuilder port;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TCPSocketAction instance) {
    instance = (instance != null ? instance : new TCPSocketAction());
  
    if (instance != null) {
        this.withHost(instance.getHost());
        this.withPort(instance.getPort());
        this.withHost(instance.getHost());
        this.withPort(instance.getPort());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getHost() {
    return this.host;
  }
  
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  
  public boolean hasHost() {
    return this.host != null;
  }
  
  public IntOrString buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  
  public A withPort(IntOrString port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public A withNewPort(Object value) {
    return (A)withPort(new IntOrString(value));
  }
  
  public PortNested<A> withNewPort() {
    return new PortNested(null);
  }
  
  public PortNested<A> withNewPortLike(IntOrString item) {
    return new PortNested(item);
  }
  
  public PortNested<A> editPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(null));
  }
  
  public PortNested<A> editOrNewPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(new IntOrStringBuilder().build()));
  }
  
  public PortNested<A> editOrNewPortLike(IntOrString item) {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TCPSocketActionFluent that = (TCPSocketActionFluent) o;
    if (!java.util.Objects.equals(host, that.host)) return false;
  
    if (!java.util.Objects.equals(port, that.port)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(host,  port,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PortNested<N> extends IntOrStringFluent<PortNested<N>> implements Nested<N>{
    PortNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) TCPSocketActionFluent.this.withPort(builder.build());
    }
    
    public N endPort() {
      return and();
    }
    
  
  }

}