package io.fabric8.kubernetes.api.model;

import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.util.LinkedHashMap;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VolumeFluent<A extends VolumeFluent<A>> extends BaseFluent<A>{
  public VolumeFluent() {
  }
  
  public VolumeFluent(Volume instance) {
    this.copyInstance(instance);
  }
  private AWSElasticBlockStoreVolumeSourceBuilder awsElasticBlockStore;
  private AzureDiskVolumeSourceBuilder azureDisk;
  private AzureFileVolumeSourceBuilder azureFile;
  private CephFSVolumeSourceBuilder cephfs;
  private CinderVolumeSourceBuilder cinder;
  private ConfigMapVolumeSourceBuilder configMap;
  private CSIVolumeSourceBuilder csi;
  private DownwardAPIVolumeSourceBuilder downwardAPI;
  private EmptyDirVolumeSourceBuilder emptyDir;
  private EphemeralVolumeSourceBuilder ephemeral;
  private FCVolumeSourceBuilder fc;
  private FlexVolumeSourceBuilder flexVolume;
  private FlockerVolumeSourceBuilder flocker;
  private GCEPersistentDiskVolumeSourceBuilder gcePersistentDisk;
  private GitRepoVolumeSourceBuilder gitRepo;
  private GlusterfsVolumeSourceBuilder glusterfs;
  private HostPathVolumeSourceBuilder hostPath;
  private ISCSIVolumeSourceBuilder iscsi;
  private String name;
  private NFSVolumeSourceBuilder nfs;
  private PersistentVolumeClaimVolumeSourceBuilder persistentVolumeClaim;
  private PhotonPersistentDiskVolumeSourceBuilder photonPersistentDisk;
  private PortworxVolumeSourceBuilder portworxVolume;
  private ProjectedVolumeSourceBuilder projected;
  private QuobyteVolumeSourceBuilder quobyte;
  private RBDVolumeSourceBuilder rbd;
  private ScaleIOVolumeSourceBuilder scaleIO;
  private SecretVolumeSourceBuilder secret;
  private StorageOSVolumeSourceBuilder storageos;
  private VsphereVirtualDiskVolumeSourceBuilder vsphereVolume;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Volume instance) {
    instance = (instance != null ? instance : new Volume());
  
    if (instance != null) {
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withAzureDisk(instance.getAzureDisk());
        this.withAzureFile(instance.getAzureFile());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withConfigMap(instance.getConfigMap());
        this.withCsi(instance.getCsi());
        this.withDownwardAPI(instance.getDownwardAPI());
        this.withEmptyDir(instance.getEmptyDir());
        this.withEphemeral(instance.getEphemeral());
        this.withFc(instance.getFc());
        this.withFlexVolume(instance.getFlexVolume());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGitRepo(instance.getGitRepo());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withName(instance.getName());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
        this.withPortworxVolume(instance.getPortworxVolume());
        this.withProjected(instance.getProjected());
        this.withQuobyte(instance.getQuobyte());
        this.withRbd(instance.getRbd());
        this.withScaleIO(instance.getScaleIO());
        this.withSecret(instance.getSecret());
        this.withStorageos(instance.getStorageos());
        this.withVsphereVolume(instance.getVsphereVolume());
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withAzureDisk(instance.getAzureDisk());
        this.withAzureFile(instance.getAzureFile());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withConfigMap(instance.getConfigMap());
        this.withCsi(instance.getCsi());
        this.withDownwardAPI(instance.getDownwardAPI());
        this.withEmptyDir(instance.getEmptyDir());
        this.withEphemeral(instance.getEphemeral());
        this.withFc(instance.getFc());
        this.withFlexVolume(instance.getFlexVolume());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGitRepo(instance.getGitRepo());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withName(instance.getName());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
        this.withPortworxVolume(instance.getPortworxVolume());
        this.withProjected(instance.getProjected());
        this.withQuobyte(instance.getQuobyte());
        this.withRbd(instance.getRbd());
        this.withScaleIO(instance.getScaleIO());
        this.withSecret(instance.getSecret());
        this.withStorageos(instance.getStorageos());
        this.withVsphereVolume(instance.getVsphereVolume());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public AWSElasticBlockStoreVolumeSource buildAwsElasticBlockStore() {
    return this.awsElasticBlockStore!=null ?this.awsElasticBlockStore.build():null;
  }
  
  public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
    _visitables.get("awsElasticBlockStore").remove(this.awsElasticBlockStore);
    if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.get("awsElasticBlockStore").add(this.awsElasticBlockStore);} else { this.awsElasticBlockStore = null; _visitables.get("awsElasticBlockStore").remove(this.awsElasticBlockStore); } return (A) this;
  }
  
  public boolean hasAwsElasticBlockStore() {
    return this.awsElasticBlockStore != null;
  }
  
  public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID) {
    return (A)withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
  }
  
  public AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore() {
    return new AwsElasticBlockStoreNested(null);
  }
  
  public AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
    return new AwsElasticBlockStoreNested(item);
  }
  
  public AwsElasticBlockStoreNested<A> editAwsElasticBlockStore() {
    return withNewAwsElasticBlockStoreLike(java.util.Optional.ofNullable(buildAwsElasticBlockStore()).orElse(null));
  }
  
  public AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore() {
    return withNewAwsElasticBlockStoreLike(java.util.Optional.ofNullable(buildAwsElasticBlockStore()).orElse(new AWSElasticBlockStoreVolumeSourceBuilder().build()));
  }
  
  public AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
    return withNewAwsElasticBlockStoreLike(java.util.Optional.ofNullable(buildAwsElasticBlockStore()).orElse(item));
  }
  
  public AzureDiskVolumeSource buildAzureDisk() {
    return this.azureDisk!=null ?this.azureDisk.build():null;
  }
  
  public A withAzureDisk(AzureDiskVolumeSource azureDisk) {
    _visitables.get("azureDisk").remove(this.azureDisk);
    if (azureDisk!=null){ this.azureDisk= new AzureDiskVolumeSourceBuilder(azureDisk); _visitables.get("azureDisk").add(this.azureDisk);} else { this.azureDisk = null; _visitables.get("azureDisk").remove(this.azureDisk); } return (A) this;
  }
  
  public boolean hasAzureDisk() {
    return this.azureDisk != null;
  }
  
  public AzureDiskNested<A> withNewAzureDisk() {
    return new AzureDiskNested(null);
  }
  
  public AzureDiskNested<A> withNewAzureDiskLike(AzureDiskVolumeSource item) {
    return new AzureDiskNested(item);
  }
  
  public AzureDiskNested<A> editAzureDisk() {
    return withNewAzureDiskLike(java.util.Optional.ofNullable(buildAzureDisk()).orElse(null));
  }
  
  public AzureDiskNested<A> editOrNewAzureDisk() {
    return withNewAzureDiskLike(java.util.Optional.ofNullable(buildAzureDisk()).orElse(new AzureDiskVolumeSourceBuilder().build()));
  }
  
  public AzureDiskNested<A> editOrNewAzureDiskLike(AzureDiskVolumeSource item) {
    return withNewAzureDiskLike(java.util.Optional.ofNullable(buildAzureDisk()).orElse(item));
  }
  
  public AzureFileVolumeSource buildAzureFile() {
    return this.azureFile!=null ?this.azureFile.build():null;
  }
  
  public A withAzureFile(AzureFileVolumeSource azureFile) {
    _visitables.get("azureFile").remove(this.azureFile);
    if (azureFile!=null){ this.azureFile= new AzureFileVolumeSourceBuilder(azureFile); _visitables.get("azureFile").add(this.azureFile);} else { this.azureFile = null; _visitables.get("azureFile").remove(this.azureFile); } return (A) this;
  }
  
  public boolean hasAzureFile() {
    return this.azureFile != null;
  }
  
  public A withNewAzureFile(Boolean readOnly,String secretName,String shareName) {
    return (A)withAzureFile(new AzureFileVolumeSource(readOnly, secretName, shareName));
  }
  
  public AzureFileNested<A> withNewAzureFile() {
    return new AzureFileNested(null);
  }
  
  public AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item) {
    return new AzureFileNested(item);
  }
  
  public AzureFileNested<A> editAzureFile() {
    return withNewAzureFileLike(java.util.Optional.ofNullable(buildAzureFile()).orElse(null));
  }
  
  public AzureFileNested<A> editOrNewAzureFile() {
    return withNewAzureFileLike(java.util.Optional.ofNullable(buildAzureFile()).orElse(new AzureFileVolumeSourceBuilder().build()));
  }
  
  public AzureFileNested<A> editOrNewAzureFileLike(AzureFileVolumeSource item) {
    return withNewAzureFileLike(java.util.Optional.ofNullable(buildAzureFile()).orElse(item));
  }
  
  public CephFSVolumeSource buildCephfs() {
    return this.cephfs!=null ?this.cephfs.build():null;
  }
  
  public A withCephfs(CephFSVolumeSource cephfs) {
    _visitables.get("cephfs").remove(this.cephfs);
    if (cephfs!=null){ this.cephfs= new CephFSVolumeSourceBuilder(cephfs); _visitables.get("cephfs").add(this.cephfs);} else { this.cephfs = null; _visitables.get("cephfs").remove(this.cephfs); } return (A) this;
  }
  
  public boolean hasCephfs() {
    return this.cephfs != null;
  }
  
  public CephfsNested<A> withNewCephfs() {
    return new CephfsNested(null);
  }
  
  public CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item) {
    return new CephfsNested(item);
  }
  
  public CephfsNested<A> editCephfs() {
    return withNewCephfsLike(java.util.Optional.ofNullable(buildCephfs()).orElse(null));
  }
  
  public CephfsNested<A> editOrNewCephfs() {
    return withNewCephfsLike(java.util.Optional.ofNullable(buildCephfs()).orElse(new CephFSVolumeSourceBuilder().build()));
  }
  
  public CephfsNested<A> editOrNewCephfsLike(CephFSVolumeSource item) {
    return withNewCephfsLike(java.util.Optional.ofNullable(buildCephfs()).orElse(item));
  }
  
  public CinderVolumeSource buildCinder() {
    return this.cinder!=null ?this.cinder.build():null;
  }
  
  public A withCinder(CinderVolumeSource cinder) {
    _visitables.get("cinder").remove(this.cinder);
    if (cinder!=null){ this.cinder= new CinderVolumeSourceBuilder(cinder); _visitables.get("cinder").add(this.cinder);} else { this.cinder = null; _visitables.get("cinder").remove(this.cinder); } return (A) this;
  }
  
  public boolean hasCinder() {
    return this.cinder != null;
  }
  
  public CinderNested<A> withNewCinder() {
    return new CinderNested(null);
  }
  
  public CinderNested<A> withNewCinderLike(CinderVolumeSource item) {
    return new CinderNested(item);
  }
  
  public CinderNested<A> editCinder() {
    return withNewCinderLike(java.util.Optional.ofNullable(buildCinder()).orElse(null));
  }
  
  public CinderNested<A> editOrNewCinder() {
    return withNewCinderLike(java.util.Optional.ofNullable(buildCinder()).orElse(new CinderVolumeSourceBuilder().build()));
  }
  
  public CinderNested<A> editOrNewCinderLike(CinderVolumeSource item) {
    return withNewCinderLike(java.util.Optional.ofNullable(buildCinder()).orElse(item));
  }
  
  public ConfigMapVolumeSource buildConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  
  public A withConfigMap(ConfigMapVolumeSource configMap) {
    _visitables.get("configMap").remove(this.configMap);
    if (configMap!=null){ this.configMap= new ConfigMapVolumeSourceBuilder(configMap); _visitables.get("configMap").add(this.configMap);} else { this.configMap = null; _visitables.get("configMap").remove(this.configMap); } return (A) this;
  }
  
  public boolean hasConfigMap() {
    return this.configMap != null;
  }
  
  public ConfigMapNested<A> withNewConfigMap() {
    return new ConfigMapNested(null);
  }
  
  public ConfigMapNested<A> withNewConfigMapLike(ConfigMapVolumeSource item) {
    return new ConfigMapNested(item);
  }
  
  public ConfigMapNested<A> editConfigMap() {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(null));
  }
  
  public ConfigMapNested<A> editOrNewConfigMap() {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(new ConfigMapVolumeSourceBuilder().build()));
  }
  
  public ConfigMapNested<A> editOrNewConfigMapLike(ConfigMapVolumeSource item) {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(item));
  }
  
  public CSIVolumeSource buildCsi() {
    return this.csi!=null ?this.csi.build():null;
  }
  
  public A withCsi(CSIVolumeSource csi) {
    _visitables.get("csi").remove(this.csi);
    if (csi!=null){ this.csi= new CSIVolumeSourceBuilder(csi); _visitables.get("csi").add(this.csi);} else { this.csi = null; _visitables.get("csi").remove(this.csi); } return (A) this;
  }
  
  public boolean hasCsi() {
    return this.csi != null;
  }
  
  public CsiNested<A> withNewCsi() {
    return new CsiNested(null);
  }
  
  public CsiNested<A> withNewCsiLike(CSIVolumeSource item) {
    return new CsiNested(item);
  }
  
  public CsiNested<A> editCsi() {
    return withNewCsiLike(java.util.Optional.ofNullable(buildCsi()).orElse(null));
  }
  
  public CsiNested<A> editOrNewCsi() {
    return withNewCsiLike(java.util.Optional.ofNullable(buildCsi()).orElse(new CSIVolumeSourceBuilder().build()));
  }
  
  public CsiNested<A> editOrNewCsiLike(CSIVolumeSource item) {
    return withNewCsiLike(java.util.Optional.ofNullable(buildCsi()).orElse(item));
  }
  
  public DownwardAPIVolumeSource buildDownwardAPI() {
    return this.downwardAPI!=null ?this.downwardAPI.build():null;
  }
  
  public A withDownwardAPI(DownwardAPIVolumeSource downwardAPI) {
    _visitables.get("downwardAPI").remove(this.downwardAPI);
    if (downwardAPI!=null){ this.downwardAPI= new DownwardAPIVolumeSourceBuilder(downwardAPI); _visitables.get("downwardAPI").add(this.downwardAPI);} else { this.downwardAPI = null; _visitables.get("downwardAPI").remove(this.downwardAPI); } return (A) this;
  }
  
  public boolean hasDownwardAPI() {
    return this.downwardAPI != null;
  }
  
  public DownwardAPINested<A> withNewDownwardAPI() {
    return new DownwardAPINested(null);
  }
  
  public DownwardAPINested<A> withNewDownwardAPILike(DownwardAPIVolumeSource item) {
    return new DownwardAPINested(item);
  }
  
  public DownwardAPINested<A> editDownwardAPI() {
    return withNewDownwardAPILike(java.util.Optional.ofNullable(buildDownwardAPI()).orElse(null));
  }
  
  public DownwardAPINested<A> editOrNewDownwardAPI() {
    return withNewDownwardAPILike(java.util.Optional.ofNullable(buildDownwardAPI()).orElse(new DownwardAPIVolumeSourceBuilder().build()));
  }
  
  public DownwardAPINested<A> editOrNewDownwardAPILike(DownwardAPIVolumeSource item) {
    return withNewDownwardAPILike(java.util.Optional.ofNullable(buildDownwardAPI()).orElse(item));
  }
  
  public EmptyDirVolumeSource buildEmptyDir() {
    return this.emptyDir!=null ?this.emptyDir.build():null;
  }
  
  public A withEmptyDir(EmptyDirVolumeSource emptyDir) {
    _visitables.get("emptyDir").remove(this.emptyDir);
    if (emptyDir!=null){ this.emptyDir= new EmptyDirVolumeSourceBuilder(emptyDir); _visitables.get("emptyDir").add(this.emptyDir);} else { this.emptyDir = null; _visitables.get("emptyDir").remove(this.emptyDir); } return (A) this;
  }
  
  public boolean hasEmptyDir() {
    return this.emptyDir != null;
  }
  
  public EmptyDirNested<A> withNewEmptyDir() {
    return new EmptyDirNested(null);
  }
  
  public EmptyDirNested<A> withNewEmptyDirLike(EmptyDirVolumeSource item) {
    return new EmptyDirNested(item);
  }
  
  public EmptyDirNested<A> editEmptyDir() {
    return withNewEmptyDirLike(java.util.Optional.ofNullable(buildEmptyDir()).orElse(null));
  }
  
  public EmptyDirNested<A> editOrNewEmptyDir() {
    return withNewEmptyDirLike(java.util.Optional.ofNullable(buildEmptyDir()).orElse(new EmptyDirVolumeSourceBuilder().build()));
  }
  
  public EmptyDirNested<A> editOrNewEmptyDirLike(EmptyDirVolumeSource item) {
    return withNewEmptyDirLike(java.util.Optional.ofNullable(buildEmptyDir()).orElse(item));
  }
  
  public EphemeralVolumeSource buildEphemeral() {
    return this.ephemeral!=null ?this.ephemeral.build():null;
  }
  
  public A withEphemeral(EphemeralVolumeSource ephemeral) {
    _visitables.get("ephemeral").remove(this.ephemeral);
    if (ephemeral!=null){ this.ephemeral= new EphemeralVolumeSourceBuilder(ephemeral); _visitables.get("ephemeral").add(this.ephemeral);} else { this.ephemeral = null; _visitables.get("ephemeral").remove(this.ephemeral); } return (A) this;
  }
  
  public boolean hasEphemeral() {
    return this.ephemeral != null;
  }
  
  public EphemeralNested<A> withNewEphemeral() {
    return new EphemeralNested(null);
  }
  
  public EphemeralNested<A> withNewEphemeralLike(EphemeralVolumeSource item) {
    return new EphemeralNested(item);
  }
  
  public EphemeralNested<A> editEphemeral() {
    return withNewEphemeralLike(java.util.Optional.ofNullable(buildEphemeral()).orElse(null));
  }
  
  public EphemeralNested<A> editOrNewEphemeral() {
    return withNewEphemeralLike(java.util.Optional.ofNullable(buildEphemeral()).orElse(new EphemeralVolumeSourceBuilder().build()));
  }
  
  public EphemeralNested<A> editOrNewEphemeralLike(EphemeralVolumeSource item) {
    return withNewEphemeralLike(java.util.Optional.ofNullable(buildEphemeral()).orElse(item));
  }
  
  public FCVolumeSource buildFc() {
    return this.fc!=null ?this.fc.build():null;
  }
  
  public A withFc(FCVolumeSource fc) {
    _visitables.get("fc").remove(this.fc);
    if (fc!=null){ this.fc= new FCVolumeSourceBuilder(fc); _visitables.get("fc").add(this.fc);} else { this.fc = null; _visitables.get("fc").remove(this.fc); } return (A) this;
  }
  
  public boolean hasFc() {
    return this.fc != null;
  }
  
  public FcNested<A> withNewFc() {
    return new FcNested(null);
  }
  
  public FcNested<A> withNewFcLike(FCVolumeSource item) {
    return new FcNested(item);
  }
  
  public FcNested<A> editFc() {
    return withNewFcLike(java.util.Optional.ofNullable(buildFc()).orElse(null));
  }
  
  public FcNested<A> editOrNewFc() {
    return withNewFcLike(java.util.Optional.ofNullable(buildFc()).orElse(new FCVolumeSourceBuilder().build()));
  }
  
  public FcNested<A> editOrNewFcLike(FCVolumeSource item) {
    return withNewFcLike(java.util.Optional.ofNullable(buildFc()).orElse(item));
  }
  
  public FlexVolumeSource buildFlexVolume() {
    return this.flexVolume!=null ?this.flexVolume.build():null;
  }
  
  public A withFlexVolume(FlexVolumeSource flexVolume) {
    _visitables.get("flexVolume").remove(this.flexVolume);
    if (flexVolume!=null){ this.flexVolume= new FlexVolumeSourceBuilder(flexVolume); _visitables.get("flexVolume").add(this.flexVolume);} else { this.flexVolume = null; _visitables.get("flexVolume").remove(this.flexVolume); } return (A) this;
  }
  
  public boolean hasFlexVolume() {
    return this.flexVolume != null;
  }
  
  public FlexVolumeNested<A> withNewFlexVolume() {
    return new FlexVolumeNested(null);
  }
  
  public FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item) {
    return new FlexVolumeNested(item);
  }
  
  public FlexVolumeNested<A> editFlexVolume() {
    return withNewFlexVolumeLike(java.util.Optional.ofNullable(buildFlexVolume()).orElse(null));
  }
  
  public FlexVolumeNested<A> editOrNewFlexVolume() {
    return withNewFlexVolumeLike(java.util.Optional.ofNullable(buildFlexVolume()).orElse(new FlexVolumeSourceBuilder().build()));
  }
  
  public FlexVolumeNested<A> editOrNewFlexVolumeLike(FlexVolumeSource item) {
    return withNewFlexVolumeLike(java.util.Optional.ofNullable(buildFlexVolume()).orElse(item));
  }
  
  public FlockerVolumeSource buildFlocker() {
    return this.flocker!=null ?this.flocker.build():null;
  }
  
  public A withFlocker(FlockerVolumeSource flocker) {
    _visitables.get("flocker").remove(this.flocker);
    if (flocker!=null){ this.flocker= new FlockerVolumeSourceBuilder(flocker); _visitables.get("flocker").add(this.flocker);} else { this.flocker = null; _visitables.get("flocker").remove(this.flocker); } return (A) this;
  }
  
  public boolean hasFlocker() {
    return this.flocker != null;
  }
  
  public A withNewFlocker(String datasetName,String datasetUUID) {
    return (A)withFlocker(new FlockerVolumeSource(datasetName, datasetUUID));
  }
  
  public FlockerNested<A> withNewFlocker() {
    return new FlockerNested(null);
  }
  
  public FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item) {
    return new FlockerNested(item);
  }
  
  public FlockerNested<A> editFlocker() {
    return withNewFlockerLike(java.util.Optional.ofNullable(buildFlocker()).orElse(null));
  }
  
  public FlockerNested<A> editOrNewFlocker() {
    return withNewFlockerLike(java.util.Optional.ofNullable(buildFlocker()).orElse(new FlockerVolumeSourceBuilder().build()));
  }
  
  public FlockerNested<A> editOrNewFlockerLike(FlockerVolumeSource item) {
    return withNewFlockerLike(java.util.Optional.ofNullable(buildFlocker()).orElse(item));
  }
  
  public GCEPersistentDiskVolumeSource buildGcePersistentDisk() {
    return this.gcePersistentDisk!=null ?this.gcePersistentDisk.build():null;
  }
  
  public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
    _visitables.get("gcePersistentDisk").remove(this.gcePersistentDisk);
    if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.get("gcePersistentDisk").add(this.gcePersistentDisk);} else { this.gcePersistentDisk = null; _visitables.get("gcePersistentDisk").remove(this.gcePersistentDisk); } return (A) this;
  }
  
  public boolean hasGcePersistentDisk() {
    return this.gcePersistentDisk != null;
  }
  
  public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly) {
    return (A)withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
  }
  
  public GcePersistentDiskNested<A> withNewGcePersistentDisk() {
    return new GcePersistentDiskNested(null);
  }
  
  public GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
    return new GcePersistentDiskNested(item);
  }
  
  public GcePersistentDiskNested<A> editGcePersistentDisk() {
    return withNewGcePersistentDiskLike(java.util.Optional.ofNullable(buildGcePersistentDisk()).orElse(null));
  }
  
  public GcePersistentDiskNested<A> editOrNewGcePersistentDisk() {
    return withNewGcePersistentDiskLike(java.util.Optional.ofNullable(buildGcePersistentDisk()).orElse(new GCEPersistentDiskVolumeSourceBuilder().build()));
  }
  
  public GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
    return withNewGcePersistentDiskLike(java.util.Optional.ofNullable(buildGcePersistentDisk()).orElse(item));
  }
  
  public GitRepoVolumeSource buildGitRepo() {
    return this.gitRepo!=null ?this.gitRepo.build():null;
  }
  
  public A withGitRepo(GitRepoVolumeSource gitRepo) {
    _visitables.get("gitRepo").remove(this.gitRepo);
    if (gitRepo!=null){ this.gitRepo= new GitRepoVolumeSourceBuilder(gitRepo); _visitables.get("gitRepo").add(this.gitRepo);} else { this.gitRepo = null; _visitables.get("gitRepo").remove(this.gitRepo); } return (A) this;
  }
  
  public boolean hasGitRepo() {
    return this.gitRepo != null;
  }
  
  public A withNewGitRepo(String directory,String repository,String revision) {
    return (A)withGitRepo(new GitRepoVolumeSource(directory, repository, revision));
  }
  
  public GitRepoNested<A> withNewGitRepo() {
    return new GitRepoNested(null);
  }
  
  public GitRepoNested<A> withNewGitRepoLike(GitRepoVolumeSource item) {
    return new GitRepoNested(item);
  }
  
  public GitRepoNested<A> editGitRepo() {
    return withNewGitRepoLike(java.util.Optional.ofNullable(buildGitRepo()).orElse(null));
  }
  
  public GitRepoNested<A> editOrNewGitRepo() {
    return withNewGitRepoLike(java.util.Optional.ofNullable(buildGitRepo()).orElse(new GitRepoVolumeSourceBuilder().build()));
  }
  
  public GitRepoNested<A> editOrNewGitRepoLike(GitRepoVolumeSource item) {
    return withNewGitRepoLike(java.util.Optional.ofNullable(buildGitRepo()).orElse(item));
  }
  
  public GlusterfsVolumeSource buildGlusterfs() {
    return this.glusterfs!=null ?this.glusterfs.build():null;
  }
  
  public A withGlusterfs(GlusterfsVolumeSource glusterfs) {
    _visitables.get("glusterfs").remove(this.glusterfs);
    if (glusterfs!=null){ this.glusterfs= new GlusterfsVolumeSourceBuilder(glusterfs); _visitables.get("glusterfs").add(this.glusterfs);} else { this.glusterfs = null; _visitables.get("glusterfs").remove(this.glusterfs); } return (A) this;
  }
  
  public boolean hasGlusterfs() {
    return this.glusterfs != null;
  }
  
  public A withNewGlusterfs(String endpoints,String path,Boolean readOnly) {
    return (A)withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
  }
  
  public GlusterfsNested<A> withNewGlusterfs() {
    return new GlusterfsNested(null);
  }
  
  public GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item) {
    return new GlusterfsNested(item);
  }
  
  public GlusterfsNested<A> editGlusterfs() {
    return withNewGlusterfsLike(java.util.Optional.ofNullable(buildGlusterfs()).orElse(null));
  }
  
  public GlusterfsNested<A> editOrNewGlusterfs() {
    return withNewGlusterfsLike(java.util.Optional.ofNullable(buildGlusterfs()).orElse(new GlusterfsVolumeSourceBuilder().build()));
  }
  
  public GlusterfsNested<A> editOrNewGlusterfsLike(GlusterfsVolumeSource item) {
    return withNewGlusterfsLike(java.util.Optional.ofNullable(buildGlusterfs()).orElse(item));
  }
  
  public HostPathVolumeSource buildHostPath() {
    return this.hostPath!=null ?this.hostPath.build():null;
  }
  
  public A withHostPath(HostPathVolumeSource hostPath) {
    _visitables.get("hostPath").remove(this.hostPath);
    if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.get("hostPath").add(this.hostPath);} else { this.hostPath = null; _visitables.get("hostPath").remove(this.hostPath); } return (A) this;
  }
  
  public boolean hasHostPath() {
    return this.hostPath != null;
  }
  
  public A withNewHostPath(String path,String type) {
    return (A)withHostPath(new HostPathVolumeSource(path, type));
  }
  
  public HostPathNested<A> withNewHostPath() {
    return new HostPathNested(null);
  }
  
  public HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item) {
    return new HostPathNested(item);
  }
  
  public HostPathNested<A> editHostPath() {
    return withNewHostPathLike(java.util.Optional.ofNullable(buildHostPath()).orElse(null));
  }
  
  public HostPathNested<A> editOrNewHostPath() {
    return withNewHostPathLike(java.util.Optional.ofNullable(buildHostPath()).orElse(new HostPathVolumeSourceBuilder().build()));
  }
  
  public HostPathNested<A> editOrNewHostPathLike(HostPathVolumeSource item) {
    return withNewHostPathLike(java.util.Optional.ofNullable(buildHostPath()).orElse(item));
  }
  
  public ISCSIVolumeSource buildIscsi() {
    return this.iscsi!=null ?this.iscsi.build():null;
  }
  
  public A withIscsi(ISCSIVolumeSource iscsi) {
    _visitables.get("iscsi").remove(this.iscsi);
    if (iscsi!=null){ this.iscsi= new ISCSIVolumeSourceBuilder(iscsi); _visitables.get("iscsi").add(this.iscsi);} else { this.iscsi = null; _visitables.get("iscsi").remove(this.iscsi); } return (A) this;
  }
  
  public boolean hasIscsi() {
    return this.iscsi != null;
  }
  
  public IscsiNested<A> withNewIscsi() {
    return new IscsiNested(null);
  }
  
  public IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item) {
    return new IscsiNested(item);
  }
  
  public IscsiNested<A> editIscsi() {
    return withNewIscsiLike(java.util.Optional.ofNullable(buildIscsi()).orElse(null));
  }
  
  public IscsiNested<A> editOrNewIscsi() {
    return withNewIscsiLike(java.util.Optional.ofNullable(buildIscsi()).orElse(new ISCSIVolumeSourceBuilder().build()));
  }
  
  public IscsiNested<A> editOrNewIscsiLike(ISCSIVolumeSource item) {
    return withNewIscsiLike(java.util.Optional.ofNullable(buildIscsi()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public NFSVolumeSource buildNfs() {
    return this.nfs!=null ?this.nfs.build():null;
  }
  
  public A withNfs(NFSVolumeSource nfs) {
    _visitables.get("nfs").remove(this.nfs);
    if (nfs!=null){ this.nfs= new NFSVolumeSourceBuilder(nfs); _visitables.get("nfs").add(this.nfs);} else { this.nfs = null; _visitables.get("nfs").remove(this.nfs); } return (A) this;
  }
  
  public boolean hasNfs() {
    return this.nfs != null;
  }
  
  public A withNewNfs(String path,Boolean readOnly,String server) {
    return (A)withNfs(new NFSVolumeSource(path, readOnly, server));
  }
  
  public NfsNested<A> withNewNfs() {
    return new NfsNested(null);
  }
  
  public NfsNested<A> withNewNfsLike(NFSVolumeSource item) {
    return new NfsNested(item);
  }
  
  public NfsNested<A> editNfs() {
    return withNewNfsLike(java.util.Optional.ofNullable(buildNfs()).orElse(null));
  }
  
  public NfsNested<A> editOrNewNfs() {
    return withNewNfsLike(java.util.Optional.ofNullable(buildNfs()).orElse(new NFSVolumeSourceBuilder().build()));
  }
  
  public NfsNested<A> editOrNewNfsLike(NFSVolumeSource item) {
    return withNewNfsLike(java.util.Optional.ofNullable(buildNfs()).orElse(item));
  }
  
  public PersistentVolumeClaimVolumeSource buildPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null ?this.persistentVolumeClaim.build():null;
  }
  
  public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
    _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
    if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new PersistentVolumeClaimVolumeSourceBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} else { this.persistentVolumeClaim = null; _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim); } return (A) this;
  }
  
  public boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  
  public A withNewPersistentVolumeClaim(String claimName,Boolean readOnly) {
    return (A)withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
  }
  
  public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
    return new PersistentVolumeClaimNested(null);
  }
  
  public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaimVolumeSource item) {
    return new PersistentVolumeClaimNested(item);
  }
  
  public PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(null));
  }
  
  public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(new PersistentVolumeClaimVolumeSourceBuilder().build()));
  }
  
  public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(PersistentVolumeClaimVolumeSource item) {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(item));
  }
  
  public PhotonPersistentDiskVolumeSource buildPhotonPersistentDisk() {
    return this.photonPersistentDisk!=null ?this.photonPersistentDisk.build():null;
  }
  
  public A withPhotonPersistentDisk(PhotonPersistentDiskVolumeSource photonPersistentDisk) {
    _visitables.get("photonPersistentDisk").remove(this.photonPersistentDisk);
    if (photonPersistentDisk!=null){ this.photonPersistentDisk= new PhotonPersistentDiskVolumeSourceBuilder(photonPersistentDisk); _visitables.get("photonPersistentDisk").add(this.photonPersistentDisk);} else { this.photonPersistentDisk = null; _visitables.get("photonPersistentDisk").remove(this.photonPersistentDisk); } return (A) this;
  }
  
  public boolean hasPhotonPersistentDisk() {
    return this.photonPersistentDisk != null;
  }
  
  public A withNewPhotonPersistentDisk(String fsType,String pdID) {
    return (A)withPhotonPersistentDisk(new PhotonPersistentDiskVolumeSource(fsType, pdID));
  }
  
  public PhotonPersistentDiskNested<A> withNewPhotonPersistentDisk() {
    return new PhotonPersistentDiskNested(null);
  }
  
  public PhotonPersistentDiskNested<A> withNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item) {
    return new PhotonPersistentDiskNested(item);
  }
  
  public PhotonPersistentDiskNested<A> editPhotonPersistentDisk() {
    return withNewPhotonPersistentDiskLike(java.util.Optional.ofNullable(buildPhotonPersistentDisk()).orElse(null));
  }
  
  public PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDisk() {
    return withNewPhotonPersistentDiskLike(java.util.Optional.ofNullable(buildPhotonPersistentDisk()).orElse(new PhotonPersistentDiskVolumeSourceBuilder().build()));
  }
  
  public PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item) {
    return withNewPhotonPersistentDiskLike(java.util.Optional.ofNullable(buildPhotonPersistentDisk()).orElse(item));
  }
  
  public PortworxVolumeSource buildPortworxVolume() {
    return this.portworxVolume!=null ?this.portworxVolume.build():null;
  }
  
  public A withPortworxVolume(PortworxVolumeSource portworxVolume) {
    _visitables.get("portworxVolume").remove(this.portworxVolume);
    if (portworxVolume!=null){ this.portworxVolume= new PortworxVolumeSourceBuilder(portworxVolume); _visitables.get("portworxVolume").add(this.portworxVolume);} else { this.portworxVolume = null; _visitables.get("portworxVolume").remove(this.portworxVolume); } return (A) this;
  }
  
  public boolean hasPortworxVolume() {
    return this.portworxVolume != null;
  }
  
  public A withNewPortworxVolume(String fsType,Boolean readOnly,String volumeID) {
    return (A)withPortworxVolume(new PortworxVolumeSource(fsType, readOnly, volumeID));
  }
  
  public PortworxVolumeNested<A> withNewPortworxVolume() {
    return new PortworxVolumeNested(null);
  }
  
  public PortworxVolumeNested<A> withNewPortworxVolumeLike(PortworxVolumeSource item) {
    return new PortworxVolumeNested(item);
  }
  
  public PortworxVolumeNested<A> editPortworxVolume() {
    return withNewPortworxVolumeLike(java.util.Optional.ofNullable(buildPortworxVolume()).orElse(null));
  }
  
  public PortworxVolumeNested<A> editOrNewPortworxVolume() {
    return withNewPortworxVolumeLike(java.util.Optional.ofNullable(buildPortworxVolume()).orElse(new PortworxVolumeSourceBuilder().build()));
  }
  
  public PortworxVolumeNested<A> editOrNewPortworxVolumeLike(PortworxVolumeSource item) {
    return withNewPortworxVolumeLike(java.util.Optional.ofNullable(buildPortworxVolume()).orElse(item));
  }
  
  public ProjectedVolumeSource buildProjected() {
    return this.projected!=null ?this.projected.build():null;
  }
  
  public A withProjected(ProjectedVolumeSource projected) {
    _visitables.get("projected").remove(this.projected);
    if (projected!=null){ this.projected= new ProjectedVolumeSourceBuilder(projected); _visitables.get("projected").add(this.projected);} else { this.projected = null; _visitables.get("projected").remove(this.projected); } return (A) this;
  }
  
  public boolean hasProjected() {
    return this.projected != null;
  }
  
  public ProjectedNested<A> withNewProjected() {
    return new ProjectedNested(null);
  }
  
  public ProjectedNested<A> withNewProjectedLike(ProjectedVolumeSource item) {
    return new ProjectedNested(item);
  }
  
  public ProjectedNested<A> editProjected() {
    return withNewProjectedLike(java.util.Optional.ofNullable(buildProjected()).orElse(null));
  }
  
  public ProjectedNested<A> editOrNewProjected() {
    return withNewProjectedLike(java.util.Optional.ofNullable(buildProjected()).orElse(new ProjectedVolumeSourceBuilder().build()));
  }
  
  public ProjectedNested<A> editOrNewProjectedLike(ProjectedVolumeSource item) {
    return withNewProjectedLike(java.util.Optional.ofNullable(buildProjected()).orElse(item));
  }
  
  public QuobyteVolumeSource buildQuobyte() {
    return this.quobyte!=null ?this.quobyte.build():null;
  }
  
  public A withQuobyte(QuobyteVolumeSource quobyte) {
    _visitables.get("quobyte").remove(this.quobyte);
    if (quobyte!=null){ this.quobyte= new QuobyteVolumeSourceBuilder(quobyte); _visitables.get("quobyte").add(this.quobyte);} else { this.quobyte = null; _visitables.get("quobyte").remove(this.quobyte); } return (A) this;
  }
  
  public boolean hasQuobyte() {
    return this.quobyte != null;
  }
  
  public QuobyteNested<A> withNewQuobyte() {
    return new QuobyteNested(null);
  }
  
  public QuobyteNested<A> withNewQuobyteLike(QuobyteVolumeSource item) {
    return new QuobyteNested(item);
  }
  
  public QuobyteNested<A> editQuobyte() {
    return withNewQuobyteLike(java.util.Optional.ofNullable(buildQuobyte()).orElse(null));
  }
  
  public QuobyteNested<A> editOrNewQuobyte() {
    return withNewQuobyteLike(java.util.Optional.ofNullable(buildQuobyte()).orElse(new QuobyteVolumeSourceBuilder().build()));
  }
  
  public QuobyteNested<A> editOrNewQuobyteLike(QuobyteVolumeSource item) {
    return withNewQuobyteLike(java.util.Optional.ofNullable(buildQuobyte()).orElse(item));
  }
  
  public RBDVolumeSource buildRbd() {
    return this.rbd!=null ?this.rbd.build():null;
  }
  
  public A withRbd(RBDVolumeSource rbd) {
    _visitables.get("rbd").remove(this.rbd);
    if (rbd!=null){ this.rbd= new RBDVolumeSourceBuilder(rbd); _visitables.get("rbd").add(this.rbd);} else { this.rbd = null; _visitables.get("rbd").remove(this.rbd); } return (A) this;
  }
  
  public boolean hasRbd() {
    return this.rbd != null;
  }
  
  public RbdNested<A> withNewRbd() {
    return new RbdNested(null);
  }
  
  public RbdNested<A> withNewRbdLike(RBDVolumeSource item) {
    return new RbdNested(item);
  }
  
  public RbdNested<A> editRbd() {
    return withNewRbdLike(java.util.Optional.ofNullable(buildRbd()).orElse(null));
  }
  
  public RbdNested<A> editOrNewRbd() {
    return withNewRbdLike(java.util.Optional.ofNullable(buildRbd()).orElse(new RBDVolumeSourceBuilder().build()));
  }
  
  public RbdNested<A> editOrNewRbdLike(RBDVolumeSource item) {
    return withNewRbdLike(java.util.Optional.ofNullable(buildRbd()).orElse(item));
  }
  
  public ScaleIOVolumeSource buildScaleIO() {
    return this.scaleIO!=null ?this.scaleIO.build():null;
  }
  
  public A withScaleIO(ScaleIOVolumeSource scaleIO) {
    _visitables.get("scaleIO").remove(this.scaleIO);
    if (scaleIO!=null){ this.scaleIO= new ScaleIOVolumeSourceBuilder(scaleIO); _visitables.get("scaleIO").add(this.scaleIO);} else { this.scaleIO = null; _visitables.get("scaleIO").remove(this.scaleIO); } return (A) this;
  }
  
  public boolean hasScaleIO() {
    return this.scaleIO != null;
  }
  
  public ScaleIONested<A> withNewScaleIO() {
    return new ScaleIONested(null);
  }
  
  public ScaleIONested<A> withNewScaleIOLike(ScaleIOVolumeSource item) {
    return new ScaleIONested(item);
  }
  
  public ScaleIONested<A> editScaleIO() {
    return withNewScaleIOLike(java.util.Optional.ofNullable(buildScaleIO()).orElse(null));
  }
  
  public ScaleIONested<A> editOrNewScaleIO() {
    return withNewScaleIOLike(java.util.Optional.ofNullable(buildScaleIO()).orElse(new ScaleIOVolumeSourceBuilder().build()));
  }
  
  public ScaleIONested<A> editOrNewScaleIOLike(ScaleIOVolumeSource item) {
    return withNewScaleIOLike(java.util.Optional.ofNullable(buildScaleIO()).orElse(item));
  }
  
  public SecretVolumeSource buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  
  public A withSecret(SecretVolumeSource secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new SecretVolumeSourceBuilder(secret); _visitables.get("secret").add(this.secret);} else { this.secret = null; _visitables.get("secret").remove(this.secret); } return (A) this;
  }
  
  public boolean hasSecret() {
    return this.secret != null;
  }
  
  public SecretNested<A> withNewSecret() {
    return new SecretNested(null);
  }
  
  public SecretNested<A> withNewSecretLike(SecretVolumeSource item) {
    return new SecretNested(item);
  }
  
  public SecretNested<A> editSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(null));
  }
  
  public SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(new SecretVolumeSourceBuilder().build()));
  }
  
  public SecretNested<A> editOrNewSecretLike(SecretVolumeSource item) {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(item));
  }
  
  public StorageOSVolumeSource buildStorageos() {
    return this.storageos!=null ?this.storageos.build():null;
  }
  
  public A withStorageos(StorageOSVolumeSource storageos) {
    _visitables.get("storageos").remove(this.storageos);
    if (storageos!=null){ this.storageos= new StorageOSVolumeSourceBuilder(storageos); _visitables.get("storageos").add(this.storageos);} else { this.storageos = null; _visitables.get("storageos").remove(this.storageos); } return (A) this;
  }
  
  public boolean hasStorageos() {
    return this.storageos != null;
  }
  
  public StorageosNested<A> withNewStorageos() {
    return new StorageosNested(null);
  }
  
  public StorageosNested<A> withNewStorageosLike(StorageOSVolumeSource item) {
    return new StorageosNested(item);
  }
  
  public StorageosNested<A> editStorageos() {
    return withNewStorageosLike(java.util.Optional.ofNullable(buildStorageos()).orElse(null));
  }
  
  public StorageosNested<A> editOrNewStorageos() {
    return withNewStorageosLike(java.util.Optional.ofNullable(buildStorageos()).orElse(new StorageOSVolumeSourceBuilder().build()));
  }
  
  public StorageosNested<A> editOrNewStorageosLike(StorageOSVolumeSource item) {
    return withNewStorageosLike(java.util.Optional.ofNullable(buildStorageos()).orElse(item));
  }
  
  public VsphereVirtualDiskVolumeSource buildVsphereVolume() {
    return this.vsphereVolume!=null ?this.vsphereVolume.build():null;
  }
  
  public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume) {
    _visitables.get("vsphereVolume").remove(this.vsphereVolume);
    if (vsphereVolume!=null){ this.vsphereVolume= new VsphereVirtualDiskVolumeSourceBuilder(vsphereVolume); _visitables.get("vsphereVolume").add(this.vsphereVolume);} else { this.vsphereVolume = null; _visitables.get("vsphereVolume").remove(this.vsphereVolume); } return (A) this;
  }
  
  public boolean hasVsphereVolume() {
    return this.vsphereVolume != null;
  }
  
  public A withNewVsphereVolume(String fsType,String storagePolicyID,String storagePolicyName,String volumePath) {
    return (A)withVsphereVolume(new VsphereVirtualDiskVolumeSource(fsType, storagePolicyID, storagePolicyName, volumePath));
  }
  
  public VsphereVolumeNested<A> withNewVsphereVolume() {
    return new VsphereVolumeNested(null);
  }
  
  public VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
    return new VsphereVolumeNested(item);
  }
  
  public VsphereVolumeNested<A> editVsphereVolume() {
    return withNewVsphereVolumeLike(java.util.Optional.ofNullable(buildVsphereVolume()).orElse(null));
  }
  
  public VsphereVolumeNested<A> editOrNewVsphereVolume() {
    return withNewVsphereVolumeLike(java.util.Optional.ofNullable(buildVsphereVolume()).orElse(new VsphereVirtualDiskVolumeSourceBuilder().build()));
  }
  
  public VsphereVolumeNested<A> editOrNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
    return withNewVsphereVolumeLike(java.util.Optional.ofNullable(buildVsphereVolume()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VolumeFluent that = (VolumeFluent) o;
    if (!java.util.Objects.equals(awsElasticBlockStore, that.awsElasticBlockStore)) return false;
  
    if (!java.util.Objects.equals(azureDisk, that.azureDisk)) return false;
  
    if (!java.util.Objects.equals(azureFile, that.azureFile)) return false;
  
    if (!java.util.Objects.equals(cephfs, that.cephfs)) return false;
  
    if (!java.util.Objects.equals(cinder, that.cinder)) return false;
  
    if (!java.util.Objects.equals(configMap, that.configMap)) return false;
  
    if (!java.util.Objects.equals(csi, that.csi)) return false;
  
    if (!java.util.Objects.equals(downwardAPI, that.downwardAPI)) return false;
  
    if (!java.util.Objects.equals(emptyDir, that.emptyDir)) return false;
  
    if (!java.util.Objects.equals(ephemeral, that.ephemeral)) return false;
  
    if (!java.util.Objects.equals(fc, that.fc)) return false;
  
    if (!java.util.Objects.equals(flexVolume, that.flexVolume)) return false;
  
    if (!java.util.Objects.equals(flocker, that.flocker)) return false;
  
    if (!java.util.Objects.equals(gcePersistentDisk, that.gcePersistentDisk)) return false;
  
    if (!java.util.Objects.equals(gitRepo, that.gitRepo)) return false;
  
    if (!java.util.Objects.equals(glusterfs, that.glusterfs)) return false;
  
    if (!java.util.Objects.equals(hostPath, that.hostPath)) return false;
  
    if (!java.util.Objects.equals(iscsi, that.iscsi)) return false;
  
    if (!java.util.Objects.equals(name, that.name)) return false;
  
    if (!java.util.Objects.equals(nfs, that.nfs)) return false;
  
    if (!java.util.Objects.equals(persistentVolumeClaim, that.persistentVolumeClaim)) return false;
  
    if (!java.util.Objects.equals(photonPersistentDisk, that.photonPersistentDisk)) return false;
  
    if (!java.util.Objects.equals(portworxVolume, that.portworxVolume)) return false;
  
    if (!java.util.Objects.equals(projected, that.projected)) return false;
  
    if (!java.util.Objects.equals(quobyte, that.quobyte)) return false;
  
    if (!java.util.Objects.equals(rbd, that.rbd)) return false;
  
    if (!java.util.Objects.equals(scaleIO, that.scaleIO)) return false;
  
    if (!java.util.Objects.equals(secret, that.secret)) return false;
  
    if (!java.util.Objects.equals(storageos, that.storageos)) return false;
  
    if (!java.util.Objects.equals(vsphereVolume, that.vsphereVolume)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(awsElasticBlockStore,  azureDisk,  azureFile,  cephfs,  cinder,  configMap,  csi,  downwardAPI,  emptyDir,  ephemeral,  fc,  flexVolume,  flocker,  gcePersistentDisk,  gitRepo,  glusterfs,  hostPath,  iscsi,  name,  nfs,  persistentVolumeClaim,  photonPersistentDisk,  portworxVolume,  projected,  quobyte,  rbd,  scaleIO,  secret,  storageos,  vsphereVolume,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (awsElasticBlockStore != null) { sb.append("awsElasticBlockStore:"); sb.append(awsElasticBlockStore + ","); }
    if (azureDisk != null) { sb.append("azureDisk:"); sb.append(azureDisk + ","); }
    if (azureFile != null) { sb.append("azureFile:"); sb.append(azureFile + ","); }
    if (cephfs != null) { sb.append("cephfs:"); sb.append(cephfs + ","); }
    if (cinder != null) { sb.append("cinder:"); sb.append(cinder + ","); }
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (csi != null) { sb.append("csi:"); sb.append(csi + ","); }
    if (downwardAPI != null) { sb.append("downwardAPI:"); sb.append(downwardAPI + ","); }
    if (emptyDir != null) { sb.append("emptyDir:"); sb.append(emptyDir + ","); }
    if (ephemeral != null) { sb.append("ephemeral:"); sb.append(ephemeral + ","); }
    if (fc != null) { sb.append("fc:"); sb.append(fc + ","); }
    if (flexVolume != null) { sb.append("flexVolume:"); sb.append(flexVolume + ","); }
    if (flocker != null) { sb.append("flocker:"); sb.append(flocker + ","); }
    if (gcePersistentDisk != null) { sb.append("gcePersistentDisk:"); sb.append(gcePersistentDisk + ","); }
    if (gitRepo != null) { sb.append("gitRepo:"); sb.append(gitRepo + ","); }
    if (glusterfs != null) { sb.append("glusterfs:"); sb.append(glusterfs + ","); }
    if (hostPath != null) { sb.append("hostPath:"); sb.append(hostPath + ","); }
    if (iscsi != null) { sb.append("iscsi:"); sb.append(iscsi + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (nfs != null) { sb.append("nfs:"); sb.append(nfs + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (photonPersistentDisk != null) { sb.append("photonPersistentDisk:"); sb.append(photonPersistentDisk + ","); }
    if (portworxVolume != null) { sb.append("portworxVolume:"); sb.append(portworxVolume + ","); }
    if (projected != null) { sb.append("projected:"); sb.append(projected + ","); }
    if (quobyte != null) { sb.append("quobyte:"); sb.append(quobyte + ","); }
    if (rbd != null) { sb.append("rbd:"); sb.append(rbd + ","); }
    if (scaleIO != null) { sb.append("scaleIO:"); sb.append(scaleIO + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (storageos != null) { sb.append("storageos:"); sb.append(storageos + ","); }
    if (vsphereVolume != null) { sb.append("vsphereVolume:"); sb.append(vsphereVolume + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AwsElasticBlockStoreNested<N> extends AWSElasticBlockStoreVolumeSourceFluent<AwsElasticBlockStoreNested<N>> implements Nested<N>{
    AwsElasticBlockStoreNested(AWSElasticBlockStoreVolumeSource item) {
      this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
    }
    AWSElasticBlockStoreVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withAwsElasticBlockStore(builder.build());
    }
    
    public N endAwsElasticBlockStore() {
      return and();
    }
    
  
  }
  public class AzureDiskNested<N> extends AzureDiskVolumeSourceFluent<AzureDiskNested<N>> implements Nested<N>{
    AzureDiskNested(AzureDiskVolumeSource item) {
      this.builder = new AzureDiskVolumeSourceBuilder(this, item);
    }
    AzureDiskVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withAzureDisk(builder.build());
    }
    
    public N endAzureDisk() {
      return and();
    }
    
  
  }
  public class AzureFileNested<N> extends AzureFileVolumeSourceFluent<AzureFileNested<N>> implements Nested<N>{
    AzureFileNested(AzureFileVolumeSource item) {
      this.builder = new AzureFileVolumeSourceBuilder(this, item);
    }
    AzureFileVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withAzureFile(builder.build());
    }
    
    public N endAzureFile() {
      return and();
    }
    
  
  }
  public class CephfsNested<N> extends CephFSVolumeSourceFluent<CephfsNested<N>> implements Nested<N>{
    CephfsNested(CephFSVolumeSource item) {
      this.builder = new CephFSVolumeSourceBuilder(this, item);
    }
    CephFSVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withCephfs(builder.build());
    }
    
    public N endCephfs() {
      return and();
    }
    
  
  }
  public class CinderNested<N> extends CinderVolumeSourceFluent<CinderNested<N>> implements Nested<N>{
    CinderNested(CinderVolumeSource item) {
      this.builder = new CinderVolumeSourceBuilder(this, item);
    }
    CinderVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withCinder(builder.build());
    }
    
    public N endCinder() {
      return and();
    }
    
  
  }
  public class ConfigMapNested<N> extends ConfigMapVolumeSourceFluent<ConfigMapNested<N>> implements Nested<N>{
    ConfigMapNested(ConfigMapVolumeSource item) {
      this.builder = new ConfigMapVolumeSourceBuilder(this, item);
    }
    ConfigMapVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withConfigMap(builder.build());
    }
    
    public N endConfigMap() {
      return and();
    }
    
  
  }
  public class CsiNested<N> extends CSIVolumeSourceFluent<CsiNested<N>> implements Nested<N>{
    CsiNested(CSIVolumeSource item) {
      this.builder = new CSIVolumeSourceBuilder(this, item);
    }
    CSIVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withCsi(builder.build());
    }
    
    public N endCsi() {
      return and();
    }
    
  
  }
  public class DownwardAPINested<N> extends DownwardAPIVolumeSourceFluent<DownwardAPINested<N>> implements Nested<N>{
    DownwardAPINested(DownwardAPIVolumeSource item) {
      this.builder = new DownwardAPIVolumeSourceBuilder(this, item);
    }
    DownwardAPIVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withDownwardAPI(builder.build());
    }
    
    public N endDownwardAPI() {
      return and();
    }
    
  
  }
  public class EmptyDirNested<N> extends EmptyDirVolumeSourceFluent<EmptyDirNested<N>> implements Nested<N>{
    EmptyDirNested(EmptyDirVolumeSource item) {
      this.builder = new EmptyDirVolumeSourceBuilder(this, item);
    }
    EmptyDirVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withEmptyDir(builder.build());
    }
    
    public N endEmptyDir() {
      return and();
    }
    
  
  }
  public class EphemeralNested<N> extends EphemeralVolumeSourceFluent<EphemeralNested<N>> implements Nested<N>{
    EphemeralNested(EphemeralVolumeSource item) {
      this.builder = new EphemeralVolumeSourceBuilder(this, item);
    }
    EphemeralVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withEphemeral(builder.build());
    }
    
    public N endEphemeral() {
      return and();
    }
    
  
  }
  public class FcNested<N> extends FCVolumeSourceFluent<FcNested<N>> implements Nested<N>{
    FcNested(FCVolumeSource item) {
      this.builder = new FCVolumeSourceBuilder(this, item);
    }
    FCVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withFc(builder.build());
    }
    
    public N endFc() {
      return and();
    }
    
  
  }
  public class FlexVolumeNested<N> extends FlexVolumeSourceFluent<FlexVolumeNested<N>> implements Nested<N>{
    FlexVolumeNested(FlexVolumeSource item) {
      this.builder = new FlexVolumeSourceBuilder(this, item);
    }
    FlexVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withFlexVolume(builder.build());
    }
    
    public N endFlexVolume() {
      return and();
    }
    
  
  }
  public class FlockerNested<N> extends FlockerVolumeSourceFluent<FlockerNested<N>> implements Nested<N>{
    FlockerNested(FlockerVolumeSource item) {
      this.builder = new FlockerVolumeSourceBuilder(this, item);
    }
    FlockerVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withFlocker(builder.build());
    }
    
    public N endFlocker() {
      return and();
    }
    
  
  }
  public class GcePersistentDiskNested<N> extends GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>> implements Nested<N>{
    GcePersistentDiskNested(GCEPersistentDiskVolumeSource item) {
      this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
    }
    GCEPersistentDiskVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withGcePersistentDisk(builder.build());
    }
    
    public N endGcePersistentDisk() {
      return and();
    }
    
  
  }
  public class GitRepoNested<N> extends GitRepoVolumeSourceFluent<GitRepoNested<N>> implements Nested<N>{
    GitRepoNested(GitRepoVolumeSource item) {
      this.builder = new GitRepoVolumeSourceBuilder(this, item);
    }
    GitRepoVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withGitRepo(builder.build());
    }
    
    public N endGitRepo() {
      return and();
    }
    
  
  }
  public class GlusterfsNested<N> extends GlusterfsVolumeSourceFluent<GlusterfsNested<N>> implements Nested<N>{
    GlusterfsNested(GlusterfsVolumeSource item) {
      this.builder = new GlusterfsVolumeSourceBuilder(this, item);
    }
    GlusterfsVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withGlusterfs(builder.build());
    }
    
    public N endGlusterfs() {
      return and();
    }
    
  
  }
  public class HostPathNested<N> extends HostPathVolumeSourceFluent<HostPathNested<N>> implements Nested<N>{
    HostPathNested(HostPathVolumeSource item) {
      this.builder = new HostPathVolumeSourceBuilder(this, item);
    }
    HostPathVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withHostPath(builder.build());
    }
    
    public N endHostPath() {
      return and();
    }
    
  
  }
  public class IscsiNested<N> extends ISCSIVolumeSourceFluent<IscsiNested<N>> implements Nested<N>{
    IscsiNested(ISCSIVolumeSource item) {
      this.builder = new ISCSIVolumeSourceBuilder(this, item);
    }
    ISCSIVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withIscsi(builder.build());
    }
    
    public N endIscsi() {
      return and();
    }
    
  
  }
  public class NfsNested<N> extends NFSVolumeSourceFluent<NfsNested<N>> implements Nested<N>{
    NfsNested(NFSVolumeSource item) {
      this.builder = new NFSVolumeSourceBuilder(this, item);
    }
    NFSVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withNfs(builder.build());
    }
    
    public N endNfs() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimNested<N> extends PersistentVolumeClaimVolumeSourceFluent<PersistentVolumeClaimNested<N>> implements Nested<N>{
    PersistentVolumeClaimNested(PersistentVolumeClaimVolumeSource item) {
      this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this, item);
    }
    PersistentVolumeClaimVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withPersistentVolumeClaim(builder.build());
    }
    
    public N endPersistentVolumeClaim() {
      return and();
    }
    
  
  }
  public class PhotonPersistentDiskNested<N> extends PhotonPersistentDiskVolumeSourceFluent<PhotonPersistentDiskNested<N>> implements Nested<N>{
    PhotonPersistentDiskNested(PhotonPersistentDiskVolumeSource item) {
      this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this, item);
    }
    PhotonPersistentDiskVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withPhotonPersistentDisk(builder.build());
    }
    
    public N endPhotonPersistentDisk() {
      return and();
    }
    
  
  }
  public class PortworxVolumeNested<N> extends PortworxVolumeSourceFluent<PortworxVolumeNested<N>> implements Nested<N>{
    PortworxVolumeNested(PortworxVolumeSource item) {
      this.builder = new PortworxVolumeSourceBuilder(this, item);
    }
    PortworxVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withPortworxVolume(builder.build());
    }
    
    public N endPortworxVolume() {
      return and();
    }
    
  
  }
  public class ProjectedNested<N> extends ProjectedVolumeSourceFluent<ProjectedNested<N>> implements Nested<N>{
    ProjectedNested(ProjectedVolumeSource item) {
      this.builder = new ProjectedVolumeSourceBuilder(this, item);
    }
    ProjectedVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withProjected(builder.build());
    }
    
    public N endProjected() {
      return and();
    }
    
  
  }
  public class QuobyteNested<N> extends QuobyteVolumeSourceFluent<QuobyteNested<N>> implements Nested<N>{
    QuobyteNested(QuobyteVolumeSource item) {
      this.builder = new QuobyteVolumeSourceBuilder(this, item);
    }
    QuobyteVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withQuobyte(builder.build());
    }
    
    public N endQuobyte() {
      return and();
    }
    
  
  }
  public class RbdNested<N> extends RBDVolumeSourceFluent<RbdNested<N>> implements Nested<N>{
    RbdNested(RBDVolumeSource item) {
      this.builder = new RBDVolumeSourceBuilder(this, item);
    }
    RBDVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withRbd(builder.build());
    }
    
    public N endRbd() {
      return and();
    }
    
  
  }
  public class ScaleIONested<N> extends ScaleIOVolumeSourceFluent<ScaleIONested<N>> implements Nested<N>{
    ScaleIONested(ScaleIOVolumeSource item) {
      this.builder = new ScaleIOVolumeSourceBuilder(this, item);
    }
    ScaleIOVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withScaleIO(builder.build());
    }
    
    public N endScaleIO() {
      return and();
    }
    
  
  }
  public class SecretNested<N> extends SecretVolumeSourceFluent<SecretNested<N>> implements Nested<N>{
    SecretNested(SecretVolumeSource item) {
      this.builder = new SecretVolumeSourceBuilder(this, item);
    }
    SecretVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withSecret(builder.build());
    }
    
    public N endSecret() {
      return and();
    }
    
  
  }
  public class StorageosNested<N> extends StorageOSVolumeSourceFluent<StorageosNested<N>> implements Nested<N>{
    StorageosNested(StorageOSVolumeSource item) {
      this.builder = new StorageOSVolumeSourceBuilder(this, item);
    }
    StorageOSVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withStorageos(builder.build());
    }
    
    public N endStorageos() {
      return and();
    }
    
  
  }
  public class VsphereVolumeNested<N> extends VsphereVirtualDiskVolumeSourceFluent<VsphereVolumeNested<N>> implements Nested<N>{
    VsphereVolumeNested(VsphereVirtualDiskVolumeSource item) {
      this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
    }
    VsphereVirtualDiskVolumeSourceBuilder builder;
    
    public N and() {
      return (N) VolumeFluent.this.withVsphereVolume(builder.build());
    }
    
    public N endVsphereVolume() {
      return and();
    }
    
  
  }

}