package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VsphereVirtualDiskVolumeSourceFluent<A extends VsphereVirtualDiskVolumeSourceFluent<A>> extends BaseFluent<A>{
  public VsphereVirtualDiskVolumeSourceFluent() {
  }
  
  public VsphereVirtualDiskVolumeSourceFluent(VsphereVirtualDiskVolumeSource instance) {
    this.copyInstance(instance);
  }
  private String fsType;
  private String storagePolicyID;
  private String storagePolicyName;
  private String volumePath;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VsphereVirtualDiskVolumeSource instance) {
    instance = (instance != null ? instance : new VsphereVirtualDiskVolumeSource());
  
    if (instance != null) {
        this.withFsType(instance.getFsType());
        this.withStoragePolicyID(instance.getStoragePolicyID());
        this.withStoragePolicyName(instance.getStoragePolicyName());
        this.withVolumePath(instance.getVolumePath());
        this.withFsType(instance.getFsType());
        this.withStoragePolicyID(instance.getStoragePolicyID());
        this.withStoragePolicyName(instance.getStoragePolicyName());
        this.withVolumePath(instance.getVolumePath());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getFsType() {
    return this.fsType;
  }
  
  public A withFsType(String fsType) {
    this.fsType=fsType; return (A) this;
  }
  
  public boolean hasFsType() {
    return this.fsType != null;
  }
  
  public String getStoragePolicyID() {
    return this.storagePolicyID;
  }
  
  public A withStoragePolicyID(String storagePolicyID) {
    this.storagePolicyID=storagePolicyID; return (A) this;
  }
  
  public boolean hasStoragePolicyID() {
    return this.storagePolicyID != null;
  }
  
  public String getStoragePolicyName() {
    return this.storagePolicyName;
  }
  
  public A withStoragePolicyName(String storagePolicyName) {
    this.storagePolicyName=storagePolicyName; return (A) this;
  }
  
  public boolean hasStoragePolicyName() {
    return this.storagePolicyName != null;
  }
  
  public String getVolumePath() {
    return this.volumePath;
  }
  
  public A withVolumePath(String volumePath) {
    this.volumePath=volumePath; return (A) this;
  }
  
  public boolean hasVolumePath() {
    return this.volumePath != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VsphereVirtualDiskVolumeSourceFluent that = (VsphereVirtualDiskVolumeSourceFluent) o;
    if (!java.util.Objects.equals(fsType, that.fsType)) return false;
  
    if (!java.util.Objects.equals(storagePolicyID, that.storagePolicyID)) return false;
  
    if (!java.util.Objects.equals(storagePolicyName, that.storagePolicyName)) return false;
  
    if (!java.util.Objects.equals(volumePath, that.volumePath)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(fsType,  storagePolicyID,  storagePolicyName,  volumePath,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (storagePolicyID != null) { sb.append("storagePolicyID:"); sb.append(storagePolicyID + ","); }
    if (storagePolicyName != null) { sb.append("storagePolicyName:"); sb.append(storagePolicyName + ","); }
    if (volumePath != null) { sb.append("volumePath:"); sb.append(volumePath + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}