package io.fabric8.kubernetes.api.model;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ContainerPortFluent<A extends ContainerPortFluent<A>> extends BaseFluent<A>{
  public ContainerPortFluent() {
  }
  
  public ContainerPortFluent(ContainerPort instance) {
    this.copyInstance(instance);
  }
  private Integer containerPort;
  private String hostIP;
  private Integer hostPort;
  private String name;
  private String protocol;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ContainerPort instance) {
    instance = (instance != null ? instance : new ContainerPort());
    if (instance != null) {
          this.withContainerPort(instance.getContainerPort());
          this.withHostIP(instance.getHostIP());
          this.withHostPort(instance.getHostPort());
          this.withName(instance.getName());
          this.withProtocol(instance.getProtocol());
          this.withContainerPort(instance.getContainerPort());
          this.withHostIP(instance.getHostIP());
          this.withHostPort(instance.getHostPort());
          this.withName(instance.getName());
          this.withProtocol(instance.getProtocol());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getContainerPort() {
    return this.containerPort;
  }
  
  public A withContainerPort(Integer containerPort) {
    this.containerPort = containerPort;
    return (A) this;
  }
  
  public boolean hasContainerPort() {
    return this.containerPort != null;
  }
  
  public String getHostIP() {
    return this.hostIP;
  }
  
  public A withHostIP(String hostIP) {
    this.hostIP = hostIP;
    return (A) this;
  }
  
  public boolean hasHostIP() {
    return this.hostIP != null;
  }
  
  public Integer getHostPort() {
    return this.hostPort;
  }
  
  public A withHostPort(Integer hostPort) {
    this.hostPort = hostPort;
    return (A) this;
  }
  
  public boolean hasHostPort() {
    return this.hostPort != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getProtocol() {
    return this.protocol;
  }
  
  public A withProtocol(String protocol) {
    this.protocol = protocol;
    return (A) this;
  }
  
  public boolean hasProtocol() {
    return this.protocol != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerPortFluent that = (ContainerPortFluent) o;
    if (!java.util.Objects.equals(containerPort, that.containerPort)) return false;
    if (!java.util.Objects.equals(hostIP, that.hostIP)) return false;
    if (!java.util.Objects.equals(hostPort, that.hostPort)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(protocol, that.protocol)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(containerPort,  hostIP,  hostPort,  name,  protocol,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerPort != null) { sb.append("containerPort:"); sb.append(containerPort + ","); }
    if (hostIP != null) { sb.append("hostIP:"); sb.append(hostIP + ","); }
    if (hostPort != null) { sb.append("hostPort:"); sb.append(hostPort + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (protocol != null) { sb.append("protocol:"); sb.append(protocol + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}