package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FCVolumeSourceFluent<A extends FCVolumeSourceFluent<A>> extends BaseFluent<A>{
  public FCVolumeSourceFluent() {
  }
  
  public FCVolumeSourceFluent(FCVolumeSource instance) {
    this.copyInstance(instance);
  }
  private String fsType;
  private Integer lun;
  private Boolean readOnly;
  private List<String> targetWWNs = new ArrayList<String>();
  private List<String> wwids = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(FCVolumeSource instance) {
    instance = (instance != null ? instance : new FCVolumeSource());
    if (instance != null) {
          this.withFsType(instance.getFsType());
          this.withLun(instance.getLun());
          this.withReadOnly(instance.getReadOnly());
          this.withTargetWWNs(instance.getTargetWWNs());
          this.withWwids(instance.getWwids());
          this.withFsType(instance.getFsType());
          this.withLun(instance.getLun());
          this.withReadOnly(instance.getReadOnly());
          this.withTargetWWNs(instance.getTargetWWNs());
          this.withWwids(instance.getWwids());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getFsType() {
    return this.fsType;
  }
  
  public A withFsType(String fsType) {
    this.fsType = fsType;
    return (A) this;
  }
  
  public boolean hasFsType() {
    return this.fsType != null;
  }
  
  public Integer getLun() {
    return this.lun;
  }
  
  public A withLun(Integer lun) {
    this.lun = lun;
    return (A) this;
  }
  
  public boolean hasLun() {
    return this.lun != null;
  }
  
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  public A withReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
    return (A) this;
  }
  
  public boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  public A addToTargetWWNs(int index,String item) {
    if (this.targetWWNs == null) {this.targetWWNs = new ArrayList<String>();}
    this.targetWWNs.add(index, item);
    return (A)this;
  }
  
  public A setToTargetWWNs(int index,String item) {
    if (this.targetWWNs == null) {this.targetWWNs = new ArrayList<String>();}
    this.targetWWNs.set(index, item); return (A)this;
  }
  
  public A addToTargetWWNs(java.lang.String... items) {
    if (this.targetWWNs == null) {this.targetWWNs = new ArrayList<String>();}
    for (String item : items) {this.targetWWNs.add(item);} return (A)this;
  }
  
  public A addAllToTargetWWNs(Collection<String> items) {
    if (this.targetWWNs == null) {this.targetWWNs = new ArrayList<String>();}
    for (String item : items) {this.targetWWNs.add(item);} return (A)this;
  }
  
  public A removeFromTargetWWNs(java.lang.String... items) {
    if (this.targetWWNs == null) return (A)this;
    for (String item : items) { this.targetWWNs.remove(item);} return (A)this;
  }
  
  public A removeAllFromTargetWWNs(Collection<String> items) {
    if (this.targetWWNs == null) return (A)this;
    for (String item : items) { this.targetWWNs.remove(item);} return (A)this;
  }
  
  public List<String> getTargetWWNs() {
    return this.targetWWNs;
  }
  
  public String getTargetWWN(int index) {
    return this.targetWWNs.get(index);
  }
  
  public String getFirstTargetWWN() {
    return this.targetWWNs.get(0);
  }
  
  public String getLastTargetWWN() {
    return this.targetWWNs.get(targetWWNs.size() - 1);
  }
  
  public String getMatchingTargetWWN(Predicate<String> predicate) {
      for (String item : targetWWNs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingTargetWWN(Predicate<String> predicate) {
      for (String item : targetWWNs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTargetWWNs(List<String> targetWWNs) {
    if (targetWWNs != null) {
        this.targetWWNs = new ArrayList();
        for (String item : targetWWNs) {
          this.addToTargetWWNs(item);
        }
    } else {
      this.targetWWNs = null;
    }
    return (A) this;
  }
  
  public A withTargetWWNs(java.lang.String... targetWWNs) {
    if (this.targetWWNs != null) {this.targetWWNs.clear(); _visitables.remove("targetWWNs"); }
    if (targetWWNs != null) {for (String item :targetWWNs){ this.addToTargetWWNs(item);}} return (A) this;
  }
  
  public boolean hasTargetWWNs() {
    return this.targetWWNs != null && !this.targetWWNs.isEmpty();
  }
  
  public A addToWwids(int index,String item) {
    if (this.wwids == null) {this.wwids = new ArrayList<String>();}
    this.wwids.add(index, item);
    return (A)this;
  }
  
  public A setToWwids(int index,String item) {
    if (this.wwids == null) {this.wwids = new ArrayList<String>();}
    this.wwids.set(index, item); return (A)this;
  }
  
  public A addToWwids(java.lang.String... items) {
    if (this.wwids == null) {this.wwids = new ArrayList<String>();}
    for (String item : items) {this.wwids.add(item);} return (A)this;
  }
  
  public A addAllToWwids(Collection<String> items) {
    if (this.wwids == null) {this.wwids = new ArrayList<String>();}
    for (String item : items) {this.wwids.add(item);} return (A)this;
  }
  
  public A removeFromWwids(java.lang.String... items) {
    if (this.wwids == null) return (A)this;
    for (String item : items) { this.wwids.remove(item);} return (A)this;
  }
  
  public A removeAllFromWwids(Collection<String> items) {
    if (this.wwids == null) return (A)this;
    for (String item : items) { this.wwids.remove(item);} return (A)this;
  }
  
  public List<String> getWwids() {
    return this.wwids;
  }
  
  public String getWwid(int index) {
    return this.wwids.get(index);
  }
  
  public String getFirstWwid() {
    return this.wwids.get(0);
  }
  
  public String getLastWwid() {
    return this.wwids.get(wwids.size() - 1);
  }
  
  public String getMatchingWwid(Predicate<String> predicate) {
      for (String item : wwids) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingWwid(Predicate<String> predicate) {
      for (String item : wwids) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWwids(List<String> wwids) {
    if (wwids != null) {
        this.wwids = new ArrayList();
        for (String item : wwids) {
          this.addToWwids(item);
        }
    } else {
      this.wwids = null;
    }
    return (A) this;
  }
  
  public A withWwids(java.lang.String... wwids) {
    if (this.wwids != null) {this.wwids.clear(); _visitables.remove("wwids"); }
    if (wwids != null) {for (String item :wwids){ this.addToWwids(item);}} return (A) this;
  }
  
  public boolean hasWwids() {
    return this.wwids != null && !this.wwids.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FCVolumeSourceFluent that = (FCVolumeSourceFluent) o;
    if (!java.util.Objects.equals(fsType, that.fsType)) return false;
    if (!java.util.Objects.equals(lun, that.lun)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    if (!java.util.Objects.equals(targetWWNs, that.targetWWNs)) return false;
    if (!java.util.Objects.equals(wwids, that.wwids)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(fsType,  lun,  readOnly,  targetWWNs,  wwids,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (lun != null) { sb.append("lun:"); sb.append(lun + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (targetWWNs != null && !targetWWNs.isEmpty()) { sb.append("targetWWNs:"); sb.append(targetWWNs + ","); }
    if (wwids != null && !wwids.isEmpty()) { sb.append("wwids:"); sb.append(wwids + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReadOnly() {
    return withReadOnly(true);
  }
  

}