package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GitRepoVolumeSourceFluent<A extends GitRepoVolumeSourceFluent<A>> extends BaseFluent<A>{
  public GitRepoVolumeSourceFluent() {
  }
  
  public GitRepoVolumeSourceFluent(GitRepoVolumeSource instance) {
    this.copyInstance(instance);
  }
  private String directory;
  private String repository;
  private String revision;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GitRepoVolumeSource instance) {
    instance = (instance != null ? instance : new GitRepoVolumeSource());
    if (instance != null) {
          this.withDirectory(instance.getDirectory());
          this.withRepository(instance.getRepository());
          this.withRevision(instance.getRevision());
          this.withDirectory(instance.getDirectory());
          this.withRepository(instance.getRepository());
          this.withRevision(instance.getRevision());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getDirectory() {
    return this.directory;
  }
  
  public A withDirectory(String directory) {
    this.directory = directory;
    return (A) this;
  }
  
  public boolean hasDirectory() {
    return this.directory != null;
  }
  
  public String getRepository() {
    return this.repository;
  }
  
  public A withRepository(String repository) {
    this.repository = repository;
    return (A) this;
  }
  
  public boolean hasRepository() {
    return this.repository != null;
  }
  
  public String getRevision() {
    return this.revision;
  }
  
  public A withRevision(String revision) {
    this.revision = revision;
    return (A) this;
  }
  
  public boolean hasRevision() {
    return this.revision != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitRepoVolumeSourceFluent that = (GitRepoVolumeSourceFluent) o;
    if (!java.util.Objects.equals(directory, that.directory)) return false;
    if (!java.util.Objects.equals(repository, that.repository)) return false;
    if (!java.util.Objects.equals(revision, that.revision)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(directory,  repository,  revision,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (directory != null) { sb.append("directory:"); sb.append(directory + ","); }
    if (repository != null) { sb.append("repository:"); sb.append(repository + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}