package io.fabric8.kubernetes.api.model;

import java.lang.String;
import java.lang.Long;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.version.Info;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.version.InfoFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.version.InfoBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KubeSchemaFluent<A extends KubeSchemaFluent<A>> extends BaseFluent<A>{
  public KubeSchemaFluent() {
  }
  
  public KubeSchemaFluent(KubeSchema instance) {
    this.copyInstance(instance);
  }
  private APIGroupBuilder aPIGroup;
  private APIGroupListBuilder aPIGroupList;
  private APIResourceBuilder aPIResource;
  private APIResourceListBuilder aPIResourceList;
  private APIServiceBuilder aPIService;
  private APIServiceListBuilder aPIServiceList;
  private BindingBuilder binding;
  private ComponentStatusBuilder componentStatus;
  private ComponentStatusListBuilder componentStatusList;
  private ConditionBuilder condition;
  private ConfigBuilder config;
  private ConfigMapBuilder configMap;
  private ConfigMapListBuilder configMapList;
  private ContainerStatusBuilder containerStatus;
  private CreateOptionsBuilder createOptions;
  private DeleteOptionsBuilder deleteOptions;
  private EndpointPortBuilder endpointPort;
  private EndpointsBuilder endpoints;
  private EndpointsListBuilder endpointsList;
  private EnvVarBuilder envVar;
  private EventBuilder event;
  private EventListBuilder eventList;
  private EventSeriesBuilder eventSeries;
  private EventSourceBuilder eventSource;
  private GetOptionsBuilder getOptions;
  private GroupKindBuilder groupKind;
  private GroupVersionKindBuilder groupVersionKind;
  private GroupVersionResourceBuilder groupVersionResource;
  private InfoBuilder info;
  private KubernetesListBuilder kubernetesList;
  private LimitRangeListBuilder limitRangeList;
  private ListOptionsBuilder listOptions;
  private MicroTimeBuilder microTime;
  private NamespaceBuilder namespace;
  private NamespaceListBuilder namespaceList;
  private NodeBuilder node;
  private NodeListBuilder nodeList;
  private ObjectMetaBuilder objectMeta;
  private PatchBuilder patch;
  private PatchOptionsBuilder patchOptions;
  private PersistentVolumeBuilder persistentVolume;
  private PersistentVolumeClaimBuilder persistentVolumeClaim;
  private PersistentVolumeClaimListBuilder persistentVolumeClaimList;
  private PersistentVolumeListBuilder persistentVolumeList;
  private PodExecOptionsBuilder podExecOptions;
  private PodListBuilder podList;
  private PodTemplateListBuilder podTemplateList;
  private QuantityBuilder quantity;
  private ReplicationControllerListBuilder replicationControllerList;
  private ResourceQuotaBuilder resourceQuota;
  private ResourceQuotaListBuilder resourceQuotaList;
  private RootPathsBuilder rootPaths;
  private SecretBuilder secret;
  private SecretListBuilder secretList;
  private ServiceAccountBuilder serviceAccount;
  private ServiceAccountListBuilder serviceAccountList;
  private ServiceListBuilder serviceList;
  private StatusBuilder status;
  private String time;
  private TolerationBuilder toleration;
  private TopologySelectorTermBuilder topologySelectorTerm;
  private TypeMetaBuilder typeMeta;
  private UpdateOptionsBuilder updateOptions;
  private WatchEventBuilder watchEvent;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(KubeSchema instance) {
    instance = (instance != null ? instance : new KubeSchema());
    if (instance != null) {
          this.withAPIGroup(instance.getAPIGroup());
          this.withAPIGroupList(instance.getAPIGroupList());
          this.withAPIResource(instance.getAPIResource());
          this.withAPIResourceList(instance.getAPIResourceList());
          this.withAPIService(instance.getAPIService());
          this.withAPIServiceList(instance.getAPIServiceList());
          this.withBinding(instance.getBinding());
          this.withComponentStatus(instance.getComponentStatus());
          this.withComponentStatusList(instance.getComponentStatusList());
          this.withCondition(instance.getCondition());
          this.withConfig(instance.getConfig());
          this.withConfigMap(instance.getConfigMap());
          this.withConfigMapList(instance.getConfigMapList());
          this.withContainerStatus(instance.getContainerStatus());
          this.withCreateOptions(instance.getCreateOptions());
          this.withDeleteOptions(instance.getDeleteOptions());
          this.withEndpointPort(instance.getEndpointPort());
          this.withEndpoints(instance.getEndpoints());
          this.withEndpointsList(instance.getEndpointsList());
          this.withEnvVar(instance.getEnvVar());
          this.withEvent(instance.getEvent());
          this.withEventList(instance.getEventList());
          this.withEventSeries(instance.getEventSeries());
          this.withEventSource(instance.getEventSource());
          this.withGetOptions(instance.getGetOptions());
          this.withGroupKind(instance.getGroupKind());
          this.withGroupVersionKind(instance.getGroupVersionKind());
          this.withGroupVersionResource(instance.getGroupVersionResource());
          this.withInfo(instance.getInfo());
          this.withKubernetesList(instance.getKubernetesList());
          this.withLimitRangeList(instance.getLimitRangeList());
          this.withListOptions(instance.getListOptions());
          this.withMicroTime(instance.getMicroTime());
          this.withNamespace(instance.getNamespace());
          this.withNamespaceList(instance.getNamespaceList());
          this.withNode(instance.getNode());
          this.withNodeList(instance.getNodeList());
          this.withObjectMeta(instance.getObjectMeta());
          this.withPatch(instance.getPatch());
          this.withPatchOptions(instance.getPatchOptions());
          this.withPersistentVolume(instance.getPersistentVolume());
          this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
          this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
          this.withPersistentVolumeList(instance.getPersistentVolumeList());
          this.withPodExecOptions(instance.getPodExecOptions());
          this.withPodList(instance.getPodList());
          this.withPodTemplateList(instance.getPodTemplateList());
          this.withQuantity(instance.getQuantity());
          this.withReplicationControllerList(instance.getReplicationControllerList());
          this.withResourceQuota(instance.getResourceQuota());
          this.withResourceQuotaList(instance.getResourceQuotaList());
          this.withRootPaths(instance.getRootPaths());
          this.withSecret(instance.getSecret());
          this.withSecretList(instance.getSecretList());
          this.withServiceAccount(instance.getServiceAccount());
          this.withServiceAccountList(instance.getServiceAccountList());
          this.withServiceList(instance.getServiceList());
          this.withStatus(instance.getStatus());
          this.withTime(instance.getTime());
          this.withToleration(instance.getToleration());
          this.withTopologySelectorTerm(instance.getTopologySelectorTerm());
          this.withTypeMeta(instance.getTypeMeta());
          this.withUpdateOptions(instance.getUpdateOptions());
          this.withWatchEvent(instance.getWatchEvent());
          this.withAPIGroup(instance.getAPIGroup());
          this.withAPIGroupList(instance.getAPIGroupList());
          this.withAPIResource(instance.getAPIResource());
          this.withAPIResourceList(instance.getAPIResourceList());
          this.withAPIService(instance.getAPIService());
          this.withAPIServiceList(instance.getAPIServiceList());
          this.withBinding(instance.getBinding());
          this.withComponentStatus(instance.getComponentStatus());
          this.withComponentStatusList(instance.getComponentStatusList());
          this.withCondition(instance.getCondition());
          this.withConfig(instance.getConfig());
          this.withConfigMap(instance.getConfigMap());
          this.withConfigMapList(instance.getConfigMapList());
          this.withContainerStatus(instance.getContainerStatus());
          this.withCreateOptions(instance.getCreateOptions());
          this.withDeleteOptions(instance.getDeleteOptions());
          this.withEndpointPort(instance.getEndpointPort());
          this.withEndpoints(instance.getEndpoints());
          this.withEndpointsList(instance.getEndpointsList());
          this.withEnvVar(instance.getEnvVar());
          this.withEvent(instance.getEvent());
          this.withEventList(instance.getEventList());
          this.withEventSeries(instance.getEventSeries());
          this.withEventSource(instance.getEventSource());
          this.withGetOptions(instance.getGetOptions());
          this.withGroupKind(instance.getGroupKind());
          this.withGroupVersionKind(instance.getGroupVersionKind());
          this.withGroupVersionResource(instance.getGroupVersionResource());
          this.withInfo(instance.getInfo());
          this.withKubernetesList(instance.getKubernetesList());
          this.withLimitRangeList(instance.getLimitRangeList());
          this.withListOptions(instance.getListOptions());
          this.withMicroTime(instance.getMicroTime());
          this.withNamespace(instance.getNamespace());
          this.withNamespaceList(instance.getNamespaceList());
          this.withNode(instance.getNode());
          this.withNodeList(instance.getNodeList());
          this.withObjectMeta(instance.getObjectMeta());
          this.withPatch(instance.getPatch());
          this.withPatchOptions(instance.getPatchOptions());
          this.withPersistentVolume(instance.getPersistentVolume());
          this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
          this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
          this.withPersistentVolumeList(instance.getPersistentVolumeList());
          this.withPodExecOptions(instance.getPodExecOptions());
          this.withPodList(instance.getPodList());
          this.withPodTemplateList(instance.getPodTemplateList());
          this.withQuantity(instance.getQuantity());
          this.withReplicationControllerList(instance.getReplicationControllerList());
          this.withResourceQuota(instance.getResourceQuota());
          this.withResourceQuotaList(instance.getResourceQuotaList());
          this.withRootPaths(instance.getRootPaths());
          this.withSecret(instance.getSecret());
          this.withSecretList(instance.getSecretList());
          this.withServiceAccount(instance.getServiceAccount());
          this.withServiceAccountList(instance.getServiceAccountList());
          this.withServiceList(instance.getServiceList());
          this.withStatus(instance.getStatus());
          this.withTime(instance.getTime());
          this.withToleration(instance.getToleration());
          this.withTopologySelectorTerm(instance.getTopologySelectorTerm());
          this.withTypeMeta(instance.getTypeMeta());
          this.withUpdateOptions(instance.getUpdateOptions());
          this.withWatchEvent(instance.getWatchEvent());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public APIGroup buildAPIGroup() {
    return this.aPIGroup != null ? this.aPIGroup.build() : null;
  }
  
  public A withAPIGroup(APIGroup aPIGroup) {
    this._visitables.remove(this.aPIGroup);
    if (aPIGroup != null) {
        this.aPIGroup = new APIGroupBuilder(aPIGroup);
        this._visitables.get("aPIGroup").add(this.aPIGroup);
    } else {
        this.aPIGroup = null;
        this._visitables.get("aPIGroup").remove(this.aPIGroup);
    }
    return (A) this;
  }
  
  public boolean hasAPIGroup() {
    return this.aPIGroup != null;
  }
  
  public APIGroupNested<A> withNewAPIGroup() {
    return new APIGroupNested(null);
  }
  
  public APIGroupNested<A> withNewAPIGroupLike(APIGroup item) {
    return new APIGroupNested(item);
  }
  
  public APIGroupNested<A> editAPIGroup() {
    return withNewAPIGroupLike(java.util.Optional.ofNullable(buildAPIGroup()).orElse(null));
  }
  
  public APIGroupNested<A> editOrNewAPIGroup() {
    return withNewAPIGroupLike(java.util.Optional.ofNullable(buildAPIGroup()).orElse(new APIGroupBuilder().build()));
  }
  
  public APIGroupNested<A> editOrNewAPIGroupLike(APIGroup item) {
    return withNewAPIGroupLike(java.util.Optional.ofNullable(buildAPIGroup()).orElse(item));
  }
  
  public APIGroupList buildAPIGroupList() {
    return this.aPIGroupList != null ? this.aPIGroupList.build() : null;
  }
  
  public A withAPIGroupList(APIGroupList aPIGroupList) {
    this._visitables.remove(this.aPIGroupList);
    if (aPIGroupList != null) {
        this.aPIGroupList = new APIGroupListBuilder(aPIGroupList);
        this._visitables.get("aPIGroupList").add(this.aPIGroupList);
    } else {
        this.aPIGroupList = null;
        this._visitables.get("aPIGroupList").remove(this.aPIGroupList);
    }
    return (A) this;
  }
  
  public boolean hasAPIGroupList() {
    return this.aPIGroupList != null;
  }
  
  public APIGroupListNested<A> withNewAPIGroupList() {
    return new APIGroupListNested(null);
  }
  
  public APIGroupListNested<A> withNewAPIGroupListLike(APIGroupList item) {
    return new APIGroupListNested(item);
  }
  
  public APIGroupListNested<A> editAPIGroupList() {
    return withNewAPIGroupListLike(java.util.Optional.ofNullable(buildAPIGroupList()).orElse(null));
  }
  
  public APIGroupListNested<A> editOrNewAPIGroupList() {
    return withNewAPIGroupListLike(java.util.Optional.ofNullable(buildAPIGroupList()).orElse(new APIGroupListBuilder().build()));
  }
  
  public APIGroupListNested<A> editOrNewAPIGroupListLike(APIGroupList item) {
    return withNewAPIGroupListLike(java.util.Optional.ofNullable(buildAPIGroupList()).orElse(item));
  }
  
  public APIResource buildAPIResource() {
    return this.aPIResource != null ? this.aPIResource.build() : null;
  }
  
  public A withAPIResource(APIResource aPIResource) {
    this._visitables.remove(this.aPIResource);
    if (aPIResource != null) {
        this.aPIResource = new APIResourceBuilder(aPIResource);
        this._visitables.get("aPIResource").add(this.aPIResource);
    } else {
        this.aPIResource = null;
        this._visitables.get("aPIResource").remove(this.aPIResource);
    }
    return (A) this;
  }
  
  public boolean hasAPIResource() {
    return this.aPIResource != null;
  }
  
  public APIResourceNested<A> withNewAPIResource() {
    return new APIResourceNested(null);
  }
  
  public APIResourceNested<A> withNewAPIResourceLike(APIResource item) {
    return new APIResourceNested(item);
  }
  
  public APIResourceNested<A> editAPIResource() {
    return withNewAPIResourceLike(java.util.Optional.ofNullable(buildAPIResource()).orElse(null));
  }
  
  public APIResourceNested<A> editOrNewAPIResource() {
    return withNewAPIResourceLike(java.util.Optional.ofNullable(buildAPIResource()).orElse(new APIResourceBuilder().build()));
  }
  
  public APIResourceNested<A> editOrNewAPIResourceLike(APIResource item) {
    return withNewAPIResourceLike(java.util.Optional.ofNullable(buildAPIResource()).orElse(item));
  }
  
  public APIResourceList buildAPIResourceList() {
    return this.aPIResourceList != null ? this.aPIResourceList.build() : null;
  }
  
  public A withAPIResourceList(APIResourceList aPIResourceList) {
    this._visitables.remove(this.aPIResourceList);
    if (aPIResourceList != null) {
        this.aPIResourceList = new APIResourceListBuilder(aPIResourceList);
        this._visitables.get("aPIResourceList").add(this.aPIResourceList);
    } else {
        this.aPIResourceList = null;
        this._visitables.get("aPIResourceList").remove(this.aPIResourceList);
    }
    return (A) this;
  }
  
  public boolean hasAPIResourceList() {
    return this.aPIResourceList != null;
  }
  
  public APIResourceListNested<A> withNewAPIResourceList() {
    return new APIResourceListNested(null);
  }
  
  public APIResourceListNested<A> withNewAPIResourceListLike(APIResourceList item) {
    return new APIResourceListNested(item);
  }
  
  public APIResourceListNested<A> editAPIResourceList() {
    return withNewAPIResourceListLike(java.util.Optional.ofNullable(buildAPIResourceList()).orElse(null));
  }
  
  public APIResourceListNested<A> editOrNewAPIResourceList() {
    return withNewAPIResourceListLike(java.util.Optional.ofNullable(buildAPIResourceList()).orElse(new APIResourceListBuilder().build()));
  }
  
  public APIResourceListNested<A> editOrNewAPIResourceListLike(APIResourceList item) {
    return withNewAPIResourceListLike(java.util.Optional.ofNullable(buildAPIResourceList()).orElse(item));
  }
  
  public APIService buildAPIService() {
    return this.aPIService != null ? this.aPIService.build() : null;
  }
  
  public A withAPIService(APIService aPIService) {
    this._visitables.remove(this.aPIService);
    if (aPIService != null) {
        this.aPIService = new APIServiceBuilder(aPIService);
        this._visitables.get("aPIService").add(this.aPIService);
    } else {
        this.aPIService = null;
        this._visitables.get("aPIService").remove(this.aPIService);
    }
    return (A) this;
  }
  
  public boolean hasAPIService() {
    return this.aPIService != null;
  }
  
  public APIServiceNested<A> withNewAPIService() {
    return new APIServiceNested(null);
  }
  
  public APIServiceNested<A> withNewAPIServiceLike(APIService item) {
    return new APIServiceNested(item);
  }
  
  public APIServiceNested<A> editAPIService() {
    return withNewAPIServiceLike(java.util.Optional.ofNullable(buildAPIService()).orElse(null));
  }
  
  public APIServiceNested<A> editOrNewAPIService() {
    return withNewAPIServiceLike(java.util.Optional.ofNullable(buildAPIService()).orElse(new APIServiceBuilder().build()));
  }
  
  public APIServiceNested<A> editOrNewAPIServiceLike(APIService item) {
    return withNewAPIServiceLike(java.util.Optional.ofNullable(buildAPIService()).orElse(item));
  }
  
  public APIServiceList buildAPIServiceList() {
    return this.aPIServiceList != null ? this.aPIServiceList.build() : null;
  }
  
  public A withAPIServiceList(APIServiceList aPIServiceList) {
    this._visitables.remove(this.aPIServiceList);
    if (aPIServiceList != null) {
        this.aPIServiceList = new APIServiceListBuilder(aPIServiceList);
        this._visitables.get("aPIServiceList").add(this.aPIServiceList);
    } else {
        this.aPIServiceList = null;
        this._visitables.get("aPIServiceList").remove(this.aPIServiceList);
    }
    return (A) this;
  }
  
  public boolean hasAPIServiceList() {
    return this.aPIServiceList != null;
  }
  
  public APIServiceListNested<A> withNewAPIServiceList() {
    return new APIServiceListNested(null);
  }
  
  public APIServiceListNested<A> withNewAPIServiceListLike(APIServiceList item) {
    return new APIServiceListNested(item);
  }
  
  public APIServiceListNested<A> editAPIServiceList() {
    return withNewAPIServiceListLike(java.util.Optional.ofNullable(buildAPIServiceList()).orElse(null));
  }
  
  public APIServiceListNested<A> editOrNewAPIServiceList() {
    return withNewAPIServiceListLike(java.util.Optional.ofNullable(buildAPIServiceList()).orElse(new APIServiceListBuilder().build()));
  }
  
  public APIServiceListNested<A> editOrNewAPIServiceListLike(APIServiceList item) {
    return withNewAPIServiceListLike(java.util.Optional.ofNullable(buildAPIServiceList()).orElse(item));
  }
  
  public Binding buildBinding() {
    return this.binding != null ? this.binding.build() : null;
  }
  
  public A withBinding(Binding binding) {
    this._visitables.remove(this.binding);
    if (binding != null) {
        this.binding = new BindingBuilder(binding);
        this._visitables.get("binding").add(this.binding);
    } else {
        this.binding = null;
        this._visitables.get("binding").remove(this.binding);
    }
    return (A) this;
  }
  
  public boolean hasBinding() {
    return this.binding != null;
  }
  
  public BindingNested<A> withNewBinding() {
    return new BindingNested(null);
  }
  
  public BindingNested<A> withNewBindingLike(Binding item) {
    return new BindingNested(item);
  }
  
  public BindingNested<A> editBinding() {
    return withNewBindingLike(java.util.Optional.ofNullable(buildBinding()).orElse(null));
  }
  
  public BindingNested<A> editOrNewBinding() {
    return withNewBindingLike(java.util.Optional.ofNullable(buildBinding()).orElse(new BindingBuilder().build()));
  }
  
  public BindingNested<A> editOrNewBindingLike(Binding item) {
    return withNewBindingLike(java.util.Optional.ofNullable(buildBinding()).orElse(item));
  }
  
  public ComponentStatus buildComponentStatus() {
    return this.componentStatus != null ? this.componentStatus.build() : null;
  }
  
  public A withComponentStatus(ComponentStatus componentStatus) {
    this._visitables.remove(this.componentStatus);
    if (componentStatus != null) {
        this.componentStatus = new ComponentStatusBuilder(componentStatus);
        this._visitables.get("componentStatus").add(this.componentStatus);
    } else {
        this.componentStatus = null;
        this._visitables.get("componentStatus").remove(this.componentStatus);
    }
    return (A) this;
  }
  
  public boolean hasComponentStatus() {
    return this.componentStatus != null;
  }
  
  public ComponentStatusNested<A> withNewComponentStatus() {
    return new ComponentStatusNested(null);
  }
  
  public ComponentStatusNested<A> withNewComponentStatusLike(ComponentStatus item) {
    return new ComponentStatusNested(item);
  }
  
  public ComponentStatusNested<A> editComponentStatus() {
    return withNewComponentStatusLike(java.util.Optional.ofNullable(buildComponentStatus()).orElse(null));
  }
  
  public ComponentStatusNested<A> editOrNewComponentStatus() {
    return withNewComponentStatusLike(java.util.Optional.ofNullable(buildComponentStatus()).orElse(new ComponentStatusBuilder().build()));
  }
  
  public ComponentStatusNested<A> editOrNewComponentStatusLike(ComponentStatus item) {
    return withNewComponentStatusLike(java.util.Optional.ofNullable(buildComponentStatus()).orElse(item));
  }
  
  public ComponentStatusList buildComponentStatusList() {
    return this.componentStatusList != null ? this.componentStatusList.build() : null;
  }
  
  public A withComponentStatusList(ComponentStatusList componentStatusList) {
    this._visitables.remove(this.componentStatusList);
    if (componentStatusList != null) {
        this.componentStatusList = new ComponentStatusListBuilder(componentStatusList);
        this._visitables.get("componentStatusList").add(this.componentStatusList);
    } else {
        this.componentStatusList = null;
        this._visitables.get("componentStatusList").remove(this.componentStatusList);
    }
    return (A) this;
  }
  
  public boolean hasComponentStatusList() {
    return this.componentStatusList != null;
  }
  
  public ComponentStatusListNested<A> withNewComponentStatusList() {
    return new ComponentStatusListNested(null);
  }
  
  public ComponentStatusListNested<A> withNewComponentStatusListLike(ComponentStatusList item) {
    return new ComponentStatusListNested(item);
  }
  
  public ComponentStatusListNested<A> editComponentStatusList() {
    return withNewComponentStatusListLike(java.util.Optional.ofNullable(buildComponentStatusList()).orElse(null));
  }
  
  public ComponentStatusListNested<A> editOrNewComponentStatusList() {
    return withNewComponentStatusListLike(java.util.Optional.ofNullable(buildComponentStatusList()).orElse(new ComponentStatusListBuilder().build()));
  }
  
  public ComponentStatusListNested<A> editOrNewComponentStatusListLike(ComponentStatusList item) {
    return withNewComponentStatusListLike(java.util.Optional.ofNullable(buildComponentStatusList()).orElse(item));
  }
  
  public Condition buildCondition() {
    return this.condition != null ? this.condition.build() : null;
  }
  
  public A withCondition(Condition condition) {
    this._visitables.remove(this.condition);
    if (condition != null) {
        this.condition = new ConditionBuilder(condition);
        this._visitables.get("condition").add(this.condition);
    } else {
        this.condition = null;
        this._visitables.get("condition").remove(this.condition);
    }
    return (A) this;
  }
  
  public boolean hasCondition() {
    return this.condition != null;
  }
  
  public ConditionNested<A> withNewCondition() {
    return new ConditionNested(null);
  }
  
  public ConditionNested<A> withNewConditionLike(Condition item) {
    return new ConditionNested(item);
  }
  
  public ConditionNested<A> editCondition() {
    return withNewConditionLike(java.util.Optional.ofNullable(buildCondition()).orElse(null));
  }
  
  public ConditionNested<A> editOrNewCondition() {
    return withNewConditionLike(java.util.Optional.ofNullable(buildCondition()).orElse(new ConditionBuilder().build()));
  }
  
  public ConditionNested<A> editOrNewConditionLike(Condition item) {
    return withNewConditionLike(java.util.Optional.ofNullable(buildCondition()).orElse(item));
  }
  
  public Config buildConfig() {
    return this.config != null ? this.config.build() : null;
  }
  
  public A withConfig(Config config) {
    this._visitables.remove(this.config);
    if (config != null) {
        this.config = new ConfigBuilder(config);
        this._visitables.get("config").add(this.config);
    } else {
        this.config = null;
        this._visitables.get("config").remove(this.config);
    }
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public ConfigNested<A> withNewConfig() {
    return new ConfigNested(null);
  }
  
  public ConfigNested<A> withNewConfigLike(Config item) {
    return new ConfigNested(item);
  }
  
  public ConfigNested<A> editConfig() {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(null));
  }
  
  public ConfigNested<A> editOrNewConfig() {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(new ConfigBuilder().build()));
  }
  
  public ConfigNested<A> editOrNewConfigLike(Config item) {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(item));
  }
  
  public ConfigMap buildConfigMap() {
    return this.configMap != null ? this.configMap.build() : null;
  }
  
  public A withConfigMap(ConfigMap configMap) {
    this._visitables.remove(this.configMap);
    if (configMap != null) {
        this.configMap = new ConfigMapBuilder(configMap);
        this._visitables.get("configMap").add(this.configMap);
    } else {
        this.configMap = null;
        this._visitables.get("configMap").remove(this.configMap);
    }
    return (A) this;
  }
  
  public boolean hasConfigMap() {
    return this.configMap != null;
  }
  
  public ConfigMapNested<A> withNewConfigMap() {
    return new ConfigMapNested(null);
  }
  
  public ConfigMapNested<A> withNewConfigMapLike(ConfigMap item) {
    return new ConfigMapNested(item);
  }
  
  public ConfigMapNested<A> editConfigMap() {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(null));
  }
  
  public ConfigMapNested<A> editOrNewConfigMap() {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(new ConfigMapBuilder().build()));
  }
  
  public ConfigMapNested<A> editOrNewConfigMapLike(ConfigMap item) {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(item));
  }
  
  public ConfigMapList buildConfigMapList() {
    return this.configMapList != null ? this.configMapList.build() : null;
  }
  
  public A withConfigMapList(ConfigMapList configMapList) {
    this._visitables.remove(this.configMapList);
    if (configMapList != null) {
        this.configMapList = new ConfigMapListBuilder(configMapList);
        this._visitables.get("configMapList").add(this.configMapList);
    } else {
        this.configMapList = null;
        this._visitables.get("configMapList").remove(this.configMapList);
    }
    return (A) this;
  }
  
  public boolean hasConfigMapList() {
    return this.configMapList != null;
  }
  
  public ConfigMapListNested<A> withNewConfigMapList() {
    return new ConfigMapListNested(null);
  }
  
  public ConfigMapListNested<A> withNewConfigMapListLike(ConfigMapList item) {
    return new ConfigMapListNested(item);
  }
  
  public ConfigMapListNested<A> editConfigMapList() {
    return withNewConfigMapListLike(java.util.Optional.ofNullable(buildConfigMapList()).orElse(null));
  }
  
  public ConfigMapListNested<A> editOrNewConfigMapList() {
    return withNewConfigMapListLike(java.util.Optional.ofNullable(buildConfigMapList()).orElse(new ConfigMapListBuilder().build()));
  }
  
  public ConfigMapListNested<A> editOrNewConfigMapListLike(ConfigMapList item) {
    return withNewConfigMapListLike(java.util.Optional.ofNullable(buildConfigMapList()).orElse(item));
  }
  
  public ContainerStatus buildContainerStatus() {
    return this.containerStatus != null ? this.containerStatus.build() : null;
  }
  
  public A withContainerStatus(ContainerStatus containerStatus) {
    this._visitables.remove(this.containerStatus);
    if (containerStatus != null) {
        this.containerStatus = new ContainerStatusBuilder(containerStatus);
        this._visitables.get("containerStatus").add(this.containerStatus);
    } else {
        this.containerStatus = null;
        this._visitables.get("containerStatus").remove(this.containerStatus);
    }
    return (A) this;
  }
  
  public boolean hasContainerStatus() {
    return this.containerStatus != null;
  }
  
  public ContainerStatusNested<A> withNewContainerStatus() {
    return new ContainerStatusNested(null);
  }
  
  public ContainerStatusNested<A> withNewContainerStatusLike(ContainerStatus item) {
    return new ContainerStatusNested(item);
  }
  
  public ContainerStatusNested<A> editContainerStatus() {
    return withNewContainerStatusLike(java.util.Optional.ofNullable(buildContainerStatus()).orElse(null));
  }
  
  public ContainerStatusNested<A> editOrNewContainerStatus() {
    return withNewContainerStatusLike(java.util.Optional.ofNullable(buildContainerStatus()).orElse(new ContainerStatusBuilder().build()));
  }
  
  public ContainerStatusNested<A> editOrNewContainerStatusLike(ContainerStatus item) {
    return withNewContainerStatusLike(java.util.Optional.ofNullable(buildContainerStatus()).orElse(item));
  }
  
  public CreateOptions buildCreateOptions() {
    return this.createOptions != null ? this.createOptions.build() : null;
  }
  
  public A withCreateOptions(CreateOptions createOptions) {
    this._visitables.remove(this.createOptions);
    if (createOptions != null) {
        this.createOptions = new CreateOptionsBuilder(createOptions);
        this._visitables.get("createOptions").add(this.createOptions);
    } else {
        this.createOptions = null;
        this._visitables.get("createOptions").remove(this.createOptions);
    }
    return (A) this;
  }
  
  public boolean hasCreateOptions() {
    return this.createOptions != null;
  }
  
  public CreateOptionsNested<A> withNewCreateOptions() {
    return new CreateOptionsNested(null);
  }
  
  public CreateOptionsNested<A> withNewCreateOptionsLike(CreateOptions item) {
    return new CreateOptionsNested(item);
  }
  
  public CreateOptionsNested<A> editCreateOptions() {
    return withNewCreateOptionsLike(java.util.Optional.ofNullable(buildCreateOptions()).orElse(null));
  }
  
  public CreateOptionsNested<A> editOrNewCreateOptions() {
    return withNewCreateOptionsLike(java.util.Optional.ofNullable(buildCreateOptions()).orElse(new CreateOptionsBuilder().build()));
  }
  
  public CreateOptionsNested<A> editOrNewCreateOptionsLike(CreateOptions item) {
    return withNewCreateOptionsLike(java.util.Optional.ofNullable(buildCreateOptions()).orElse(item));
  }
  
  public DeleteOptions buildDeleteOptions() {
    return this.deleteOptions != null ? this.deleteOptions.build() : null;
  }
  
  public A withDeleteOptions(DeleteOptions deleteOptions) {
    this._visitables.remove(this.deleteOptions);
    if (deleteOptions != null) {
        this.deleteOptions = new DeleteOptionsBuilder(deleteOptions);
        this._visitables.get("deleteOptions").add(this.deleteOptions);
    } else {
        this.deleteOptions = null;
        this._visitables.get("deleteOptions").remove(this.deleteOptions);
    }
    return (A) this;
  }
  
  public boolean hasDeleteOptions() {
    return this.deleteOptions != null;
  }
  
  public DeleteOptionsNested<A> withNewDeleteOptions() {
    return new DeleteOptionsNested(null);
  }
  
  public DeleteOptionsNested<A> withNewDeleteOptionsLike(DeleteOptions item) {
    return new DeleteOptionsNested(item);
  }
  
  public DeleteOptionsNested<A> editDeleteOptions() {
    return withNewDeleteOptionsLike(java.util.Optional.ofNullable(buildDeleteOptions()).orElse(null));
  }
  
  public DeleteOptionsNested<A> editOrNewDeleteOptions() {
    return withNewDeleteOptionsLike(java.util.Optional.ofNullable(buildDeleteOptions()).orElse(new DeleteOptionsBuilder().build()));
  }
  
  public DeleteOptionsNested<A> editOrNewDeleteOptionsLike(DeleteOptions item) {
    return withNewDeleteOptionsLike(java.util.Optional.ofNullable(buildDeleteOptions()).orElse(item));
  }
  
  public EndpointPort buildEndpointPort() {
    return this.endpointPort != null ? this.endpointPort.build() : null;
  }
  
  public A withEndpointPort(EndpointPort endpointPort) {
    this._visitables.remove(this.endpointPort);
    if (endpointPort != null) {
        this.endpointPort = new EndpointPortBuilder(endpointPort);
        this._visitables.get("endpointPort").add(this.endpointPort);
    } else {
        this.endpointPort = null;
        this._visitables.get("endpointPort").remove(this.endpointPort);
    }
    return (A) this;
  }
  
  public boolean hasEndpointPort() {
    return this.endpointPort != null;
  }
  
  public A withNewEndpointPort(String appProtocol,String name,Integer port,String protocol) {
    return (A)withEndpointPort(new EndpointPort(appProtocol, name, port, protocol));
  }
  
  public EndpointPortNested<A> withNewEndpointPort() {
    return new EndpointPortNested(null);
  }
  
  public EndpointPortNested<A> withNewEndpointPortLike(EndpointPort item) {
    return new EndpointPortNested(item);
  }
  
  public EndpointPortNested<A> editEndpointPort() {
    return withNewEndpointPortLike(java.util.Optional.ofNullable(buildEndpointPort()).orElse(null));
  }
  
  public EndpointPortNested<A> editOrNewEndpointPort() {
    return withNewEndpointPortLike(java.util.Optional.ofNullable(buildEndpointPort()).orElse(new EndpointPortBuilder().build()));
  }
  
  public EndpointPortNested<A> editOrNewEndpointPortLike(EndpointPort item) {
    return withNewEndpointPortLike(java.util.Optional.ofNullable(buildEndpointPort()).orElse(item));
  }
  
  public Endpoints buildEndpoints() {
    return this.endpoints != null ? this.endpoints.build() : null;
  }
  
  public A withEndpoints(Endpoints endpoints) {
    this._visitables.remove(this.endpoints);
    if (endpoints != null) {
        this.endpoints = new EndpointsBuilder(endpoints);
        this._visitables.get("endpoints").add(this.endpoints);
    } else {
        this.endpoints = null;
        this._visitables.get("endpoints").remove(this.endpoints);
    }
    return (A) this;
  }
  
  public boolean hasEndpoints() {
    return this.endpoints != null;
  }
  
  public EndpointsNested<A> withNewEndpoints() {
    return new EndpointsNested(null);
  }
  
  public EndpointsNested<A> withNewEndpointsLike(Endpoints item) {
    return new EndpointsNested(item);
  }
  
  public EndpointsNested<A> editEndpoints() {
    return withNewEndpointsLike(java.util.Optional.ofNullable(buildEndpoints()).orElse(null));
  }
  
  public EndpointsNested<A> editOrNewEndpoints() {
    return withNewEndpointsLike(java.util.Optional.ofNullable(buildEndpoints()).orElse(new EndpointsBuilder().build()));
  }
  
  public EndpointsNested<A> editOrNewEndpointsLike(Endpoints item) {
    return withNewEndpointsLike(java.util.Optional.ofNullable(buildEndpoints()).orElse(item));
  }
  
  public EndpointsList buildEndpointsList() {
    return this.endpointsList != null ? this.endpointsList.build() : null;
  }
  
  public A withEndpointsList(EndpointsList endpointsList) {
    this._visitables.remove(this.endpointsList);
    if (endpointsList != null) {
        this.endpointsList = new EndpointsListBuilder(endpointsList);
        this._visitables.get("endpointsList").add(this.endpointsList);
    } else {
        this.endpointsList = null;
        this._visitables.get("endpointsList").remove(this.endpointsList);
    }
    return (A) this;
  }
  
  public boolean hasEndpointsList() {
    return this.endpointsList != null;
  }
  
  public EndpointsListNested<A> withNewEndpointsList() {
    return new EndpointsListNested(null);
  }
  
  public EndpointsListNested<A> withNewEndpointsListLike(EndpointsList item) {
    return new EndpointsListNested(item);
  }
  
  public EndpointsListNested<A> editEndpointsList() {
    return withNewEndpointsListLike(java.util.Optional.ofNullable(buildEndpointsList()).orElse(null));
  }
  
  public EndpointsListNested<A> editOrNewEndpointsList() {
    return withNewEndpointsListLike(java.util.Optional.ofNullable(buildEndpointsList()).orElse(new EndpointsListBuilder().build()));
  }
  
  public EndpointsListNested<A> editOrNewEndpointsListLike(EndpointsList item) {
    return withNewEndpointsListLike(java.util.Optional.ofNullable(buildEndpointsList()).orElse(item));
  }
  
  public EnvVar buildEnvVar() {
    return this.envVar != null ? this.envVar.build() : null;
  }
  
  public A withEnvVar(EnvVar envVar) {
    this._visitables.remove(this.envVar);
    if (envVar != null) {
        this.envVar = new EnvVarBuilder(envVar);
        this._visitables.get("envVar").add(this.envVar);
    } else {
        this.envVar = null;
        this._visitables.get("envVar").remove(this.envVar);
    }
    return (A) this;
  }
  
  public boolean hasEnvVar() {
    return this.envVar != null;
  }
  
  public EnvVarNested<A> withNewEnvVar() {
    return new EnvVarNested(null);
  }
  
  public EnvVarNested<A> withNewEnvVarLike(EnvVar item) {
    return new EnvVarNested(item);
  }
  
  public EnvVarNested<A> editEnvVar() {
    return withNewEnvVarLike(java.util.Optional.ofNullable(buildEnvVar()).orElse(null));
  }
  
  public EnvVarNested<A> editOrNewEnvVar() {
    return withNewEnvVarLike(java.util.Optional.ofNullable(buildEnvVar()).orElse(new EnvVarBuilder().build()));
  }
  
  public EnvVarNested<A> editOrNewEnvVarLike(EnvVar item) {
    return withNewEnvVarLike(java.util.Optional.ofNullable(buildEnvVar()).orElse(item));
  }
  
  public Event buildEvent() {
    return this.event != null ? this.event.build() : null;
  }
  
  public A withEvent(Event event) {
    this._visitables.remove(this.event);
    if (event != null) {
        this.event = new EventBuilder(event);
        this._visitables.get("event").add(this.event);
    } else {
        this.event = null;
        this._visitables.get("event").remove(this.event);
    }
    return (A) this;
  }
  
  public boolean hasEvent() {
    return this.event != null;
  }
  
  public EventNested<A> withNewEvent() {
    return new EventNested(null);
  }
  
  public EventNested<A> withNewEventLike(Event item) {
    return new EventNested(item);
  }
  
  public EventNested<A> editEvent() {
    return withNewEventLike(java.util.Optional.ofNullable(buildEvent()).orElse(null));
  }
  
  public EventNested<A> editOrNewEvent() {
    return withNewEventLike(java.util.Optional.ofNullable(buildEvent()).orElse(new EventBuilder().build()));
  }
  
  public EventNested<A> editOrNewEventLike(Event item) {
    return withNewEventLike(java.util.Optional.ofNullable(buildEvent()).orElse(item));
  }
  
  public EventList buildEventList() {
    return this.eventList != null ? this.eventList.build() : null;
  }
  
  public A withEventList(EventList eventList) {
    this._visitables.remove(this.eventList);
    if (eventList != null) {
        this.eventList = new EventListBuilder(eventList);
        this._visitables.get("eventList").add(this.eventList);
    } else {
        this.eventList = null;
        this._visitables.get("eventList").remove(this.eventList);
    }
    return (A) this;
  }
  
  public boolean hasEventList() {
    return this.eventList != null;
  }
  
  public EventListNested<A> withNewEventList() {
    return new EventListNested(null);
  }
  
  public EventListNested<A> withNewEventListLike(EventList item) {
    return new EventListNested(item);
  }
  
  public EventListNested<A> editEventList() {
    return withNewEventListLike(java.util.Optional.ofNullable(buildEventList()).orElse(null));
  }
  
  public EventListNested<A> editOrNewEventList() {
    return withNewEventListLike(java.util.Optional.ofNullable(buildEventList()).orElse(new EventListBuilder().build()));
  }
  
  public EventListNested<A> editOrNewEventListLike(EventList item) {
    return withNewEventListLike(java.util.Optional.ofNullable(buildEventList()).orElse(item));
  }
  
  public EventSeries buildEventSeries() {
    return this.eventSeries != null ? this.eventSeries.build() : null;
  }
  
  public A withEventSeries(EventSeries eventSeries) {
    this._visitables.remove(this.eventSeries);
    if (eventSeries != null) {
        this.eventSeries = new EventSeriesBuilder(eventSeries);
        this._visitables.get("eventSeries").add(this.eventSeries);
    } else {
        this.eventSeries = null;
        this._visitables.get("eventSeries").remove(this.eventSeries);
    }
    return (A) this;
  }
  
  public boolean hasEventSeries() {
    return this.eventSeries != null;
  }
  
  public EventSeriesNested<A> withNewEventSeries() {
    return new EventSeriesNested(null);
  }
  
  public EventSeriesNested<A> withNewEventSeriesLike(EventSeries item) {
    return new EventSeriesNested(item);
  }
  
  public EventSeriesNested<A> editEventSeries() {
    return withNewEventSeriesLike(java.util.Optional.ofNullable(buildEventSeries()).orElse(null));
  }
  
  public EventSeriesNested<A> editOrNewEventSeries() {
    return withNewEventSeriesLike(java.util.Optional.ofNullable(buildEventSeries()).orElse(new EventSeriesBuilder().build()));
  }
  
  public EventSeriesNested<A> editOrNewEventSeriesLike(EventSeries item) {
    return withNewEventSeriesLike(java.util.Optional.ofNullable(buildEventSeries()).orElse(item));
  }
  
  public EventSource buildEventSource() {
    return this.eventSource != null ? this.eventSource.build() : null;
  }
  
  public A withEventSource(EventSource eventSource) {
    this._visitables.remove(this.eventSource);
    if (eventSource != null) {
        this.eventSource = new EventSourceBuilder(eventSource);
        this._visitables.get("eventSource").add(this.eventSource);
    } else {
        this.eventSource = null;
        this._visitables.get("eventSource").remove(this.eventSource);
    }
    return (A) this;
  }
  
  public boolean hasEventSource() {
    return this.eventSource != null;
  }
  
  public A withNewEventSource(String component,String host) {
    return (A)withEventSource(new EventSource(component, host));
  }
  
  public EventSourceNested<A> withNewEventSource() {
    return new EventSourceNested(null);
  }
  
  public EventSourceNested<A> withNewEventSourceLike(EventSource item) {
    return new EventSourceNested(item);
  }
  
  public EventSourceNested<A> editEventSource() {
    return withNewEventSourceLike(java.util.Optional.ofNullable(buildEventSource()).orElse(null));
  }
  
  public EventSourceNested<A> editOrNewEventSource() {
    return withNewEventSourceLike(java.util.Optional.ofNullable(buildEventSource()).orElse(new EventSourceBuilder().build()));
  }
  
  public EventSourceNested<A> editOrNewEventSourceLike(EventSource item) {
    return withNewEventSourceLike(java.util.Optional.ofNullable(buildEventSource()).orElse(item));
  }
  
  public GetOptions buildGetOptions() {
    return this.getOptions != null ? this.getOptions.build() : null;
  }
  
  public A withGetOptions(GetOptions getOptions) {
    this._visitables.remove(this.getOptions);
    if (getOptions != null) {
        this.getOptions = new GetOptionsBuilder(getOptions);
        this._visitables.get("getOptions").add(this.getOptions);
    } else {
        this.getOptions = null;
        this._visitables.get("getOptions").remove(this.getOptions);
    }
    return (A) this;
  }
  
  public boolean hasGetOptions() {
    return this.getOptions != null;
  }
  
  public A withNewGetOptions(String apiVersion,String kind,String resourceVersion) {
    return (A)withGetOptions(new GetOptions(apiVersion, kind, resourceVersion));
  }
  
  public GetOptionsNested<A> withNewGetOptions() {
    return new GetOptionsNested(null);
  }
  
  public GetOptionsNested<A> withNewGetOptionsLike(GetOptions item) {
    return new GetOptionsNested(item);
  }
  
  public GetOptionsNested<A> editGetOptions() {
    return withNewGetOptionsLike(java.util.Optional.ofNullable(buildGetOptions()).orElse(null));
  }
  
  public GetOptionsNested<A> editOrNewGetOptions() {
    return withNewGetOptionsLike(java.util.Optional.ofNullable(buildGetOptions()).orElse(new GetOptionsBuilder().build()));
  }
  
  public GetOptionsNested<A> editOrNewGetOptionsLike(GetOptions item) {
    return withNewGetOptionsLike(java.util.Optional.ofNullable(buildGetOptions()).orElse(item));
  }
  
  public GroupKind buildGroupKind() {
    return this.groupKind != null ? this.groupKind.build() : null;
  }
  
  public A withGroupKind(GroupKind groupKind) {
    this._visitables.remove(this.groupKind);
    if (groupKind != null) {
        this.groupKind = new GroupKindBuilder(groupKind);
        this._visitables.get("groupKind").add(this.groupKind);
    } else {
        this.groupKind = null;
        this._visitables.get("groupKind").remove(this.groupKind);
    }
    return (A) this;
  }
  
  public boolean hasGroupKind() {
    return this.groupKind != null;
  }
  
  public A withNewGroupKind(String group,String kind) {
    return (A)withGroupKind(new GroupKind(group, kind));
  }
  
  public GroupKindNested<A> withNewGroupKind() {
    return new GroupKindNested(null);
  }
  
  public GroupKindNested<A> withNewGroupKindLike(GroupKind item) {
    return new GroupKindNested(item);
  }
  
  public GroupKindNested<A> editGroupKind() {
    return withNewGroupKindLike(java.util.Optional.ofNullable(buildGroupKind()).orElse(null));
  }
  
  public GroupKindNested<A> editOrNewGroupKind() {
    return withNewGroupKindLike(java.util.Optional.ofNullable(buildGroupKind()).orElse(new GroupKindBuilder().build()));
  }
  
  public GroupKindNested<A> editOrNewGroupKindLike(GroupKind item) {
    return withNewGroupKindLike(java.util.Optional.ofNullable(buildGroupKind()).orElse(item));
  }
  
  public GroupVersionKind buildGroupVersionKind() {
    return this.groupVersionKind != null ? this.groupVersionKind.build() : null;
  }
  
  public A withGroupVersionKind(GroupVersionKind groupVersionKind) {
    this._visitables.remove(this.groupVersionKind);
    if (groupVersionKind != null) {
        this.groupVersionKind = new GroupVersionKindBuilder(groupVersionKind);
        this._visitables.get("groupVersionKind").add(this.groupVersionKind);
    } else {
        this.groupVersionKind = null;
        this._visitables.get("groupVersionKind").remove(this.groupVersionKind);
    }
    return (A) this;
  }
  
  public boolean hasGroupVersionKind() {
    return this.groupVersionKind != null;
  }
  
  public A withNewGroupVersionKind(String group,String kind,String version) {
    return (A)withGroupVersionKind(new GroupVersionKind(group, kind, version));
  }
  
  public GroupVersionKindNested<A> withNewGroupVersionKind() {
    return new GroupVersionKindNested(null);
  }
  
  public GroupVersionKindNested<A> withNewGroupVersionKindLike(GroupVersionKind item) {
    return new GroupVersionKindNested(item);
  }
  
  public GroupVersionKindNested<A> editGroupVersionKind() {
    return withNewGroupVersionKindLike(java.util.Optional.ofNullable(buildGroupVersionKind()).orElse(null));
  }
  
  public GroupVersionKindNested<A> editOrNewGroupVersionKind() {
    return withNewGroupVersionKindLike(java.util.Optional.ofNullable(buildGroupVersionKind()).orElse(new GroupVersionKindBuilder().build()));
  }
  
  public GroupVersionKindNested<A> editOrNewGroupVersionKindLike(GroupVersionKind item) {
    return withNewGroupVersionKindLike(java.util.Optional.ofNullable(buildGroupVersionKind()).orElse(item));
  }
  
  public GroupVersionResource buildGroupVersionResource() {
    return this.groupVersionResource != null ? this.groupVersionResource.build() : null;
  }
  
  public A withGroupVersionResource(GroupVersionResource groupVersionResource) {
    this._visitables.remove(this.groupVersionResource);
    if (groupVersionResource != null) {
        this.groupVersionResource = new GroupVersionResourceBuilder(groupVersionResource);
        this._visitables.get("groupVersionResource").add(this.groupVersionResource);
    } else {
        this.groupVersionResource = null;
        this._visitables.get("groupVersionResource").remove(this.groupVersionResource);
    }
    return (A) this;
  }
  
  public boolean hasGroupVersionResource() {
    return this.groupVersionResource != null;
  }
  
  public A withNewGroupVersionResource(String group,String resource,String version) {
    return (A)withGroupVersionResource(new GroupVersionResource(group, resource, version));
  }
  
  public GroupVersionResourceNested<A> withNewGroupVersionResource() {
    return new GroupVersionResourceNested(null);
  }
  
  public GroupVersionResourceNested<A> withNewGroupVersionResourceLike(GroupVersionResource item) {
    return new GroupVersionResourceNested(item);
  }
  
  public GroupVersionResourceNested<A> editGroupVersionResource() {
    return withNewGroupVersionResourceLike(java.util.Optional.ofNullable(buildGroupVersionResource()).orElse(null));
  }
  
  public GroupVersionResourceNested<A> editOrNewGroupVersionResource() {
    return withNewGroupVersionResourceLike(java.util.Optional.ofNullable(buildGroupVersionResource()).orElse(new GroupVersionResourceBuilder().build()));
  }
  
  public GroupVersionResourceNested<A> editOrNewGroupVersionResourceLike(GroupVersionResource item) {
    return withNewGroupVersionResourceLike(java.util.Optional.ofNullable(buildGroupVersionResource()).orElse(item));
  }
  
  public Info buildInfo() {
    return this.info != null ? this.info.build() : null;
  }
  
  public A withInfo(Info info) {
    this._visitables.remove(this.info);
    if (info != null) {
        this.info = new InfoBuilder(info);
        this._visitables.get("info").add(this.info);
    } else {
        this.info = null;
        this._visitables.get("info").remove(this.info);
    }
    return (A) this;
  }
  
  public boolean hasInfo() {
    return this.info != null;
  }
  
  public InfoNested<A> withNewInfo() {
    return new InfoNested(null);
  }
  
  public InfoNested<A> withNewInfoLike(Info item) {
    return new InfoNested(item);
  }
  
  public InfoNested<A> editInfo() {
    return withNewInfoLike(java.util.Optional.ofNullable(buildInfo()).orElse(null));
  }
  
  public InfoNested<A> editOrNewInfo() {
    return withNewInfoLike(java.util.Optional.ofNullable(buildInfo()).orElse(new InfoBuilder().build()));
  }
  
  public InfoNested<A> editOrNewInfoLike(Info item) {
    return withNewInfoLike(java.util.Optional.ofNullable(buildInfo()).orElse(item));
  }
  
  public KubernetesList buildKubernetesList() {
    return this.kubernetesList != null ? this.kubernetesList.build() : null;
  }
  
  public A withKubernetesList(KubernetesList kubernetesList) {
    this._visitables.remove(this.kubernetesList);
    if (kubernetesList != null) {
        this.kubernetesList = new KubernetesListBuilder(kubernetesList);
        this._visitables.get("kubernetesList").add(this.kubernetesList);
    } else {
        this.kubernetesList = null;
        this._visitables.get("kubernetesList").remove(this.kubernetesList);
    }
    return (A) this;
  }
  
  public boolean hasKubernetesList() {
    return this.kubernetesList != null;
  }
  
  public KubernetesListNested<A> withNewKubernetesList() {
    return new KubernetesListNested(null);
  }
  
  public KubernetesListNested<A> withNewKubernetesListLike(KubernetesList item) {
    return new KubernetesListNested(item);
  }
  
  public KubernetesListNested<A> editKubernetesList() {
    return withNewKubernetesListLike(java.util.Optional.ofNullable(buildKubernetesList()).orElse(null));
  }
  
  public KubernetesListNested<A> editOrNewKubernetesList() {
    return withNewKubernetesListLike(java.util.Optional.ofNullable(buildKubernetesList()).orElse(new KubernetesListBuilder().build()));
  }
  
  public KubernetesListNested<A> editOrNewKubernetesListLike(KubernetesList item) {
    return withNewKubernetesListLike(java.util.Optional.ofNullable(buildKubernetesList()).orElse(item));
  }
  
  public LimitRangeList buildLimitRangeList() {
    return this.limitRangeList != null ? this.limitRangeList.build() : null;
  }
  
  public A withLimitRangeList(LimitRangeList limitRangeList) {
    this._visitables.remove(this.limitRangeList);
    if (limitRangeList != null) {
        this.limitRangeList = new LimitRangeListBuilder(limitRangeList);
        this._visitables.get("limitRangeList").add(this.limitRangeList);
    } else {
        this.limitRangeList = null;
        this._visitables.get("limitRangeList").remove(this.limitRangeList);
    }
    return (A) this;
  }
  
  public boolean hasLimitRangeList() {
    return this.limitRangeList != null;
  }
  
  public LimitRangeListNested<A> withNewLimitRangeList() {
    return new LimitRangeListNested(null);
  }
  
  public LimitRangeListNested<A> withNewLimitRangeListLike(LimitRangeList item) {
    return new LimitRangeListNested(item);
  }
  
  public LimitRangeListNested<A> editLimitRangeList() {
    return withNewLimitRangeListLike(java.util.Optional.ofNullable(buildLimitRangeList()).orElse(null));
  }
  
  public LimitRangeListNested<A> editOrNewLimitRangeList() {
    return withNewLimitRangeListLike(java.util.Optional.ofNullable(buildLimitRangeList()).orElse(new LimitRangeListBuilder().build()));
  }
  
  public LimitRangeListNested<A> editOrNewLimitRangeListLike(LimitRangeList item) {
    return withNewLimitRangeListLike(java.util.Optional.ofNullable(buildLimitRangeList()).orElse(item));
  }
  
  public ListOptions buildListOptions() {
    return this.listOptions != null ? this.listOptions.build() : null;
  }
  
  public A withListOptions(ListOptions listOptions) {
    this._visitables.remove(this.listOptions);
    if (listOptions != null) {
        this.listOptions = new ListOptionsBuilder(listOptions);
        this._visitables.get("listOptions").add(this.listOptions);
    } else {
        this.listOptions = null;
        this._visitables.get("listOptions").remove(this.listOptions);
    }
    return (A) this;
  }
  
  public boolean hasListOptions() {
    return this.listOptions != null;
  }
  
  public ListOptionsNested<A> withNewListOptions() {
    return new ListOptionsNested(null);
  }
  
  public ListOptionsNested<A> withNewListOptionsLike(ListOptions item) {
    return new ListOptionsNested(item);
  }
  
  public ListOptionsNested<A> editListOptions() {
    return withNewListOptionsLike(java.util.Optional.ofNullable(buildListOptions()).orElse(null));
  }
  
  public ListOptionsNested<A> editOrNewListOptions() {
    return withNewListOptionsLike(java.util.Optional.ofNullable(buildListOptions()).orElse(new ListOptionsBuilder().build()));
  }
  
  public ListOptionsNested<A> editOrNewListOptionsLike(ListOptions item) {
    return withNewListOptionsLike(java.util.Optional.ofNullable(buildListOptions()).orElse(item));
  }
  
  public MicroTime buildMicroTime() {
    return this.microTime != null ? this.microTime.build() : null;
  }
  
  public A withMicroTime(MicroTime microTime) {
    this._visitables.remove(this.microTime);
    if (microTime != null) {
        this.microTime = new MicroTimeBuilder(microTime);
        this._visitables.get("microTime").add(this.microTime);
    } else {
        this.microTime = null;
        this._visitables.get("microTime").remove(this.microTime);
    }
    return (A) this;
  }
  
  public boolean hasMicroTime() {
    return this.microTime != null;
  }
  
  public A withNewMicroTime(String time) {
    return (A)withMicroTime(new MicroTime(time));
  }
  
  public MicroTimeNested<A> withNewMicroTime() {
    return new MicroTimeNested(null);
  }
  
  public MicroTimeNested<A> withNewMicroTimeLike(MicroTime item) {
    return new MicroTimeNested(item);
  }
  
  public MicroTimeNested<A> editMicroTime() {
    return withNewMicroTimeLike(java.util.Optional.ofNullable(buildMicroTime()).orElse(null));
  }
  
  public MicroTimeNested<A> editOrNewMicroTime() {
    return withNewMicroTimeLike(java.util.Optional.ofNullable(buildMicroTime()).orElse(new MicroTimeBuilder().build()));
  }
  
  public MicroTimeNested<A> editOrNewMicroTimeLike(MicroTime item) {
    return withNewMicroTimeLike(java.util.Optional.ofNullable(buildMicroTime()).orElse(item));
  }
  
  public Namespace buildNamespace() {
    return this.namespace != null ? this.namespace.build() : null;
  }
  
  public A withNamespace(Namespace namespace) {
    this._visitables.remove(this.namespace);
    if (namespace != null) {
        this.namespace = new NamespaceBuilder(namespace);
        this._visitables.get("namespace").add(this.namespace);
    } else {
        this.namespace = null;
        this._visitables.get("namespace").remove(this.namespace);
    }
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public NamespaceNested<A> withNewNamespace() {
    return new NamespaceNested(null);
  }
  
  public NamespaceNested<A> withNewNamespaceLike(Namespace item) {
    return new NamespaceNested(item);
  }
  
  public NamespaceNested<A> editNamespace() {
    return withNewNamespaceLike(java.util.Optional.ofNullable(buildNamespace()).orElse(null));
  }
  
  public NamespaceNested<A> editOrNewNamespace() {
    return withNewNamespaceLike(java.util.Optional.ofNullable(buildNamespace()).orElse(new NamespaceBuilder().build()));
  }
  
  public NamespaceNested<A> editOrNewNamespaceLike(Namespace item) {
    return withNewNamespaceLike(java.util.Optional.ofNullable(buildNamespace()).orElse(item));
  }
  
  public NamespaceList buildNamespaceList() {
    return this.namespaceList != null ? this.namespaceList.build() : null;
  }
  
  public A withNamespaceList(NamespaceList namespaceList) {
    this._visitables.remove(this.namespaceList);
    if (namespaceList != null) {
        this.namespaceList = new NamespaceListBuilder(namespaceList);
        this._visitables.get("namespaceList").add(this.namespaceList);
    } else {
        this.namespaceList = null;
        this._visitables.get("namespaceList").remove(this.namespaceList);
    }
    return (A) this;
  }
  
  public boolean hasNamespaceList() {
    return this.namespaceList != null;
  }
  
  public NamespaceListNested<A> withNewNamespaceList() {
    return new NamespaceListNested(null);
  }
  
  public NamespaceListNested<A> withNewNamespaceListLike(NamespaceList item) {
    return new NamespaceListNested(item);
  }
  
  public NamespaceListNested<A> editNamespaceList() {
    return withNewNamespaceListLike(java.util.Optional.ofNullable(buildNamespaceList()).orElse(null));
  }
  
  public NamespaceListNested<A> editOrNewNamespaceList() {
    return withNewNamespaceListLike(java.util.Optional.ofNullable(buildNamespaceList()).orElse(new NamespaceListBuilder().build()));
  }
  
  public NamespaceListNested<A> editOrNewNamespaceListLike(NamespaceList item) {
    return withNewNamespaceListLike(java.util.Optional.ofNullable(buildNamespaceList()).orElse(item));
  }
  
  public Node buildNode() {
    return this.node != null ? this.node.build() : null;
  }
  
  public A withNode(Node node) {
    this._visitables.remove(this.node);
    if (node != null) {
        this.node = new NodeBuilder(node);
        this._visitables.get("node").add(this.node);
    } else {
        this.node = null;
        this._visitables.get("node").remove(this.node);
    }
    return (A) this;
  }
  
  public boolean hasNode() {
    return this.node != null;
  }
  
  public NodeNested<A> withNewNode() {
    return new NodeNested(null);
  }
  
  public NodeNested<A> withNewNodeLike(Node item) {
    return new NodeNested(item);
  }
  
  public NodeNested<A> editNode() {
    return withNewNodeLike(java.util.Optional.ofNullable(buildNode()).orElse(null));
  }
  
  public NodeNested<A> editOrNewNode() {
    return withNewNodeLike(java.util.Optional.ofNullable(buildNode()).orElse(new NodeBuilder().build()));
  }
  
  public NodeNested<A> editOrNewNodeLike(Node item) {
    return withNewNodeLike(java.util.Optional.ofNullable(buildNode()).orElse(item));
  }
  
  public NodeList buildNodeList() {
    return this.nodeList != null ? this.nodeList.build() : null;
  }
  
  public A withNodeList(NodeList nodeList) {
    this._visitables.remove(this.nodeList);
    if (nodeList != null) {
        this.nodeList = new NodeListBuilder(nodeList);
        this._visitables.get("nodeList").add(this.nodeList);
    } else {
        this.nodeList = null;
        this._visitables.get("nodeList").remove(this.nodeList);
    }
    return (A) this;
  }
  
  public boolean hasNodeList() {
    return this.nodeList != null;
  }
  
  public NodeListNested<A> withNewNodeList() {
    return new NodeListNested(null);
  }
  
  public NodeListNested<A> withNewNodeListLike(NodeList item) {
    return new NodeListNested(item);
  }
  
  public NodeListNested<A> editNodeList() {
    return withNewNodeListLike(java.util.Optional.ofNullable(buildNodeList()).orElse(null));
  }
  
  public NodeListNested<A> editOrNewNodeList() {
    return withNewNodeListLike(java.util.Optional.ofNullable(buildNodeList()).orElse(new NodeListBuilder().build()));
  }
  
  public NodeListNested<A> editOrNewNodeListLike(NodeList item) {
    return withNewNodeListLike(java.util.Optional.ofNullable(buildNodeList()).orElse(item));
  }
  
  public ObjectMeta buildObjectMeta() {
    return this.objectMeta != null ? this.objectMeta.build() : null;
  }
  
  public A withObjectMeta(ObjectMeta objectMeta) {
    this._visitables.remove(this.objectMeta);
    if (objectMeta != null) {
        this.objectMeta = new ObjectMetaBuilder(objectMeta);
        this._visitables.get("objectMeta").add(this.objectMeta);
    } else {
        this.objectMeta = null;
        this._visitables.get("objectMeta").remove(this.objectMeta);
    }
    return (A) this;
  }
  
  public boolean hasObjectMeta() {
    return this.objectMeta != null;
  }
  
  public ObjectMetaNested<A> withNewObjectMeta() {
    return new ObjectMetaNested(null);
  }
  
  public ObjectMetaNested<A> withNewObjectMetaLike(ObjectMeta item) {
    return new ObjectMetaNested(item);
  }
  
  public ObjectMetaNested<A> editObjectMeta() {
    return withNewObjectMetaLike(java.util.Optional.ofNullable(buildObjectMeta()).orElse(null));
  }
  
  public ObjectMetaNested<A> editOrNewObjectMeta() {
    return withNewObjectMetaLike(java.util.Optional.ofNullable(buildObjectMeta()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public ObjectMetaNested<A> editOrNewObjectMetaLike(ObjectMeta item) {
    return withNewObjectMetaLike(java.util.Optional.ofNullable(buildObjectMeta()).orElse(item));
  }
  
  public Patch buildPatch() {
    return this.patch != null ? this.patch.build() : null;
  }
  
  public A withPatch(Patch patch) {
    this._visitables.remove(this.patch);
    if (patch != null) {
        this.patch = new PatchBuilder(patch);
        this._visitables.get("patch").add(this.patch);
    } else {
        this.patch = null;
        this._visitables.get("patch").remove(this.patch);
    }
    return (A) this;
  }
  
  public boolean hasPatch() {
    return this.patch != null;
  }
  
  public PatchNested<A> withNewPatch() {
    return new PatchNested(null);
  }
  
  public PatchNested<A> withNewPatchLike(Patch item) {
    return new PatchNested(item);
  }
  
  public PatchNested<A> editPatch() {
    return withNewPatchLike(java.util.Optional.ofNullable(buildPatch()).orElse(null));
  }
  
  public PatchNested<A> editOrNewPatch() {
    return withNewPatchLike(java.util.Optional.ofNullable(buildPatch()).orElse(new PatchBuilder().build()));
  }
  
  public PatchNested<A> editOrNewPatchLike(Patch item) {
    return withNewPatchLike(java.util.Optional.ofNullable(buildPatch()).orElse(item));
  }
  
  public PatchOptions buildPatchOptions() {
    return this.patchOptions != null ? this.patchOptions.build() : null;
  }
  
  public A withPatchOptions(PatchOptions patchOptions) {
    this._visitables.remove(this.patchOptions);
    if (patchOptions != null) {
        this.patchOptions = new PatchOptionsBuilder(patchOptions);
        this._visitables.get("patchOptions").add(this.patchOptions);
    } else {
        this.patchOptions = null;
        this._visitables.get("patchOptions").remove(this.patchOptions);
    }
    return (A) this;
  }
  
  public boolean hasPatchOptions() {
    return this.patchOptions != null;
  }
  
  public PatchOptionsNested<A> withNewPatchOptions() {
    return new PatchOptionsNested(null);
  }
  
  public PatchOptionsNested<A> withNewPatchOptionsLike(PatchOptions item) {
    return new PatchOptionsNested(item);
  }
  
  public PatchOptionsNested<A> editPatchOptions() {
    return withNewPatchOptionsLike(java.util.Optional.ofNullable(buildPatchOptions()).orElse(null));
  }
  
  public PatchOptionsNested<A> editOrNewPatchOptions() {
    return withNewPatchOptionsLike(java.util.Optional.ofNullable(buildPatchOptions()).orElse(new PatchOptionsBuilder().build()));
  }
  
  public PatchOptionsNested<A> editOrNewPatchOptionsLike(PatchOptions item) {
    return withNewPatchOptionsLike(java.util.Optional.ofNullable(buildPatchOptions()).orElse(item));
  }
  
  public PersistentVolume buildPersistentVolume() {
    return this.persistentVolume != null ? this.persistentVolume.build() : null;
  }
  
  public A withPersistentVolume(PersistentVolume persistentVolume) {
    this._visitables.remove(this.persistentVolume);
    if (persistentVolume != null) {
        this.persistentVolume = new PersistentVolumeBuilder(persistentVolume);
        this._visitables.get("persistentVolume").add(this.persistentVolume);
    } else {
        this.persistentVolume = null;
        this._visitables.get("persistentVolume").remove(this.persistentVolume);
    }
    return (A) this;
  }
  
  public boolean hasPersistentVolume() {
    return this.persistentVolume != null;
  }
  
  public PersistentVolumeNested<A> withNewPersistentVolume() {
    return new PersistentVolumeNested(null);
  }
  
  public PersistentVolumeNested<A> withNewPersistentVolumeLike(PersistentVolume item) {
    return new PersistentVolumeNested(item);
  }
  
  public PersistentVolumeNested<A> editPersistentVolume() {
    return withNewPersistentVolumeLike(java.util.Optional.ofNullable(buildPersistentVolume()).orElse(null));
  }
  
  public PersistentVolumeNested<A> editOrNewPersistentVolume() {
    return withNewPersistentVolumeLike(java.util.Optional.ofNullable(buildPersistentVolume()).orElse(new PersistentVolumeBuilder().build()));
  }
  
  public PersistentVolumeNested<A> editOrNewPersistentVolumeLike(PersistentVolume item) {
    return withNewPersistentVolumeLike(java.util.Optional.ofNullable(buildPersistentVolume()).orElse(item));
  }
  
  public PersistentVolumeClaim buildPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null ? this.persistentVolumeClaim.build() : null;
  }
  
  public A withPersistentVolumeClaim(PersistentVolumeClaim persistentVolumeClaim) {
    this._visitables.remove(this.persistentVolumeClaim);
    if (persistentVolumeClaim != null) {
        this.persistentVolumeClaim = new PersistentVolumeClaimBuilder(persistentVolumeClaim);
        this._visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);
    } else {
        this.persistentVolumeClaim = null;
        this._visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
    }
    return (A) this;
  }
  
  public boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  
  public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
    return new PersistentVolumeClaimNested(null);
  }
  
  public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimNested(item);
  }
  
  public PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(null));
  }
  
  public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(new PersistentVolumeClaimBuilder().build()));
  }
  
  public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(PersistentVolumeClaim item) {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(item));
  }
  
  public PersistentVolumeClaimList buildPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList != null ? this.persistentVolumeClaimList.build() : null;
  }
  
  public A withPersistentVolumeClaimList(PersistentVolumeClaimList persistentVolumeClaimList) {
    this._visitables.remove(this.persistentVolumeClaimList);
    if (persistentVolumeClaimList != null) {
        this.persistentVolumeClaimList = new PersistentVolumeClaimListBuilder(persistentVolumeClaimList);
        this._visitables.get("persistentVolumeClaimList").add(this.persistentVolumeClaimList);
    } else {
        this.persistentVolumeClaimList = null;
        this._visitables.get("persistentVolumeClaimList").remove(this.persistentVolumeClaimList);
    }
    return (A) this;
  }
  
  public boolean hasPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList != null;
  }
  
  public PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimList() {
    return new PersistentVolumeClaimListNested(null);
  }
  
  public PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimListLike(PersistentVolumeClaimList item) {
    return new PersistentVolumeClaimListNested(item);
  }
  
  public PersistentVolumeClaimListNested<A> editPersistentVolumeClaimList() {
    return withNewPersistentVolumeClaimListLike(java.util.Optional.ofNullable(buildPersistentVolumeClaimList()).orElse(null));
  }
  
  public PersistentVolumeClaimListNested<A> editOrNewPersistentVolumeClaimList() {
    return withNewPersistentVolumeClaimListLike(java.util.Optional.ofNullable(buildPersistentVolumeClaimList()).orElse(new PersistentVolumeClaimListBuilder().build()));
  }
  
  public PersistentVolumeClaimListNested<A> editOrNewPersistentVolumeClaimListLike(PersistentVolumeClaimList item) {
    return withNewPersistentVolumeClaimListLike(java.util.Optional.ofNullable(buildPersistentVolumeClaimList()).orElse(item));
  }
  
  public PersistentVolumeList buildPersistentVolumeList() {
    return this.persistentVolumeList != null ? this.persistentVolumeList.build() : null;
  }
  
  public A withPersistentVolumeList(PersistentVolumeList persistentVolumeList) {
    this._visitables.remove(this.persistentVolumeList);
    if (persistentVolumeList != null) {
        this.persistentVolumeList = new PersistentVolumeListBuilder(persistentVolumeList);
        this._visitables.get("persistentVolumeList").add(this.persistentVolumeList);
    } else {
        this.persistentVolumeList = null;
        this._visitables.get("persistentVolumeList").remove(this.persistentVolumeList);
    }
    return (A) this;
  }
  
  public boolean hasPersistentVolumeList() {
    return this.persistentVolumeList != null;
  }
  
  public PersistentVolumeListNested<A> withNewPersistentVolumeList() {
    return new PersistentVolumeListNested(null);
  }
  
  public PersistentVolumeListNested<A> withNewPersistentVolumeListLike(PersistentVolumeList item) {
    return new PersistentVolumeListNested(item);
  }
  
  public PersistentVolumeListNested<A> editPersistentVolumeList() {
    return withNewPersistentVolumeListLike(java.util.Optional.ofNullable(buildPersistentVolumeList()).orElse(null));
  }
  
  public PersistentVolumeListNested<A> editOrNewPersistentVolumeList() {
    return withNewPersistentVolumeListLike(java.util.Optional.ofNullable(buildPersistentVolumeList()).orElse(new PersistentVolumeListBuilder().build()));
  }
  
  public PersistentVolumeListNested<A> editOrNewPersistentVolumeListLike(PersistentVolumeList item) {
    return withNewPersistentVolumeListLike(java.util.Optional.ofNullable(buildPersistentVolumeList()).orElse(item));
  }
  
  public PodExecOptions buildPodExecOptions() {
    return this.podExecOptions != null ? this.podExecOptions.build() : null;
  }
  
  public A withPodExecOptions(PodExecOptions podExecOptions) {
    this._visitables.remove(this.podExecOptions);
    if (podExecOptions != null) {
        this.podExecOptions = new PodExecOptionsBuilder(podExecOptions);
        this._visitables.get("podExecOptions").add(this.podExecOptions);
    } else {
        this.podExecOptions = null;
        this._visitables.get("podExecOptions").remove(this.podExecOptions);
    }
    return (A) this;
  }
  
  public boolean hasPodExecOptions() {
    return this.podExecOptions != null;
  }
  
  public PodExecOptionsNested<A> withNewPodExecOptions() {
    return new PodExecOptionsNested(null);
  }
  
  public PodExecOptionsNested<A> withNewPodExecOptionsLike(PodExecOptions item) {
    return new PodExecOptionsNested(item);
  }
  
  public PodExecOptionsNested<A> editPodExecOptions() {
    return withNewPodExecOptionsLike(java.util.Optional.ofNullable(buildPodExecOptions()).orElse(null));
  }
  
  public PodExecOptionsNested<A> editOrNewPodExecOptions() {
    return withNewPodExecOptionsLike(java.util.Optional.ofNullable(buildPodExecOptions()).orElse(new PodExecOptionsBuilder().build()));
  }
  
  public PodExecOptionsNested<A> editOrNewPodExecOptionsLike(PodExecOptions item) {
    return withNewPodExecOptionsLike(java.util.Optional.ofNullable(buildPodExecOptions()).orElse(item));
  }
  
  public PodList buildPodList() {
    return this.podList != null ? this.podList.build() : null;
  }
  
  public A withPodList(PodList podList) {
    this._visitables.remove(this.podList);
    if (podList != null) {
        this.podList = new PodListBuilder(podList);
        this._visitables.get("podList").add(this.podList);
    } else {
        this.podList = null;
        this._visitables.get("podList").remove(this.podList);
    }
    return (A) this;
  }
  
  public boolean hasPodList() {
    return this.podList != null;
  }
  
  public PodListNested<A> withNewPodList() {
    return new PodListNested(null);
  }
  
  public PodListNested<A> withNewPodListLike(PodList item) {
    return new PodListNested(item);
  }
  
  public PodListNested<A> editPodList() {
    return withNewPodListLike(java.util.Optional.ofNullable(buildPodList()).orElse(null));
  }
  
  public PodListNested<A> editOrNewPodList() {
    return withNewPodListLike(java.util.Optional.ofNullable(buildPodList()).orElse(new PodListBuilder().build()));
  }
  
  public PodListNested<A> editOrNewPodListLike(PodList item) {
    return withNewPodListLike(java.util.Optional.ofNullable(buildPodList()).orElse(item));
  }
  
  public PodTemplateList buildPodTemplateList() {
    return this.podTemplateList != null ? this.podTemplateList.build() : null;
  }
  
  public A withPodTemplateList(PodTemplateList podTemplateList) {
    this._visitables.remove(this.podTemplateList);
    if (podTemplateList != null) {
        this.podTemplateList = new PodTemplateListBuilder(podTemplateList);
        this._visitables.get("podTemplateList").add(this.podTemplateList);
    } else {
        this.podTemplateList = null;
        this._visitables.get("podTemplateList").remove(this.podTemplateList);
    }
    return (A) this;
  }
  
  public boolean hasPodTemplateList() {
    return this.podTemplateList != null;
  }
  
  public PodTemplateListNested<A> withNewPodTemplateList() {
    return new PodTemplateListNested(null);
  }
  
  public PodTemplateListNested<A> withNewPodTemplateListLike(PodTemplateList item) {
    return new PodTemplateListNested(item);
  }
  
  public PodTemplateListNested<A> editPodTemplateList() {
    return withNewPodTemplateListLike(java.util.Optional.ofNullable(buildPodTemplateList()).orElse(null));
  }
  
  public PodTemplateListNested<A> editOrNewPodTemplateList() {
    return withNewPodTemplateListLike(java.util.Optional.ofNullable(buildPodTemplateList()).orElse(new PodTemplateListBuilder().build()));
  }
  
  public PodTemplateListNested<A> editOrNewPodTemplateListLike(PodTemplateList item) {
    return withNewPodTemplateListLike(java.util.Optional.ofNullable(buildPodTemplateList()).orElse(item));
  }
  
  public Quantity buildQuantity() {
    return this.quantity != null ? this.quantity.build() : null;
  }
  
  public A withQuantity(Quantity quantity) {
    this._visitables.remove(this.quantity);
    if (quantity != null) {
        this.quantity = new QuantityBuilder(quantity);
        this._visitables.get("quantity").add(this.quantity);
    } else {
        this.quantity = null;
        this._visitables.get("quantity").remove(this.quantity);
    }
    return (A) this;
  }
  
  public boolean hasQuantity() {
    return this.quantity != null;
  }
  
  public A withNewQuantity(String amount,String format) {
    return (A)withQuantity(new Quantity(amount, format));
  }
  
  public A withNewQuantity(String amount) {
    return (A)withQuantity(new Quantity(amount));
  }
  
  public QuantityNested<A> withNewQuantity() {
    return new QuantityNested(null);
  }
  
  public QuantityNested<A> withNewQuantityLike(Quantity item) {
    return new QuantityNested(item);
  }
  
  public QuantityNested<A> editQuantity() {
    return withNewQuantityLike(java.util.Optional.ofNullable(buildQuantity()).orElse(null));
  }
  
  public QuantityNested<A> editOrNewQuantity() {
    return withNewQuantityLike(java.util.Optional.ofNullable(buildQuantity()).orElse(new QuantityBuilder().build()));
  }
  
  public QuantityNested<A> editOrNewQuantityLike(Quantity item) {
    return withNewQuantityLike(java.util.Optional.ofNullable(buildQuantity()).orElse(item));
  }
  
  public ReplicationControllerList buildReplicationControllerList() {
    return this.replicationControllerList != null ? this.replicationControllerList.build() : null;
  }
  
  public A withReplicationControllerList(ReplicationControllerList replicationControllerList) {
    this._visitables.remove(this.replicationControllerList);
    if (replicationControllerList != null) {
        this.replicationControllerList = new ReplicationControllerListBuilder(replicationControllerList);
        this._visitables.get("replicationControllerList").add(this.replicationControllerList);
    } else {
        this.replicationControllerList = null;
        this._visitables.get("replicationControllerList").remove(this.replicationControllerList);
    }
    return (A) this;
  }
  
  public boolean hasReplicationControllerList() {
    return this.replicationControllerList != null;
  }
  
  public ReplicationControllerListNested<A> withNewReplicationControllerList() {
    return new ReplicationControllerListNested(null);
  }
  
  public ReplicationControllerListNested<A> withNewReplicationControllerListLike(ReplicationControllerList item) {
    return new ReplicationControllerListNested(item);
  }
  
  public ReplicationControllerListNested<A> editReplicationControllerList() {
    return withNewReplicationControllerListLike(java.util.Optional.ofNullable(buildReplicationControllerList()).orElse(null));
  }
  
  public ReplicationControllerListNested<A> editOrNewReplicationControllerList() {
    return withNewReplicationControllerListLike(java.util.Optional.ofNullable(buildReplicationControllerList()).orElse(new ReplicationControllerListBuilder().build()));
  }
  
  public ReplicationControllerListNested<A> editOrNewReplicationControllerListLike(ReplicationControllerList item) {
    return withNewReplicationControllerListLike(java.util.Optional.ofNullable(buildReplicationControllerList()).orElse(item));
  }
  
  public ResourceQuota buildResourceQuota() {
    return this.resourceQuota != null ? this.resourceQuota.build() : null;
  }
  
  public A withResourceQuota(ResourceQuota resourceQuota) {
    this._visitables.remove(this.resourceQuota);
    if (resourceQuota != null) {
        this.resourceQuota = new ResourceQuotaBuilder(resourceQuota);
        this._visitables.get("resourceQuota").add(this.resourceQuota);
    } else {
        this.resourceQuota = null;
        this._visitables.get("resourceQuota").remove(this.resourceQuota);
    }
    return (A) this;
  }
  
  public boolean hasResourceQuota() {
    return this.resourceQuota != null;
  }
  
  public ResourceQuotaNested<A> withNewResourceQuota() {
    return new ResourceQuotaNested(null);
  }
  
  public ResourceQuotaNested<A> withNewResourceQuotaLike(ResourceQuota item) {
    return new ResourceQuotaNested(item);
  }
  
  public ResourceQuotaNested<A> editResourceQuota() {
    return withNewResourceQuotaLike(java.util.Optional.ofNullable(buildResourceQuota()).orElse(null));
  }
  
  public ResourceQuotaNested<A> editOrNewResourceQuota() {
    return withNewResourceQuotaLike(java.util.Optional.ofNullable(buildResourceQuota()).orElse(new ResourceQuotaBuilder().build()));
  }
  
  public ResourceQuotaNested<A> editOrNewResourceQuotaLike(ResourceQuota item) {
    return withNewResourceQuotaLike(java.util.Optional.ofNullable(buildResourceQuota()).orElse(item));
  }
  
  public ResourceQuotaList buildResourceQuotaList() {
    return this.resourceQuotaList != null ? this.resourceQuotaList.build() : null;
  }
  
  public A withResourceQuotaList(ResourceQuotaList resourceQuotaList) {
    this._visitables.remove(this.resourceQuotaList);
    if (resourceQuotaList != null) {
        this.resourceQuotaList = new ResourceQuotaListBuilder(resourceQuotaList);
        this._visitables.get("resourceQuotaList").add(this.resourceQuotaList);
    } else {
        this.resourceQuotaList = null;
        this._visitables.get("resourceQuotaList").remove(this.resourceQuotaList);
    }
    return (A) this;
  }
  
  public boolean hasResourceQuotaList() {
    return this.resourceQuotaList != null;
  }
  
  public ResourceQuotaListNested<A> withNewResourceQuotaList() {
    return new ResourceQuotaListNested(null);
  }
  
  public ResourceQuotaListNested<A> withNewResourceQuotaListLike(ResourceQuotaList item) {
    return new ResourceQuotaListNested(item);
  }
  
  public ResourceQuotaListNested<A> editResourceQuotaList() {
    return withNewResourceQuotaListLike(java.util.Optional.ofNullable(buildResourceQuotaList()).orElse(null));
  }
  
  public ResourceQuotaListNested<A> editOrNewResourceQuotaList() {
    return withNewResourceQuotaListLike(java.util.Optional.ofNullable(buildResourceQuotaList()).orElse(new ResourceQuotaListBuilder().build()));
  }
  
  public ResourceQuotaListNested<A> editOrNewResourceQuotaListLike(ResourceQuotaList item) {
    return withNewResourceQuotaListLike(java.util.Optional.ofNullable(buildResourceQuotaList()).orElse(item));
  }
  
  public RootPaths buildRootPaths() {
    return this.rootPaths != null ? this.rootPaths.build() : null;
  }
  
  public A withRootPaths(RootPaths rootPaths) {
    this._visitables.remove(this.rootPaths);
    if (rootPaths != null) {
        this.rootPaths = new RootPathsBuilder(rootPaths);
        this._visitables.get("rootPaths").add(this.rootPaths);
    } else {
        this.rootPaths = null;
        this._visitables.get("rootPaths").remove(this.rootPaths);
    }
    return (A) this;
  }
  
  public boolean hasRootPaths() {
    return this.rootPaths != null;
  }
  
  public RootPathsNested<A> withNewRootPaths() {
    return new RootPathsNested(null);
  }
  
  public RootPathsNested<A> withNewRootPathsLike(RootPaths item) {
    return new RootPathsNested(item);
  }
  
  public RootPathsNested<A> editRootPaths() {
    return withNewRootPathsLike(java.util.Optional.ofNullable(buildRootPaths()).orElse(null));
  }
  
  public RootPathsNested<A> editOrNewRootPaths() {
    return withNewRootPathsLike(java.util.Optional.ofNullable(buildRootPaths()).orElse(new RootPathsBuilder().build()));
  }
  
  public RootPathsNested<A> editOrNewRootPathsLike(RootPaths item) {
    return withNewRootPathsLike(java.util.Optional.ofNullable(buildRootPaths()).orElse(item));
  }
  
  public Secret buildSecret() {
    return this.secret != null ? this.secret.build() : null;
  }
  
  public A withSecret(Secret secret) {
    this._visitables.remove(this.secret);
    if (secret != null) {
        this.secret = new SecretBuilder(secret);
        this._visitables.get("secret").add(this.secret);
    } else {
        this.secret = null;
        this._visitables.get("secret").remove(this.secret);
    }
    return (A) this;
  }
  
  public boolean hasSecret() {
    return this.secret != null;
  }
  
  public SecretNested<A> withNewSecret() {
    return new SecretNested(null);
  }
  
  public SecretNested<A> withNewSecretLike(Secret item) {
    return new SecretNested(item);
  }
  
  public SecretNested<A> editSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(null));
  }
  
  public SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(new SecretBuilder().build()));
  }
  
  public SecretNested<A> editOrNewSecretLike(Secret item) {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(item));
  }
  
  public SecretList buildSecretList() {
    return this.secretList != null ? this.secretList.build() : null;
  }
  
  public A withSecretList(SecretList secretList) {
    this._visitables.remove(this.secretList);
    if (secretList != null) {
        this.secretList = new SecretListBuilder(secretList);
        this._visitables.get("secretList").add(this.secretList);
    } else {
        this.secretList = null;
        this._visitables.get("secretList").remove(this.secretList);
    }
    return (A) this;
  }
  
  public boolean hasSecretList() {
    return this.secretList != null;
  }
  
  public SecretListNested<A> withNewSecretList() {
    return new SecretListNested(null);
  }
  
  public SecretListNested<A> withNewSecretListLike(SecretList item) {
    return new SecretListNested(item);
  }
  
  public SecretListNested<A> editSecretList() {
    return withNewSecretListLike(java.util.Optional.ofNullable(buildSecretList()).orElse(null));
  }
  
  public SecretListNested<A> editOrNewSecretList() {
    return withNewSecretListLike(java.util.Optional.ofNullable(buildSecretList()).orElse(new SecretListBuilder().build()));
  }
  
  public SecretListNested<A> editOrNewSecretListLike(SecretList item) {
    return withNewSecretListLike(java.util.Optional.ofNullable(buildSecretList()).orElse(item));
  }
  
  public ServiceAccount buildServiceAccount() {
    return this.serviceAccount != null ? this.serviceAccount.build() : null;
  }
  
  public A withServiceAccount(ServiceAccount serviceAccount) {
    this._visitables.remove(this.serviceAccount);
    if (serviceAccount != null) {
        this.serviceAccount = new ServiceAccountBuilder(serviceAccount);
        this._visitables.get("serviceAccount").add(this.serviceAccount);
    } else {
        this.serviceAccount = null;
        this._visitables.get("serviceAccount").remove(this.serviceAccount);
    }
    return (A) this;
  }
  
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  public ServiceAccountNested<A> withNewServiceAccount() {
    return new ServiceAccountNested(null);
  }
  
  public ServiceAccountNested<A> withNewServiceAccountLike(ServiceAccount item) {
    return new ServiceAccountNested(item);
  }
  
  public ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(null));
  }
  
  public ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(new ServiceAccountBuilder().build()));
  }
  
  public ServiceAccountNested<A> editOrNewServiceAccountLike(ServiceAccount item) {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(item));
  }
  
  public ServiceAccountList buildServiceAccountList() {
    return this.serviceAccountList != null ? this.serviceAccountList.build() : null;
  }
  
  public A withServiceAccountList(ServiceAccountList serviceAccountList) {
    this._visitables.remove(this.serviceAccountList);
    if (serviceAccountList != null) {
        this.serviceAccountList = new ServiceAccountListBuilder(serviceAccountList);
        this._visitables.get("serviceAccountList").add(this.serviceAccountList);
    } else {
        this.serviceAccountList = null;
        this._visitables.get("serviceAccountList").remove(this.serviceAccountList);
    }
    return (A) this;
  }
  
  public boolean hasServiceAccountList() {
    return this.serviceAccountList != null;
  }
  
  public ServiceAccountListNested<A> withNewServiceAccountList() {
    return new ServiceAccountListNested(null);
  }
  
  public ServiceAccountListNested<A> withNewServiceAccountListLike(ServiceAccountList item) {
    return new ServiceAccountListNested(item);
  }
  
  public ServiceAccountListNested<A> editServiceAccountList() {
    return withNewServiceAccountListLike(java.util.Optional.ofNullable(buildServiceAccountList()).orElse(null));
  }
  
  public ServiceAccountListNested<A> editOrNewServiceAccountList() {
    return withNewServiceAccountListLike(java.util.Optional.ofNullable(buildServiceAccountList()).orElse(new ServiceAccountListBuilder().build()));
  }
  
  public ServiceAccountListNested<A> editOrNewServiceAccountListLike(ServiceAccountList item) {
    return withNewServiceAccountListLike(java.util.Optional.ofNullable(buildServiceAccountList()).orElse(item));
  }
  
  public ServiceList buildServiceList() {
    return this.serviceList != null ? this.serviceList.build() : null;
  }
  
  public A withServiceList(ServiceList serviceList) {
    this._visitables.remove(this.serviceList);
    if (serviceList != null) {
        this.serviceList = new ServiceListBuilder(serviceList);
        this._visitables.get("serviceList").add(this.serviceList);
    } else {
        this.serviceList = null;
        this._visitables.get("serviceList").remove(this.serviceList);
    }
    return (A) this;
  }
  
  public boolean hasServiceList() {
    return this.serviceList != null;
  }
  
  public ServiceListNested<A> withNewServiceList() {
    return new ServiceListNested(null);
  }
  
  public ServiceListNested<A> withNewServiceListLike(ServiceList item) {
    return new ServiceListNested(item);
  }
  
  public ServiceListNested<A> editServiceList() {
    return withNewServiceListLike(java.util.Optional.ofNullable(buildServiceList()).orElse(null));
  }
  
  public ServiceListNested<A> editOrNewServiceList() {
    return withNewServiceListLike(java.util.Optional.ofNullable(buildServiceList()).orElse(new ServiceListBuilder().build()));
  }
  
  public ServiceListNested<A> editOrNewServiceListLike(ServiceList item) {
    return withNewServiceListLike(java.util.Optional.ofNullable(buildServiceList()).orElse(item));
  }
  
  public Status buildStatus() {
    return this.status != null ? this.status.build() : null;
  }
  
  public A withStatus(Status status) {
    this._visitables.remove(this.status);
    if (status != null) {
        this.status = new StatusBuilder(status);
        this._visitables.get("status").add(this.status);
    } else {
        this.status = null;
        this._visitables.get("status").remove(this.status);
    }
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public StatusNested<A> withNewStatus() {
    return new StatusNested(null);
  }
  
  public StatusNested<A> withNewStatusLike(Status item) {
    return new StatusNested(item);
  }
  
  public StatusNested<A> editStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(null));
  }
  
  public StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(new StatusBuilder().build()));
  }
  
  public StatusNested<A> editOrNewStatusLike(Status item) {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(item));
  }
  
  public String getTime() {
    return this.time;
  }
  
  public A withTime(String time) {
    this.time = time;
    return (A) this;
  }
  
  public boolean hasTime() {
    return this.time != null;
  }
  
  public Toleration buildToleration() {
    return this.toleration != null ? this.toleration.build() : null;
  }
  
  public A withToleration(Toleration toleration) {
    this._visitables.remove(this.toleration);
    if (toleration != null) {
        this.toleration = new TolerationBuilder(toleration);
        this._visitables.get("toleration").add(this.toleration);
    } else {
        this.toleration = null;
        this._visitables.get("toleration").remove(this.toleration);
    }
    return (A) this;
  }
  
  public boolean hasToleration() {
    return this.toleration != null;
  }
  
  public A withNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)withToleration(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  
  public TolerationNested<A> withNewToleration() {
    return new TolerationNested(null);
  }
  
  public TolerationNested<A> withNewTolerationLike(Toleration item) {
    return new TolerationNested(item);
  }
  
  public TolerationNested<A> editToleration() {
    return withNewTolerationLike(java.util.Optional.ofNullable(buildToleration()).orElse(null));
  }
  
  public TolerationNested<A> editOrNewToleration() {
    return withNewTolerationLike(java.util.Optional.ofNullable(buildToleration()).orElse(new TolerationBuilder().build()));
  }
  
  public TolerationNested<A> editOrNewTolerationLike(Toleration item) {
    return withNewTolerationLike(java.util.Optional.ofNullable(buildToleration()).orElse(item));
  }
  
  public TopologySelectorTerm buildTopologySelectorTerm() {
    return this.topologySelectorTerm != null ? this.topologySelectorTerm.build() : null;
  }
  
  public A withTopologySelectorTerm(TopologySelectorTerm topologySelectorTerm) {
    this._visitables.remove(this.topologySelectorTerm);
    if (topologySelectorTerm != null) {
        this.topologySelectorTerm = new TopologySelectorTermBuilder(topologySelectorTerm);
        this._visitables.get("topologySelectorTerm").add(this.topologySelectorTerm);
    } else {
        this.topologySelectorTerm = null;
        this._visitables.get("topologySelectorTerm").remove(this.topologySelectorTerm);
    }
    return (A) this;
  }
  
  public boolean hasTopologySelectorTerm() {
    return this.topologySelectorTerm != null;
  }
  
  public TopologySelectorTermNested<A> withNewTopologySelectorTerm() {
    return new TopologySelectorTermNested(null);
  }
  
  public TopologySelectorTermNested<A> withNewTopologySelectorTermLike(TopologySelectorTerm item) {
    return new TopologySelectorTermNested(item);
  }
  
  public TopologySelectorTermNested<A> editTopologySelectorTerm() {
    return withNewTopologySelectorTermLike(java.util.Optional.ofNullable(buildTopologySelectorTerm()).orElse(null));
  }
  
  public TopologySelectorTermNested<A> editOrNewTopologySelectorTerm() {
    return withNewTopologySelectorTermLike(java.util.Optional.ofNullable(buildTopologySelectorTerm()).orElse(new TopologySelectorTermBuilder().build()));
  }
  
  public TopologySelectorTermNested<A> editOrNewTopologySelectorTermLike(TopologySelectorTerm item) {
    return withNewTopologySelectorTermLike(java.util.Optional.ofNullable(buildTopologySelectorTerm()).orElse(item));
  }
  
  public TypeMeta buildTypeMeta() {
    return this.typeMeta != null ? this.typeMeta.build() : null;
  }
  
  public A withTypeMeta(TypeMeta typeMeta) {
    this._visitables.remove(this.typeMeta);
    if (typeMeta != null) {
        this.typeMeta = new TypeMetaBuilder(typeMeta);
        this._visitables.get("typeMeta").add(this.typeMeta);
    } else {
        this.typeMeta = null;
        this._visitables.get("typeMeta").remove(this.typeMeta);
    }
    return (A) this;
  }
  
  public boolean hasTypeMeta() {
    return this.typeMeta != null;
  }
  
  public A withNewTypeMeta(String apiVersion,String kind) {
    return (A)withTypeMeta(new TypeMeta(apiVersion, kind));
  }
  
  public TypeMetaNested<A> withNewTypeMeta() {
    return new TypeMetaNested(null);
  }
  
  public TypeMetaNested<A> withNewTypeMetaLike(TypeMeta item) {
    return new TypeMetaNested(item);
  }
  
  public TypeMetaNested<A> editTypeMeta() {
    return withNewTypeMetaLike(java.util.Optional.ofNullable(buildTypeMeta()).orElse(null));
  }
  
  public TypeMetaNested<A> editOrNewTypeMeta() {
    return withNewTypeMetaLike(java.util.Optional.ofNullable(buildTypeMeta()).orElse(new TypeMetaBuilder().build()));
  }
  
  public TypeMetaNested<A> editOrNewTypeMetaLike(TypeMeta item) {
    return withNewTypeMetaLike(java.util.Optional.ofNullable(buildTypeMeta()).orElse(item));
  }
  
  public UpdateOptions buildUpdateOptions() {
    return this.updateOptions != null ? this.updateOptions.build() : null;
  }
  
  public A withUpdateOptions(UpdateOptions updateOptions) {
    this._visitables.remove(this.updateOptions);
    if (updateOptions != null) {
        this.updateOptions = new UpdateOptionsBuilder(updateOptions);
        this._visitables.get("updateOptions").add(this.updateOptions);
    } else {
        this.updateOptions = null;
        this._visitables.get("updateOptions").remove(this.updateOptions);
    }
    return (A) this;
  }
  
  public boolean hasUpdateOptions() {
    return this.updateOptions != null;
  }
  
  public UpdateOptionsNested<A> withNewUpdateOptions() {
    return new UpdateOptionsNested(null);
  }
  
  public UpdateOptionsNested<A> withNewUpdateOptionsLike(UpdateOptions item) {
    return new UpdateOptionsNested(item);
  }
  
  public UpdateOptionsNested<A> editUpdateOptions() {
    return withNewUpdateOptionsLike(java.util.Optional.ofNullable(buildUpdateOptions()).orElse(null));
  }
  
  public UpdateOptionsNested<A> editOrNewUpdateOptions() {
    return withNewUpdateOptionsLike(java.util.Optional.ofNullable(buildUpdateOptions()).orElse(new UpdateOptionsBuilder().build()));
  }
  
  public UpdateOptionsNested<A> editOrNewUpdateOptionsLike(UpdateOptions item) {
    return withNewUpdateOptionsLike(java.util.Optional.ofNullable(buildUpdateOptions()).orElse(item));
  }
  
  public WatchEvent buildWatchEvent() {
    return this.watchEvent != null ? this.watchEvent.build() : null;
  }
  
  public A withWatchEvent(WatchEvent watchEvent) {
    this._visitables.remove(this.watchEvent);
    if (watchEvent != null) {
        this.watchEvent = new WatchEventBuilder(watchEvent);
        this._visitables.get("watchEvent").add(this.watchEvent);
    } else {
        this.watchEvent = null;
        this._visitables.get("watchEvent").remove(this.watchEvent);
    }
    return (A) this;
  }
  
  public boolean hasWatchEvent() {
    return this.watchEvent != null;
  }
  
  public WatchEventNested<A> withNewWatchEvent() {
    return new WatchEventNested(null);
  }
  
  public WatchEventNested<A> withNewWatchEventLike(WatchEvent item) {
    return new WatchEventNested(item);
  }
  
  public WatchEventNested<A> editWatchEvent() {
    return withNewWatchEventLike(java.util.Optional.ofNullable(buildWatchEvent()).orElse(null));
  }
  
  public WatchEventNested<A> editOrNewWatchEvent() {
    return withNewWatchEventLike(java.util.Optional.ofNullable(buildWatchEvent()).orElse(new WatchEventBuilder().build()));
  }
  
  public WatchEventNested<A> editOrNewWatchEventLike(WatchEvent item) {
    return withNewWatchEventLike(java.util.Optional.ofNullable(buildWatchEvent()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubeSchemaFluent that = (KubeSchemaFluent) o;
    if (!java.util.Objects.equals(aPIGroup, that.aPIGroup)) return false;
    if (!java.util.Objects.equals(aPIGroupList, that.aPIGroupList)) return false;
    if (!java.util.Objects.equals(aPIResource, that.aPIResource)) return false;
    if (!java.util.Objects.equals(aPIResourceList, that.aPIResourceList)) return false;
    if (!java.util.Objects.equals(aPIService, that.aPIService)) return false;
    if (!java.util.Objects.equals(aPIServiceList, that.aPIServiceList)) return false;
    if (!java.util.Objects.equals(binding, that.binding)) return false;
    if (!java.util.Objects.equals(componentStatus, that.componentStatus)) return false;
    if (!java.util.Objects.equals(componentStatusList, that.componentStatusList)) return false;
    if (!java.util.Objects.equals(condition, that.condition)) return false;
    if (!java.util.Objects.equals(config, that.config)) return false;
    if (!java.util.Objects.equals(configMap, that.configMap)) return false;
    if (!java.util.Objects.equals(configMapList, that.configMapList)) return false;
    if (!java.util.Objects.equals(containerStatus, that.containerStatus)) return false;
    if (!java.util.Objects.equals(createOptions, that.createOptions)) return false;
    if (!java.util.Objects.equals(deleteOptions, that.deleteOptions)) return false;
    if (!java.util.Objects.equals(endpointPort, that.endpointPort)) return false;
    if (!java.util.Objects.equals(endpoints, that.endpoints)) return false;
    if (!java.util.Objects.equals(endpointsList, that.endpointsList)) return false;
    if (!java.util.Objects.equals(envVar, that.envVar)) return false;
    if (!java.util.Objects.equals(event, that.event)) return false;
    if (!java.util.Objects.equals(eventList, that.eventList)) return false;
    if (!java.util.Objects.equals(eventSeries, that.eventSeries)) return false;
    if (!java.util.Objects.equals(eventSource, that.eventSource)) return false;
    if (!java.util.Objects.equals(getOptions, that.getOptions)) return false;
    if (!java.util.Objects.equals(groupKind, that.groupKind)) return false;
    if (!java.util.Objects.equals(groupVersionKind, that.groupVersionKind)) return false;
    if (!java.util.Objects.equals(groupVersionResource, that.groupVersionResource)) return false;
    if (!java.util.Objects.equals(info, that.info)) return false;
    if (!java.util.Objects.equals(kubernetesList, that.kubernetesList)) return false;
    if (!java.util.Objects.equals(limitRangeList, that.limitRangeList)) return false;
    if (!java.util.Objects.equals(listOptions, that.listOptions)) return false;
    if (!java.util.Objects.equals(microTime, that.microTime)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(namespaceList, that.namespaceList)) return false;
    if (!java.util.Objects.equals(node, that.node)) return false;
    if (!java.util.Objects.equals(nodeList, that.nodeList)) return false;
    if (!java.util.Objects.equals(objectMeta, that.objectMeta)) return false;
    if (!java.util.Objects.equals(patch, that.patch)) return false;
    if (!java.util.Objects.equals(patchOptions, that.patchOptions)) return false;
    if (!java.util.Objects.equals(persistentVolume, that.persistentVolume)) return false;
    if (!java.util.Objects.equals(persistentVolumeClaim, that.persistentVolumeClaim)) return false;
    if (!java.util.Objects.equals(persistentVolumeClaimList, that.persistentVolumeClaimList)) return false;
    if (!java.util.Objects.equals(persistentVolumeList, that.persistentVolumeList)) return false;
    if (!java.util.Objects.equals(podExecOptions, that.podExecOptions)) return false;
    if (!java.util.Objects.equals(podList, that.podList)) return false;
    if (!java.util.Objects.equals(podTemplateList, that.podTemplateList)) return false;
    if (!java.util.Objects.equals(quantity, that.quantity)) return false;
    if (!java.util.Objects.equals(replicationControllerList, that.replicationControllerList)) return false;
    if (!java.util.Objects.equals(resourceQuota, that.resourceQuota)) return false;
    if (!java.util.Objects.equals(resourceQuotaList, that.resourceQuotaList)) return false;
    if (!java.util.Objects.equals(rootPaths, that.rootPaths)) return false;
    if (!java.util.Objects.equals(secret, that.secret)) return false;
    if (!java.util.Objects.equals(secretList, that.secretList)) return false;
    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;
    if (!java.util.Objects.equals(serviceAccountList, that.serviceAccountList)) return false;
    if (!java.util.Objects.equals(serviceList, that.serviceList)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    if (!java.util.Objects.equals(time, that.time)) return false;
    if (!java.util.Objects.equals(toleration, that.toleration)) return false;
    if (!java.util.Objects.equals(topologySelectorTerm, that.topologySelectorTerm)) return false;
    if (!java.util.Objects.equals(typeMeta, that.typeMeta)) return false;
    if (!java.util.Objects.equals(updateOptions, that.updateOptions)) return false;
    if (!java.util.Objects.equals(watchEvent, that.watchEvent)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(aPIGroup,  aPIGroupList,  aPIResource,  aPIResourceList,  aPIService,  aPIServiceList,  binding,  componentStatus,  componentStatusList,  condition,  config,  configMap,  configMapList,  containerStatus,  createOptions,  deleteOptions,  endpointPort,  endpoints,  endpointsList,  envVar,  event,  eventList,  eventSeries,  eventSource,  getOptions,  groupKind,  groupVersionKind,  groupVersionResource,  info,  kubernetesList,  limitRangeList,  listOptions,  microTime,  namespace,  namespaceList,  node,  nodeList,  objectMeta,  patch,  patchOptions,  persistentVolume,  persistentVolumeClaim,  persistentVolumeClaimList,  persistentVolumeList,  podExecOptions,  podList,  podTemplateList,  quantity,  replicationControllerList,  resourceQuota,  resourceQuotaList,  rootPaths,  secret,  secretList,  serviceAccount,  serviceAccountList,  serviceList,  status,  time,  toleration,  topologySelectorTerm,  typeMeta,  updateOptions,  watchEvent,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aPIGroup != null) { sb.append("aPIGroup:"); sb.append(aPIGroup + ","); }
    if (aPIGroupList != null) { sb.append("aPIGroupList:"); sb.append(aPIGroupList + ","); }
    if (aPIResource != null) { sb.append("aPIResource:"); sb.append(aPIResource + ","); }
    if (aPIResourceList != null) { sb.append("aPIResourceList:"); sb.append(aPIResourceList + ","); }
    if (aPIService != null) { sb.append("aPIService:"); sb.append(aPIService + ","); }
    if (aPIServiceList != null) { sb.append("aPIServiceList:"); sb.append(aPIServiceList + ","); }
    if (binding != null) { sb.append("binding:"); sb.append(binding + ","); }
    if (componentStatus != null) { sb.append("componentStatus:"); sb.append(componentStatus + ","); }
    if (componentStatusList != null) { sb.append("componentStatusList:"); sb.append(componentStatusList + ","); }
    if (condition != null) { sb.append("condition:"); sb.append(condition + ","); }
    if (config != null) { sb.append("config:"); sb.append(config + ","); }
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (configMapList != null) { sb.append("configMapList:"); sb.append(configMapList + ","); }
    if (containerStatus != null) { sb.append("containerStatus:"); sb.append(containerStatus + ","); }
    if (createOptions != null) { sb.append("createOptions:"); sb.append(createOptions + ","); }
    if (deleteOptions != null) { sb.append("deleteOptions:"); sb.append(deleteOptions + ","); }
    if (endpointPort != null) { sb.append("endpointPort:"); sb.append(endpointPort + ","); }
    if (endpoints != null) { sb.append("endpoints:"); sb.append(endpoints + ","); }
    if (endpointsList != null) { sb.append("endpointsList:"); sb.append(endpointsList + ","); }
    if (envVar != null) { sb.append("envVar:"); sb.append(envVar + ","); }
    if (event != null) { sb.append("event:"); sb.append(event + ","); }
    if (eventList != null) { sb.append("eventList:"); sb.append(eventList + ","); }
    if (eventSeries != null) { sb.append("eventSeries:"); sb.append(eventSeries + ","); }
    if (eventSource != null) { sb.append("eventSource:"); sb.append(eventSource + ","); }
    if (getOptions != null) { sb.append("getOptions:"); sb.append(getOptions + ","); }
    if (groupKind != null) { sb.append("groupKind:"); sb.append(groupKind + ","); }
    if (groupVersionKind != null) { sb.append("groupVersionKind:"); sb.append(groupVersionKind + ","); }
    if (groupVersionResource != null) { sb.append("groupVersionResource:"); sb.append(groupVersionResource + ","); }
    if (info != null) { sb.append("info:"); sb.append(info + ","); }
    if (kubernetesList != null) { sb.append("kubernetesList:"); sb.append(kubernetesList + ","); }
    if (limitRangeList != null) { sb.append("limitRangeList:"); sb.append(limitRangeList + ","); }
    if (listOptions != null) { sb.append("listOptions:"); sb.append(listOptions + ","); }
    if (microTime != null) { sb.append("microTime:"); sb.append(microTime + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (namespaceList != null) { sb.append("namespaceList:"); sb.append(namespaceList + ","); }
    if (node != null) { sb.append("node:"); sb.append(node + ","); }
    if (nodeList != null) { sb.append("nodeList:"); sb.append(nodeList + ","); }
    if (objectMeta != null) { sb.append("objectMeta:"); sb.append(objectMeta + ","); }
    if (patch != null) { sb.append("patch:"); sb.append(patch + ","); }
    if (patchOptions != null) { sb.append("patchOptions:"); sb.append(patchOptions + ","); }
    if (persistentVolume != null) { sb.append("persistentVolume:"); sb.append(persistentVolume + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (persistentVolumeClaimList != null) { sb.append("persistentVolumeClaimList:"); sb.append(persistentVolumeClaimList + ","); }
    if (persistentVolumeList != null) { sb.append("persistentVolumeList:"); sb.append(persistentVolumeList + ","); }
    if (podExecOptions != null) { sb.append("podExecOptions:"); sb.append(podExecOptions + ","); }
    if (podList != null) { sb.append("podList:"); sb.append(podList + ","); }
    if (podTemplateList != null) { sb.append("podTemplateList:"); sb.append(podTemplateList + ","); }
    if (quantity != null) { sb.append("quantity:"); sb.append(quantity + ","); }
    if (replicationControllerList != null) { sb.append("replicationControllerList:"); sb.append(replicationControllerList + ","); }
    if (resourceQuota != null) { sb.append("resourceQuota:"); sb.append(resourceQuota + ","); }
    if (resourceQuotaList != null) { sb.append("resourceQuotaList:"); sb.append(resourceQuotaList + ","); }
    if (rootPaths != null) { sb.append("rootPaths:"); sb.append(rootPaths + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (secretList != null) { sb.append("secretList:"); sb.append(secretList + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (serviceAccountList != null) { sb.append("serviceAccountList:"); sb.append(serviceAccountList + ","); }
    if (serviceList != null) { sb.append("serviceList:"); sb.append(serviceList + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (time != null) { sb.append("time:"); sb.append(time + ","); }
    if (toleration != null) { sb.append("toleration:"); sb.append(toleration + ","); }
    if (topologySelectorTerm != null) { sb.append("topologySelectorTerm:"); sb.append(topologySelectorTerm + ","); }
    if (typeMeta != null) { sb.append("typeMeta:"); sb.append(typeMeta + ","); }
    if (updateOptions != null) { sb.append("updateOptions:"); sb.append(updateOptions + ","); }
    if (watchEvent != null) { sb.append("watchEvent:"); sb.append(watchEvent + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class APIGroupNested<N> extends APIGroupFluent<APIGroupNested<N>> implements Nested<N>{
    APIGroupNested(APIGroup item) {
      this.builder = new APIGroupBuilder(this, item);
    }
    APIGroupBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withAPIGroup(builder.build());
    }
    
    public N endAPIGroup() {
      return and();
    }
    
  
  }
  public class APIGroupListNested<N> extends APIGroupListFluent<APIGroupListNested<N>> implements Nested<N>{
    APIGroupListNested(APIGroupList item) {
      this.builder = new APIGroupListBuilder(this, item);
    }
    APIGroupListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withAPIGroupList(builder.build());
    }
    
    public N endAPIGroupList() {
      return and();
    }
    
  
  }
  public class APIResourceNested<N> extends APIResourceFluent<APIResourceNested<N>> implements Nested<N>{
    APIResourceNested(APIResource item) {
      this.builder = new APIResourceBuilder(this, item);
    }
    APIResourceBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withAPIResource(builder.build());
    }
    
    public N endAPIResource() {
      return and();
    }
    
  
  }
  public class APIResourceListNested<N> extends APIResourceListFluent<APIResourceListNested<N>> implements Nested<N>{
    APIResourceListNested(APIResourceList item) {
      this.builder = new APIResourceListBuilder(this, item);
    }
    APIResourceListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withAPIResourceList(builder.build());
    }
    
    public N endAPIResourceList() {
      return and();
    }
    
  
  }
  public class APIServiceNested<N> extends APIServiceFluent<APIServiceNested<N>> implements Nested<N>{
    APIServiceNested(APIService item) {
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withAPIService(builder.build());
    }
    
    public N endAPIService() {
      return and();
    }
    
  
  }
  public class APIServiceListNested<N> extends APIServiceListFluent<APIServiceListNested<N>> implements Nested<N>{
    APIServiceListNested(APIServiceList item) {
      this.builder = new APIServiceListBuilder(this, item);
    }
    APIServiceListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withAPIServiceList(builder.build());
    }
    
    public N endAPIServiceList() {
      return and();
    }
    
  
  }
  public class BindingNested<N> extends BindingFluent<BindingNested<N>> implements Nested<N>{
    BindingNested(Binding item) {
      this.builder = new BindingBuilder(this, item);
    }
    BindingBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withBinding(builder.build());
    }
    
    public N endBinding() {
      return and();
    }
    
  
  }
  public class ComponentStatusNested<N> extends ComponentStatusFluent<ComponentStatusNested<N>> implements Nested<N>{
    ComponentStatusNested(ComponentStatus item) {
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withComponentStatus(builder.build());
    }
    
    public N endComponentStatus() {
      return and();
    }
    
  
  }
  public class ComponentStatusListNested<N> extends ComponentStatusListFluent<ComponentStatusListNested<N>> implements Nested<N>{
    ComponentStatusListNested(ComponentStatusList item) {
      this.builder = new ComponentStatusListBuilder(this, item);
    }
    ComponentStatusListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withComponentStatusList(builder.build());
    }
    
    public N endComponentStatusList() {
      return and();
    }
    
  
  }
  public class ConditionNested<N> extends ConditionFluent<ConditionNested<N>> implements Nested<N>{
    ConditionNested(Condition item) {
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withCondition(builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class ConfigNested<N> extends ConfigFluent<ConfigNested<N>> implements Nested<N>{
    ConfigNested(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withConfig(builder.build());
    }
    
    public N endConfig() {
      return and();
    }
    
  
  }
  public class ConfigMapNested<N> extends ConfigMapFluent<ConfigMapNested<N>> implements Nested<N>{
    ConfigMapNested(ConfigMap item) {
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withConfigMap(builder.build());
    }
    
    public N endConfigMap() {
      return and();
    }
    
  
  }
  public class ConfigMapListNested<N> extends ConfigMapListFluent<ConfigMapListNested<N>> implements Nested<N>{
    ConfigMapListNested(ConfigMapList item) {
      this.builder = new ConfigMapListBuilder(this, item);
    }
    ConfigMapListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withConfigMapList(builder.build());
    }
    
    public N endConfigMapList() {
      return and();
    }
    
  
  }
  public class ContainerStatusNested<N> extends ContainerStatusFluent<ContainerStatusNested<N>> implements Nested<N>{
    ContainerStatusNested(ContainerStatus item) {
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withContainerStatus(builder.build());
    }
    
    public N endContainerStatus() {
      return and();
    }
    
  
  }
  public class CreateOptionsNested<N> extends CreateOptionsFluent<CreateOptionsNested<N>> implements Nested<N>{
    CreateOptionsNested(CreateOptions item) {
      this.builder = new CreateOptionsBuilder(this, item);
    }
    CreateOptionsBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withCreateOptions(builder.build());
    }
    
    public N endCreateOptions() {
      return and();
    }
    
  
  }
  public class DeleteOptionsNested<N> extends DeleteOptionsFluent<DeleteOptionsNested<N>> implements Nested<N>{
    DeleteOptionsNested(DeleteOptions item) {
      this.builder = new DeleteOptionsBuilder(this, item);
    }
    DeleteOptionsBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withDeleteOptions(builder.build());
    }
    
    public N endDeleteOptions() {
      return and();
    }
    
  
  }
  public class EndpointPortNested<N> extends EndpointPortFluent<EndpointPortNested<N>> implements Nested<N>{
    EndpointPortNested(EndpointPort item) {
      this.builder = new EndpointPortBuilder(this, item);
    }
    EndpointPortBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withEndpointPort(builder.build());
    }
    
    public N endEndpointPort() {
      return and();
    }
    
  
  }
  public class EndpointsNested<N> extends EndpointsFluent<EndpointsNested<N>> implements Nested<N>{
    EndpointsNested(Endpoints item) {
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withEndpoints(builder.build());
    }
    
    public N endEndpoints() {
      return and();
    }
    
  
  }
  public class EndpointsListNested<N> extends EndpointsListFluent<EndpointsListNested<N>> implements Nested<N>{
    EndpointsListNested(EndpointsList item) {
      this.builder = new EndpointsListBuilder(this, item);
    }
    EndpointsListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withEndpointsList(builder.build());
    }
    
    public N endEndpointsList() {
      return and();
    }
    
  
  }
  public class EnvVarNested<N> extends EnvVarFluent<EnvVarNested<N>> implements Nested<N>{
    EnvVarNested(EnvVar item) {
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withEnvVar(builder.build());
    }
    
    public N endEnvVar() {
      return and();
    }
    
  
  }
  public class EventNested<N> extends EventFluent<EventNested<N>> implements Nested<N>{
    EventNested(Event item) {
      this.builder = new EventBuilder(this, item);
    }
    EventBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withEvent(builder.build());
    }
    
    public N endEvent() {
      return and();
    }
    
  
  }
  public class EventListNested<N> extends EventListFluent<EventListNested<N>> implements Nested<N>{
    EventListNested(EventList item) {
      this.builder = new EventListBuilder(this, item);
    }
    EventListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withEventList(builder.build());
    }
    
    public N endEventList() {
      return and();
    }
    
  
  }
  public class EventSeriesNested<N> extends EventSeriesFluent<EventSeriesNested<N>> implements Nested<N>{
    EventSeriesNested(EventSeries item) {
      this.builder = new EventSeriesBuilder(this, item);
    }
    EventSeriesBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withEventSeries(builder.build());
    }
    
    public N endEventSeries() {
      return and();
    }
    
  
  }
  public class EventSourceNested<N> extends EventSourceFluent<EventSourceNested<N>> implements Nested<N>{
    EventSourceNested(EventSource item) {
      this.builder = new EventSourceBuilder(this, item);
    }
    EventSourceBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withEventSource(builder.build());
    }
    
    public N endEventSource() {
      return and();
    }
    
  
  }
  public class GetOptionsNested<N> extends GetOptionsFluent<GetOptionsNested<N>> implements Nested<N>{
    GetOptionsNested(GetOptions item) {
      this.builder = new GetOptionsBuilder(this, item);
    }
    GetOptionsBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withGetOptions(builder.build());
    }
    
    public N endGetOptions() {
      return and();
    }
    
  
  }
  public class GroupKindNested<N> extends GroupKindFluent<GroupKindNested<N>> implements Nested<N>{
    GroupKindNested(GroupKind item) {
      this.builder = new GroupKindBuilder(this, item);
    }
    GroupKindBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withGroupKind(builder.build());
    }
    
    public N endGroupKind() {
      return and();
    }
    
  
  }
  public class GroupVersionKindNested<N> extends GroupVersionKindFluent<GroupVersionKindNested<N>> implements Nested<N>{
    GroupVersionKindNested(GroupVersionKind item) {
      this.builder = new GroupVersionKindBuilder(this, item);
    }
    GroupVersionKindBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withGroupVersionKind(builder.build());
    }
    
    public N endGroupVersionKind() {
      return and();
    }
    
  
  }
  public class GroupVersionResourceNested<N> extends GroupVersionResourceFluent<GroupVersionResourceNested<N>> implements Nested<N>{
    GroupVersionResourceNested(GroupVersionResource item) {
      this.builder = new GroupVersionResourceBuilder(this, item);
    }
    GroupVersionResourceBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withGroupVersionResource(builder.build());
    }
    
    public N endGroupVersionResource() {
      return and();
    }
    
  
  }
  public class InfoNested<N> extends InfoFluent<InfoNested<N>> implements Nested<N>{
    InfoNested(Info item) {
      this.builder = new InfoBuilder(this, item);
    }
    InfoBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withInfo(builder.build());
    }
    
    public N endInfo() {
      return and();
    }
    
  
  }
  public class KubernetesListNested<N> extends KubernetesListFluent<KubernetesListNested<N>> implements Nested<N>{
    KubernetesListNested(KubernetesList item) {
      this.builder = new KubernetesListBuilder(this, item);
    }
    KubernetesListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withKubernetesList(builder.build());
    }
    
    public N endKubernetesList() {
      return and();
    }
    
  
  }
  public class LimitRangeListNested<N> extends LimitRangeListFluent<LimitRangeListNested<N>> implements Nested<N>{
    LimitRangeListNested(LimitRangeList item) {
      this.builder = new LimitRangeListBuilder(this, item);
    }
    LimitRangeListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withLimitRangeList(builder.build());
    }
    
    public N endLimitRangeList() {
      return and();
    }
    
  
  }
  public class ListOptionsNested<N> extends ListOptionsFluent<ListOptionsNested<N>> implements Nested<N>{
    ListOptionsNested(ListOptions item) {
      this.builder = new ListOptionsBuilder(this, item);
    }
    ListOptionsBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withListOptions(builder.build());
    }
    
    public N endListOptions() {
      return and();
    }
    
  
  }
  public class MicroTimeNested<N> extends MicroTimeFluent<MicroTimeNested<N>> implements Nested<N>{
    MicroTimeNested(MicroTime item) {
      this.builder = new MicroTimeBuilder(this, item);
    }
    MicroTimeBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withMicroTime(builder.build());
    }
    
    public N endMicroTime() {
      return and();
    }
    
  
  }
  public class NamespaceNested<N> extends NamespaceFluent<NamespaceNested<N>> implements Nested<N>{
    NamespaceNested(Namespace item) {
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withNamespace(builder.build());
    }
    
    public N endNamespace() {
      return and();
    }
    
  
  }
  public class NamespaceListNested<N> extends NamespaceListFluent<NamespaceListNested<N>> implements Nested<N>{
    NamespaceListNested(NamespaceList item) {
      this.builder = new NamespaceListBuilder(this, item);
    }
    NamespaceListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withNamespaceList(builder.build());
    }
    
    public N endNamespaceList() {
      return and();
    }
    
  
  }
  public class NodeNested<N> extends NodeFluent<NodeNested<N>> implements Nested<N>{
    NodeNested(Node item) {
      this.builder = new NodeBuilder(this, item);
    }
    NodeBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withNode(builder.build());
    }
    
    public N endNode() {
      return and();
    }
    
  
  }
  public class NodeListNested<N> extends NodeListFluent<NodeListNested<N>> implements Nested<N>{
    NodeListNested(NodeList item) {
      this.builder = new NodeListBuilder(this, item);
    }
    NodeListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withNodeList(builder.build());
    }
    
    public N endNodeList() {
      return and();
    }
    
  
  }
  public class ObjectMetaNested<N> extends ObjectMetaFluent<ObjectMetaNested<N>> implements Nested<N>{
    ObjectMetaNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withObjectMeta(builder.build());
    }
    
    public N endObjectMeta() {
      return and();
    }
    
  
  }
  public class PatchNested<N> extends PatchFluent<PatchNested<N>> implements Nested<N>{
    PatchNested(Patch item) {
      this.builder = new PatchBuilder(this, item);
    }
    PatchBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withPatch(builder.build());
    }
    
    public N endPatch() {
      return and();
    }
    
  
  }
  public class PatchOptionsNested<N> extends PatchOptionsFluent<PatchOptionsNested<N>> implements Nested<N>{
    PatchOptionsNested(PatchOptions item) {
      this.builder = new PatchOptionsBuilder(this, item);
    }
    PatchOptionsBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withPatchOptions(builder.build());
    }
    
    public N endPatchOptions() {
      return and();
    }
    
  
  }
  public class PersistentVolumeNested<N> extends PersistentVolumeFluent<PersistentVolumeNested<N>> implements Nested<N>{
    PersistentVolumeNested(PersistentVolume item) {
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withPersistentVolume(builder.build());
    }
    
    public N endPersistentVolume() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimNested<N>> implements Nested<N>{
    PersistentVolumeClaimNested(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withPersistentVolumeClaim(builder.build());
    }
    
    public N endPersistentVolumeClaim() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimListNested<N> extends PersistentVolumeClaimListFluent<PersistentVolumeClaimListNested<N>> implements Nested<N>{
    PersistentVolumeClaimListNested(PersistentVolumeClaimList item) {
      this.builder = new PersistentVolumeClaimListBuilder(this, item);
    }
    PersistentVolumeClaimListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withPersistentVolumeClaimList(builder.build());
    }
    
    public N endPersistentVolumeClaimList() {
      return and();
    }
    
  
  }
  public class PersistentVolumeListNested<N> extends PersistentVolumeListFluent<PersistentVolumeListNested<N>> implements Nested<N>{
    PersistentVolumeListNested(PersistentVolumeList item) {
      this.builder = new PersistentVolumeListBuilder(this, item);
    }
    PersistentVolumeListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withPersistentVolumeList(builder.build());
    }
    
    public N endPersistentVolumeList() {
      return and();
    }
    
  
  }
  public class PodExecOptionsNested<N> extends PodExecOptionsFluent<PodExecOptionsNested<N>> implements Nested<N>{
    PodExecOptionsNested(PodExecOptions item) {
      this.builder = new PodExecOptionsBuilder(this, item);
    }
    PodExecOptionsBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withPodExecOptions(builder.build());
    }
    
    public N endPodExecOptions() {
      return and();
    }
    
  
  }
  public class PodListNested<N> extends PodListFluent<PodListNested<N>> implements Nested<N>{
    PodListNested(PodList item) {
      this.builder = new PodListBuilder(this, item);
    }
    PodListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withPodList(builder.build());
    }
    
    public N endPodList() {
      return and();
    }
    
  
  }
  public class PodTemplateListNested<N> extends PodTemplateListFluent<PodTemplateListNested<N>> implements Nested<N>{
    PodTemplateListNested(PodTemplateList item) {
      this.builder = new PodTemplateListBuilder(this, item);
    }
    PodTemplateListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withPodTemplateList(builder.build());
    }
    
    public N endPodTemplateList() {
      return and();
    }
    
  
  }
  public class QuantityNested<N> extends QuantityFluent<QuantityNested<N>> implements Nested<N>{
    QuantityNested(Quantity item) {
      this.builder = new QuantityBuilder(this, item);
    }
    QuantityBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withQuantity(builder.build());
    }
    
    public N endQuantity() {
      return and();
    }
    
  
  }
  public class ReplicationControllerListNested<N> extends ReplicationControllerListFluent<ReplicationControllerListNested<N>> implements Nested<N>{
    ReplicationControllerListNested(ReplicationControllerList item) {
      this.builder = new ReplicationControllerListBuilder(this, item);
    }
    ReplicationControllerListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withReplicationControllerList(builder.build());
    }
    
    public N endReplicationControllerList() {
      return and();
    }
    
  
  }
  public class ResourceQuotaNested<N> extends ResourceQuotaFluent<ResourceQuotaNested<N>> implements Nested<N>{
    ResourceQuotaNested(ResourceQuota item) {
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withResourceQuota(builder.build());
    }
    
    public N endResourceQuota() {
      return and();
    }
    
  
  }
  public class ResourceQuotaListNested<N> extends ResourceQuotaListFluent<ResourceQuotaListNested<N>> implements Nested<N>{
    ResourceQuotaListNested(ResourceQuotaList item) {
      this.builder = new ResourceQuotaListBuilder(this, item);
    }
    ResourceQuotaListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withResourceQuotaList(builder.build());
    }
    
    public N endResourceQuotaList() {
      return and();
    }
    
  
  }
  public class RootPathsNested<N> extends RootPathsFluent<RootPathsNested<N>> implements Nested<N>{
    RootPathsNested(RootPaths item) {
      this.builder = new RootPathsBuilder(this, item);
    }
    RootPathsBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withRootPaths(builder.build());
    }
    
    public N endRootPaths() {
      return and();
    }
    
  
  }
  public class SecretNested<N> extends SecretFluent<SecretNested<N>> implements Nested<N>{
    SecretNested(Secret item) {
      this.builder = new SecretBuilder(this, item);
    }
    SecretBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withSecret(builder.build());
    }
    
    public N endSecret() {
      return and();
    }
    
  
  }
  public class SecretListNested<N> extends SecretListFluent<SecretListNested<N>> implements Nested<N>{
    SecretListNested(SecretList item) {
      this.builder = new SecretListBuilder(this, item);
    }
    SecretListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withSecretList(builder.build());
    }
    
    public N endSecretList() {
      return and();
    }
    
  
  }
  public class ServiceAccountNested<N> extends ServiceAccountFluent<ServiceAccountNested<N>> implements Nested<N>{
    ServiceAccountNested(ServiceAccount item) {
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withServiceAccount(builder.build());
    }
    
    public N endServiceAccount() {
      return and();
    }
    
  
  }
  public class ServiceAccountListNested<N> extends ServiceAccountListFluent<ServiceAccountListNested<N>> implements Nested<N>{
    ServiceAccountListNested(ServiceAccountList item) {
      this.builder = new ServiceAccountListBuilder(this, item);
    }
    ServiceAccountListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withServiceAccountList(builder.build());
    }
    
    public N endServiceAccountList() {
      return and();
    }
    
  
  }
  public class ServiceListNested<N> extends ServiceListFluent<ServiceListNested<N>> implements Nested<N>{
    ServiceListNested(ServiceList item) {
      this.builder = new ServiceListBuilder(this, item);
    }
    ServiceListBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withServiceList(builder.build());
    }
    
    public N endServiceList() {
      return and();
    }
    
  
  }
  public class StatusNested<N> extends StatusFluent<StatusNested<N>> implements Nested<N>{
    StatusNested(Status item) {
      this.builder = new StatusBuilder(this, item);
    }
    StatusBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withStatus(builder.build());
    }
    
    public N endStatus() {
      return and();
    }
    
  
  }
  public class TolerationNested<N> extends TolerationFluent<TolerationNested<N>> implements Nested<N>{
    TolerationNested(Toleration item) {
      this.builder = new TolerationBuilder(this, item);
    }
    TolerationBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withToleration(builder.build());
    }
    
    public N endToleration() {
      return and();
    }
    
  
  }
  public class TopologySelectorTermNested<N> extends TopologySelectorTermFluent<TopologySelectorTermNested<N>> implements Nested<N>{
    TopologySelectorTermNested(TopologySelectorTerm item) {
      this.builder = new TopologySelectorTermBuilder(this, item);
    }
    TopologySelectorTermBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withTopologySelectorTerm(builder.build());
    }
    
    public N endTopologySelectorTerm() {
      return and();
    }
    
  
  }
  public class TypeMetaNested<N> extends TypeMetaFluent<TypeMetaNested<N>> implements Nested<N>{
    TypeMetaNested(TypeMeta item) {
      this.builder = new TypeMetaBuilder(this, item);
    }
    TypeMetaBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withTypeMeta(builder.build());
    }
    
    public N endTypeMeta() {
      return and();
    }
    
  
  }
  public class UpdateOptionsNested<N> extends UpdateOptionsFluent<UpdateOptionsNested<N>> implements Nested<N>{
    UpdateOptionsNested(UpdateOptions item) {
      this.builder = new UpdateOptionsBuilder(this, item);
    }
    UpdateOptionsBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withUpdateOptions(builder.build());
    }
    
    public N endUpdateOptions() {
      return and();
    }
    
  
  }
  public class WatchEventNested<N> extends WatchEventFluent<WatchEventNested<N>> implements Nested<N>{
    WatchEventNested(WatchEvent item) {
      this.builder = new WatchEventBuilder(this, item);
    }
    WatchEventBuilder builder;
    
    public N and() {
      return (N) KubeSchemaFluent.this.withWatchEvent(builder.build());
    }
    
    public N endWatchEvent() {
      return and();
    }
    
  
  }

}