package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LifecycleFluent<A extends LifecycleFluent<A>> extends BaseFluent<A>{
  public LifecycleFluent() {
  }
  
  public LifecycleFluent(Lifecycle instance) {
    this.copyInstance(instance);
  }
  private LifecycleHandlerBuilder postStart;
  private LifecycleHandlerBuilder preStop;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Lifecycle instance) {
    instance = (instance != null ? instance : new Lifecycle());
    if (instance != null) {
          this.withPostStart(instance.getPostStart());
          this.withPreStop(instance.getPreStop());
          this.withPostStart(instance.getPostStart());
          this.withPreStop(instance.getPreStop());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LifecycleHandler buildPostStart() {
    return this.postStart != null ? this.postStart.build() : null;
  }
  
  public A withPostStart(LifecycleHandler postStart) {
    this._visitables.remove(this.postStart);
    if (postStart != null) {
        this.postStart = new LifecycleHandlerBuilder(postStart);
        this._visitables.get("postStart").add(this.postStart);
    } else {
        this.postStart = null;
        this._visitables.get("postStart").remove(this.postStart);
    }
    return (A) this;
  }
  
  public boolean hasPostStart() {
    return this.postStart != null;
  }
  
  public PostStartNested<A> withNewPostStart() {
    return new PostStartNested(null);
  }
  
  public PostStartNested<A> withNewPostStartLike(LifecycleHandler item) {
    return new PostStartNested(item);
  }
  
  public PostStartNested<A> editPostStart() {
    return withNewPostStartLike(java.util.Optional.ofNullable(buildPostStart()).orElse(null));
  }
  
  public PostStartNested<A> editOrNewPostStart() {
    return withNewPostStartLike(java.util.Optional.ofNullable(buildPostStart()).orElse(new LifecycleHandlerBuilder().build()));
  }
  
  public PostStartNested<A> editOrNewPostStartLike(LifecycleHandler item) {
    return withNewPostStartLike(java.util.Optional.ofNullable(buildPostStart()).orElse(item));
  }
  
  public LifecycleHandler buildPreStop() {
    return this.preStop != null ? this.preStop.build() : null;
  }
  
  public A withPreStop(LifecycleHandler preStop) {
    this._visitables.remove(this.preStop);
    if (preStop != null) {
        this.preStop = new LifecycleHandlerBuilder(preStop);
        this._visitables.get("preStop").add(this.preStop);
    } else {
        this.preStop = null;
        this._visitables.get("preStop").remove(this.preStop);
    }
    return (A) this;
  }
  
  public boolean hasPreStop() {
    return this.preStop != null;
  }
  
  public PreStopNested<A> withNewPreStop() {
    return new PreStopNested(null);
  }
  
  public PreStopNested<A> withNewPreStopLike(LifecycleHandler item) {
    return new PreStopNested(item);
  }
  
  public PreStopNested<A> editPreStop() {
    return withNewPreStopLike(java.util.Optional.ofNullable(buildPreStop()).orElse(null));
  }
  
  public PreStopNested<A> editOrNewPreStop() {
    return withNewPreStopLike(java.util.Optional.ofNullable(buildPreStop()).orElse(new LifecycleHandlerBuilder().build()));
  }
  
  public PreStopNested<A> editOrNewPreStopLike(LifecycleHandler item) {
    return withNewPreStopLike(java.util.Optional.ofNullable(buildPreStop()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LifecycleFluent that = (LifecycleFluent) o;
    if (!java.util.Objects.equals(postStart, that.postStart)) return false;
    if (!java.util.Objects.equals(preStop, that.preStop)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(postStart,  preStop,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (postStart != null) { sb.append("postStart:"); sb.append(postStart + ","); }
    if (preStop != null) { sb.append("preStop:"); sb.append(preStop + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PostStartNested<N> extends LifecycleHandlerFluent<PostStartNested<N>> implements Nested<N>{
    PostStartNested(LifecycleHandler item) {
      this.builder = new LifecycleHandlerBuilder(this, item);
    }
    LifecycleHandlerBuilder builder;
    
    public N and() {
      return (N) LifecycleFluent.this.withPostStart(builder.build());
    }
    
    public N endPostStart() {
      return and();
    }
    
  
  }
  public class PreStopNested<N> extends LifecycleHandlerFluent<PreStopNested<N>> implements Nested<N>{
    PreStopNested(LifecycleHandler item) {
      this.builder = new LifecycleHandlerBuilder(this, item);
    }
    LifecycleHandlerBuilder builder;
    
    public N and() {
      return (N) LifecycleFluent.this.withPreStop(builder.build());
    }
    
    public N endPreStop() {
      return and();
    }
    
  
  }

}