package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NamedContextFluent<A extends NamedContextFluent<A>> extends BaseFluent<A>{
  public NamedContextFluent() {
  }
  
  public NamedContextFluent(NamedContext instance) {
    this.copyInstance(instance);
  }
  private ContextBuilder context;
  private String name;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NamedContext instance) {
    instance = (instance != null ? instance : new NamedContext());
    if (instance != null) {
          this.withContext(instance.getContext());
          this.withName(instance.getName());
          this.withContext(instance.getContext());
          this.withName(instance.getName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Context buildContext() {
    return this.context != null ? this.context.build() : null;
  }
  
  public A withContext(Context context) {
    this._visitables.remove(this.context);
    if (context != null) {
        this.context = new ContextBuilder(context);
        this._visitables.get("context").add(this.context);
    } else {
        this.context = null;
        this._visitables.get("context").remove(this.context);
    }
    return (A) this;
  }
  
  public boolean hasContext() {
    return this.context != null;
  }
  
  public ContextNested<A> withNewContext() {
    return new ContextNested(null);
  }
  
  public ContextNested<A> withNewContextLike(Context item) {
    return new ContextNested(item);
  }
  
  public ContextNested<A> editContext() {
    return withNewContextLike(java.util.Optional.ofNullable(buildContext()).orElse(null));
  }
  
  public ContextNested<A> editOrNewContext() {
    return withNewContextLike(java.util.Optional.ofNullable(buildContext()).orElse(new ContextBuilder().build()));
  }
  
  public ContextNested<A> editOrNewContextLike(Context item) {
    return withNewContextLike(java.util.Optional.ofNullable(buildContext()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedContextFluent that = (NamedContextFluent) o;
    if (!java.util.Objects.equals(context, that.context)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(context,  name,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (context != null) { sb.append("context:"); sb.append(context + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ContextNested<N> extends ContextFluent<ContextNested<N>> implements Nested<N>{
    ContextNested(Context item) {
      this.builder = new ContextBuilder(this, item);
    }
    ContextBuilder builder;
    
    public N and() {
      return (N) NamedContextFluent.this.withContext(builder.build());
    }
    
    public N endContext() {
      return and();
    }
    
  
  }

}