package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PreferredSchedulingTermFluent<A extends PreferredSchedulingTermFluent<A>> extends BaseFluent<A>{
  public PreferredSchedulingTermFluent() {
  }
  
  public PreferredSchedulingTermFluent(PreferredSchedulingTerm instance) {
    this.copyInstance(instance);
  }
  private NodeSelectorTermBuilder preference;
  private Integer weight;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PreferredSchedulingTerm instance) {
    instance = (instance != null ? instance : new PreferredSchedulingTerm());
    if (instance != null) {
          this.withPreference(instance.getPreference());
          this.withWeight(instance.getWeight());
          this.withPreference(instance.getPreference());
          this.withWeight(instance.getWeight());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public NodeSelectorTerm buildPreference() {
    return this.preference != null ? this.preference.build() : null;
  }
  
  public A withPreference(NodeSelectorTerm preference) {
    this._visitables.remove(this.preference);
    if (preference != null) {
        this.preference = new NodeSelectorTermBuilder(preference);
        this._visitables.get("preference").add(this.preference);
    } else {
        this.preference = null;
        this._visitables.get("preference").remove(this.preference);
    }
    return (A) this;
  }
  
  public boolean hasPreference() {
    return this.preference != null;
  }
  
  public PreferenceNested<A> withNewPreference() {
    return new PreferenceNested(null);
  }
  
  public PreferenceNested<A> withNewPreferenceLike(NodeSelectorTerm item) {
    return new PreferenceNested(item);
  }
  
  public PreferenceNested<A> editPreference() {
    return withNewPreferenceLike(java.util.Optional.ofNullable(buildPreference()).orElse(null));
  }
  
  public PreferenceNested<A> editOrNewPreference() {
    return withNewPreferenceLike(java.util.Optional.ofNullable(buildPreference()).orElse(new NodeSelectorTermBuilder().build()));
  }
  
  public PreferenceNested<A> editOrNewPreferenceLike(NodeSelectorTerm item) {
    return withNewPreferenceLike(java.util.Optional.ofNullable(buildPreference()).orElse(item));
  }
  
  public Integer getWeight() {
    return this.weight;
  }
  
  public A withWeight(Integer weight) {
    this.weight = weight;
    return (A) this;
  }
  
  public boolean hasWeight() {
    return this.weight != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PreferredSchedulingTermFluent that = (PreferredSchedulingTermFluent) o;
    if (!java.util.Objects.equals(preference, that.preference)) return false;
    if (!java.util.Objects.equals(weight, that.weight)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(preference,  weight,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (preference != null) { sb.append("preference:"); sb.append(preference + ","); }
    if (weight != null) { sb.append("weight:"); sb.append(weight + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PreferenceNested<N> extends NodeSelectorTermFluent<PreferenceNested<N>> implements Nested<N>{
    PreferenceNested(NodeSelectorTerm item) {
      this.builder = new NodeSelectorTermBuilder(this, item);
    }
    NodeSelectorTermBuilder builder;
    
    public N and() {
      return (N) PreferredSchedulingTermFluent.this.withPreference(builder.build());
    }
    
    public N endPreference() {
      return and();
    }
    
  
  }

}