/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.FCVolumeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FCVolumeSourceFluent<A extends FCVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private String fsType;
    private Integer lun;
    private Boolean readOnly;
    private List<String> targetWWNs = new ArrayList<String>();
    private List<String> wwids = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public FCVolumeSourceFluent() {
    }

    public FCVolumeSourceFluent(FCVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(FCVolumeSource instance) {
        FCVolumeSource fCVolumeSource = instance = instance != null ? instance : new FCVolumeSource();
        if (instance != null) {
            this.withFsType(instance.getFsType());
            this.withLun(instance.getLun());
            this.withReadOnly(instance.getReadOnly());
            this.withTargetWWNs(instance.getTargetWWNs());
            this.withWwids(instance.getWwids());
            this.withFsType(instance.getFsType());
            this.withLun(instance.getLun());
            this.withReadOnly(instance.getReadOnly());
            this.withTargetWWNs(instance.getTargetWWNs());
            this.withWwids(instance.getWwids());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)((Object)this);
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public Integer getLun() {
        return this.lun;
    }

    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)((Object)this);
    }

    public boolean hasLun() {
        return this.lun != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)((Object)this);
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A addToTargetWWNs(int index, String item) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        this.targetWWNs.add(index, item);
        return (A)((Object)this);
    }

    public A setToTargetWWNs(int index, String item) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        this.targetWWNs.set(index, item);
        return (A)((Object)this);
    }

    public A addToTargetWWNs(String ... items) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetWWNs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTargetWWNs(Collection<String> items) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetWWNs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTargetWWNs(String ... items) {
        if (this.targetWWNs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetWWNs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTargetWWNs(Collection<String> items) {
        if (this.targetWWNs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetWWNs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTargetWWNs() {
        return this.targetWWNs;
    }

    public String getTargetWWN(int index) {
        return this.targetWWNs.get(index);
    }

    public String getFirstTargetWWN() {
        return this.targetWWNs.get(0);
    }

    public String getLastTargetWWN() {
        return this.targetWWNs.get(this.targetWWNs.size() - 1);
    }

    public String getMatchingTargetWWN(Predicate<String> predicate) {
        for (String item : this.targetWWNs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTargetWWN(Predicate<String> predicate) {
        for (String item : this.targetWWNs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetWWNs(List<String> targetWWNs) {
        if (targetWWNs != null) {
            this.targetWWNs = new ArrayList<String>();
            for (String item : targetWWNs) {
                this.addToTargetWWNs(item);
            }
        } else {
            this.targetWWNs = null;
        }
        return (A)((Object)this);
    }

    public A withTargetWWNs(String ... targetWWNs) {
        if (this.targetWWNs != null) {
            this.targetWWNs.clear();
            this._visitables.remove((Object)"targetWWNs");
        }
        if (targetWWNs != null) {
            for (String item : targetWWNs) {
                this.addToTargetWWNs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTargetWWNs() {
        return this.targetWWNs != null && !this.targetWWNs.isEmpty();
    }

    public A addToWwids(int index, String item) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        this.wwids.add(index, item);
        return (A)((Object)this);
    }

    public A setToWwids(int index, String item) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        this.wwids.set(index, item);
        return (A)((Object)this);
    }

    public A addToWwids(String ... items) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        for (String item : items) {
            this.wwids.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToWwids(Collection<String> items) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        for (String item : items) {
            this.wwids.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromWwids(String ... items) {
        if (this.wwids == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.wwids.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromWwids(Collection<String> items) {
        if (this.wwids == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.wwids.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getWwids() {
        return this.wwids;
    }

    public String getWwid(int index) {
        return this.wwids.get(index);
    }

    public String getFirstWwid() {
        return this.wwids.get(0);
    }

    public String getLastWwid() {
        return this.wwids.get(this.wwids.size() - 1);
    }

    public String getMatchingWwid(Predicate<String> predicate) {
        for (String item : this.wwids) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingWwid(Predicate<String> predicate) {
        for (String item : this.wwids) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWwids(List<String> wwids) {
        if (wwids != null) {
            this.wwids = new ArrayList<String>();
            for (String item : wwids) {
                this.addToWwids(item);
            }
        } else {
            this.wwids = null;
        }
        return (A)((Object)this);
    }

    public A withWwids(String ... wwids) {
        if (this.wwids != null) {
            this.wwids.clear();
            this._visitables.remove((Object)"wwids");
        }
        if (wwids != null) {
            for (String item : wwids) {
                this.addToWwids(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasWwids() {
        return this.wwids != null && !this.wwids.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FCVolumeSourceFluent that = (FCVolumeSourceFluent)((Object)o);
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.lun, that.lun)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.targetWWNs, that.targetWWNs)) {
            return false;
        }
        if (!Objects.equals(this.wwids, that.wwids)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.lun, this.readOnly, this.targetWWNs, this.wwids, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.lun != null) {
            sb.append("lun:");
            sb.append(this.lun + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.targetWWNs != null && !this.targetWWNs.isEmpty()) {
            sb.append("targetWWNs:");
            sb.append(this.targetWWNs + ",");
        }
        if (this.wwids != null && !this.wwids.isEmpty()) {
            sb.append("wwids:");
            sb.append(this.wwids + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }
}

