/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServicePortFluent;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.SessionAffinityConfig;
import io.fabric8.kubernetes.api.model.SessionAffinityConfigBuilder;
import io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServiceSpecFluent<A extends ServiceSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean allocateLoadBalancerNodePorts;
    private String clusterIP;
    private List<String> clusterIPs = new ArrayList<String>();
    private List<String> externalIPs = new ArrayList<String>();
    private String externalName;
    private String externalTrafficPolicy;
    private Integer healthCheckNodePort;
    private String internalTrafficPolicy;
    private List<String> ipFamilies = new ArrayList<String>();
    private String ipFamilyPolicy;
    private String loadBalancerClass;
    private String loadBalancerIP;
    private List<String> loadBalancerSourceRanges = new ArrayList<String>();
    private ArrayList<ServicePortBuilder> ports = new ArrayList();
    private Boolean publishNotReadyAddresses;
    private Map<String, String> selector;
    private String sessionAffinity;
    private SessionAffinityConfigBuilder sessionAffinityConfig;
    private String type;
    private Map<String, Object> additionalProperties;

    public ServiceSpecFluent() {
    }

    public ServiceSpecFluent(ServiceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceSpec instance) {
        ServiceSpec serviceSpec = instance = instance != null ? instance : new ServiceSpec();
        if (instance != null) {
            this.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts());
            this.withClusterIP(instance.getClusterIP());
            this.withClusterIPs(instance.getClusterIPs());
            this.withExternalIPs(instance.getExternalIPs());
            this.withExternalName(instance.getExternalName());
            this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
            this.withHealthCheckNodePort(instance.getHealthCheckNodePort());
            this.withInternalTrafficPolicy(instance.getInternalTrafficPolicy());
            this.withIpFamilies(instance.getIpFamilies());
            this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
            this.withLoadBalancerClass(instance.getLoadBalancerClass());
            this.withLoadBalancerIP(instance.getLoadBalancerIP());
            this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
            this.withPorts(instance.getPorts());
            this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses());
            this.withSelector(instance.getSelector());
            this.withSessionAffinity(instance.getSessionAffinity());
            this.withSessionAffinityConfig(instance.getSessionAffinityConfig());
            this.withType(instance.getType());
            this.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts());
            this.withClusterIP(instance.getClusterIP());
            this.withClusterIPs(instance.getClusterIPs());
            this.withExternalIPs(instance.getExternalIPs());
            this.withExternalName(instance.getExternalName());
            this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
            this.withHealthCheckNodePort(instance.getHealthCheckNodePort());
            this.withInternalTrafficPolicy(instance.getInternalTrafficPolicy());
            this.withIpFamilies(instance.getIpFamilies());
            this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
            this.withLoadBalancerClass(instance.getLoadBalancerClass());
            this.withLoadBalancerIP(instance.getLoadBalancerIP());
            this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
            this.withPorts(instance.getPorts());
            this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses());
            this.withSelector(instance.getSelector());
            this.withSessionAffinity(instance.getSessionAffinity());
            this.withSessionAffinityConfig(instance.getSessionAffinityConfig());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllocateLoadBalancerNodePorts() {
        return this.allocateLoadBalancerNodePorts;
    }

    public A withAllocateLoadBalancerNodePorts(Boolean allocateLoadBalancerNodePorts) {
        this.allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts;
        return (A)((Object)this);
    }

    public boolean hasAllocateLoadBalancerNodePorts() {
        return this.allocateLoadBalancerNodePorts != null;
    }

    public String getClusterIP() {
        return this.clusterIP;
    }

    public A withClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return (A)((Object)this);
    }

    public boolean hasClusterIP() {
        return this.clusterIP != null;
    }

    public A addToClusterIPs(int index, String item) {
        if (this.clusterIPs == null) {
            this.clusterIPs = new ArrayList<String>();
        }
        this.clusterIPs.add(index, item);
        return (A)((Object)this);
    }

    public A setToClusterIPs(int index, String item) {
        if (this.clusterIPs == null) {
            this.clusterIPs = new ArrayList<String>();
        }
        this.clusterIPs.set(index, item);
        return (A)((Object)this);
    }

    public A addToClusterIPs(String ... items) {
        if (this.clusterIPs == null) {
            this.clusterIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.clusterIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToClusterIPs(Collection<String> items) {
        if (this.clusterIPs == null) {
            this.clusterIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.clusterIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterIPs(String ... items) {
        if (this.clusterIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.clusterIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusterIPs(Collection<String> items) {
        if (this.clusterIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.clusterIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getClusterIPs() {
        return this.clusterIPs;
    }

    public String getClusterIP(int index) {
        return this.clusterIPs.get(index);
    }

    public String getFirstClusterIP() {
        return this.clusterIPs.get(0);
    }

    public String getLastClusterIP() {
        return this.clusterIPs.get(this.clusterIPs.size() - 1);
    }

    public String getMatchingClusterIP(Predicate<String> predicate) {
        for (String item : this.clusterIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingClusterIP(Predicate<String> predicate) {
        for (String item : this.clusterIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterIPs(List<String> clusterIPs) {
        if (clusterIPs != null) {
            this.clusterIPs = new ArrayList<String>();
            for (String item : clusterIPs) {
                this.addToClusterIPs(item);
            }
        } else {
            this.clusterIPs = null;
        }
        return (A)((Object)this);
    }

    public A withClusterIPs(String ... clusterIPs) {
        if (this.clusterIPs != null) {
            this.clusterIPs.clear();
            this._visitables.remove((Object)"clusterIPs");
        }
        if (clusterIPs != null) {
            for (String item : clusterIPs) {
                this.addToClusterIPs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusterIPs() {
        return this.clusterIPs != null && !this.clusterIPs.isEmpty();
    }

    public A addToExternalIPs(int index, String item) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        this.externalIPs.add(index, item);
        return (A)((Object)this);
    }

    public A setToExternalIPs(int index, String item) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        this.externalIPs.set(index, item);
        return (A)((Object)this);
    }

    public A addToExternalIPs(String ... items) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExternalIPs(Collection<String> items) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExternalIPs(String ... items) {
        if (this.externalIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.externalIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExternalIPs(Collection<String> items) {
        if (this.externalIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.externalIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    public String getExternalIP(int index) {
        return this.externalIPs.get(index);
    }

    public String getFirstExternalIP() {
        return this.externalIPs.get(0);
    }

    public String getLastExternalIP() {
        return this.externalIPs.get(this.externalIPs.size() - 1);
    }

    public String getMatchingExternalIP(Predicate<String> predicate) {
        for (String item : this.externalIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExternalIP(Predicate<String> predicate) {
        for (String item : this.externalIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExternalIPs(List<String> externalIPs) {
        if (externalIPs != null) {
            this.externalIPs = new ArrayList<String>();
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        } else {
            this.externalIPs = null;
        }
        return (A)((Object)this);
    }

    public A withExternalIPs(String ... externalIPs) {
        if (this.externalIPs != null) {
            this.externalIPs.clear();
            this._visitables.remove((Object)"externalIPs");
        }
        if (externalIPs != null) {
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExternalIPs() {
        return this.externalIPs != null && !this.externalIPs.isEmpty();
    }

    public String getExternalName() {
        return this.externalName;
    }

    public A withExternalName(String externalName) {
        this.externalName = externalName;
        return (A)((Object)this);
    }

    public boolean hasExternalName() {
        return this.externalName != null;
    }

    public String getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    public A withExternalTrafficPolicy(String externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
        return (A)((Object)this);
    }

    public boolean hasExternalTrafficPolicy() {
        return this.externalTrafficPolicy != null;
    }

    public Integer getHealthCheckNodePort() {
        return this.healthCheckNodePort;
    }

    public A withHealthCheckNodePort(Integer healthCheckNodePort) {
        this.healthCheckNodePort = healthCheckNodePort;
        return (A)((Object)this);
    }

    public boolean hasHealthCheckNodePort() {
        return this.healthCheckNodePort != null;
    }

    public String getInternalTrafficPolicy() {
        return this.internalTrafficPolicy;
    }

    public A withInternalTrafficPolicy(String internalTrafficPolicy) {
        this.internalTrafficPolicy = internalTrafficPolicy;
        return (A)((Object)this);
    }

    public boolean hasInternalTrafficPolicy() {
        return this.internalTrafficPolicy != null;
    }

    public A addToIpFamilies(int index, String item) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<String>();
        }
        this.ipFamilies.add(index, item);
        return (A)((Object)this);
    }

    public A setToIpFamilies(int index, String item) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<String>();
        }
        this.ipFamilies.set(index, item);
        return (A)((Object)this);
    }

    public A addToIpFamilies(String ... items) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipFamilies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpFamilies(Collection<String> items) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipFamilies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpFamilies(String ... items) {
        if (this.ipFamilies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipFamilies.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpFamilies(Collection<String> items) {
        if (this.ipFamilies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipFamilies.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIpFamilies() {
        return this.ipFamilies;
    }

    public String getIpFamily(int index) {
        return this.ipFamilies.get(index);
    }

    public String getFirstIpFamily() {
        return this.ipFamilies.get(0);
    }

    public String getLastIpFamily() {
        return this.ipFamilies.get(this.ipFamilies.size() - 1);
    }

    public String getMatchingIpFamily(Predicate<String> predicate) {
        for (String item : this.ipFamilies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIpFamily(Predicate<String> predicate) {
        for (String item : this.ipFamilies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIpFamilies(List<String> ipFamilies) {
        if (ipFamilies != null) {
            this.ipFamilies = new ArrayList<String>();
            for (String item : ipFamilies) {
                this.addToIpFamilies(item);
            }
        } else {
            this.ipFamilies = null;
        }
        return (A)((Object)this);
    }

    public A withIpFamilies(String ... ipFamilies) {
        if (this.ipFamilies != null) {
            this.ipFamilies.clear();
            this._visitables.remove((Object)"ipFamilies");
        }
        if (ipFamilies != null) {
            for (String item : ipFamilies) {
                this.addToIpFamilies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIpFamilies() {
        return this.ipFamilies != null && !this.ipFamilies.isEmpty();
    }

    public String getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    public A withIpFamilyPolicy(String ipFamilyPolicy) {
        this.ipFamilyPolicy = ipFamilyPolicy;
        return (A)((Object)this);
    }

    public boolean hasIpFamilyPolicy() {
        return this.ipFamilyPolicy != null;
    }

    public String getLoadBalancerClass() {
        return this.loadBalancerClass;
    }

    public A withLoadBalancerClass(String loadBalancerClass) {
        this.loadBalancerClass = loadBalancerClass;
        return (A)((Object)this);
    }

    public boolean hasLoadBalancerClass() {
        return this.loadBalancerClass != null;
    }

    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public A withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return (A)((Object)this);
    }

    public boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    public A addToLoadBalancerSourceRanges(int index, String item) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.add(index, item);
        return (A)((Object)this);
    }

    public A setToLoadBalancerSourceRanges(int index, String item) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.set(index, item);
        return (A)((Object)this);
    }

    public A addToLoadBalancerSourceRanges(String ... items) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToLoadBalancerSourceRanges(Collection<String> items) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromLoadBalancerSourceRanges(String ... items) {
        if (this.loadBalancerSourceRanges == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items) {
        if (this.loadBalancerSourceRanges == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public String getLoadBalancerSourceRange(int index) {
        return this.loadBalancerSourceRanges.get(index);
    }

    public String getFirstLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(0);
    }

    public String getLastLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(this.loadBalancerSourceRanges.size() - 1);
    }

    public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        if (loadBalancerSourceRanges != null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        } else {
            this.loadBalancerSourceRanges = null;
        }
        return (A)((Object)this);
    }

    public A withLoadBalancerSourceRanges(String ... loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {
            this.loadBalancerSourceRanges.clear();
            this._visitables.remove((Object)"loadBalancerSourceRanges");
        }
        if (loadBalancerSourceRanges != null) {
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges != null && !this.loadBalancerSourceRanges.isEmpty();
    }

    public A addToPorts(int index, ServicePort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        ServicePortBuilder builder = new ServicePortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPorts(int index, ServicePort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        ServicePortBuilder builder = new ServicePortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(ServicePort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPorts(Collection<ServicePort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(ServicePort ... items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPorts(Collection<ServicePort> items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPorts(Predicate<ServicePortBuilder> predicate) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        Iterator<ServicePortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            ServicePortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ServicePort> buildPorts() {
        return this.ports != null ? ServiceSpecFluent.build(this.ports) : null;
    }

    public ServicePort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public ServicePort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public ServicePort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public ServicePort buildMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<ServicePort> ports) {
        if (this.ports != null) {
            this._visitables.get((Object)"ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)((Object)this);
    }

    public A withPorts(ServicePort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove((Object)"ports");
        }
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(ServicePort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, ServicePort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<ServicePortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public Boolean getPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses;
    }

    public A withPublishNotReadyAddresses(Boolean publishNotReadyAddresses) {
        this.publishNotReadyAddresses = publishNotReadyAddresses;
        return (A)((Object)this);
    }

    public boolean hasPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses != null;
    }

    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public <K, V> A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    public A withSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return (A)((Object)this);
    }

    public boolean hasSessionAffinity() {
        return this.sessionAffinity != null;
    }

    public SessionAffinityConfig buildSessionAffinityConfig() {
        return this.sessionAffinityConfig != null ? this.sessionAffinityConfig.build() : null;
    }

    public A withSessionAffinityConfig(SessionAffinityConfig sessionAffinityConfig) {
        this._visitables.remove((Object)this.sessionAffinityConfig);
        if (sessionAffinityConfig != null) {
            this.sessionAffinityConfig = new SessionAffinityConfigBuilder(sessionAffinityConfig);
            this._visitables.get((Object)"sessionAffinityConfig").add(this.sessionAffinityConfig);
        } else {
            this.sessionAffinityConfig = null;
            this._visitables.get((Object)"sessionAffinityConfig").remove((Object)this.sessionAffinityConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasSessionAffinityConfig() {
        return this.sessionAffinityConfig != null;
    }

    public SessionAffinityConfigNested<A> withNewSessionAffinityConfig() {
        return new SessionAffinityConfigNested(null);
    }

    public SessionAffinityConfigNested<A> withNewSessionAffinityConfigLike(SessionAffinityConfig item) {
        return new SessionAffinityConfigNested(item);
    }

    public SessionAffinityConfigNested<A> editSessionAffinityConfig() {
        return this.withNewSessionAffinityConfigLike(Optional.ofNullable(this.buildSessionAffinityConfig()).orElse(null));
    }

    public SessionAffinityConfigNested<A> editOrNewSessionAffinityConfig() {
        return this.withNewSessionAffinityConfigLike(Optional.ofNullable(this.buildSessionAffinityConfig()).orElse(new SessionAffinityConfigBuilder().build()));
    }

    public SessionAffinityConfigNested<A> editOrNewSessionAffinityConfigLike(SessionAffinityConfig item) {
        return this.withNewSessionAffinityConfigLike(Optional.ofNullable(this.buildSessionAffinityConfig()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceSpecFluent that = (ServiceSpecFluent)((Object)o);
        if (!Objects.equals(this.allocateLoadBalancerNodePorts, that.allocateLoadBalancerNodePorts)) {
            return false;
        }
        if (!Objects.equals(this.clusterIP, that.clusterIP)) {
            return false;
        }
        if (!Objects.equals(this.clusterIPs, that.clusterIPs)) {
            return false;
        }
        if (!Objects.equals(this.externalIPs, that.externalIPs)) {
            return false;
        }
        if (!Objects.equals(this.externalName, that.externalName)) {
            return false;
        }
        if (!Objects.equals(this.externalTrafficPolicy, that.externalTrafficPolicy)) {
            return false;
        }
        if (!Objects.equals(this.healthCheckNodePort, that.healthCheckNodePort)) {
            return false;
        }
        if (!Objects.equals(this.internalTrafficPolicy, that.internalTrafficPolicy)) {
            return false;
        }
        if (!Objects.equals(this.ipFamilies, that.ipFamilies)) {
            return false;
        }
        if (!Objects.equals(this.ipFamilyPolicy, that.ipFamilyPolicy)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancerClass, that.loadBalancerClass)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancerIP, that.loadBalancerIP)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancerSourceRanges, that.loadBalancerSourceRanges)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals(this.publishNotReadyAddresses, that.publishNotReadyAddresses)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.sessionAffinity, that.sessionAffinity)) {
            return false;
        }
        if (!Objects.equals((Object)this.sessionAffinityConfig, (Object)that.sessionAffinityConfig)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allocateLoadBalancerNodePorts, this.clusterIP, this.clusterIPs, this.externalIPs, this.externalName, this.externalTrafficPolicy, this.healthCheckNodePort, this.internalTrafficPolicy, this.ipFamilies, this.ipFamilyPolicy, this.loadBalancerClass, this.loadBalancerIP, this.loadBalancerSourceRanges, this.ports, this.publishNotReadyAddresses, this.selector, this.sessionAffinity, this.sessionAffinityConfig, this.type, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocateLoadBalancerNodePorts != null) {
            sb.append("allocateLoadBalancerNodePorts:");
            sb.append(this.allocateLoadBalancerNodePorts + ",");
        }
        if (this.clusterIP != null) {
            sb.append("clusterIP:");
            sb.append(this.clusterIP + ",");
        }
        if (this.clusterIPs != null && !this.clusterIPs.isEmpty()) {
            sb.append("clusterIPs:");
            sb.append(this.clusterIPs + ",");
        }
        if (this.externalIPs != null && !this.externalIPs.isEmpty()) {
            sb.append("externalIPs:");
            sb.append(this.externalIPs + ",");
        }
        if (this.externalName != null) {
            sb.append("externalName:");
            sb.append(this.externalName + ",");
        }
        if (this.externalTrafficPolicy != null) {
            sb.append("externalTrafficPolicy:");
            sb.append(this.externalTrafficPolicy + ",");
        }
        if (this.healthCheckNodePort != null) {
            sb.append("healthCheckNodePort:");
            sb.append(this.healthCheckNodePort + ",");
        }
        if (this.internalTrafficPolicy != null) {
            sb.append("internalTrafficPolicy:");
            sb.append(this.internalTrafficPolicy + ",");
        }
        if (this.ipFamilies != null && !this.ipFamilies.isEmpty()) {
            sb.append("ipFamilies:");
            sb.append(this.ipFamilies + ",");
        }
        if (this.ipFamilyPolicy != null) {
            sb.append("ipFamilyPolicy:");
            sb.append(this.ipFamilyPolicy + ",");
        }
        if (this.loadBalancerClass != null) {
            sb.append("loadBalancerClass:");
            sb.append(this.loadBalancerClass + ",");
        }
        if (this.loadBalancerIP != null) {
            sb.append("loadBalancerIP:");
            sb.append(this.loadBalancerIP + ",");
        }
        if (this.loadBalancerSourceRanges != null && !this.loadBalancerSourceRanges.isEmpty()) {
            sb.append("loadBalancerSourceRanges:");
            sb.append(this.loadBalancerSourceRanges + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.publishNotReadyAddresses != null) {
            sb.append("publishNotReadyAddresses:");
            sb.append(this.publishNotReadyAddresses + ",");
        }
        if (this.selector != null && !this.selector.isEmpty()) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.sessionAffinity != null) {
            sb.append("sessionAffinity:");
            sb.append(this.sessionAffinity + ",");
        }
        if (this.sessionAffinityConfig != null) {
            sb.append("sessionAffinityConfig:");
            sb.append((Object)((Object)this.sessionAffinityConfig) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllocateLoadBalancerNodePorts() {
        return this.withAllocateLoadBalancerNodePorts(true);
    }

    public A withPublishNotReadyAddresses() {
        return this.withPublishNotReadyAddresses(true);
    }

    public class SessionAffinityConfigNested<N>
    extends SessionAffinityConfigFluent<SessionAffinityConfigNested<N>>
    implements Nested<N> {
        SessionAffinityConfigBuilder builder;

        SessionAffinityConfigNested(SessionAffinityConfig item) {
            this.builder = new SessionAffinityConfigBuilder(this, item);
        }

        public N and() {
            return (N)ServiceSpecFluent.this.withSessionAffinityConfig(this.builder.build());
        }

        public N endSessionAffinityConfig() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends ServicePortFluent<PortsNested<N>>
    implements Nested<N> {
        ServicePortBuilder builder;
        int index;

        PortsNested(int index, ServicePort item) {
            this.index = index;
            this.builder = new ServicePortBuilder(this, item);
        }

        public N and() {
            return (N)ServiceSpecFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

